/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson2.benchmark.eishay;

import com.alibaba.fastjson2.JSONB;
import com.alibaba.fastjson2.JSONFactory;
import com.alibaba.fastjson2.JSONReader;
import com.alibaba.fastjson2.JSONWriter;
import com.alibaba.fastjson2.benchmark.eishay.EishayForyCompatibleWrite;
import com.alibaba.fastjson2.benchmark.eishay.vo.MediaContent;
import java.io.InputStream;
import java.util.concurrent.TimeUnit;
import org.apache.commons.io.IOUtils;
import org.apache.fory.Fory;
import org.apache.fory.ThreadSafeFory;
import org.apache.fory.config.CompatibleMode;
import org.apache.fory.config.Language;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.infra.Blackhole;
import org.openjdk.jmh.runner.Runner;
import org.openjdk.jmh.runner.options.Options;
import org.openjdk.jmh.runner.options.OptionsBuilder;

public class EishayForyCompatibleParse {
    static MediaContent mc;
    static JSONReader.Feature[] features;
    static JSONReader.Context context;
    static byte[] jsonbBytes;
    static byte[] foryCompatibleBytes;
    static ThreadSafeFory foryCompatible;

    @Benchmark
    public void jsonb(Blackhole bh) {
        Object object = JSONB.parseObject((byte[])jsonbBytes, Object.class, (JSONReader.Context)context);
        bh.consume(object);
    }

    @Benchmark
    public void fory(Blackhole bh) {
        Object object = foryCompatible.deserialize(foryCompatibleBytes);
        bh.consume(object);
    }

    public static void main(String[] args) throws Exception {
        Options options = new OptionsBuilder().include(EishayForyCompatibleParse.class.getName()).mode(Mode.Throughput).timeUnit(TimeUnit.MILLISECONDS).warmupIterations(3).forks(1).threads(16).build();
        new Runner(options).run();
    }

    static {
        features = new JSONReader.Feature[]{JSONReader.Feature.SupportAutoType, JSONReader.Feature.IgnoreNoneSerializable, JSONReader.Feature.UseDefaultConstructorAsPossible, JSONReader.Feature.UseNativeObject, JSONReader.Feature.FieldBased};
        context = new JSONReader.Context(JSONFactory.getDefaultObjectReaderProvider(), features);
        foryCompatible = Fory.builder().withLanguage(Language.JAVA).withRefTracking(true).requireClassRegistration(false).withCompatibleMode(CompatibleMode.COMPATIBLE).buildThreadSafeFory();
        try {
            InputStream is = EishayForyCompatibleParse.class.getClassLoader().getResourceAsStream("data/eishay.json");
            String str = IOUtils.toString((InputStream)is, (String)"UTF-8");
            mc = (MediaContent)JSONReader.of((String)str).read(MediaContent.class);
            jsonbBytes = JSONB.toBytes((Object)mc, (JSONWriter.Feature[])EishayForyCompatibleWrite.features);
            foryCompatibleBytes = foryCompatible.serialize((Object)mc);
        }
        catch (Throwable ex) {
            ex.printStackTrace();
        }
    }
}

