/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson2.benchmark;

import com.alibaba.fastjson2.benchmark.eishay.EishayParseBinary;
import com.alibaba.fastjson2.support.csv.CSVReader;
import com.univocity.parsers.annotations.Parsed;
import com.univocity.parsers.csv.CsvFormat;
import com.univocity.parsers.csv.CsvParserSettings;
import com.univocity.parsers.csv.CsvRoutines;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.TimeUnit;
import org.apache.commons.io.IOUtils;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.infra.Blackhole;
import org.openjdk.jmh.runner.Runner;
import org.openjdk.jmh.runner.RunnerException;
import org.openjdk.jmh.runner.options.Options;
import org.openjdk.jmh.runner.options.OptionsBuilder;

public class CSVPerson {
    static final String file = "csv/person.csv";
    static byte[] byteArray;

    @Benchmark
    public void fastjson2(Blackhole BH) {
        CSVReader.of((InputStream)new ByteArrayInputStream(byteArray), (Charset)StandardCharsets.UTF_8, Person.class).readLineObjectAll(arg_0 -> ((Blackhole)BH).consume(arg_0));
    }

    @Benchmark
    public void univocity(Blackhole BH) {
        CsvParserSettings settings = new CsvParserSettings();
        CsvRoutines processor = new CsvRoutines(settings);
        ((CsvFormat)settings.getFormat()).setLineSeparator("\n");
        settings.setNumberOfRowsToSkip(1L);
        processor.iterate(Person.class, (InputStream)new ByteArrayInputStream(byteArray)).forEach(arg_0 -> ((Blackhole)BH).consume(arg_0));
    }

    public void cainiao(Blackhole BH) {
    }

    public static void main(String[] args) throws RunnerException {
        Options options = new OptionsBuilder().include(CSVPerson.class.getName()).mode(Mode.Throughput).timeUnit(TimeUnit.MILLISECONDS).warmupIterations(3).forks(1).build();
        new Runner(options).run();
    }

    static {
        try (InputStream is = EishayParseBinary.class.getClassLoader().getResourceAsStream(file);){
            String str = IOUtils.toString((InputStream)is, (String)"UTF-8");
            byteArray = str.getBytes();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static class Person {
        @Parsed(index=0)
        public String name;
        @Parsed(index=1)
        public Double weight;
        @Parsed(index=2)
        public Integer age;
        @Parsed(index=3)
        public String gender;
        @Parsed(index=4)
        public Integer height;
        @Parsed(index=5)
        public String address;
        @Parsed(index=6)
        public Integer id;
        @Parsed(index=7)
        public Boolean single;
    }
}

