/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson2.benchmark.primitves;

import com.alibaba.fastjson2.JSON;
import com.alibaba.fastjson2.JSONB;
import com.alibaba.fastjson2.benchmark.primitves.vo.ZonedDateTime20Field;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.InputStream;
import java.util.concurrent.TimeUnit;
import org.apache.commons.io.IOUtils;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.infra.Blackhole;
import org.openjdk.jmh.runner.Runner;
import org.openjdk.jmh.runner.RunnerException;
import org.openjdk.jmh.runner.options.Options;
import org.openjdk.jmh.runner.options.OptionsBuilder;

public class ZonedDateTime20 {
    static String str;
    static byte[] jsonbBytes;
    static ObjectMapper mapper;

    public ZonedDateTime20() {
        try {
            InputStream is = ZonedDateTime20.class.getClassLoader().getResourceAsStream("data/date20.json");
            str = IOUtils.toString((InputStream)is, (String)"UTF-8");
            jsonbBytes = JSONB.toBytes((Object)JSON.parseObject((String)str, ZonedDateTime20Field.class));
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    @Benchmark
    public void fastjson1(Blackhole bh) {
        bh.consume(com.alibaba.fastjson.JSON.parseObject((String)str, ZonedDateTime20Field.class));
    }

    @Benchmark
    public void fastjson2(Blackhole bh) {
        bh.consume(JSON.parseObject((String)str, ZonedDateTime20Field.class));
    }

    @Benchmark
    public void fastjson2_jsonb(Blackhole bh) {
        bh.consume(JSONB.parseObject((byte[])jsonbBytes, ZonedDateTime20Field.class));
    }

    @Benchmark
    public void jackson(Blackhole bh) throws Exception {
        bh.consume(mapper.readValue(str, ZonedDateTime20Field.class));
    }

    public static void main(String[] args) throws RunnerException {
        Options options = new OptionsBuilder().include(ZonedDateTime20.class.getName()).mode(Mode.Throughput).timeUnit(TimeUnit.MILLISECONDS).warmupIterations(3).forks(1).build();
        new Runner(options).run();
    }

    static {
        mapper = new ObjectMapper();
    }
}

