/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson2.benchmark.taobao;

import com.alibaba.fastjson2.JSON;
import com.alibaba.fastjson2.JSONReader;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.gson.Gson;
import java.io.InputStream;
import java.util.concurrent.TimeUnit;
import org.apache.commons.io.IOUtils;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.infra.Blackhole;
import org.openjdk.jmh.runner.Runner;
import org.openjdk.jmh.runner.RunnerException;
import org.openjdk.jmh.runner.options.Options;
import org.openjdk.jmh.runner.options.OptionsBuilder;

public class DetailSkuResponse {
    static String str;
    static final ObjectMapper mapper;
    static final Gson gson;

    @Benchmark
    public void fastjson1(Blackhole bh) {
        bh.consume((Object)com.alibaba.fastjson.JSON.parseObject((String)str));
    }

    @Benchmark
    public void fastjson2(Blackhole bh) {
        bh.consume((Object)JSON.parseObject((String)str, (JSONReader.Feature[])new JSONReader.Feature[]{JSONReader.Feature.IgnoreNullPropertyValue}));
    }

    public static void main(String[] args) throws RunnerException {
        Options options = new OptionsBuilder().include(DetailSkuResponse.class.getName()).mode(Mode.Throughput).timeUnit(TimeUnit.MILLISECONDS).warmupIterations(3).forks(1).threads(16).build();
        new Runner(options).run();
    }

    static {
        mapper = new ObjectMapper();
        gson = new Gson();
        try {
            InputStream is = DetailSkuResponse.class.getClassLoader().getResourceAsStream("taobao/detail_sku_response2.json");
            str = IOUtils.toString((InputStream)is, (String)"UTF-8");
        }
        catch (Throwable ex) {
            ex.printStackTrace();
        }
    }
}

