/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson2.benchmark.protobuf;

import com.alibaba.fastjson2.benchmark.eishay.vo.Image;
import com.alibaba.fastjson2.benchmark.eishay.vo.Media;
import com.alibaba.fastjson2.benchmark.eishay.vo.MediaContent;
import com.alibaba.fastjson2.benchmark.protobuf.MediaContentHolder;
import java.util.ArrayList;
import java.util.Collection;

public class MediaContentTransform {
    public static MediaContent reverse(MediaContentHolder.MediaContent mc) {
        ArrayList<Image> images = new ArrayList<Image>(mc.getImageCount());
        for (MediaContentHolder.Image image : mc.getImageList()) {
            images.add(MediaContentTransform.reverseImage(image));
        }
        return new MediaContent(MediaContentTransform.reverseMedia(mc.getMedia()), images);
    }

    public static Media reverseMedia(MediaContentHolder.Media media) {
        return new Media(media.getUri(), media.hasTitle() ? media.getTitle() : null, media.getWidth(), media.getHeight(), media.getFormat(), media.getDuration(), media.getSize(), media.hasBitrate() ? media.getBitrate() : 0, new ArrayList<String>((Collection<String>)media.getPersonList()), MediaContentTransform.reversePlayer(media.getPlayer()), media.hasCopyright() ? media.getCopyright() : null);
    }

    public static Image reverseImage(MediaContentHolder.Image image) {
        return new Image(image.getUri(), image.getTitle(), image.getWidth(), image.getHeight(), MediaContentTransform.reverseSize(image.getSize()));
    }

    public static Image.Size reverseSize(MediaContentHolder.Image.Size s) {
        switch (s) {
            case SMALL: {
                return Image.Size.SMALL;
            }
            case LARGE: {
                return Image.Size.LARGE;
            }
        }
        throw new AssertionError((Object)("invalid case: " + (Object)((Object)s)));
    }

    public static Media.Player reversePlayer(MediaContentHolder.Media.Player p) {
        switch (p) {
            case JAVA: {
                return Media.Player.JAVA;
            }
            case FLASH: {
                return Media.Player.FLASH;
            }
        }
        throw new AssertionError((Object)("invalid case: " + (Object)((Object)p)));
    }

    public static MediaContentHolder.MediaContent forward(MediaContent mc) {
        MediaContentHolder.MediaContent.Builder cb = MediaContentHolder.MediaContent.newBuilder();
        cb.setMedia(MediaContentTransform.forwardMedia(mc.getMedia()));
        for (Image image : mc.getImages()) {
            cb.addImage(MediaContentTransform.forwardImage(image));
        }
        return cb.build();
    }

    public static MediaContentHolder.Media forwardMedia(Media media) {
        MediaContentHolder.Media.Builder mb = MediaContentHolder.Media.newBuilder();
        mb.setUri(media.getUri());
        String title = media.getTitle();
        if (title != null) {
            mb.setTitle(title);
        }
        mb.setWidth(media.getWidth());
        mb.setHeight(media.getHeight());
        mb.setFormat(media.getFormat());
        mb.setDuration(media.getDuration());
        mb.setSize(media.getSize());
        mb.setBitrate(media.getBitrate());
        for (String person : media.getPersons()) {
            mb.addPerson(person);
        }
        mb.setPlayer(MediaContentTransform.forwardPlayer(media.getPlayer()));
        String copyright = media.getCopyright();
        if (copyright != null) {
            mb.setCopyright(copyright);
        }
        return mb.build();
    }

    public static MediaContentHolder.Media.Player forwardPlayer(Media.Player p) {
        switch (p) {
            case JAVA: {
                return MediaContentHolder.Media.Player.JAVA;
            }
            case FLASH: {
                return MediaContentHolder.Media.Player.FLASH;
            }
        }
        throw new AssertionError((Object)("invalid case: " + (Object)((Object)p)));
    }

    public static MediaContentHolder.Image forwardImage(Image image) {
        MediaContentHolder.Image.Builder ib = MediaContentHolder.Image.newBuilder();
        ib.setUri(image.getUri());
        String title = image.getTitle();
        if (title != null) {
            ib.setTitle(title);
        }
        ib.setWidth(image.getWidth());
        ib.setHeight(image.getHeight());
        ib.setSize(MediaContentTransform.forwardSize(image.getSize()));
        return ib.build();
    }

    public static MediaContentHolder.Image.Size forwardSize(Image.Size s) {
        switch (s) {
            case SMALL: {
                return MediaContentHolder.Image.Size.SMALL;
            }
            case LARGE: {
                return MediaContentHolder.Image.Size.LARGE;
            }
        }
        throw new AssertionError((Object)("invalid case: " + (Object)((Object)s)));
    }
}

