/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson2.benchmark.primitves;

import com.alibaba.fastjson2.JSON;
import com.alibaba.fastjson2.JSONB;
import com.alibaba.fastjson2.benchmark.primitves.vo.Int20Field;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.InputStream;
import java.util.concurrent.TimeUnit;
import org.apache.commons.io.IOUtils;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.infra.Blackhole;
import org.openjdk.jmh.runner.Runner;
import org.openjdk.jmh.runner.RunnerException;
import org.openjdk.jmh.runner.options.Options;
import org.openjdk.jmh.runner.options.OptionsBuilder;

public class IntValue20 {
    static final Class OBJECT_CLASS = Int20Field.class;
    static String str;
    static byte[] jsonbBytes;
    static ObjectMapper mapper;

    public IntValue20() {
        try {
            InputStream is = IntValue20.class.getClassLoader().getResourceAsStream("data/Int20.json");
            str = IOUtils.toString((InputStream)is, (String)"UTF-8");
            jsonbBytes = JSONB.toBytes((Object)JSON.parseObject((String)str, (Class)OBJECT_CLASS));
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    @Benchmark
    public void fastjson1(Blackhole bh) {
        bh.consume(com.alibaba.fastjson.JSON.parseObject((String)str, (Class)OBJECT_CLASS));
    }

    @Benchmark
    public void wastjson(Blackhole bh) {
        bh.consume(io.github.wycst.wast.json.JSON.parseObject((String)str, (Class)OBJECT_CLASS));
    }

    @Benchmark
    public void fastjson2(Blackhole bh) {
        bh.consume(JSON.parseObject((String)str, (Class)OBJECT_CLASS));
    }

    @Benchmark
    public void fastjson2_jsonb(Blackhole bh) {
        bh.consume(JSONB.parseObject((byte[])jsonbBytes, (Class)OBJECT_CLASS));
    }

    @Benchmark
    public void jackson(Blackhole bh) throws Exception {
        bh.consume(mapper.readValue(str, OBJECT_CLASS));
    }

    public static void main(String[] args) throws RunnerException {
        Options options = new OptionsBuilder().include(OBJECT_CLASS.getName()).mode(Mode.Throughput).timeUnit(TimeUnit.MILLISECONDS).warmupIterations(3).forks(1).build();
        new Runner(options).run();
    }

    static {
        mapper = new ObjectMapper();
    }
}

