/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson2.benchmark.jjb;

import com.alibaba.fastjson2.JSON;
import com.alibaba.fastjson2.benchmark.eishay.EishayParseUTF8BytesPretty;
import com.alibaba.fastjson2.benchmark.jjb.Users;
import com.dslplatform.json.DslJson;
import com.dslplatform.json.runtime.Settings;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.gson.Gson;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.TimeUnit;
import org.apache.commons.io.IOUtils;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.infra.Blackhole;
import org.openjdk.jmh.runner.Runner;
import org.openjdk.jmh.runner.RunnerException;
import org.openjdk.jmh.runner.options.Options;
import org.openjdk.jmh.runner.options.OptionsBuilder;

public class UsersParseUTF8Bytes {
    static byte[] utf8Bytes;
    static char[] chars;
    static String str;
    static final ObjectMapper mapper;
    static final Gson gson;
    static final DslJson<Object> dslJson;

    @Benchmark
    public void fastjson2(Blackhole bh) {
        bh.consume(JSON.parseObject((byte[])utf8Bytes, Users.class));
    }

    public void fastjson2_str(Blackhole bh) {
        bh.consume(JSON.parseObject((String)str, Users.class));
    }

    public void fastjson2_chars(Blackhole bh) {
        bh.consume(JSON.parseObject((char[])chars, Users.class));
    }

    @Benchmark
    public void wast(Blackhole bh) {
        bh.consume(io.github.wycst.wast.json.JSON.parseObject((byte[])utf8Bytes, Users.class));
    }

    public void dsljson(Blackhole bh) throws IOException {
        bh.consume(dslJson.deserialize(Users.class, utf8Bytes, utf8Bytes.length));
    }

    public void jackson(Blackhole bh) throws Exception {
        bh.consume(mapper.readValue(utf8Bytes, Users.class));
    }

    public void gson(Blackhole bh) throws Exception {
        bh.consume(gson.fromJson(new String(utf8Bytes, 0, utf8Bytes.length, StandardCharsets.UTF_8), Users.class));
    }

    public static void main(String[] args) throws RunnerException {
        Options options = new OptionsBuilder().include(UsersParseUTF8Bytes.class.getName()).exclude(EishayParseUTF8BytesPretty.class.getName()).mode(Mode.Throughput).timeUnit(TimeUnit.MILLISECONDS).warmupIterations(3).forks(2).threads(16).build();
        new Runner(options).run();
    }

    static {
        mapper = new ObjectMapper();
        gson = new Gson();
        dslJson = new DslJson(Settings.withRuntime().includeServiceLoader());
        try {
            InputStream is = UsersParseUTF8Bytes.class.getClassLoader().getResourceAsStream("data/jjb/user.json");
            str = IOUtils.toString((InputStream)is, (String)"UTF-8");
            utf8Bytes = str.getBytes(StandardCharsets.UTF_8);
            chars = str.toCharArray();
        }
        catch (Throwable ex) {
            ex.printStackTrace();
        }
    }
}

