/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson2.benchmark;

import com.alibaba.fastjson2.JSON;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.BufferedInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.concurrent.TimeUnit;
import java.util.zip.ZipInputStream;
import org.apache.commons.io.IOUtils;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.infra.Blackhole;
import org.openjdk.jmh.runner.Runner;
import org.openjdk.jmh.runner.options.Options;
import org.openjdk.jmh.runner.options.OptionsBuilder;

public class LargeFile26MTest {
    static String str;
    static ObjectMapper mapper;
    static final int COUNT = 10;

    @Benchmark
    public void fastjson1(Blackhole bh) {
        bh.consume(com.alibaba.fastjson.JSON.parseObject((String)str, ArrayList.class));
    }

    @Benchmark
    public void fastjson2(Blackhole bh) {
        bh.consume(JSON.parseObject((String)str, ArrayList.class));
    }

    @Benchmark
    public void jackson(Blackhole bh) throws Exception {
        bh.consume(mapper.readValue(str, ArrayList.class));
    }

    public void fastjson1_perf_test() {
        for (int i = 0; i < 10; ++i) {
            LargeFile26MTest.fastjson1_perf();
        }
    }

    public void fastjson2_perf_test() {
        for (int i = 0; i < 10; ++i) {
            LargeFile26MTest.fastjson2_perf();
        }
    }

    public void jackson_perf_test() throws Exception {
        for (int i = 0; i < 10; ++i) {
            LargeFile26MTest.jackson_perf();
        }
    }

    public static void fastjson2_perf() {
        long start = System.currentTimeMillis();
        for (int i = 0; i < 10; ++i) {
            JSON.parseObject((String)str, ArrayList.class);
        }
        long millis = System.currentTimeMillis() - start;
        System.out.println("fastjson2 millis : " + millis);
    }

    public static void jackson_perf() throws Exception {
        long start = System.currentTimeMillis();
        for (int i = 0; i < 10; ++i) {
            mapper.readValue(str, ArrayList.class);
        }
        long millis = System.currentTimeMillis() - start;
        System.out.println("jackson millis : " + millis);
    }

    public static void fastjson1_perf() {
        long start = System.currentTimeMillis();
        for (int i = 0; i < 10; ++i) {
            com.alibaba.fastjson.JSON.parseObject((String)str, ArrayList.class);
        }
        long millis = System.currentTimeMillis() - start;
        System.out.println("fastjson1 millis : " + millis);
    }

    public static void main(String[] args) throws Exception {
        Options options = new OptionsBuilder().include(LargeFile26MTest.class.getName()).mode(Mode.Throughput).timeUnit(TimeUnit.MILLISECONDS).forks(1).build();
        new Runner(options).run();
    }

    static {
        mapper = new ObjectMapper();
        try (InputStream fis = LargeFile26MTest.class.getClassLoader().getResourceAsStream("data/large-file.json.zip");
             BufferedInputStream bis = new BufferedInputStream(fis);
             ZipInputStream zipIn = new ZipInputStream(bis);){
            zipIn.getNextEntry();
            str = IOUtils.toString((InputStream)zipIn, (String)"UTF-8");
        }
        catch (Throwable ex) {
            ex.printStackTrace();
        }
    }
}

