/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson2.benchmark;

import com.alibaba.fastjson2.util.DateUtils;
import com.alibaba.fastjson2.util.JDKUtils;
import java.text.SimpleDateFormat;
import java.time.DateTimeException;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.Date;
import java.util.concurrent.TimeUnit;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.infra.Blackhole;
import org.openjdk.jmh.runner.Runner;
import org.openjdk.jmh.runner.options.Options;
import org.openjdk.jmh.runner.options.OptionsBuilder;

public class DateWrite {
    static final ZoneId ZONE_ID_SHANGHAI = ZoneId.of("Asia/Shanghai");
    static final DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss").withZone(ZONE_ID_SHANGHAI);
    static final ThreadLocal<SimpleDateFormat> formatThreadLocal = ThreadLocal.withInitial(() -> new SimpleDateFormat("yyyy-MM-dd HH:mm:ss"));
    static Date[] dates = new Date[12];

    @Benchmark
    public void dateTimeFormatter(Blackhole bh) {
        for (int i = 0; i < dates.length; ++i) {
            Date date = dates[i];
            bh.consume((Object)formatter.format(date.toInstant()));
        }
    }

    @Benchmark
    public void simpleDateFormat(Blackhole bh) throws Exception {
        for (int i = 0; i < dates.length; ++i) {
            Date date = dates[i];
            SimpleDateFormat format = formatThreadLocal.get();
            bh.consume((Object)format.format(date));
        }
    }

    @Benchmark
    public void formatYYYYMMDDHHMMSS19(Blackhole bh) throws Throwable {
        for (int i = 0; i < dates.length; ++i) {
            Date date = dates[i];
            DateWrite.formatYYYYMMDDHHMMSS19(ZONE_ID_SHANGHAI, date);
        }
    }

    static String formatYYYYMMDDHHMMSS19(ZoneId zoneId, Date date) throws Throwable {
        long yearEst;
        long doyEst;
        int offsetTotalSeconds;
        long millis = date.getTime();
        long SECONDS_PER_DAY = 86400L;
        long epochSecond = Math.floorDiv(millis, 1000L);
        if (zoneId == DateUtils.SHANGHAI_ZONE_ID || zoneId.getRules() == DateUtils.SHANGHAI_ZONE_RULES) {
            offsetTotalSeconds = DateUtils.getShanghaiZoneOffsetTotalSeconds((long)epochSecond);
        } else {
            Instant instant = Instant.ofEpochMilli(millis);
            offsetTotalSeconds = zoneId.getRules().getOffset(instant).getTotalSeconds();
        }
        long localSecond = epochSecond + (long)offsetTotalSeconds;
        long localEpochDay = Math.floorDiv(localSecond, 86400L);
        int secsOfDay = (int)Math.floorMod(localSecond, 86400L);
        int DAYS_PER_CYCLE = 146097;
        long DAYS_0000_TO_1970 = 719528L;
        long zeroDay = localEpochDay + 719528L;
        long adjust = 0L;
        if ((zeroDay -= 60L) < 0L) {
            long adjustCycles = (zeroDay + 1L) / 146097L - 1L;
            adjust = adjustCycles * 400L;
            zeroDay += -adjustCycles * 146097L;
        }
        if ((doyEst = zeroDay - (365L * (yearEst = (400L * zeroDay + 591L) / 146097L) + yearEst / 4L - yearEst / 100L + yearEst / 400L)) < 0L) {
            doyEst = zeroDay - (365L * --yearEst + yearEst / 4L - yearEst / 100L + yearEst / 400L);
        }
        yearEst += adjust;
        int marchDoy0 = (int)doyEst;
        int marchMonth0 = (marchDoy0 * 5 + 2) / 153;
        int month = (marchMonth0 + 2) % 12 + 1;
        int dayOfMonth = marchDoy0 - (marchMonth0 * 306 + 5) / 10 + 1;
        if ((yearEst += (long)(marchMonth0 / 10)) < -999999999L || yearEst > 999999999L) {
            throw new DateTimeException("Invalid year " + yearEst);
        }
        int year = (int)yearEst;
        int MINUTES_PER_HOUR = 60;
        int SECONDS_PER_MINUTE = 60;
        int SECONDS_PER_HOUR = 3600;
        long secondOfDay = secsOfDay;
        if (secondOfDay < 0L || secondOfDay > 86399L) {
            throw new DateTimeException("Invalid secondOfDay " + secondOfDay);
        }
        int hours = (int)(secondOfDay / 3600L);
        int minutes = (int)((secondOfDay -= (long)(hours * 3600)) / 60L);
        int hour = hours;
        int minute = minutes;
        int second = (int)(secondOfDay -= (long)(minutes * 60));
        if (JDKUtils.STRING_CREATOR_JDK8 != null) {
            char[] chars = new char[]{(char)(year / 1000 + 48), (char)(year / 100 % 10 + 48), (char)(year / 10 % 10 + 48), (char)(year % 10 + 48), '-', (char)(month / 10 + 48), (char)(month % 10 + 48), '-', (char)(dayOfMonth / 10 + 48), (char)(dayOfMonth % 10 + 48), ' ', (char)(hour / 10 + 48), (char)(hour % 10 + 48), ':', (char)(minute / 10 + 48), (char)(minute % 10 + 48), ':', (char)(second / 10 + 48), (char)(second % 10 + 48)};
            return (String)JDKUtils.STRING_CREATOR_JDK8.apply(chars, Boolean.TRUE);
        }
        byte[] bytes = new byte[]{(byte)(year / 1000 + 48), (byte)(year / 100 % 10 + 48), (byte)(year / 10 % 10 + 48), (byte)(year % 10 + 48), 45, (byte)(month / 10 + 48), (byte)(month % 10 + 48), 45, (byte)(dayOfMonth / 10 + 48), (byte)(dayOfMonth % 10 + 48), 32, (byte)(hour / 10 + 48), (byte)(hour % 10 + 48), 58, (byte)(minute / 10 + 48), (byte)(minute % 10 + 48), 58, (byte)(second / 10 + 48), (byte)(second % 10 + 48)};
        if (JDKUtils.STRING_CREATOR_JDK11 != null) {
            return (String)JDKUtils.STRING_CREATOR_JDK11.apply(bytes, JDKUtils.LATIN1);
        }
        return new String(bytes, 0, bytes.length);
    }

    public static void main(String[] args) throws Exception {
        Options options = new OptionsBuilder().include(DateWrite.class.getName()).mode(Mode.Throughput).timeUnit(TimeUnit.MILLISECONDS).warmupIterations(3).forks(1).build();
        new Runner(options).run();
    }

    static {
        String[] strings = new String[]{"2001-07-01 01:02:03", "2011-06-02 09:02:03", "2021-11-03 02:02:03", "2001-11-14 07:02:03", "2002-10-07 16:02:03", "2003-09-12 15:02:03", "2006-08-16 02:02:03", "2002-01-30 22:02:03", "2009-02-27 01:02:03", "2011-04-26 11:02:03", "2012-06-23 01:02:03", "2022-02-18 09:02:03"};
        for (int i = 0; i < strings.length; ++i) {
            LocalDateTime ldt = LocalDateTime.parse(strings[i], formatter);
            long millis = ldt.atZone(ZONE_ID_SHANGHAI).toInstant().toEpochMilli();
            DateWrite.dates[i] = new Date(millis);
        }
    }
}

