/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson2.benchmark.eishay;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson2.JSONFactory;
import com.alibaba.fastjson2.JSONReader;
import com.alibaba.fastjson2.JSONWriter;
import com.alibaba.fastjson2.benchmark.eishay.EishayWriteStringNoneCache;
import com.alibaba.fastjson2.benchmark.eishay.EishayWriteStringTree;
import com.alibaba.fastjson2.benchmark.eishay.EishayWriteStringTree1x;
import com.alibaba.fastjson2.benchmark.eishay.mixin.ImageMixin;
import com.alibaba.fastjson2.benchmark.eishay.mixin.MediaContentMixin;
import com.alibaba.fastjson2.benchmark.eishay.mixin.MediaMixin;
import com.alibaba.fastjson2.benchmark.eishay.vo.Image;
import com.alibaba.fastjson2.benchmark.eishay.vo.Media;
import com.alibaba.fastjson2.benchmark.eishay.vo.MediaContent;
import com.alibaba.fastjson2.writer.ObjectWriterProvider;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.gson.Gson;
import java.io.InputStream;
import java.util.concurrent.TimeUnit;
import org.apache.commons.io.IOUtils;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.infra.Blackhole;
import org.openjdk.jmh.runner.Runner;
import org.openjdk.jmh.runner.RunnerException;
import org.openjdk.jmh.runner.options.Options;
import org.openjdk.jmh.runner.options.OptionsBuilder;

public class EishayWriteString {
    static MediaContent mc;
    static final ObjectMapper mapper;
    static final Gson gson;
    static ObjectWriterProvider provider;

    @Benchmark
    public void fastjson1(Blackhole bh) {
        bh.consume((Object)JSON.toJSONString((Object)mc));
    }

    @Benchmark
    public void fastjson2(Blackhole bh) {
        bh.consume((Object)com.alibaba.fastjson2.JSON.toJSONString((Object)mc));
    }

    public void fastjson2Mixin(Blackhole bh) {
        bh.consume((Object)com.alibaba.fastjson2.JSON.toJSONString((Object)mc, (JSONWriter.Context)JSONFactory.createWriteContext((ObjectWriterProvider)provider, (JSONWriter.Feature[])new JSONWriter.Feature[0])));
    }

    @Benchmark
    public void jackson(Blackhole bh) throws Exception {
        bh.consume((Object)mapper.writeValueAsString((Object)mc));
    }

    public void wastjson(Blackhole bh) throws Exception {
        bh.consume((Object)io.github.wycst.wast.json.JSON.toJsonString((Object)mc));
    }

    @Benchmark
    public void gson(Blackhole bh) throws Exception {
        bh.consume((Object)gson.toJson((Object)mc));
    }

    public static void main(String[] args) throws RunnerException {
        Options options = new OptionsBuilder().include(EishayWriteString.class.getName()).exclude(EishayWriteStringNoneCache.class.getName()).exclude(EishayWriteStringTree.class.getName()).exclude(EishayWriteStringTree1x.class.getName()).mode(Mode.Throughput).warmupIterations(3).timeUnit(TimeUnit.MILLISECONDS).warmupIterations(3).forks(1).threads(16).build();
        new Runner(options).run();
    }

    static {
        mapper = new ObjectMapper();
        gson = new Gson();
        provider = new ObjectWriterProvider();
        try {
            InputStream is = EishayWriteString.class.getClassLoader().getResourceAsStream("data/eishay.json");
            String str = IOUtils.toString((InputStream)is, (String)"UTF-8");
            mc = (MediaContent)JSONReader.of((String)str).read(MediaContent.class);
            provider.register(MediaContent.class, MediaContentMixin.objectWriter);
            provider.register(Media.class, MediaMixin.objectWriter);
            provider.register(Image.class, ImageMixin.objectWriter);
        }
        catch (Throwable ex) {
            ex.printStackTrace();
        }
    }
}

