/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson2.benchmark.taobao;

import com.alibaba.fastjson2.JSON;
import com.alibaba.fastjson2.JSONArray;
import com.alibaba.fastjson2.JSONB;
import com.alibaba.fastjson2.JSONFactory;
import com.alibaba.fastjson2.JSONObject;
import com.alibaba.fastjson2.JSONReader;
import java.net.URL;
import org.openjdk.jmh.infra.Blackhole;

public class TaobaoDetailBench {
    static final Blackhole BH = new Blackhole("Today's password is swordfish. I understand instantiating Blackholes directly is dangerous.");
    static JSONReader.Context context = JSONFactory.createReadContext(() -> new com.alibaba.fastjson.JSONObject(), () -> new com.alibaba.fastjson.JSONArray(), (JSONReader.Feature[])new JSONReader.Feature[0]);

    public static void main(String ... args) throws Exception {
        URL resource = Thread.currentThread().getContextClassLoader().getResource("taobao/taodetail_296KB.json");
        JSONObject jsonObject = JSON.parseObject((URL)resource);
        TaobaoDetailBench.perf(jsonObject);
    }

    public static void perf(JSONObject jsonObject) {
        JSONObject dataValue = jsonObject.getJSONObject("data");
        JSONArray apiStack = dataValue.getJSONArray("apiStack");
        String valueStr = apiStack.getJSONObject(0).getString("value");
        JSONObject valueObject = JSON.parseObject((String)valueStr);
        apiStack.getJSONObject(0).remove((Object)"value");
        apiStack.getJSONObject(0).put((Object)"value", (Object)valueObject);
        byte[] utf8 = JSON.toJSONBytes((Object)jsonObject);
        byte[] jsonb = JSONB.toBytes((Object)jsonObject);
        for (int i = 0; i < 5; ++i) {
            TaobaoDetailBench.jsonbParse(jsonb);
        }
    }

    public static void jsonParse(byte[] utf8) {
        long start = System.currentTimeMillis();
        for (int i = 0; i < 1000; ++i) {
            JSONObject jsonObject = JSON.parseObject((byte[])utf8);
            JSONObject dataValue = jsonObject.getJSONObject("data");
            JSONArray apiStack = dataValue.getJSONArray("apiStack");
            BH.consume((Object)apiStack);
        }
        long millis = System.currentTimeMillis() - start;
        System.out.println("jsonParse : " + millis);
    }

    public static void jsonParse2(byte[] utf8) {
        long start = System.currentTimeMillis();
        for (int i = 0; i < 1000; ++i) {
            com.alibaba.fastjson.JSONObject jsonObject = (com.alibaba.fastjson.JSONObject)JSON.parse((byte[])utf8, (JSONReader.Context)context);
            com.alibaba.fastjson.JSONObject dataValue = jsonObject.getJSONObject("data");
            com.alibaba.fastjson.JSONArray apiStack = dataValue.getJSONArray("apiStack");
            BH.consume((Object)apiStack);
        }
        long millis = System.currentTimeMillis() - start;
        System.out.println("jsonParse2 : " + millis);
    }

    public static void jsonbParse(byte[] jsonb) {
        long start = System.currentTimeMillis();
        for (int i = 0; i < 1000; ++i) {
            JSONObject jsonObject = JSONB.parseObject((byte[])jsonb);
            JSONObject dataValue = jsonObject.getJSONObject("data");
            JSONArray apiStack = dataValue.getJSONArray("apiStack");
            BH.consume((Object)apiStack);
        }
        long millis = System.currentTimeMillis() - start;
        System.out.println("jsonbParse : " + millis);
    }

    public static void jsonbParse2(byte[] jsonb) {
        long start = System.currentTimeMillis();
        for (int i = 0; i < 1000; ++i) {
            com.alibaba.fastjson.JSONObject jsonObject = (com.alibaba.fastjson.JSONObject)JSONB.parse((byte[])jsonb, (JSONReader.Context)context);
            com.alibaba.fastjson.JSONObject dataValue = jsonObject.getJSONObject("data");
            com.alibaba.fastjson.JSONArray apiStack = dataValue.getJSONArray("apiStack");
            BH.consume((Object)apiStack);
        }
        long millis = System.currentTimeMillis() - start;
        System.out.println("jsonbParse : " + millis);
    }

    public static void perfLevel2(JSONObject jsonObject) {
        byte[] utf8 = JSON.toJSONBytes((Object)jsonObject);
        JSONObject dataValue = jsonObject.getJSONObject("data");
        JSONArray apiStack = dataValue.getJSONArray("apiStack");
        String valueStr = apiStack.getJSONObject(0).getString("value");
        JSONObject valueObject = JSON.parseObject((String)valueStr);
        apiStack.getJSONObject(0).remove((Object)"value");
        apiStack.getJSONObject(0).put((Object)"value", (Object)JSONB.toBytes((Object)valueObject));
        byte[] jsonb = JSONB.toBytes((Object)jsonObject);
        for (int i = 0; i < 5; ++i) {
            TaobaoDetailBench.jsonParseLevel2(utf8);
        }
    }

    public static void jsonParseLevel2(byte[] utf8) {
        long start = System.currentTimeMillis();
        for (int i = 0; i < 1000; ++i) {
            JSONObject jsonObject = JSON.parseObject((byte[])utf8);
            JSONObject dataValue = jsonObject.getJSONObject("data");
            JSONArray apiStack = dataValue.getJSONArray("apiStack");
            String valueStr = apiStack.getJSONObject(0).getString("value");
            JSONObject valueObject = JSON.parseObject((String)valueStr);
            apiStack.getJSONObject(0).remove((Object)"value");
            apiStack.getJSONObject(0).put((Object)"value", (Object)valueObject);
            BH.consume((Object)apiStack);
        }
        long millis = System.currentTimeMillis() - start;
        System.out.println("jsonParse : " + millis);
    }

    public static void jsonbParseLevel2(byte[] jsonb) {
        long start = System.currentTimeMillis();
        for (int i = 0; i < 1000; ++i) {
            JSONObject jsonObject = JSONB.parseObject((byte[])jsonb);
            JSONObject dataValue = jsonObject.getJSONObject("data");
            JSONArray apiStack = dataValue.getJSONArray("apiStack");
            byte[] valueBytes = apiStack.getJSONObject(0).getBytes("value");
            JSONObject valueObject = JSONB.parseObject((byte[])valueBytes);
            apiStack.getJSONObject(0).remove((Object)"value");
            apiStack.getJSONObject(0).put((Object)"value", (Object)valueObject);
            BH.consume((Object)apiStack);
        }
        long millis = System.currentTimeMillis() - start;
        System.out.println("jsonParse : " + millis);
    }
}

