/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson2.benchmark.fastcode;

import com.alibaba.fastjson2.util.IOUtils;
import com.alibaba.fastjson2.util.JDKUtils;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.concurrent.TimeUnit;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.infra.Blackhole;
import org.openjdk.jmh.runner.Runner;
import org.openjdk.jmh.runner.RunnerException;
import org.openjdk.jmh.runner.options.Options;
import org.openjdk.jmh.runner.options.OptionsBuilder;

public class LocalDateTimeFormat19 {
    static final String pattern = "yyyy-MM-dd HH:mm:ss";
    static DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
    static LocalDateTime ldt = LocalDateTime.of(2023, 8, 16, 20, 21, 15);

    @Benchmark
    public void javaTimeFormatter(Blackhole bh) throws Throwable {
        String str = formatter.format(ldt);
        bh.consume((Object)str);
    }

    @Benchmark
    public void formatYMDHMS19(Blackhole bh) throws Throwable {
        bh.consume((Object)LocalDateTimeFormat19.formatYMDHMS19(ldt));
    }

    @Benchmark
    public void formatYMDHMS19_o(Blackhole bh) throws Throwable {
        bh.consume((Object)LocalDateTimeFormat19.formatYMDHMS19_o(ldt));
    }

    public static void main(String[] args) throws RunnerException {
        Options options = new OptionsBuilder().include(LocalDateTimeFormat19.class.getName()).mode(Mode.Throughput).timeUnit(TimeUnit.MILLISECONDS).warmupIterations(1).forks(1).build();
        new Runner(options).run();
    }

    public static String formatYMDHMS19(LocalDateTime ldt) {
        int year = ldt.getYear();
        int month = ldt.getMonthValue();
        int dayOfMonth = ldt.getDayOfMonth();
        int hour = ldt.getHour();
        int minute = ldt.getMinute();
        int second = ldt.getSecond();
        byte[] bytes = new byte[19];
        int y01 = year / 100;
        int y23 = year - y01 * 100;
        JDKUtils.UNSAFE.putShort(bytes, JDKUtils.ARRAY_BYTE_BASE_OFFSET, IOUtils.PACKED_DIGITS[y01]);
        JDKUtils.UNSAFE.putShort(bytes, JDKUtils.ARRAY_BYTE_BASE_OFFSET + 2L, IOUtils.PACKED_DIGITS[y23]);
        bytes[4] = 45;
        JDKUtils.UNSAFE.putShort(bytes, JDKUtils.ARRAY_BYTE_BASE_OFFSET + 5L, IOUtils.PACKED_DIGITS[month]);
        bytes[7] = 45;
        JDKUtils.UNSAFE.putShort(bytes, JDKUtils.ARRAY_BYTE_BASE_OFFSET + 8L, IOUtils.PACKED_DIGITS[dayOfMonth]);
        bytes[10] = 32;
        JDKUtils.UNSAFE.putShort(bytes, JDKUtils.ARRAY_BYTE_BASE_OFFSET + 11L, IOUtils.PACKED_DIGITS[hour]);
        bytes[13] = 58;
        JDKUtils.UNSAFE.putShort(bytes, JDKUtils.ARRAY_BYTE_BASE_OFFSET + 14L, IOUtils.PACKED_DIGITS[minute]);
        bytes[16] = 58;
        JDKUtils.UNSAFE.putShort(bytes, JDKUtils.ARRAY_BYTE_BASE_OFFSET + 17L, IOUtils.PACKED_DIGITS[second]);
        return (String)JDKUtils.STRING_CREATOR_JDK11.apply(bytes, JDKUtils.LATIN1);
    }

    static String formatYMDHMS19_o(LocalDateTime ldt) {
        int year = ldt.getYear();
        int month = ldt.getMonthValue();
        int dayOfMonth = ldt.getDayOfMonth();
        int hour = ldt.getHour();
        int minute = ldt.getMinute();
        int second = ldt.getSecond();
        int y0 = year / 1000 + 48;
        int y1 = year / 100 % 10 + 48;
        int y2 = year / 10 % 10 + 48;
        int y3 = year % 10 + 48;
        int m0 = month / 10 + 48;
        int m1 = month % 10 + 48;
        int d0 = dayOfMonth / 10 + 48;
        int d1 = dayOfMonth % 10 + 48;
        int h0 = hour / 10 + 48;
        int h1 = hour % 10 + 48;
        int i0 = minute / 10 + 48;
        int i1 = minute % 10 + 48;
        int s0 = second / 10 + 48;
        int s1 = second % 10 + 48;
        byte[] bytes = new byte[]{(byte)y0, (byte)y1, (byte)y2, (byte)y3, 45, (byte)m0, (byte)m1, 45, (byte)d0, (byte)d1, 32, (byte)h0, (byte)h1, 58, (byte)i0, (byte)i1, 58, (byte)s0, (byte)s1};
        return (String)JDKUtils.STRING_CREATOR_JDK11.apply(bytes, JDKUtils.LATIN1);
    }
}

