/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson2.benchmark;

import com.alibaba.fastjson2.benchmark.eishay.EishayParseBinary;
import com.alibaba.fastjson2.support.csv.CSVReader;
import com.univocity.parsers.annotations.Parsed;
import com.univocity.parsers.csv.CsvFormat;
import com.univocity.parsers.csv.CsvParserSettings;
import com.univocity.parsers.csv.CsvRoutines;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.apache.commons.io.IOUtils;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.infra.Blackhole;
import org.openjdk.jmh.runner.Runner;
import org.openjdk.jmh.runner.RunnerException;
import org.openjdk.jmh.runner.options.Options;
import org.openjdk.jmh.runner.options.OptionsBuilder;

public class CSVPerson {
    static final String file = "csv/person.csv";
    static byte[] byteArray;

    @Benchmark
    public void fastjson2(Blackhole BH) {
        CSVReader.of((InputStream)new ByteArrayInputStream(byteArray), (Charset)StandardCharsets.UTF_8, Person.class).readLineObjectAll(arg_0 -> ((Blackhole)BH).consume(arg_0));
    }

    @Benchmark
    public void univocity(Blackhole BH) {
        CsvParserSettings settings = new CsvParserSettings();
        CsvRoutines processor = new CsvRoutines(settings);
        ((CsvFormat)settings.getFormat()).setLineSeparator("\n");
        settings.setNumberOfRowsToSkip(1L);
        processor.iterate(Person.class, (InputStream)new ByteArrayInputStream(byteArray)).forEach(arg_0 -> ((Blackhole)BH).consume(arg_0));
    }

    public void cainiao(Blackhole BH) {
    }

    public static void main(String[] args) throws RunnerException {
        Options options = new OptionsBuilder().include(CSVPerson.class.getName()).mode(Mode.Throughput).timeUnit(TimeUnit.MILLISECONDS).warmupIterations(3).forks(1).build();
        new Runner(options).run();
    }

    static {
        try (InputStream is = EishayParseBinary.class.getClassLoader().getResourceAsStream(file);){
            String str = IOUtils.toString((InputStream)is, (String)"UTF-8");
            byteArray = str.getBytes();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static class Person {
        @Parsed(index=0)
        public String name;
        @Parsed(index=1)
        public Double weight;
        @Parsed(index=2)
        public Integer age;
        @Parsed(index=3)
        public String gender;
        @Parsed(index=4)
        public Integer height;
        @Parsed(index=5)
        public String address;
        @Parsed(index=6)
        public Integer id;
        @Parsed(index=7)
        public Boolean single;

        @Generated
        public Person() {
        }

        @Generated
        public String getName() {
            return this.name;
        }

        @Generated
        public Double getWeight() {
            return this.weight;
        }

        @Generated
        public Integer getAge() {
            return this.age;
        }

        @Generated
        public String getGender() {
            return this.gender;
        }

        @Generated
        public Integer getHeight() {
            return this.height;
        }

        @Generated
        public String getAddress() {
            return this.address;
        }

        @Generated
        public Integer getId() {
            return this.id;
        }

        @Generated
        public Boolean getSingle() {
            return this.single;
        }

        @Generated
        public void setName(String name) {
            this.name = name;
        }

        @Generated
        public void setWeight(Double weight) {
            this.weight = weight;
        }

        @Generated
        public void setAge(Integer age) {
            this.age = age;
        }

        @Generated
        public void setGender(String gender) {
            this.gender = gender;
        }

        @Generated
        public void setHeight(Integer height) {
            this.height = height;
        }

        @Generated
        public void setAddress(String address) {
            this.address = address;
        }

        @Generated
        public void setId(Integer id) {
            this.id = id;
        }

        @Generated
        public void setSingle(Boolean single) {
            this.single = single;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Person)) {
                return false;
            }
            Person other = (Person)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Double this$weight = this.getWeight();
            Double other$weight = other.getWeight();
            if (this$weight == null ? other$weight != null : !((Object)this$weight).equals(other$weight)) {
                return false;
            }
            Integer this$age = this.getAge();
            Integer other$age = other.getAge();
            if (this$age == null ? other$age != null : !((Object)this$age).equals(other$age)) {
                return false;
            }
            Integer this$height = this.getHeight();
            Integer other$height = other.getHeight();
            if (this$height == null ? other$height != null : !((Object)this$height).equals(other$height)) {
                return false;
            }
            Integer this$id = this.getId();
            Integer other$id = other.getId();
            if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
                return false;
            }
            Boolean this$single = this.getSingle();
            Boolean other$single = other.getSingle();
            if (this$single == null ? other$single != null : !((Object)this$single).equals(other$single)) {
                return false;
            }
            String this$name = this.getName();
            String other$name = other.getName();
            if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
                return false;
            }
            String this$gender = this.getGender();
            String other$gender = other.getGender();
            if (this$gender == null ? other$gender != null : !this$gender.equals(other$gender)) {
                return false;
            }
            String this$address = this.getAddress();
            String other$address = other.getAddress();
            return !(this$address == null ? other$address != null : !this$address.equals(other$address));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof Person;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Double $weight = this.getWeight();
            result = result * 59 + ($weight == null ? 43 : ((Object)$weight).hashCode());
            Integer $age = this.getAge();
            result = result * 59 + ($age == null ? 43 : ((Object)$age).hashCode());
            Integer $height = this.getHeight();
            result = result * 59 + ($height == null ? 43 : ((Object)$height).hashCode());
            Integer $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            Boolean $single = this.getSingle();
            result = result * 59 + ($single == null ? 43 : ((Object)$single).hashCode());
            String $name = this.getName();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            String $gender = this.getGender();
            result = result * 59 + ($gender == null ? 43 : $gender.hashCode());
            String $address = this.getAddress();
            result = result * 59 + ($address == null ? 43 : $address.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "CSVPerson.Person(name=" + this.getName() + ", weight=" + this.getWeight() + ", age=" + this.getAge() + ", gender=" + this.getGender() + ", height=" + this.getHeight() + ", address=" + this.getAddress() + ", id=" + this.getId() + ", single=" + this.getSingle() + ")";
        }
    }
}

