/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson2.benchmark.utf8;

import com.alibaba.fastjson2.util.IOUtils;
import com.alibaba.fastjson2.util.JDKUtils;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import org.openjdk.jmh.infra.Blackhole;

public class UTF8Encode {
    static final CacheItem[] CACHE_ITEMS;
    static final int CACHE_THRESHOLD = 0x400000;
    static final AtomicReferenceFieldUpdater<CacheItem, char[]> CHARS_UPDATER;
    static final AtomicReferenceFieldUpdater<CacheItem, byte[]> BYTES_UPDATER;
    static final String STR_CN_SMALL = "\u898f\u5b9a\u4e86\u56db\u7a2e\u8868";
    static final String STR0 = "EEE 754\u898f\u5b9a\u4e86\u56db\u7a2e\u8868\u793a\u6d6e\u9ede\u6578\u503c\u7684\u65b9\u5f0f\uff1a\u55ae\u7cbe\u78ba\u5ea6\uff0832\u4f4d\u5143\uff09\u3001\u96d9\u7cbe\u78ba\u5ea6\uff0864\u4f4d\u5143\uff09\u3001\u5ef6\u4f38\u55ae\u7cbe\u78ba\u5ea6\uff0843\u4f4d\u5143\u4ee5\u4e0a\uff0c\u5f88\u5c11\u4f7f\u7528\uff09\u8207\u5ef6\u4f38\u96d9\u7cbe\u78ba\u5ea6\uff0879\u4f4d\u5143\u4ee5\u4e0a\uff0c\u901a\u5e38\u4ee580\u4f4d\u5143\u5be6\u505a\uff09\u3002\u53ea\u670932\u4f4d\u5143\u6a21\u5f0f\u6709\u5f37\u5236\u8981\u6c42\uff0c\u5176\u4ed6\u90fd\u662f\u9078\u64c7\u6027\u7684\u3002\u5927\u90e8\u5206\u7a0b\u5f0f\u8a9e\u8a00\u90fd\u63d0\u4f9b\u4e86IEEE\u6d6e\u70b9\u6570\u683c\u5f0f\u8207\u7b97\u8853\uff0c\u4f46\u6709\u4e9b\u5c07\u5176\u5217\u70ba\u975e\u5fc5\u9700\u7684\u3002\u4f8b\u5982\uff0cIEEE 754\u554f\u4e16\u4e4b\u524d\u5c31\u6709\u7684C\u8a9e\u8a00\uff0c\u73fe\u5728\u5305\u62ec\u4e86IEEE\u7b97\u8853\uff0c\u4f46\u4e0d\u7b97\u4f5c\u5f37\u5236\u8981\u6c42\uff08C\u8a9e\u8a00\u7684float\u901a\u5e38\u662f\u6307IEEE\u55ae\u7cbe\u78ba\u5ea6\uff0c\u800cdouble\u662f\u6307\u96d9\u7cbe\u78ba\u5ea6\uff09\u3002";
    static final String STR1 = "ISO/IEC 8859-1:1998, Information technology \u2014 8-bit single-byte coded graphic character sets \u2014 Part 1: Latin alphabet No. 1, is part of the ISO/IEC 8859 series of ASCII-based standard character encodings, first edition published in 1987. ISO/IEC 8859-1 encodes what it refers to as \"Latin alphabet no. 1\", consisting of 191 characters from the Latin script. This character-encoding scheme is used throughout the Americas, Western Europe, Oceania, and much of Africa. It is the basis for some popular 8-bit character sets and the first two blocks of characters in Unicode.";

    public void jdk(Blackhole bh) {
        bh.consume((Object)STR0.getBytes(StandardCharsets.UTF_8));
    }

    public void jdk_small(Blackhole bh) {
        bh.consume((Object)STR_CN_SMALL.getBytes(StandardCharsets.UTF_8));
    }

    public void fj(Blackhole bh) {
        bh.consume((Object)UTF8Encode.encode(STR0));
    }

    public void fj_small(Blackhole bh) {
        bh.consume((Object)UTF8Encode.encode(STR_CN_SMALL));
    }

    public void jdk_ascii(Blackhole bh) {
        bh.consume((Object)STR1.getBytes(StandardCharsets.UTF_8));
    }

    public void fj_ascii(Blackhole bh) {
        byte[] utf8 = UTF8Encode.encode(STR1);
        bh.consume((Object)utf8);
    }

    private static byte[] jdk8(String str) {
        char[] chars = JDKUtils.getCharArray((String)str);
        int cacheIndex = System.identityHashCode(Thread.currentThread()) & CACHE_ITEMS.length - 1;
        CacheItem cacheItem = CACHE_ITEMS[cacheIndex];
        byte[] bytes = BYTES_UPDATER.getAndSet(cacheItem, null);
        int bufferSize = chars.length * 3;
        if (bytes == null || bytes.length < bufferSize) {
            bytes = new byte[bufferSize];
        }
        int cnt = IOUtils.encodeUTF8((char[])chars, (int)0, (int)chars.length, (byte[])bytes, (int)0);
        byte[] utf8 = Arrays.copyOf(bytes, cnt);
        BYTES_UPDATER.lazySet(cacheItem, bytes);
        return utf8;
    }

    private static byte[] encode(String str) {
        if (JDKUtils.JVM_VERSION <= 8 || JDKUtils.STRING_CODER == null) {
            return UTF8Encode.jdk8(str);
        }
        int coder = JDKUtils.STRING_CODER.applyAsInt(str);
        byte[] value = (byte[])JDKUtils.STRING_VALUE.apply(str);
        if (coder == 0) {
            boolean hasNegative;
            try {
                hasNegative = JDKUtils.METHOD_HANDLE_HAS_NEGATIVE.invoke(value, 0, value.length);
            }
            catch (Throwable e) {
                throw new RuntimeException(e);
            }
            if (!hasNegative) {
                return value;
            }
            return str.getBytes(StandardCharsets.UTF_8);
        }
        int cacheIndex = System.identityHashCode(Thread.currentThread()) & CACHE_ITEMS.length - 1;
        CacheItem cacheItem = CACHE_ITEMS[cacheIndex];
        byte[] bytes = BYTES_UPDATER.getAndSet(cacheItem, null);
        int bufferSize = str.length() * 3;
        if (bytes == null || bytes.length < bufferSize) {
            bytes = new byte[bufferSize];
        }
        int cnt = IOUtils.encodeUTF8((byte[])value, (int)0, (int)value.length, (byte[])bytes, (int)0);
        byte[] utf8 = Arrays.copyOf(bytes, cnt);
        BYTES_UPDATER.lazySet(cacheItem, bytes);
        return utf8;
    }

    static {
        CacheItem[] items = new CacheItem[16];
        for (int i = 0; i < items.length; ++i) {
            items[i] = new CacheItem();
        }
        CACHE_ITEMS = items;
        CHARS_UPDATER = AtomicReferenceFieldUpdater.newUpdater(CacheItem.class, char[].class, "chars");
        BYTES_UPDATER = AtomicReferenceFieldUpdater.newUpdater(CacheItem.class, byte[].class, "bytes");
    }

    static final class CacheItem {
        volatile char[] chars;
        volatile byte[] bytes;

        CacheItem() {
        }
    }
}

