/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson2.benchmark;

import com.alibaba.fastjson2.support.csv.CSVReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Type;
import java.net.URL;
import java.util.Date;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.infra.Blackhole;

public class CSVBankList {
    static final String file = "csv/banklist.csv";

    @Benchmark
    public void rowCount(Blackhole bh) throws IOException {
        URL resource = Thread.currentThread().getContextClassLoader().getResource(file);
        if (resource == null) {
            return;
        }
        File file = new File(resource.getFile());
        FileInputStream fileIn = new FileInputStream(file);
        int rowCount = CSVReader.rowCount((InputStream)fileIn);
        bh.consume(rowCount);
    }

    @Benchmark
    public void readLines(Blackhole bh) throws IOException {
        String[] line;
        URL resource = Thread.currentThread().getContextClassLoader().getResource(file);
        if (resource == null) {
            return;
        }
        File file = new File(resource.getFile());
        CSVReader parser = CSVReader.of((File)file, (Type[])new Type[0]);
        int rowCount = 0;
        while ((line = parser.readLine()) != null) {
            ++rowCount;
        }
        bh.consume(rowCount);
    }

    @Benchmark
    public void readLineValues(Blackhole bh) throws IOException {
        Object[] line;
        URL resource = Thread.currentThread().getContextClassLoader().getResource(file);
        if (resource == null) {
            return;
        }
        File file = new File(resource.getFile());
        Type[] types = new Type[]{String.class, String.class, String.class, Integer.class, String.class, Date.class, Integer.class};
        CSVReader parser = CSVReader.of((File)file, (Type[])types);
        parser.readHeader();
        int rowCount = 0;
        while ((line = parser.readLineValues()) != null) {
            ++rowCount;
        }
        bh.consume(rowCount);
    }
}

