/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson2.benchmark.eishay;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson2.JSONB;
import com.alibaba.fastjson2.JSONObject;
import com.alibaba.fastjson2.JSONReader;
import com.alibaba.fastjson2.JSONWriter;
import com.alibaba.fastjson2.benchmark.eishay.EishayWriteStringTree1x;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.gson.Gson;
import java.io.InputStream;
import java.util.concurrent.TimeUnit;
import org.apache.commons.io.IOUtils;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.infra.Blackhole;
import org.openjdk.jmh.runner.Runner;
import org.openjdk.jmh.runner.RunnerException;
import org.openjdk.jmh.runner.options.Options;
import org.openjdk.jmh.runner.options.OptionsBuilder;

public class EishayWriteStringTree {
    static JSONObject mc;
    static final ObjectMapper mapper;
    static final Gson gson;

    @Benchmark
    public void fastjson1(Blackhole bh) {
        bh.consume((Object)JSON.toJSONString((Object)mc));
    }

    @Benchmark
    public void fastjson2(Blackhole bh) {
        bh.consume((Object)com.alibaba.fastjson2.JSON.toJSONString((Object)mc));
    }

    public void fastjson2_ReferenceDetection(Blackhole bh) {
        bh.consume((Object)com.alibaba.fastjson2.JSON.toJSONString((Object)mc, (JSONWriter.Feature[])new JSONWriter.Feature[]{JSONWriter.Feature.ReferenceDetection}));
    }

    public void fastjson2_jsonb(Blackhole bh) {
        bh.consume((Object)JSONB.toBytes((Object)mc));
    }

    @Benchmark
    public void jackson(Blackhole bh) throws Exception {
        bh.consume((Object)mapper.writeValueAsString((Object)mc));
    }

    public void wastjson(Blackhole bh) throws Exception {
        bh.consume((Object)io.github.wycst.wast.json.JSON.toJsonString((Object)mc));
    }

    @Benchmark
    public void gson(Blackhole bh) throws Exception {
        bh.consume((Object)gson.toJson((Object)mc));
    }

    public static void main(String[] args) throws RunnerException {
        Options options = new OptionsBuilder().include(EishayWriteStringTree.class.getName()).exclude(EishayWriteStringTree1x.class.getName()).mode(Mode.Throughput).warmupIterations(3).timeUnit(TimeUnit.MILLISECONDS).warmupIterations(3).forks(1).threads(2).build();
        new Runner(options).run();
    }

    static {
        mapper = new ObjectMapper();
        gson = new Gson();
        try {
            InputStream is = EishayWriteStringTree.class.getClassLoader().getResourceAsStream("data/eishay.json");
            String str = IOUtils.toString((InputStream)is, (String)"UTF-8");
            mc = (JSONObject)JSONReader.of((String)str).readAny();
        }
        catch (Throwable ex) {
            ex.printStackTrace();
        }
    }
}

