/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson2.benchmark.eishay;

import com.alibaba.fastjson2.JSON;
import com.alibaba.fastjson2.JSONB;
import com.alibaba.fastjson2.JSONReader;
import com.alibaba.fastjson2.benchmark.eishay.EishayParseBinaryArrayMapping;
import com.alibaba.fastjson2.benchmark.eishay.EishayParseBinaryAutoType;
import com.alibaba.fastjson2.benchmark.eishay.vo.Image;
import com.alibaba.fastjson2.benchmark.eishay.vo.Media;
import com.alibaba.fastjson2.benchmark.eishay.vo.MediaContent;
import com.caucho.hessian.io.Hessian2Input;
import com.caucho.hessian.io.Hessian2Output;
import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.concurrent.TimeUnit;
import org.apache.commons.io.IOUtils;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.infra.Blackhole;
import org.openjdk.jmh.runner.Runner;
import org.openjdk.jmh.runner.options.Options;
import org.openjdk.jmh.runner.options.OptionsBuilder;

public class EishayParseBinary {
    static MediaContent mc;
    static byte[] fastjson2UTF8Bytes;
    static byte[] fastjson2JSONBBytes;
    static byte[] hessianBytes;
    static byte[] javaSerializeBytes;
    private static final ThreadLocal<Kryo> kryos;
    static byte[] kryoBytes;

    @Benchmark
    public void fastjson2UTF8Bytes(Blackhole bh) {
        bh.consume(JSON.parseObject((byte[])fastjson2UTF8Bytes, MediaContent.class));
    }

    @Benchmark
    public void jsonb(Blackhole bh) {
        bh.consume(JSONB.parseObject((byte[])fastjson2JSONBBytes, MediaContent.class));
    }

    @Benchmark
    public void javaSerialize(Blackhole bh) throws Exception {
        ByteArrayInputStream bytesIn = new ByteArrayInputStream(javaSerializeBytes);
        ObjectInputStream objectIn = new ObjectInputStream(bytesIn);
        bh.consume(objectIn.readObject());
    }

    @Benchmark
    public void hessian(Blackhole bh) throws Exception {
        ByteArrayInputStream bytesIn = new ByteArrayInputStream(hessianBytes);
        Hessian2Input hessian2Input = new Hessian2Input((InputStream)bytesIn);
        bh.consume(hessian2Input.readObject());
    }

    public void kryo(Blackhole bh) throws Exception {
        Input input = new Input(kryoBytes);
        MediaContent object = (MediaContent)kryos.get().readObject(input, MediaContent.class);
        bh.consume((Object)object);
    }

    public static void main(String[] args) throws Exception {
        Options options = new OptionsBuilder().include(EishayParseBinary.class.getName()).exclude(EishayParseBinaryAutoType.class.getName()).exclude(EishayParseBinaryArrayMapping.class.getName()).mode(Mode.Throughput).timeUnit(TimeUnit.MILLISECONDS).warmupIterations(3).forks(1).threads(2).build();
        new Runner(options).run();
    }

    static {
        kryos = new ThreadLocal<Kryo>(){

            @Override
            protected Kryo initialValue() {
                Kryo kryo = new Kryo();
                kryo.register(MediaContent.class);
                kryo.register(ArrayList.class);
                kryo.register(Image.class);
                kryo.register(Image.Size.class);
                kryo.register(Media.class);
                kryo.register(Media.Player.class);
                return kryo;
            }
        };
        try {
            InputStream is = EishayParseBinary.class.getClassLoader().getResourceAsStream("data/eishay.json");
            String str = IOUtils.toString((InputStream)is, (String)"UTF-8");
            mc = (MediaContent)JSONReader.of((String)str).read(MediaContent.class);
            fastjson2UTF8Bytes = JSON.toJSONBytes((Object)mc);
            fastjson2JSONBBytes = JSONB.toBytes((Object)mc);
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            Hessian2Output hessian2Output = new Hessian2Output((OutputStream)byteArrayOutputStream);
            hessian2Output.writeObject((Object)mc);
            hessian2Output.flush();
            hessianBytes = byteArrayOutputStream.toByteArray();
            byteArrayOutputStream = new ByteArrayOutputStream();
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
            objectOutputStream.writeObject(mc);
            objectOutputStream.flush();
            javaSerializeBytes = byteArrayOutputStream.toByteArray();
            Kryo kryo = new Kryo();
            kryo.register(MediaContent.class);
            kryo.register(ArrayList.class);
            kryo.register(Image.class);
            kryo.register(Image.Size.class);
            kryo.register(Media.class);
            kryo.register(Media.Player.class);
            Output output = new Output(1024, -1);
            kryo.writeObject(output, (Object)mc);
            kryoBytes = output.toBytes();
        }
        catch (Throwable ex) {
            ex.printStackTrace();
        }
    }
}

