/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson2.benchmark.primitves;

import com.alibaba.fastjson2.JSON;
import com.alibaba.fastjson2.JSONB;
import com.alibaba.fastjson2.benchmark.primitves.BigDecimal20Tree;
import com.alibaba.fastjson2.benchmark.primitves.vo.BigInteger20Field;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.gson.Gson;
import java.io.InputStream;
import java.util.concurrent.TimeUnit;
import org.apache.commons.io.IOUtils;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.infra.Blackhole;
import org.openjdk.jmh.runner.Runner;
import org.openjdk.jmh.runner.RunnerException;
import org.openjdk.jmh.runner.options.Options;
import org.openjdk.jmh.runner.options.OptionsBuilder;

public class BigInteger20 {
    static BigInteger20Field bean;
    static ObjectMapper mapper;
    static Gson gson;

    public BigInteger20() {
        try {
            InputStream is = BigInteger20.class.getClassLoader().getResourceAsStream("data/bigint20.json");
            String str = IOUtils.toString((InputStream)is, (String)"UTF-8");
            bean = (BigInteger20Field)JSON.parseObject((String)str, BigInteger20Field.class);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    @Benchmark
    public void fastjson1(Blackhole bh) {
        bh.consume((Object)com.alibaba.fastjson.JSON.toJSONString((Object)bean));
    }

    @Benchmark
    public void fastjson2(Blackhole bh) {
        bh.consume((Object)JSON.toJSONString((Object)bean));
    }

    @Benchmark
    public void jsonb(Blackhole bh) {
        bh.consume((Object)JSONB.toBytes((Object)bean));
    }

    @Benchmark
    public void jackson(Blackhole bh) throws Exception {
        bh.consume((Object)mapper.writeValueAsString((Object)bean));
    }

    @Benchmark
    public void gson(Blackhole bh) throws Exception {
        bh.consume((Object)gson.toJson((Object)bean));
    }

    @Benchmark
    public void wastjson(Blackhole bh) throws Exception {
        bh.consume((Object)io.github.wycst.wast.json.JSON.toJsonString((Object)bean));
    }

    public static void main(String[] args) throws RunnerException {
        Options options = new OptionsBuilder().include(BigInteger20.class.getName()).exclude(BigDecimal20Tree.class.getName()).mode(Mode.Throughput).timeUnit(TimeUnit.MILLISECONDS).warmupIterations(3).forks(1).build();
        new Runner(options).run();
    }

    static {
        mapper = new ObjectMapper();
        gson = new Gson();
    }
}

