/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson2.benchmark.eishay;

import com.alibaba.fastjson2.JSONB;
import com.alibaba.fastjson2.JSONReader;
import com.alibaba.fastjson2.util.DynamicClassLoader;
import com.alibaba.fastjson2.util.IOUtils;
import java.io.Closeable;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.zip.ZipInputStream;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.infra.Blackhole;
import org.openjdk.jmh.runner.Runner;
import org.openjdk.jmh.runner.options.Options;
import org.openjdk.jmh.runner.options.OptionsBuilder;

public class EishayFuryParseNoneCache {
    static final int COUNT = 10000;
    static final Class[] classes = new Class[10000];
    static JSONReader.Feature[] features = new JSONReader.Feature[]{JSONReader.Feature.SupportAutoType, JSONReader.Feature.IgnoreNoneSerializable, JSONReader.Feature.UseDefaultConstructorAsPossible, JSONReader.Feature.UseNativeObject, JSONReader.Feature.FieldBased, JSONReader.Feature.SupportArrayToBean};
    static DynamicClassLoader classLoader = DynamicClassLoader.getInstance();
    static byte[][] fastjson2JSONBBytes = new byte[10000][];
    static byte[][] furyBytes = new byte[10000][];
    static int index;

    @Benchmark
    public void fastjson2JSONB(Blackhole bh) {
        Thread.currentThread().setContextClassLoader((ClassLoader)classLoader);
        byte[] bytes = fastjson2JSONBBytes[index++];
        bh.consume(JSONB.parseObject((byte[])bytes, Object.class, (JSONReader.Feature[])features));
    }

    public void fury(Blackhole bh) {
        Thread.currentThread().setContextClassLoader((ClassLoader)classLoader);
        byte[] bytes = furyBytes[index++];
    }

    public static void main(String[] args) throws Exception {
        Options options = new OptionsBuilder().include(EishayFuryParseNoneCache.class.getName()).mode(Mode.Throughput).timeUnit(TimeUnit.MILLISECONDS).warmupIterations(1).forks(1).build();
        new Runner(options).run();
    }

    static {
        String classZipDataFile = "data/EishayFuryParseNoneCache_classes.bin.zip";
        String jsonbZipDataFile = "data/EishayFuryParseNoneCache_data_fastjson.bin.zip";
        String furyZipDataFile = "data/EishayFuryParseNoneCache_data_fury.bin.zip";
        try {
            InputStream fis = EishayFuryParseNoneCache.class.getClassLoader().getResourceAsStream(classZipDataFile);
            ZipInputStream zipIn = new ZipInputStream(fis);
            zipIn.getNextEntry();
            ObjectInputStream is = new ObjectInputStream(zipIn);
            Map codeMap = (Map)is.readObject();
            HashMap classMap = new HashMap(codeMap.size());
            String prefix = "com.alibaba.fastjson2.benchmark.eishay";
            codeMap.forEach((name, code) -> {
                int index = Integer.parseInt(name.substring(prefix.length(), name.indexOf(46, prefix.length())));
                if (index > 10000) {
                    return;
                }
                Class clazz = classLoader.loadClass(name, code, 0, ((byte[])code).length);
                classMap.put(name, clazz);
            });
            for (int i = 0; i < 10000; ++i) {
                Class mediaClass;
                String packageName = prefix + i;
                classLoader.definePackage(packageName);
                String className = packageName + ".MediaContent";
                EishayFuryParseNoneCache.classes[i] = mediaClass = (Class)classMap.get(className);
            }
            IOUtils.close((Closeable)zipIn);
            IOUtils.close((Closeable)is);
            IOUtils.close((Closeable)fis);
            fis = EishayFuryParseNoneCache.class.getClassLoader().getResourceAsStream(jsonbZipDataFile);
            zipIn = new ZipInputStream(fis);
            zipIn.getNextEntry();
            is = new ObjectInputStream(zipIn);
            fastjson2JSONBBytes = (byte[][])is.readObject();
            IOUtils.close((Closeable)zipIn);
            IOUtils.close((Closeable)is);
            IOUtils.close((Closeable)fis);
            fis = EishayFuryParseNoneCache.class.getClassLoader().getResourceAsStream(furyZipDataFile);
            zipIn = new ZipInputStream(fis);
            zipIn.getNextEntry();
            is = new ObjectInputStream(zipIn);
            furyBytes = (byte[][])is.readObject();
            IOUtils.close((Closeable)zipIn);
            IOUtils.close((Closeable)is);
            IOUtils.close((Closeable)fis);
        }
        catch (Throwable ex) {
            ex.printStackTrace();
        }
    }
}

