/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson2.example.springtest.config;

import java.io.IOException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.springframework.web.socket.TextMessage;
import org.springframework.web.socket.WebSocketMessage;
import org.springframework.web.socket.WebSocketSession;
import org.springframework.web.socket.handler.TextWebSocketHandler;

public class ChatMessageHandler
extends TextWebSocketHandler {
    private static final Map<String, WebSocketSession> allClients = new ConcurrentHashMap<String, WebSocketSession>();

    public void afterConnectionEstablished(WebSocketSession session) throws Exception {
    }

    public void sendMessageToUser(String userName, TextMessage message) {
        WebSocketSession webSocketSession = allClients.get(userName);
        if (webSocketSession != null && webSocketSession.isOpen()) {
            try {
                webSocketSession.sendMessage((WebSocketMessage)message);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public void sendMessageToUsers(TextMessage message) {
        for (Map.Entry<String, WebSocketSession> webSocketSessionEntry : allClients.entrySet()) {
            WebSocketSession session = webSocketSessionEntry.getValue();
            if (session == null || !session.isOpen()) continue;
            try {
                session.sendMessage((WebSocketMessage)message);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public boolean supportsPartialMessages() {
        return false;
    }
}

