/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson;

import com.alibaba.fastjson.Fastjson1xReaderModule;
import com.alibaba.fastjson.Fastjson1xWriterModule;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONException;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import com.alibaba.fastjson.serializer.SerializeConfig;
import com.alibaba.fastjson.serializer.SerializeFilter;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.alibaba.fastjson.util.IOUtils;
import com.alibaba.fastjson2.JSONFactory;
import com.alibaba.fastjson2.JSONReader;
import com.alibaba.fastjson2.JSONWriter;
import com.alibaba.fastjson2.filter.NameFilter;
import com.alibaba.fastjson2.filter.PropertyFilter;
import com.alibaba.fastjson2.filter.PropertyPreFilter;
import com.alibaba.fastjson2.filter.ValueFilter;
import com.alibaba.fastjson2.modules.ObjectReaderModule;
import com.alibaba.fastjson2.modules.ObjectWriterModule;
import com.alibaba.fastjson2.reader.ObjectReader;
import com.alibaba.fastjson2.reader.ObjectReaderProvider;
import com.alibaba.fastjson2.support.AwtRederModule;
import com.alibaba.fastjson2.support.AwtWriterModule;
import com.alibaba.fastjson2.util.ParameterizedTypeImpl;
import com.alibaba.fastjson2.writer.ObjectWriter;
import com.alibaba.fastjson2.writer.ObjectWriterProvider;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Type;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharsetDecoder;
import java.util.List;
import java.util.Locale;
import java.util.TimeZone;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;

public class JSON {
    public static final String VERSION = "2.0.3";
    static final Cache CACHE = new Cache();
    static final AtomicReferenceFieldUpdater<Cache, char[]> CHARS_UPDATER = AtomicReferenceFieldUpdater.newUpdater(Cache.class, char[].class, "chars");
    public static TimeZone defaultTimeZone = TimeZone.getDefault();
    public static Locale defaultLocale = Locale.getDefault();
    public static String DEFAULT_TYPE_KEY = "@type";
    public static String DEFFAULT_DATE_FORMAT = "yyyy-MM-dd HH:mm:ss";
    public static int DEFAULT_PARSER_FEATURE;
    public static int DEFAULT_GENERATE_FEATURE;

    public static JSONObject parseObject(String str) {
        return JSON.parseObject(str, JSONObject.class);
    }

    public static JSONObject parseObject(String text, Feature ... features) {
        return (JSONObject)JSON.parseObject(text, JSONObject.class, features);
    }

    public static <T> T parseObject(char[] str, Class type, Feature ... features) {
        return JSON.parseObject(new String(str), (Type)type, features);
    }

    public static <T> T parseObject(String str, TypeReference typeReference, Feature ... features) {
        return JSON.parseObject(str, typeReference.getType(), features);
    }

    public static <T> T parseObject(String text, Class<T> clazz) {
        return JSON.parseObject(text, clazz, new Feature[0]);
    }

    public static <T> T parseObject(String str, Type type, Feature ... features) {
        if (str == null || str.isEmpty()) {
            return null;
        }
        JSONReader reader = JSONReader.of((String)str);
        JSONReader.Context context = reader.getContext();
        context.setObjectClass(JSONObject.class);
        String defaultDateFormat = DEFFAULT_DATE_FORMAT;
        if (!"yyyy-MM-dd HH:mm:ss".equals(defaultDateFormat)) {
            context.setUtilDateFormat(defaultDateFormat);
        }
        JSON.config(context, features);
        try {
            return (T)reader.read(type);
        }
        catch (com.alibaba.fastjson2.JSONException e) {
            Throwable cause = e.getCause();
            if (cause == null) {
                cause = e;
            }
            throw new JSONException(e.getMessage(), cause);
        }
    }

    public static <T> T parseObject(byte[] jsonBytes, Type type, Feature ... features) {
        if (jsonBytes == null) {
            return null;
        }
        JSONReader reader = JSONReader.of((byte[])jsonBytes);
        JSONReader.Context context = reader.getContext();
        context.setObjectClass(JSONObject.class);
        String defaultDateFormat = DEFFAULT_DATE_FORMAT;
        if (!"yyyy-MM-dd HH:mm:ss".equals(defaultDateFormat)) {
            context.setUtilDateFormat(defaultDateFormat);
        }
        JSON.config(context, features);
        try {
            return (T)reader.read(type);
        }
        catch (com.alibaba.fastjson2.JSONException e) {
            Throwable cause = e.getCause();
            if (cause == null) {
                cause = e;
            }
            throw new JSONException(e.getMessage(), cause);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Object parse(String str, Feature ... features) {
        if (str == null) return null;
        if (str.isEmpty()) {
            return null;
        }
        try (JSONReader reader = JSONReader.of((String)str);){
            JSONReader.Context context = reader.getContext();
            context.setObjectClass(JSONObject.class);
            JSON.config(context, features);
            if (reader.isObject() && !reader.isSupportAutoType(0L)) {
                Object object = reader.read(JSONObject.class);
                return object;
            }
            Object object = reader.readAny();
            return object;
        }
        catch (Exception ex) {
            throw new JSONException(ex.getMessage(), ex);
        }
    }

    protected static void config(JSONReader.Context context, Feature[] features) {
        block6: for (Feature feature : features) {
            switch (feature) {
                case SupportArrayToBean: {
                    context.config(new JSONReader.Feature[]{JSONReader.Feature.SupportArrayToBean});
                    continue block6;
                }
                case SupportAutoType: {
                    context.config(new JSONReader.Feature[]{JSONReader.Feature.SupportAutoType});
                    continue block6;
                }
                case ErrorOnEnumNotMatch: {
                    context.config(new JSONReader.Feature[]{JSONReader.Feature.ErrorOnEnumNotMatch});
                }
                case SupportNonPublicField: {
                    context.config(new JSONReader.Feature[]{JSONReader.Feature.FieldBased});
                }
            }
        }
        boolean disableFieldSmartMatch = false;
        for (Feature feature : features) {
            if (!feature.equals((Object)Feature.DisableFieldSmartMatch)) continue;
            disableFieldSmartMatch = true;
            break;
        }
        if (!disableFieldSmartMatch) {
            context.config(new JSONReader.Feature[]{JSONReader.Feature.SupportSmartMatch});
        }
    }

    public static Object parse(byte[] input, int off, int len, CharsetDecoder charsetDecoder, Feature ... features) {
        if (input == null || input.length == 0) {
            return null;
        }
        int featureValues = DEFAULT_PARSER_FEATURE;
        for (Feature feature : features) {
            featureValues = Feature.config(featureValues, feature, true);
        }
        return JSON.parse(input, off, len, charsetDecoder, featureValues);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object parse(byte[] input, int off, int len, CharsetDecoder charsetDecoder, int features) {
        charsetDecoder.reset();
        int scaleLength = (int)((double)len * (double)charsetDecoder.maxCharsPerByte());
        char[] chars = CHARS_UPDATER.getAndSet(CACHE, null);
        if (chars == null || chars.length < scaleLength) {
            chars = new char[scaleLength];
        }
        try {
            ByteBuffer byteBuf = ByteBuffer.wrap(input, off, len);
            CharBuffer charBuf = CharBuffer.wrap(chars);
            IOUtils.decode(charsetDecoder, byteBuf, charBuf);
            int position = charBuf.position();
            JSONReader reader = JSONReader.of((char[])chars, (int)0, (int)position);
            JSONReader.Context context = reader.getContext();
            block9: for (Feature feature : Feature.values()) {
                if ((features & feature.mask) == 0) continue;
                switch (feature) {
                    case SupportArrayToBean: {
                        context.config(new JSONReader.Feature[]{JSONReader.Feature.SupportArrayToBean});
                        continue block9;
                    }
                    case SupportAutoType: {
                        context.config(new JSONReader.Feature[]{JSONReader.Feature.SupportAutoType});
                        continue block9;
                    }
                    case ErrorOnEnumNotMatch: {
                        context.config(new JSONReader.Feature[]{JSONReader.Feature.ErrorOnEnumNotMatch});
                    }
                    case SupportNonPublicField: {
                        context.config(new JSONReader.Feature[]{JSONReader.Feature.FieldBased});
                    }
                }
            }
            Object object = reader.read(Object.class);
            return object;
        }
        finally {
            if (chars.length <= 65536) {
                CHARS_UPDATER.set(CACHE, chars);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T parseObject(byte[] input, int off, int len, CharsetDecoder charsetDecoder, Type clazz, Feature ... features) {
        charsetDecoder.reset();
        int scaleLength = (int)((double)len * (double)charsetDecoder.maxCharsPerByte());
        char[] chars = CHARS_UPDATER.getAndSet(CACHE, null);
        if (chars == null || chars.length < scaleLength) {
            chars = new char[scaleLength];
        }
        try {
            ByteBuffer byteBuf = ByteBuffer.wrap(input, off, len);
            CharBuffer charByte = CharBuffer.wrap(chars);
            IOUtils.decode(charsetDecoder, byteBuf, charByte);
            int position = charByte.position();
            JSONReader reader = JSONReader.of((char[])chars, (int)0, (int)position);
            Object object = reader.read(clazz);
            return (T)object;
        }
        finally {
            if (chars.length <= 65536) {
                CHARS_UPDATER.set(CACHE, chars);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String toJSONString(Object object, SerializeFilter[] filters, SerializerFeature ... features) {
        try (JSONWriter writer = JSONWriter.of();){
            JSONWriter.Context context = writer.getContext();
            writer.setRootObject(object);
            JSON.config(context, features);
            for (SerializeFilter filter : filters) {
                if (filter instanceof com.alibaba.fastjson.serializer.NameFilter) {
                    context.setNameFilter((NameFilter)((com.alibaba.fastjson.serializer.NameFilter)filter));
                    continue;
                }
                if (filter instanceof ValueFilter) {
                    context.setValueFilter((ValueFilter)filter);
                    continue;
                }
                if (filter instanceof PropertyPreFilter) {
                    context.setPropertyPreFilter((PropertyPreFilter)filter);
                    continue;
                }
                if (!(filter instanceof PropertyFilter)) continue;
                context.setPropertyFilter((PropertyFilter)filter);
            }
            if (object == null) {
                writer.writeNull();
            } else {
                Class<?> clazz = object.getClass();
                ObjectWriter objectWriter = context.getObjectWriter(clazz, clazz);
                objectWriter.write(writer, object, null, null, 0L);
            }
            String string = writer.toString();
            return string;
        }
        catch (com.alibaba.fastjson2.JSONException ex) {
            Throwable cause = ex.getCause() != null ? ex.getCause() : ex;
            throw new JSONException("toJSONString error", cause);
        }
        catch (RuntimeException ex) {
            throw new JSONException("toJSONString error", ex);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static byte[] toJSONBytes(Object object, SerializeFilter[] filters, SerializerFeature ... features) {
        try (JSONWriter writer = JSONWriter.ofUTF8();){
            JSONWriter.Context context = writer.getContext();
            writer.setRootObject(object);
            JSON.config(context, features);
            for (SerializeFilter filter : filters) {
                if (filter instanceof com.alibaba.fastjson.serializer.NameFilter) {
                    context.setNameFilter((NameFilter)((com.alibaba.fastjson.serializer.NameFilter)filter));
                    continue;
                }
                if (filter instanceof ValueFilter) {
                    context.setValueFilter((ValueFilter)filter);
                    continue;
                }
                if (filter instanceof PropertyPreFilter) {
                    context.setPropertyPreFilter((PropertyPreFilter)filter);
                    continue;
                }
                if (!(filter instanceof PropertyFilter)) continue;
                context.setPropertyFilter((PropertyFilter)filter);
            }
            if (object == null) {
                writer.writeNull();
            } else {
                Class<?> clazz = object.getClass();
                ObjectWriter objectWriter = context.getObjectWriter(clazz, clazz);
                objectWriter.write(writer, object, null, null, 0L);
            }
            byte[] byArray = writer.getBytes();
            return byArray;
        }
        catch (com.alibaba.fastjson2.JSONException ex) {
            Throwable cause = ex.getCause() != null ? ex.getCause() : ex;
            throw new JSONException("toJSONBytes error", cause);
        }
        catch (RuntimeException ex) {
            throw new JSONException("toJSONBytes error", ex);
        }
    }

    public static String toJSONString(Object object) {
        return JSON.toJSONString(object, new SerializeFilter[0], new SerializerFeature[0]);
    }

    public static String toJSONString(Object object, SerializeFilter ... filters) {
        return JSON.toJSONString(object, filters, new SerializerFeature[0]);
    }

    public static String toJSONString(Object object, SerializerFeature ... features) {
        return JSON.toJSONString(object, new SerializeFilter[0], features);
    }

    public static byte[] toJSONBytes(Object object) {
        return JSON.toJSONBytes(object, new SerializeFilter[0], new SerializerFeature[0]);
    }

    public static byte[] toJSONBytes(Object object, SerializeFilter ... filters) {
        return JSON.toJSONBytes(object, filters, new SerializerFeature[0]);
    }

    public static byte[] toJSONBytes(Object object, SerializerFeature ... features) {
        return JSON.toJSONBytes(object, new SerializeFilter[0], features);
    }

    static void config(JSONWriter.Context ctx, SerializerFeature[] features) {
        ctx.setDateFormat("millis");
        ctx.setZoneId(defaultTimeZone.toZoneId());
        ctx.config(new JSONWriter.Feature[]{JSONWriter.Feature.ReferenceDetection});
        block13: for (SerializerFeature feature : features) {
            switch (feature) {
                case UseISO8601DateFormat: {
                    ctx.setDateFormat("iso8601");
                    continue block13;
                }
                case WriteMapNullValue: {
                    ctx.config(new JSONWriter.Feature[]{JSONWriter.Feature.WriteNulls});
                    continue block13;
                }
                case WriteNullListAsEmpty: 
                case WriteNullStringAsEmpty: 
                case WriteNullNumberAsZero: 
                case WriteNullBooleanAsFalse: {
                    ctx.config(new JSONWriter.Feature[]{JSONWriter.Feature.NullAsDefaultValue});
                    continue block13;
                }
                case BrowserCompatible: {
                    ctx.config(new JSONWriter.Feature[]{JSONWriter.Feature.BrowserCompatible});
                    continue block13;
                }
                case WriteClassName: {
                    ctx.config(new JSONWriter.Feature[]{JSONWriter.Feature.WriteClassName});
                    continue block13;
                }
                case WriteNonStringValueAsString: {
                    ctx.config(new JSONWriter.Feature[]{JSONWriter.Feature.WriteNonStringValueAsString});
                    continue block13;
                }
                case WriteEnumUsingToString: {
                    ctx.config(new JSONWriter.Feature[]{JSONWriter.Feature.WriteEnumUsingToString});
                    continue block13;
                }
                case NotWriteRootClassName: {
                    ctx.config(new JSONWriter.Feature[]{JSONWriter.Feature.NotWriteRootClassName});
                    continue block13;
                }
                case IgnoreErrorGetter: {
                    ctx.config(new JSONWriter.Feature[]{JSONWriter.Feature.IgnoreErrorGetter});
                    continue block13;
                }
                case WriteDateUseDateFormat: {
                    ctx.setDateFormat(DEFFAULT_DATE_FORMAT);
                    continue block13;
                }
                case BeanToArray: {
                    ctx.config(new JSONWriter.Feature[]{JSONWriter.Feature.BeanToArray});
                    continue block13;
                }
            }
        }
    }

    public static String toJSONString(Object object, SerializeConfig config, SerializerFeature ... features) {
        return JSON.toJSONString(object, DEFAULT_GENERATE_FEATURE, features);
    }

    public static String toJSONString(Object object, int defaultFeatures, SerializerFeature ... features) {
        try (JSONWriter writer = JSONWriter.of();){
            JSONWriter.Context ctx = writer.getContext();
            JSON.config(ctx, features);
            writer.writeAny(object);
            String string = writer.toString();
            return string;
        }
    }

    public static String toJSONStringWithDateFormat(Object object, String dateFormat, SerializerFeature ... features) {
        try (JSONWriter writer = JSONWriter.of();){
            for (SerializerFeature feature : features) {
                if (feature != SerializerFeature.WriteMapNullValue) continue;
                writer.config(new JSONWriter.Feature[]{JSONWriter.Feature.WriteNulls});
            }
            writer.getContext().setDateFormat(dateFormat);
            writer.writeAny(object);
            String string = writer.toString();
            return string;
        }
    }

    public static final int writeJSONString(OutputStream os, Object object, SerializerFeature ... features) throws IOException {
        return JSON.writeJSONString(os, object, new SerializeFilter[0], features);
    }

    public static final int writeJSONString(OutputStream os, Object object, SerializeFilter[] filters) throws IOException {
        return JSON.writeJSONString(os, object, filters, new SerializerFeature[0]);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static final int writeJSONString(OutputStream os, Object object, SerializeFilter[] filters, SerializerFeature ... features) throws IOException {
        try (JSONWriter writer = JSONWriter.ofUTF8();){
            JSONWriter.Context context = writer.getContext();
            writer.setRootObject(object);
            JSON.config(context, features);
            for (SerializeFilter filter : filters) {
                if (filter instanceof com.alibaba.fastjson.serializer.NameFilter) {
                    context.setNameFilter((NameFilter)((com.alibaba.fastjson.serializer.NameFilter)filter));
                    continue;
                }
                if (filter instanceof ValueFilter) {
                    context.setValueFilter((ValueFilter)filter);
                    continue;
                }
                if (filter instanceof PropertyPreFilter) {
                    context.setPropertyPreFilter((PropertyPreFilter)filter);
                    continue;
                }
                if (!(filter instanceof PropertyFilter)) continue;
                context.setPropertyFilter((PropertyFilter)filter);
            }
            writer.writeAny(object);
            byte[] bytes = writer.getBytes();
            os.write(bytes);
            int n = bytes.length;
            return n;
        }
        catch (com.alibaba.fastjson2.JSONException ex) {
            Throwable cause = ex.getCause() != null ? ex.getCause() : ex;
            throw new JSONException("writeJSONString error", cause);
        }
        catch (RuntimeException ex) {
            throw new JSONException("writeJSONString error", ex);
        }
    }

    public static JSONArray parseArray(String str, Feature ... features) {
        try (JSONReader reader = JSONReader.of((String)str);){
            JSONReader.Context context = reader.getContext();
            context.setObjectClass(JSONObject.class);
            JSON.config(context, features);
            ObjectReader objectReader = reader.getObjectReader(JSONArray.class);
            JSONArray jSONArray = (JSONArray)objectReader.readObject(reader, 0L);
            return jSONArray;
        }
    }

    public static <T> List<T> parseArray(String text, Class<T> type) {
        if (text == null || text.length() == 0) {
            return null;
        }
        ParameterizedTypeImpl paramType = new ParameterizedTypeImpl(new Type[]{type}, null, List.class);
        JSONReader reader = JSONReader.of((String)text);
        try {
            return (List)reader.read((Type)paramType);
        }
        catch (com.alibaba.fastjson2.JSONException e) {
            Throwable cause = e.getCause();
            if (cause == null) {
                cause = e;
            }
            throw new JSONException(e.getMessage(), cause);
        }
    }

    public static boolean isValid(String str) {
        return com.alibaba.fastjson2.JSON.isValid((String)str);
    }

    public static boolean isValidArray(String str) {
        return com.alibaba.fastjson2.JSON.isValidArray((String)str);
    }

    public static <T> T toJavaObject(JSON json, Class<T> clazz) {
        if (json instanceof JSONObject) {
            return ((JSONObject)json).toJavaObject(clazz);
        }
        String str = JSON.toJSONString(json);
        return JSON.parseObject(str, clazz);
    }

    public static Object toJSON(Object javaObject) {
        if (javaObject instanceof JSON) {
            return javaObject;
        }
        String str = JSON.toJSONString(javaObject);
        Object object = JSON.parse(str, new Feature[0]);
        if (object instanceof List) {
            return new JSONArray((List)object);
        }
        return object;
    }

    public static List<Object> parseArray(String text, Type[] types) {
        return com.alibaba.fastjson2.JSON.parseArray((String)text, (Type[])types, (JSONReader.Feature[])new JSONReader.Feature[0]);
    }

    static {
        ObjectReaderProvider readerProvider = JSONFactory.getDefaultObjectReaderProvider();
        readerProvider.register((ObjectReaderModule)AwtRederModule.INSTANCE);
        readerProvider.register((ObjectReaderModule)new Fastjson1xReaderModule(readerProvider));
        ObjectWriterProvider writerProvider = JSONFactory.getDefaultObjectWriterProvider();
        writerProvider.register((ObjectWriterModule)AwtWriterModule.INSTANCE);
        writerProvider.register((ObjectWriterModule)new Fastjson1xWriterModule(writerProvider));
    }

    static class Cache {
        volatile char[] chars;

        Cache() {
        }
    }
}

