/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson.util;

import com.alibaba.fastjson.util.IOUtils;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CoderResult;

public class UTF8Decoder
extends CharsetDecoder {
    public UTF8Decoder() {
        super(IOUtils.UTF8, 1.0f, 1.0f);
    }

    public static CoderResult malformedN(ByteBuffer src, int nb) {
        switch (nb) {
            case 1: {
                byte b1 = src.get();
                if (b1 >> 2 == -2) {
                    if (src.remaining() < 4) {
                        return CoderResult.UNDERFLOW;
                    }
                    int n = 5;
                    for (int i = 1; i < n; ++i) {
                        if ((src.get() & 0xC0) == 128) continue;
                        return CoderResult.malformedForLength(i);
                    }
                    return CoderResult.malformedForLength(n);
                }
                if (b1 >> 1 == -2) {
                    if (src.remaining() < 5) {
                        return CoderResult.UNDERFLOW;
                    }
                    int n = 6;
                    for (int i = 1; i < n; ++i) {
                        if ((src.get() & 0xC0) == 128) continue;
                        return CoderResult.malformedForLength(i);
                    }
                    return CoderResult.malformedForLength(n);
                }
                return CoderResult.malformedForLength(1);
            }
            case 2: {
                return CoderResult.malformedForLength(1);
            }
            case 3: {
                byte b1 = src.get();
                byte b2 = src.get();
                return CoderResult.malformedForLength(b1 == -32 && (b2 & 0xE0) == 128 || (b2 & 0xC0) != 128 ? 1 : 2);
            }
            case 4: {
                int b1 = src.get() & 0xFF;
                int b2 = src.get() & 0xFF;
                if (b1 > 244 || b1 == 240 && (b2 < 144 || b2 > 191) || b1 == 244 && (b2 & 0xF0) != 128 || (b2 & 0xC0) != 128) {
                    return CoderResult.malformedForLength(1);
                }
                if ((src.get() & 0xC0) != 128) {
                    return CoderResult.malformedForLength(2);
                }
                return CoderResult.malformedForLength(3);
            }
        }
        throw new IllegalStateException();
    }

    private static CoderResult malformed(ByteBuffer src, int sp, CharBuffer dst, int dp, int nb) {
        src.position(sp - src.arrayOffset());
        CoderResult cr = UTF8Decoder.malformedN(src, nb);
        src.position(sp);
        dst.position(dp);
        return cr;
    }

    private static CoderResult xflow(Buffer src, int sp, int sl, Buffer dst, int dp, int nb) {
        src.position(sp);
        dst.position(dp);
        return nb == 0 || sl - sp < nb ? CoderResult.UNDERFLOW : CoderResult.OVERFLOW;
    }

    protected CoderResult decodeLoop(ByteBuffer src, CharBuffer dst) {
        byte[] srcArray = src.array();
        int sp = src.arrayOffset() + src.position();
        int srcLength = src.arrayOffset() + src.limit();
        char[] destArray = dst.array();
        int dp = dst.arrayOffset() + dst.position();
        int destLength = dst.arrayOffset() + dst.limit();
        int destLengthASCII = dp + Math.min(srcLength - sp, destLength - dp);
        while (dp < destLengthASCII && srcArray[sp] >= 0) {
            destArray[dp++] = (char)srcArray[sp++];
        }
        while (sp < srcLength) {
            byte b3;
            byte b2;
            byte b1 = srcArray[sp];
            if (b1 >= 0) {
                if (dp >= destLength) {
                    return UTF8Decoder.xflow(src, sp, srcLength, dst, dp, 1);
                }
                destArray[dp++] = (char)b1;
                ++sp;
                continue;
            }
            if (b1 >> 5 == -2) {
                boolean isMalformed2;
                if (srcLength - sp < 2 || dp >= destLength) {
                    return UTF8Decoder.xflow(src, sp, srcLength, dst, dp, 2);
                }
                b2 = srcArray[sp + 1];
                boolean bl = isMalformed2 = (b1 & 0x1E) == 0 || (b2 & 0xC0) != 128;
                if (isMalformed2) {
                    return UTF8Decoder.malformed(src, sp, dst, dp, 2);
                }
                destArray[dp++] = (char)(b1 << 6 ^ b2 ^ 0xF80);
                sp += 2;
                continue;
            }
            if (b1 >> 4 == -2) {
                boolean isMalformed3;
                if (srcLength - sp < 3 || dp >= destLength) {
                    return UTF8Decoder.xflow(src, sp, srcLength, dst, dp, 3);
                }
                b2 = srcArray[sp + 1];
                b3 = srcArray[sp + 2];
                boolean bl = isMalformed3 = b1 == -32 && (b2 & 0xE0) == 128 || (b2 & 0xC0) != 128 || (b3 & 0xC0) != 128;
                if (isMalformed3) {
                    return UTF8Decoder.malformed(src, sp, dst, dp, 3);
                }
                destArray[dp++] = (char)(b1 << 12 ^ b2 << 6 ^ b3 ^ 0x1F80);
                sp += 3;
                continue;
            }
            if (b1 >> 3 == -2) {
                boolean isMalformed4;
                if (srcLength - sp < 4 || destLength - dp < 2) {
                    return UTF8Decoder.xflow(src, sp, srcLength, dst, dp, 4);
                }
                b2 = srcArray[sp + 1];
                b3 = srcArray[sp + 2];
                byte b4 = srcArray[sp + 3];
                int uc = (b1 & 7) << 18 | (b2 & 0x3F) << 12 | (b3 & 0x3F) << 6 | b4 & 0x3F;
                boolean bl = isMalformed4 = (b2 & 0xC0) != 128 || (b3 & 0xC0) != 128 || (b4 & 0xC0) != 128;
                if (isMalformed4 || uc < 65536 || uc > 0x10FFFF) {
                    return UTF8Decoder.malformed(src, sp, dst, dp, 4);
                }
                destArray[dp++] = (char)(0xD800 | uc - 65536 >> 10 & 0x3FF);
                destArray[dp++] = (char)(0xDC00 | uc - 65536 & 0x3FF);
                sp += 4;
                continue;
            }
            return UTF8Decoder.malformed(src, sp, dst, dp, 1);
        }
        return UTF8Decoder.xflow(src, sp, srcLength, dst, dp, 0);
    }
}

