/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson.support.spring;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.parser.Feature;
import com.alibaba.fastjson.serializer.SerializeConfig;
import com.alibaba.fastjson.serializer.SerializeFilter;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.alibaba.fastjson.util.IOUtils;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Type;
import java.nio.charset.Charset;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpInputMessage;
import org.springframework.http.HttpOutputMessage;
import org.springframework.http.MediaType;
import org.springframework.http.converter.AbstractHttpMessageConverter;
import org.springframework.http.converter.GenericHttpMessageConverter;
import org.springframework.http.converter.HttpMessageNotReadableException;
import org.springframework.http.converter.HttpMessageNotWritableException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FastJsonHttpMessageConverter
extends AbstractHttpMessageConverter<Object>
implements GenericHttpMessageConverter<Object> {
    private Charset charset = IOUtils.UTF8;
    private SerializerFeature[] features = new SerializerFeature[0];
    protected SerializeFilter[] filters = new SerializeFilter[0];
    protected String dateFormat;

    public FastJsonHttpMessageConverter() {
        super(new MediaType[]{MediaType.APPLICATION_JSON, MediaType.APPLICATION_FORM_URLENCODED});
    }

    protected boolean supports(Class<?> clazz) {
        return true;
    }

    public Charset getCharset() {
        return this.charset;
    }

    public void setCharset(Charset charset) {
        this.charset = charset;
    }

    public String getDateFormat() {
        return this.dateFormat;
    }

    public void setDateFormat(String dateFormat) {
        this.dateFormat = dateFormat;
    }

    public SerializerFeature[] getFeatures() {
        return this.features;
    }

    public void setFeatures(SerializerFeature ... features) {
        this.features = features;
    }

    public SerializeFilter[] getFilters() {
        return this.filters;
    }

    public void setFilters(SerializeFilter ... filters) {
        this.filters = filters;
    }

    protected Object readInternal(Class<? extends Object> clazz, HttpInputMessage inputMessage) throws IOException, HttpMessageNotReadableException {
        int len;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        InputStream in = inputMessage.getBody();
        byte[] buf = new byte[1024];
        while ((len = in.read(buf)) != -1) {
            if (len <= 0) continue;
            baos.write(buf, 0, len);
        }
        byte[] bytes = baos.toByteArray();
        return JSON.parseObject(bytes, 0, bytes.length, this.charset.newDecoder(), clazz, new Feature[0]);
    }

    protected void writeInternal(Object obj, HttpOutputMessage outputMessage) throws IOException, HttpMessageNotWritableException {
        HttpHeaders headers = outputMessage.getHeaders();
        String text = JSON.toJSONString(obj, SerializeConfig.globalInstance, this.filters, this.dateFormat, JSON.DEFAULT_GENERATE_FEATURE, this.features);
        byte[] bytes = text.getBytes(this.charset);
        headers.setContentLength((long)bytes.length);
        OutputStream out = outputMessage.getBody();
        out.write(bytes);
        out.flush();
    }

    public void addSerializeFilter(SerializeFilter filter) {
        if (filter == null) {
            return;
        }
        SerializeFilter[] filters = new SerializeFilter[this.filters.length + 1];
        System.arraycopy(this.filters, 0, filter, 0, this.filters.length);
        filters[filters.length - 1] = filter;
        this.filters = filters;
    }

    public boolean canRead(Type type, Class<?> contextClass, MediaType mediaType) {
        return super.canRead(type.getClass(), mediaType);
    }

    public Object read(Type type, Class<?> contextClass, HttpInputMessage inputMessage) throws IOException, HttpMessageNotReadableException {
        int len;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        InputStream in = inputMessage.getBody();
        byte[] buf = new byte[1024];
        while ((len = in.read(buf)) != -1) {
            if (len <= 0) continue;
            baos.write(buf, 0, len);
        }
        byte[] bytes = baos.toByteArray();
        return JSON.parseObject(bytes, 0, bytes.length, this.charset.newDecoder(), type, new Feature[0]);
    }
}

