/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson.serializer;

import com.alibaba.fastjson.parser.DefaultJSONParser;
import com.alibaba.fastjson.parser.JSONLexer;
import com.alibaba.fastjson.parser.deserializer.ObjectDeserializer;
import com.alibaba.fastjson.serializer.JSONSerializer;
import com.alibaba.fastjson.serializer.ObjectSerializer;
import com.alibaba.fastjson.serializer.SerializeWriter;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.alibaba.fastjson.util.TypeUtils;
import java.io.IOException;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.math.BigInteger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BigDecimalCodec
implements ObjectSerializer,
ObjectDeserializer {
    public static final BigDecimalCodec instance = new BigDecimalCodec();

    private BigDecimalCodec() {
    }

    @Override
    public void write(JSONSerializer serializer, Object object, Object fieldName, Type fieldType) throws IOException {
        SerializeWriter out = serializer.out;
        if (object == null) {
            if ((out.features & SerializerFeature.WriteNullNumberAsZero.mask) != 0) {
                out.write(48);
            } else {
                out.writeNull();
            }
            return;
        }
        if (object instanceof BigInteger) {
            BigInteger val = (BigInteger)object;
            out.write(val.toString());
            return;
        }
        BigDecimal val = (BigDecimal)object;
        out.write(val.toString());
        if ((out.features & SerializerFeature.WriteClassName.mask) != 0 && fieldType != BigDecimal.class && val.scale() == 0) {
            out.write(46);
        }
    }

    @Override
    public <T> T deserialze(DefaultJSONParser parser, Type clazz, Object fieldName) {
        JSONLexer lexer = parser.lexer;
        int token = lexer.token();
        if (token == 2) {
            if (clazz == BigInteger.class) {
                String val = lexer.numberString();
                lexer.nextToken(16);
                return (T)new BigInteger(val, 10);
            }
            BigDecimal decimal = lexer.decimalValue();
            lexer.nextToken(16);
            return (T)decimal;
        }
        if (token == 3) {
            BigDecimal val = lexer.decimalValue();
            lexer.nextToken(16);
            if (clazz == BigInteger.class) {
                int scale = val.scale();
                if (scale < -100 || scale > 100) {
                    throw new NumberFormatException();
                }
                return (T)val.toBigInteger();
            }
            return (T)val;
        }
        Object value = parser.parse();
        if (value == null) {
            return null;
        }
        if (clazz == BigInteger.class) {
            return (T)TypeUtils.castToBigInteger(value);
        }
        return (T)TypeUtils.castToBigDecimal(value);
    }
}

