/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson.util;

import com.alibaba.fastjson.JSONException;
import com.alibaba.fastjson.annotation.JSONCreator;
import com.alibaba.fastjson.annotation.JSONField;
import com.alibaba.fastjson.annotation.JSONType;
import com.alibaba.fastjson.parser.Feature;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.alibaba.fastjson.util.FieldInfo;
import com.alibaba.fastjson.util.TypeUtils;
import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DeserializeBeanInfo {
    public final Constructor<?> defaultConstructor;
    public final int defaultConstructorParameterSize;
    public final Constructor<?> creatorConstructor;
    public final Method factoryMethod;
    public final List<FieldInfo> fields = new ArrayList<FieldInfo>();
    public final List<FieldInfo> sortedFieldList = new ArrayList<FieldInfo>();
    public final int parserFeatures;
    public final JSONType jsonType;

    public DeserializeBeanInfo(Class<?> clazz, Constructor<?> defaultConstructor, Constructor<?> creatorConstructor, Method factoryMethod) {
        this.defaultConstructor = defaultConstructor;
        this.creatorConstructor = creatorConstructor;
        this.factoryMethod = factoryMethod;
        this.jsonType = clazz.getAnnotation(JSONType.class);
        if (this.jsonType != null) {
            Feature[] features = this.jsonType.parseFeatures();
            if (features == null) {
                this.parserFeatures = 0;
            } else {
                int value = 0;
                for (Feature feature : features) {
                    value |= feature.mask;
                }
                this.parserFeatures = value;
            }
        } else {
            this.parserFeatures = 0;
        }
        this.defaultConstructorParameterSize = defaultConstructor != null ? defaultConstructor.getParameterTypes().length : 0;
    }

    public boolean add(FieldInfo field) {
        for (FieldInfo item : this.fields) {
            if (!item.name.equals(field.name) || item.getOnly && !field.getOnly) continue;
            return false;
        }
        this.fields.add(field);
        this.sortedFieldList.add(field);
        Collections.sort(this.sortedFieldList);
        return true;
    }

    /*
     * WARNING - void declaration
     */
    public static DeserializeBeanInfo computeSetters(Class<?> clazz, Type type) {
        DeserializeBeanInfo beanInfo = null;
        Constructor<?> defaultConstructor = DeserializeBeanInfo.getDefaultConstructor(clazz);
        Method[] methods = clazz.getMethods();
        Field[] declaredFields = clazz.getDeclaredFields();
        int modifiers = clazz.getModifiers();
        if (defaultConstructor != null) {
            TypeUtils.setAccessible(clazz, defaultConstructor, modifiers);
            beanInfo = new DeserializeBeanInfo(clazz, defaultConstructor, null, null);
        } else if (defaultConstructor == null && !clazz.isInterface() && (modifiers & 0x400) == 0) {
            Constructor<?> creatorConstructor = DeserializeBeanInfo.getCreatorConstructor(clazz);
            if (creatorConstructor != null) {
                void var10_16;
                TypeUtils.setAccessible(clazz, creatorConstructor, modifiers);
                beanInfo = new DeserializeBeanInfo(clazz, null, creatorConstructor, null);
                Class<?>[] parameterTypes = creatorConstructor.getParameterTypes();
                Type[] getGenericParameterTypes = creatorConstructor.getGenericParameterTypes();
                boolean bl = false;
                while (var10_16 < parameterTypes.length) {
                    Annotation[] paramAnnotations = creatorConstructor.getParameterAnnotations()[var10_16];
                    JSONField fieldAnnotation = null;
                    for (Annotation paramAnnotation : paramAnnotations) {
                        if (!(paramAnnotation instanceof JSONField)) continue;
                        fieldAnnotation = (JSONField)paramAnnotation;
                        break;
                    }
                    if (fieldAnnotation == null) {
                        throw new JSONException("illegal json creator");
                    }
                    Class<?> fieldClass = parameterTypes[var10_16];
                    Type fieldType = getGenericParameterTypes[var10_16];
                    Field field = TypeUtils.getField(clazz, fieldAnnotation.name(), declaredFields);
                    if (field != null) {
                        TypeUtils.setAccessible(clazz, field, modifiers);
                    }
                    int ordinal = fieldAnnotation.ordinal();
                    int serialzeFeatures = SerializerFeature.of(fieldAnnotation.serialzeFeatures());
                    FieldInfo fieldInfo = new FieldInfo(fieldAnnotation.name(), clazz, fieldClass, fieldType, field, ordinal, serialzeFeatures);
                    beanInfo.add(fieldInfo);
                    ++var10_16;
                }
                return beanInfo;
            }
            Method factoryMethod = DeserializeBeanInfo.getFactoryMethod(clazz, methods);
            if (factoryMethod != null) {
                TypeUtils.setAccessible(clazz, factoryMethod, modifiers);
                beanInfo = new DeserializeBeanInfo(clazz, null, null, factoryMethod);
                Class<?>[] parameterTypes = factoryMethod.getParameterTypes();
                Type[] typeArray = factoryMethod.getGenericParameterTypes();
                for (int i = 0; i < parameterTypes.length; ++i) {
                    Annotation[] paramAnnotations = factoryMethod.getParameterAnnotations()[i];
                    JSONField fieldAnnotation = null;
                    for (Annotation paramAnnotation : paramAnnotations) {
                        if (!(paramAnnotation instanceof JSONField)) continue;
                        fieldAnnotation = (JSONField)paramAnnotation;
                        break;
                    }
                    if (fieldAnnotation == null) {
                        throw new JSONException("illegal json creator");
                    }
                    Class<?> fieldClass = parameterTypes[i];
                    Type fieldType = typeArray[i];
                    Field field = TypeUtils.getField(clazz, fieldAnnotation.name(), declaredFields);
                    int ordinal = fieldAnnotation.ordinal();
                    int serialzeFeatures = SerializerFeature.of(fieldAnnotation.serialzeFeatures());
                    FieldInfo fieldInfo = new FieldInfo(fieldAnnotation.name(), clazz, fieldClass, fieldType, field, ordinal, serialzeFeatures);
                    beanInfo.add(fieldInfo);
                }
                return beanInfo;
            }
            throw new JSONException("default constructor not found. " + clazz);
        }
        if (beanInfo == null) {
            beanInfo = new DeserializeBeanInfo(clazz, defaultConstructor, null, null);
        }
        for (Method method : methods) {
            JSONField fieldAnnotation;
            String propertyName;
            Class<?> returnType;
            int ordinal = 0;
            int serialzeFeatures = 0;
            String methodName = method.getName();
            if (methodName.length() < 4 || Modifier.isStatic(method.getModifiers()) || (returnType = method.getReturnType()) != Void.TYPE && returnType != clazz || method.getParameterTypes().length != 1 || method.getDeclaringClass() == Object.class) continue;
            JSONField annotation = method.getAnnotation(JSONField.class);
            if (annotation == null) {
                annotation = TypeUtils.getSupperMethodAnnotation(clazz, method);
            }
            if (annotation != null) {
                if (!annotation.deserialize()) continue;
                ordinal = annotation.ordinal();
                serialzeFeatures = SerializerFeature.of(annotation.serialzeFeatures());
                if (annotation.name().length() != 0) {
                    String propertyName2 = annotation.name();
                    beanInfo.add(new FieldInfo(propertyName2, method, null, clazz, type, ordinal, serialzeFeatures, annotation, null));
                    TypeUtils.setAccessible(clazz, method, modifiers);
                    continue;
                }
            }
            if (!methodName.startsWith("set")) continue;
            char c3 = methodName.charAt(3);
            if (Character.isUpperCase(c3)) {
                propertyName = TypeUtils.compatibleWithJavaBean ? TypeUtils.decapitalize(methodName.substring(3)) : Character.toLowerCase(methodName.charAt(3)) + methodName.substring(4);
            } else if (c3 == '_') {
                propertyName = methodName.substring(4);
            } else if (c3 == 'f') {
                propertyName = methodName.substring(3);
            } else {
                if (methodName.length() < 5 || !Character.isUpperCase(methodName.charAt(4))) continue;
                propertyName = TypeUtils.decapitalize(methodName.substring(3));
            }
            Field field = TypeUtils.getField(clazz, propertyName, declaredFields);
            if (field == null && method.getParameterTypes()[0] == Boolean.TYPE) {
                String isFieldName = "is" + Character.toUpperCase(propertyName.charAt(0)) + propertyName.substring(1);
                field = TypeUtils.getField(clazz, isFieldName, declaredFields);
            }
            if (field != null && (fieldAnnotation = field.getAnnotation(JSONField.class)) != null) {
                ordinal = fieldAnnotation.ordinal();
                serialzeFeatures = SerializerFeature.of(fieldAnnotation.serialzeFeatures());
                if (fieldAnnotation.name().length() != 0) {
                    propertyName = fieldAnnotation.name();
                    beanInfo.add(new FieldInfo(propertyName, method, field, clazz, type, ordinal, serialzeFeatures, annotation, fieldAnnotation));
                    continue;
                }
            }
            beanInfo.add(new FieldInfo(propertyName, method, null, clazz, type, ordinal, serialzeFeatures, annotation, null));
            TypeUtils.setAccessible(clazz, method, modifiers);
        }
        for (AccessibleObject accessibleObject : clazz.getFields()) {
            if (Modifier.isStatic(((Field)accessibleObject).getModifiers())) continue;
            String fieldName = ((Field)accessibleObject).getName();
            boolean contains = false;
            for (FieldInfo item : beanInfo.fields) {
                if (!item.name.equals(fieldName)) continue;
                contains = true;
            }
            if (contains) continue;
            int ordinal = 0;
            int serialzeFeatures = 0;
            String propertyName = fieldName;
            JSONField fieldAnnotation = ((Field)accessibleObject).getAnnotation(JSONField.class);
            if (fieldAnnotation != null) {
                ordinal = fieldAnnotation.ordinal();
                serialzeFeatures = SerializerFeature.of(fieldAnnotation.serialzeFeatures());
                if (fieldAnnotation.name().length() != 0) {
                    propertyName = fieldAnnotation.name();
                }
            }
            TypeUtils.setAccessible(clazz, (Member)((Object)accessibleObject), modifiers);
            beanInfo.add(new FieldInfo(propertyName, null, (Field)accessibleObject, clazz, type, ordinal, serialzeFeatures, null, fieldAnnotation));
        }
        for (AccessibleObject accessibleObject : clazz.getMethods()) {
            String annotationName;
            Class<?> methodReturnType;
            String methodName = ((Method)accessibleObject).getName();
            if (methodName.length() < 4 || Modifier.isStatic(((Method)accessibleObject).getModifiers()) || !methodName.startsWith("get") || !Character.isUpperCase(methodName.charAt(3)) || ((Method)accessibleObject).getParameterTypes().length != 0 || !Collection.class.isAssignableFrom(methodReturnType = ((Method)accessibleObject).getReturnType()) && !Map.class.isAssignableFrom(methodReturnType)) continue;
            JSONField annotation = ((Method)accessibleObject).getAnnotation(JSONField.class);
            String propertyName = annotation != null && (annotationName = annotation.name()).length() > 0 ? annotationName : Character.toLowerCase(methodName.charAt(3)) + methodName.substring(4);
            beanInfo.add(new FieldInfo(propertyName, (Method)accessibleObject, null, clazz, type, 0, 0, annotation, null));
            TypeUtils.setAccessible(clazz, (Member)((Object)accessibleObject), modifiers);
        }
        return beanInfo;
    }

    private static Constructor<?> getDefaultConstructor(Class<?> clazz) {
        int classModifiers = clazz.getModifiers();
        if ((classModifiers & 0x400) != 0) {
            return null;
        }
        Constructor<?> defaultConstructor = null;
        for (Constructor<?> constructor : clazz.getDeclaredConstructors()) {
            if (constructor.getParameterTypes().length != 0) continue;
            defaultConstructor = constructor;
            break;
        }
        if (defaultConstructor == null && clazz.isMemberClass() && (classModifiers & 8) == 0) {
            for (Constructor<?> constructor : clazz.getDeclaredConstructors()) {
                Class<?>[] parameterTypes = constructor.getParameterTypes();
                if (parameterTypes.length != 1 || !parameterTypes[0].equals(clazz.getDeclaringClass())) continue;
                defaultConstructor = constructor;
                break;
            }
        }
        return defaultConstructor;
    }

    public static Constructor<?> getCreatorConstructor(Class<?> clazz) {
        Constructor<?> creatorConstructor = null;
        for (Constructor<?> constructor : clazz.getDeclaredConstructors()) {
            JSONCreator annotation = constructor.getAnnotation(JSONCreator.class);
            if (annotation == null) continue;
            if (creatorConstructor != null) {
                throw new JSONException("multi-json creator");
            }
            creatorConstructor = constructor;
            break;
        }
        return creatorConstructor;
    }

    private static Method getFactoryMethod(Class<?> clazz, Method[] methods) {
        Method factoryMethod = null;
        for (Method method : methods) {
            JSONCreator annotation;
            if (!Modifier.isStatic(method.getModifiers()) || !clazz.isAssignableFrom(method.getReturnType()) || (annotation = method.getAnnotation(JSONCreator.class)) == null) continue;
            if (factoryMethod != null) {
                throw new JSONException("multi-json creator");
            }
            factoryMethod = method;
            break;
        }
        return factoryMethod;
    }
}

