/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson.serializer;

import com.alibaba.fastjson.serializer.ArrayCodec;
import com.alibaba.fastjson.serializer.BigDecimalCodec;
import com.alibaba.fastjson.serializer.BooleanCodec;
import com.alibaba.fastjson.serializer.IntegerCodec;
import com.alibaba.fastjson.serializer.JavaBeanSerializer;
import com.alibaba.fastjson.serializer.MiscCodec;
import com.alibaba.fastjson.serializer.NumberCodec;
import com.alibaba.fastjson.serializer.ObjectSerializer;
import com.alibaba.fastjson.serializer.StringCodec;
import com.alibaba.fastjson.util.IdentityHashMap;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URI;
import java.net.URL;
import java.nio.charset.Charset;
import java.text.SimpleDateFormat;
import java.util.Currency;
import java.util.Locale;
import java.util.TimeZone;
import java.util.UUID;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SerializeConfig
extends IdentityHashMap<Type, ObjectSerializer> {
    public static final SerializeConfig globalInstance = new SerializeConfig();

    public ObjectSerializer createJavaBeanSerializer(Class<?> clazz) {
        return new JavaBeanSerializer(clazz);
    }

    public static final SerializeConfig getGlobalInstance() {
        return globalInstance;
    }

    public SerializeConfig() {
        this(1024);
    }

    public SerializeConfig(int tableSize) {
        super(tableSize);
        this.put(Boolean.class, BooleanCodec.instance);
        this.put(Character.class, MiscCodec.instance);
        this.put(Byte.class, IntegerCodec.instance);
        this.put(Short.class, IntegerCodec.instance);
        this.put(Integer.class, IntegerCodec.instance);
        this.put(Long.class, IntegerCodec.instance);
        this.put(Float.class, NumberCodec.instance);
        this.put(Double.class, NumberCodec.instance);
        this.put(BigDecimal.class, BigDecimalCodec.instance);
        this.put(BigInteger.class, BigDecimalCodec.instance);
        this.put(String.class, StringCodec.instance);
        this.put(Object[].class, ArrayCodec.instance);
        this.put(Class.class, MiscCodec.instance);
        this.put(SimpleDateFormat.class, MiscCodec.instance);
        this.put(Locale.class, MiscCodec.instance);
        this.put(Currency.class, MiscCodec.instance);
        this.put(TimeZone.class, MiscCodec.instance);
        this.put(UUID.class, MiscCodec.instance);
        this.put(URI.class, MiscCodec.instance);
        this.put(URL.class, MiscCodec.instance);
        this.put(Pattern.class, MiscCodec.instance);
        this.put(Charset.class, MiscCodec.instance);
    }
}

