/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson.parser.deserializer;

import com.alibaba.fastjson.parser.DefaultJSONParser;
import com.alibaba.fastjson.parser.JSONLexer;
import com.alibaba.fastjson.parser.ParserConfig;
import com.alibaba.fastjson.parser.deserializer.FieldDeserializer;
import com.alibaba.fastjson.util.FieldInfo;
import com.alibaba.fastjson.util.TypeUtils;
import java.lang.reflect.Type;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BooleanFieldDeserializer
extends FieldDeserializer {
    public BooleanFieldDeserializer(ParserConfig mapping, Class<?> clazz, FieldInfo fieldInfo) {
        super(clazz, fieldInfo, 6);
    }

    @Override
    public void parseField(DefaultJSONParser parser, Object object, Type objectType, Map<String, Object> fieldValues) {
        JSONLexer lexer = parser.lexer;
        int token = lexer.token();
        if (token == 6) {
            lexer.nextToken(16);
            if (object == null) {
                fieldValues.put(this.fieldInfo.name, Boolean.TRUE);
            } else {
                this.setValue(object, Boolean.TRUE);
            }
            return;
        }
        if (token == 2) {
            boolean booleanValue;
            int val = lexer.intValue();
            lexer.nextToken(16);
            boolean bl = booleanValue = val == 1;
            if (object == null) {
                fieldValues.put(this.fieldInfo.name, booleanValue);
            } else {
                this.setValue(object, booleanValue ? Boolean.TRUE : Boolean.FALSE);
            }
            return;
        }
        if (token == 8) {
            Object value = null;
            lexer.nextToken(16);
            if (this.fieldInfo.fieldClass == Boolean.TYPE) {
                return;
            }
            if (object != null) {
                this.setValue(object, null);
            }
            return;
        }
        if (token == 7) {
            lexer.nextToken(16);
            if (object == null) {
                fieldValues.put(this.fieldInfo.name, Boolean.FALSE);
            } else {
                this.setValue(object, Boolean.FALSE);
            }
            return;
        }
        Object obj = parser.parse();
        Boolean value = TypeUtils.castToBoolean(obj);
        if (value == null && this.fieldInfo.fieldClass == Boolean.TYPE) {
            return;
        }
        if (object == null) {
            fieldValues.put(this.fieldInfo.name, value);
        } else {
            this.setValue(object, value);
        }
    }
}

