/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson.parser;

import com.alibaba.fastjson.annotation.JSONType;
import com.alibaba.fastjson.parser.SymbolTable;
import com.alibaba.fastjson.parser.deserializer.ArrayListTypeFieldDeserializer;
import com.alibaba.fastjson.parser.deserializer.BooleanFieldDeserializer;
import com.alibaba.fastjson.parser.deserializer.DefaultFieldDeserializer;
import com.alibaba.fastjson.parser.deserializer.EnumDeserializer;
import com.alibaba.fastjson.parser.deserializer.FieldDeserializer;
import com.alibaba.fastjson.parser.deserializer.IntegerFieldDeserializer;
import com.alibaba.fastjson.parser.deserializer.JavaBeanDeserializer;
import com.alibaba.fastjson.parser.deserializer.JavaObjectDeserializer;
import com.alibaba.fastjson.parser.deserializer.LongFieldDeserializer;
import com.alibaba.fastjson.parser.deserializer.ObjectDeserializer;
import com.alibaba.fastjson.parser.deserializer.StringFieldDeserializer;
import com.alibaba.fastjson.parser.deserializer.ThrowableDeserializer;
import com.alibaba.fastjson.serializer.ArrayCodec;
import com.alibaba.fastjson.serializer.BigDecimalCodec;
import com.alibaba.fastjson.serializer.BooleanCodec;
import com.alibaba.fastjson.serializer.CalendarCodec;
import com.alibaba.fastjson.serializer.CollectionCodec;
import com.alibaba.fastjson.serializer.DateCodec;
import com.alibaba.fastjson.serializer.IntegerCodec;
import com.alibaba.fastjson.serializer.MapCodec;
import com.alibaba.fastjson.serializer.MiscCodec;
import com.alibaba.fastjson.serializer.NumberCodec;
import com.alibaba.fastjson.serializer.StringCodec;
import com.alibaba.fastjson.util.FieldInfo;
import com.alibaba.fastjson.util.IdentityHashMap;
import java.io.Closeable;
import java.io.Serializable;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URI;
import java.net.URL;
import java.nio.charset.Charset;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Currency;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import java.util.TreeMap;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ParserConfig {
    private static Object PRESENT = new Object();
    private static final Map<Class<?>, Object> primitiveClasses = new java.util.IdentityHashMap();
    public static ParserConfig global = new ParserConfig();
    private final IdentityHashMap<Type, ObjectDeserializer> derializers = new IdentityHashMap();
    public final SymbolTable symbolTable = new SymbolTable(512);
    public ClassLoader defaultClassLoader;

    public static ParserConfig getGlobalInstance() {
        return global;
    }

    public ParserConfig() {
        this.derializers.put((Type)((Object)SimpleDateFormat.class), MiscCodec.instance);
        this.derializers.put((Type)((Object)Date.class), DateCodec.instance);
        this.derializers.put((Type)((Object)Calendar.class), CalendarCodec.instance);
        this.derializers.put((Type)((Object)Map.class), MapCodec.instance);
        this.derializers.put((Type)((Object)HashMap.class), MapCodec.instance);
        this.derializers.put((Type)((Object)LinkedHashMap.class), MapCodec.instance);
        this.derializers.put((Type)((Object)TreeMap.class), MapCodec.instance);
        this.derializers.put((Type)((Object)ConcurrentMap.class), MapCodec.instance);
        this.derializers.put((Type)((Object)ConcurrentHashMap.class), MapCodec.instance);
        this.derializers.put((Type)((Object)Collection.class), CollectionCodec.instance);
        this.derializers.put((Type)((Object)List.class), CollectionCodec.instance);
        this.derializers.put((Type)((Object)ArrayList.class), CollectionCodec.instance);
        this.derializers.put((Type)((Object)Object.class), JavaObjectDeserializer.instance);
        this.derializers.put((Type)((Object)String.class), StringCodec.instance);
        this.derializers.put(Character.TYPE, MiscCodec.instance);
        this.derializers.put((Type)((Object)Character.class), MiscCodec.instance);
        this.derializers.put(Byte.TYPE, NumberCodec.instance);
        this.derializers.put((Type)((Object)Byte.class), NumberCodec.instance);
        this.derializers.put(Short.TYPE, NumberCodec.instance);
        this.derializers.put((Type)((Object)Short.class), NumberCodec.instance);
        this.derializers.put(Integer.TYPE, IntegerCodec.instance);
        this.derializers.put((Type)((Object)Integer.class), IntegerCodec.instance);
        this.derializers.put(Long.TYPE, IntegerCodec.instance);
        this.derializers.put((Type)((Object)Long.class), IntegerCodec.instance);
        this.derializers.put((Type)((Object)BigInteger.class), BigDecimalCodec.instance);
        this.derializers.put((Type)((Object)BigDecimal.class), BigDecimalCodec.instance);
        this.derializers.put(Float.TYPE, NumberCodec.instance);
        this.derializers.put((Type)((Object)Float.class), NumberCodec.instance);
        this.derializers.put(Double.TYPE, NumberCodec.instance);
        this.derializers.put((Type)((Object)Double.class), NumberCodec.instance);
        this.derializers.put(Boolean.TYPE, BooleanCodec.instance);
        this.derializers.put((Type)((Object)Boolean.class), BooleanCodec.instance);
        this.derializers.put((Type)((Object)Class.class), MiscCodec.instance);
        this.derializers.put((Type)((Object)char[].class), ArrayCodec.instance);
        this.derializers.put((Type)((Object)UUID.class), MiscCodec.instance);
        this.derializers.put((Type)((Object)TimeZone.class), MiscCodec.instance);
        this.derializers.put((Type)((Object)Locale.class), MiscCodec.instance);
        this.derializers.put((Type)((Object)Currency.class), MiscCodec.instance);
        this.derializers.put((Type)((Object)URI.class), MiscCodec.instance);
        this.derializers.put((Type)((Object)URL.class), MiscCodec.instance);
        this.derializers.put((Type)((Object)Pattern.class), MiscCodec.instance);
        this.derializers.put((Type)((Object)Charset.class), MiscCodec.instance);
        this.derializers.put((Type)((Object)Number.class), NumberCodec.instance);
        this.derializers.put((Type)((Object)StackTraceElement.class), MiscCodec.instance);
        this.derializers.put((Type)((Object)Serializable.class), JavaObjectDeserializer.instance);
        this.derializers.put((Type)((Object)Cloneable.class), JavaObjectDeserializer.instance);
        this.derializers.put((Type)((Object)Comparable.class), JavaObjectDeserializer.instance);
        this.derializers.put((Type)((Object)Closeable.class), JavaObjectDeserializer.instance);
    }

    public ObjectDeserializer getDeserializer(Type type) {
        ObjectDeserializer derializer = this.derializers.get(type);
        if (derializer != null) {
            return derializer;
        }
        if (type instanceof Class) {
            return this.getDeserializer((Class)type, type);
        }
        if (type instanceof ParameterizedType) {
            Type rawType = ((ParameterizedType)type).getRawType();
            if (rawType instanceof Class) {
                return this.getDeserializer((Class)rawType, type);
            }
            return this.getDeserializer(rawType);
        }
        return JavaObjectDeserializer.instance;
    }

    public ObjectDeserializer getDeserializer(Class<?> clazz, Type type) {
        Class<?> mappingTo;
        JSONType annotation;
        ObjectDeserializer derializer = this.derializers.get(type);
        if (derializer != null) {
            return derializer;
        }
        if (type == null) {
            type = clazz;
        }
        if ((derializer = this.derializers.get(type)) != null) {
            return derializer;
        }
        if (!this.isPrimitive(clazz) && (annotation = clazz.getAnnotation(JSONType.class)) != null && (mappingTo = annotation.mappingTo()) != Void.class) {
            return this.getDeserializer(mappingTo, mappingTo);
        }
        if (type instanceof WildcardType || type instanceof TypeVariable || type instanceof ParameterizedType) {
            derializer = this.derializers.get(clazz);
        }
        if (derializer != null) {
            return derializer;
        }
        derializer = this.derializers.get(type);
        if (derializer != null) {
            return derializer;
        }
        derializer = clazz.isEnum() ? new EnumDeserializer(clazz) : (clazz.isArray() ? ArrayCodec.instance : (clazz == Set.class || clazz == HashSet.class || clazz == Collection.class || clazz == List.class || clazz == ArrayList.class ? CollectionCodec.instance : (Collection.class.isAssignableFrom(clazz) ? CollectionCodec.instance : (Map.class.isAssignableFrom(clazz) ? MapCodec.instance : (Throwable.class.isAssignableFrom(clazz) ? new ThrowableDeserializer(this, clazz) : this.createJavaBeanDeserializer(clazz, type))))));
        this.putDeserializer(type, derializer);
        return derializer;
    }

    public ObjectDeserializer createJavaBeanDeserializer(Class<?> clazz, Type type) {
        return new JavaBeanDeserializer(this, clazz, type);
    }

    public FieldDeserializer createFieldDeserializer(ParserConfig mapping, Class<?> clazz, FieldInfo fieldInfo) {
        Class<?> fieldClass = fieldInfo.fieldClass;
        if (fieldClass == Boolean.TYPE || fieldClass == Boolean.class) {
            return new BooleanFieldDeserializer(mapping, clazz, fieldInfo);
        }
        if (fieldClass == Integer.TYPE || fieldClass == Integer.class) {
            return new IntegerFieldDeserializer(mapping, clazz, fieldInfo);
        }
        if (fieldClass == Long.TYPE || fieldClass == Long.class) {
            return new LongFieldDeserializer(mapping, clazz, fieldInfo);
        }
        if (fieldClass == String.class) {
            return new StringFieldDeserializer(mapping, clazz, fieldInfo);
        }
        if (fieldClass == List.class || fieldClass == ArrayList.class) {
            return new ArrayListTypeFieldDeserializer(mapping, clazz, fieldInfo);
        }
        return new DefaultFieldDeserializer(mapping, clazz, fieldInfo);
    }

    public void putDeserializer(Type type, ObjectDeserializer deserializer) {
        this.derializers.put(type, deserializer);
    }

    public ObjectDeserializer getDeserializer(FieldInfo fieldInfo) {
        return this.getDeserializer(fieldInfo.fieldClass, fieldInfo.fieldType);
    }

    public boolean isPrimitive(Class<?> clazz) {
        return primitiveClasses.containsKey(clazz);
    }

    public Map<String, FieldDeserializer> getFieldDeserializers(Class<?> clazz) {
        ObjectDeserializer deserizer = this.getDeserializer(clazz);
        if (deserizer instanceof JavaBeanDeserializer) {
            return ((JavaBeanDeserializer)deserizer).feildDeserializerMap;
        }
        return Collections.emptyMap();
    }

    static {
        primitiveClasses.put(Boolean.TYPE, PRESENT);
        primitiveClasses.put(Boolean.class, PRESENT);
        primitiveClasses.put(Character.TYPE, PRESENT);
        primitiveClasses.put(Character.class, PRESENT);
        primitiveClasses.put(Byte.TYPE, PRESENT);
        primitiveClasses.put(Byte.class, PRESENT);
        primitiveClasses.put(Short.TYPE, PRESENT);
        primitiveClasses.put(Short.class, PRESENT);
        primitiveClasses.put(Integer.TYPE, PRESENT);
        primitiveClasses.put(Integer.class, PRESENT);
        primitiveClasses.put(Long.TYPE, PRESENT);
        primitiveClasses.put(Long.class, PRESENT);
        primitiveClasses.put(Float.TYPE, PRESENT);
        primitiveClasses.put(Float.class, PRESENT);
        primitiveClasses.put(Double.TYPE, PRESENT);
        primitiveClasses.put(Double.class, PRESENT);
        primitiveClasses.put(BigInteger.class, PRESENT);
        primitiveClasses.put(BigDecimal.class, PRESENT);
        primitiveClasses.put(String.class, PRESENT);
        primitiveClasses.put(Date.class, PRESENT);
    }
}

