/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson.parser;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONException;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.annotation.JSONType;
import com.alibaba.fastjson.asm.ASMException;
import com.alibaba.fastjson.parser.SymbolTable;
import com.alibaba.fastjson.parser.deserializer.ASMDeserializerFactory;
import com.alibaba.fastjson.parser.deserializer.ASMJavaBeanDeserializer;
import com.alibaba.fastjson.parser.deserializer.ArrayDeserializer;
import com.alibaba.fastjson.parser.deserializer.ArrayListTypeFieldDeserializer;
import com.alibaba.fastjson.parser.deserializer.AtomicIntegerArrayDeserializer;
import com.alibaba.fastjson.parser.deserializer.AtomicLongArrayDeserializer;
import com.alibaba.fastjson.parser.deserializer.AutowiredObjectDeserializer;
import com.alibaba.fastjson.parser.deserializer.BigDecimalDeserializer;
import com.alibaba.fastjson.parser.deserializer.BigIntegerDeserializer;
import com.alibaba.fastjson.parser.deserializer.BooleanDeserializer;
import com.alibaba.fastjson.parser.deserializer.BooleanFieldDeserializer;
import com.alibaba.fastjson.parser.deserializer.CalendarDeserializer;
import com.alibaba.fastjson.parser.deserializer.CharArrayDeserializer;
import com.alibaba.fastjson.parser.deserializer.CharacterDeserializer;
import com.alibaba.fastjson.parser.deserializer.CharsetDeserializer;
import com.alibaba.fastjson.parser.deserializer.ClassDerializer;
import com.alibaba.fastjson.parser.deserializer.CollectionDeserializer;
import com.alibaba.fastjson.parser.deserializer.ColorDeserializer;
import com.alibaba.fastjson.parser.deserializer.DateDeserializer;
import com.alibaba.fastjson.parser.deserializer.DateFormatDeserializer;
import com.alibaba.fastjson.parser.deserializer.DefaultFieldDeserializer;
import com.alibaba.fastjson.parser.deserializer.EnumDeserializer;
import com.alibaba.fastjson.parser.deserializer.FieldDeserializer;
import com.alibaba.fastjson.parser.deserializer.FileDeserializer;
import com.alibaba.fastjson.parser.deserializer.FloatDeserializer;
import com.alibaba.fastjson.parser.deserializer.FontDeserializer;
import com.alibaba.fastjson.parser.deserializer.InetAddressDeserializer;
import com.alibaba.fastjson.parser.deserializer.InetSocketAddressDeserializer;
import com.alibaba.fastjson.parser.deserializer.IntegerDeserializer;
import com.alibaba.fastjson.parser.deserializer.IntegerFieldDeserializer;
import com.alibaba.fastjson.parser.deserializer.JSONArrayDeserializer;
import com.alibaba.fastjson.parser.deserializer.JSONObjectDeserializer;
import com.alibaba.fastjson.parser.deserializer.JavaBeanDeserializer;
import com.alibaba.fastjson.parser.deserializer.JavaObjectDeserializer;
import com.alibaba.fastjson.parser.deserializer.LocaleDeserializer;
import com.alibaba.fastjson.parser.deserializer.LongDeserializer;
import com.alibaba.fastjson.parser.deserializer.LongFieldDeserializer;
import com.alibaba.fastjson.parser.deserializer.MapDeserializer;
import com.alibaba.fastjson.parser.deserializer.NumberDeserializer;
import com.alibaba.fastjson.parser.deserializer.ObjectDeserializer;
import com.alibaba.fastjson.parser.deserializer.PatternDeserializer;
import com.alibaba.fastjson.parser.deserializer.PointDeserializer;
import com.alibaba.fastjson.parser.deserializer.RectangleDeserializer;
import com.alibaba.fastjson.parser.deserializer.ReferenceDeserializer;
import com.alibaba.fastjson.parser.deserializer.SqlDateDeserializer;
import com.alibaba.fastjson.parser.deserializer.StackTraceElementDeserializer;
import com.alibaba.fastjson.parser.deserializer.StringDeserializer;
import com.alibaba.fastjson.parser.deserializer.StringFieldDeserializer;
import com.alibaba.fastjson.parser.deserializer.ThrowableDeserializer;
import com.alibaba.fastjson.parser.deserializer.TimeDeserializer;
import com.alibaba.fastjson.parser.deserializer.TimeZoneDeserializer;
import com.alibaba.fastjson.parser.deserializer.TimestampDeserializer;
import com.alibaba.fastjson.parser.deserializer.URIDeserializer;
import com.alibaba.fastjson.parser.deserializer.URLDeserializer;
import com.alibaba.fastjson.parser.deserializer.UUIDDeserializer;
import com.alibaba.fastjson.util.ASMUtils;
import com.alibaba.fastjson.util.DeserializeBeanInfo;
import com.alibaba.fastjson.util.FieldInfo;
import com.alibaba.fastjson.util.IOUtils;
import com.alibaba.fastjson.util.IdentityHashMap;
import com.alibaba.fastjson.util.ServiceLoader;
import com.alibaba.fastjson.util.TypeUtils;
import java.io.Closeable;
import java.io.File;
import java.io.Serializable;
import java.lang.ref.SoftReference;
import java.lang.ref.WeakReference;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.URI;
import java.net.URL;
import java.nio.charset.Charset;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TimeZone;
import java.util.TreeMap;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicIntegerArray;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicLongArray;
import java.util.concurrent.atomic.AtomicReference;
import java.util.regex.Pattern;
import javax.sql.DataSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ParserConfig {
    public static final String DENY_PROPERTY = "fastjson.parser.deny";
    public static final String AUTOTYPE_ACCEPT = "fastjson.parser.autoTypeAccept";
    public static final String AUTOTYPE_SUPPORT_PROPERTY = "fastjson.parser.autoTypeSupport";
    public static final String[] DENYS;
    private static final String[] AUTO_TYPE_ACCEPT_LIST;
    public static final boolean AUTO_SUPPORT;
    private final Set<Class<?>> primitiveClasses = new HashSet();
    private static ParserConfig global;
    private final IdentityHashMap<Type, ObjectDeserializer> derializers = new IdentityHashMap();
    private boolean asmEnable = !ASMUtils.isAndroid();
    protected final SymbolTable symbolTable = new SymbolTable();
    private boolean autoTypeSupport = AUTO_SUPPORT;
    private String[] denyList = "bsh,com.mchange,com.sun.,java.lang.Thread,java.net.Socket,java.rmi,javax.xml,org.apache.bcel,org.apache.commons.beanutils,org.apache.commons.collections.Transformer,org.apache.commons.collections.functors,org.apache.commons.collections4.comparators,org.apache.commons.fileupload,org.apache.myfaces.context.servlet,org.apache.tomcat,org.apache.wicket.util,org.codehaus.groovy.runtime,org.hibernate,org.jboss,org.mozilla.javascript,org.python.core,org.springframework".split(",");
    private String[] acceptList = AUTO_TYPE_ACCEPT_LIST;

    public static ParserConfig getGlobalInstance() {
        return global;
    }

    public ParserConfig() {
        this.primitiveClasses.add(Boolean.TYPE);
        this.primitiveClasses.add(Boolean.class);
        this.primitiveClasses.add(Character.TYPE);
        this.primitiveClasses.add(Character.class);
        this.primitiveClasses.add(Byte.TYPE);
        this.primitiveClasses.add(Byte.class);
        this.primitiveClasses.add(Short.TYPE);
        this.primitiveClasses.add(Short.class);
        this.primitiveClasses.add(Integer.TYPE);
        this.primitiveClasses.add(Integer.class);
        this.primitiveClasses.add(Long.TYPE);
        this.primitiveClasses.add(Long.class);
        this.primitiveClasses.add(Float.TYPE);
        this.primitiveClasses.add(Float.class);
        this.primitiveClasses.add(Double.TYPE);
        this.primitiveClasses.add(Double.class);
        this.primitiveClasses.add(BigInteger.class);
        this.primitiveClasses.add(BigDecimal.class);
        this.primitiveClasses.add(String.class);
        this.primitiveClasses.add(Date.class);
        this.primitiveClasses.add(java.sql.Date.class);
        this.primitiveClasses.add(Time.class);
        this.primitiveClasses.add(Timestamp.class);
        this.derializers.put((Type)((Object)SimpleDateFormat.class), DateFormatDeserializer.instance);
        this.derializers.put((Type)((Object)Timestamp.class), TimestampDeserializer.instance);
        this.derializers.put((Type)((Object)java.sql.Date.class), SqlDateDeserializer.instance);
        this.derializers.put((Type)((Object)Time.class), TimeDeserializer.instance);
        this.derializers.put((Type)((Object)Date.class), DateDeserializer.instance);
        this.derializers.put((Type)((Object)Calendar.class), CalendarDeserializer.instance);
        this.derializers.put((Type)((Object)JSONObject.class), JSONObjectDeserializer.instance);
        this.derializers.put((Type)((Object)JSONArray.class), JSONArrayDeserializer.instance);
        this.derializers.put((Type)((Object)Map.class), MapDeserializer.instance);
        this.derializers.put((Type)((Object)HashMap.class), MapDeserializer.instance);
        this.derializers.put((Type)((Object)LinkedHashMap.class), MapDeserializer.instance);
        this.derializers.put((Type)((Object)TreeMap.class), MapDeserializer.instance);
        this.derializers.put((Type)((Object)ConcurrentMap.class), MapDeserializer.instance);
        this.derializers.put((Type)((Object)ConcurrentHashMap.class), MapDeserializer.instance);
        this.derializers.put((Type)((Object)Collection.class), CollectionDeserializer.instance);
        this.derializers.put((Type)((Object)List.class), CollectionDeserializer.instance);
        this.derializers.put((Type)((Object)ArrayList.class), CollectionDeserializer.instance);
        this.derializers.put((Type)((Object)Object.class), JavaObjectDeserializer.instance);
        this.derializers.put((Type)((Object)String.class), StringDeserializer.instance);
        this.derializers.put(Character.TYPE, CharacterDeserializer.instance);
        this.derializers.put((Type)((Object)Character.class), CharacterDeserializer.instance);
        this.derializers.put(Byte.TYPE, NumberDeserializer.instance);
        this.derializers.put((Type)((Object)Byte.class), NumberDeserializer.instance);
        this.derializers.put(Short.TYPE, NumberDeserializer.instance);
        this.derializers.put((Type)((Object)Short.class), NumberDeserializer.instance);
        this.derializers.put(Integer.TYPE, IntegerDeserializer.instance);
        this.derializers.put((Type)((Object)Integer.class), IntegerDeserializer.instance);
        this.derializers.put(Long.TYPE, LongDeserializer.instance);
        this.derializers.put((Type)((Object)Long.class), LongDeserializer.instance);
        this.derializers.put((Type)((Object)BigInteger.class), BigIntegerDeserializer.instance);
        this.derializers.put((Type)((Object)BigDecimal.class), BigDecimalDeserializer.instance);
        this.derializers.put(Float.TYPE, FloatDeserializer.instance);
        this.derializers.put((Type)((Object)Float.class), FloatDeserializer.instance);
        this.derializers.put(Double.TYPE, NumberDeserializer.instance);
        this.derializers.put((Type)((Object)Double.class), NumberDeserializer.instance);
        this.derializers.put(Boolean.TYPE, BooleanDeserializer.instance);
        this.derializers.put((Type)((Object)Boolean.class), BooleanDeserializer.instance);
        this.derializers.put((Type)((Object)Class.class), ClassDerializer.instance);
        this.derializers.put((Type)((Object)char[].class), CharArrayDeserializer.instance);
        this.derializers.put((Type)((Object)AtomicBoolean.class), BooleanDeserializer.instance);
        this.derializers.put((Type)((Object)AtomicInteger.class), IntegerDeserializer.instance);
        this.derializers.put((Type)((Object)AtomicLong.class), LongDeserializer.instance);
        this.derializers.put((Type)((Object)AtomicReference.class), ReferenceDeserializer.instance);
        this.derializers.put((Type)((Object)WeakReference.class), ReferenceDeserializer.instance);
        this.derializers.put((Type)((Object)SoftReference.class), ReferenceDeserializer.instance);
        this.derializers.put((Type)((Object)UUID.class), UUIDDeserializer.instance);
        this.derializers.put((Type)((Object)TimeZone.class), TimeZoneDeserializer.instance);
        this.derializers.put((Type)((Object)Locale.class), LocaleDeserializer.instance);
        this.derializers.put((Type)((Object)InetAddress.class), InetAddressDeserializer.instance);
        this.derializers.put((Type)((Object)Inet4Address.class), InetAddressDeserializer.instance);
        this.derializers.put((Type)((Object)Inet6Address.class), InetAddressDeserializer.instance);
        this.derializers.put((Type)((Object)InetSocketAddress.class), InetSocketAddressDeserializer.instance);
        this.derializers.put((Type)((Object)File.class), FileDeserializer.instance);
        this.derializers.put((Type)((Object)URI.class), URIDeserializer.instance);
        this.derializers.put((Type)((Object)URL.class), URLDeserializer.instance);
        this.derializers.put((Type)((Object)Pattern.class), PatternDeserializer.instance);
        this.derializers.put((Type)((Object)Charset.class), CharsetDeserializer.instance);
        this.derializers.put((Type)((Object)Number.class), NumberDeserializer.instance);
        this.derializers.put((Type)((Object)AtomicIntegerArray.class), AtomicIntegerArrayDeserializer.instance);
        this.derializers.put((Type)((Object)AtomicLongArray.class), AtomicLongArrayDeserializer.instance);
        this.derializers.put((Type)((Object)StackTraceElement.class), StackTraceElementDeserializer.instance);
        this.derializers.put((Type)((Object)Serializable.class), JavaObjectDeserializer.instance);
        this.derializers.put((Type)((Object)Cloneable.class), JavaObjectDeserializer.instance);
        this.derializers.put((Type)((Object)Comparable.class), JavaObjectDeserializer.instance);
        this.derializers.put((Type)((Object)Closeable.class), JavaObjectDeserializer.instance);
        try {
            this.derializers.put(Class.forName("java.awt.Point"), PointDeserializer.instance);
            this.derializers.put(Class.forName("java.awt.Font"), FontDeserializer.instance);
            this.derializers.put(Class.forName("java.awt.Rectangle"), RectangleDeserializer.instance);
            this.derializers.put(Class.forName("java.awt.Color"), ColorDeserializer.instance);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.addItemsToDeny(DENYS);
        this.addItemsToAccept(AUTO_TYPE_ACCEPT_LIST);
    }

    public boolean isAsmEnable() {
        return this.asmEnable;
    }

    public void setAsmEnable(boolean asmEnable) {
        this.asmEnable = asmEnable;
    }

    public SymbolTable getSymbolTable() {
        return this.symbolTable;
    }

    public IdentityHashMap<Type, ObjectDeserializer> getDerializers() {
        return this.derializers;
    }

    public ObjectDeserializer getDeserializer(Type type) {
        ObjectDeserializer derializer = this.derializers.get(type);
        if (derializer != null) {
            return derializer;
        }
        if (type instanceof Class) {
            return this.getDeserializer((Class)type, type);
        }
        if (type instanceof ParameterizedType) {
            Type rawType = ((ParameterizedType)type).getRawType();
            if (rawType instanceof Class) {
                return this.getDeserializer((Class)rawType, type);
            }
            return this.getDeserializer(rawType);
        }
        return JavaObjectDeserializer.instance;
    }

    public ObjectDeserializer getDeserializer(Class<?> clazz, Type type) {
        Class<?> mappingTo;
        ObjectDeserializer derializer = this.derializers.get(type);
        if (derializer != null) {
            return derializer;
        }
        if (type == null) {
            type = clazz;
        }
        if ((derializer = this.derializers.get(type)) != null) {
            return derializer;
        }
        JSONType annotation = clazz.getAnnotation(JSONType.class);
        if (annotation != null && (mappingTo = annotation.mappingTo()) != Void.class) {
            return this.getDeserializer(mappingTo, mappingTo);
        }
        if (type instanceof WildcardType || type instanceof TypeVariable || type instanceof ParameterizedType) {
            derializer = this.derializers.get(clazz);
        }
        if (derializer != null) {
            return derializer;
        }
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        try {
            for (AutowiredObjectDeserializer autowired : ServiceLoader.load(AutowiredObjectDeserializer.class, classLoader)) {
                for (Type forType : autowired.getAutowiredFor()) {
                    this.derializers.put(forType, autowired);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if ((derializer = this.derializers.get(type)) != null) {
            return derializer;
        }
        if (clazz.isEnum()) {
            derializer = new EnumDeserializer(clazz);
        } else {
            if (clazz.isArray()) {
                return ArrayDeserializer.instance;
            }
            derializer = clazz == Set.class || clazz == HashSet.class || clazz == Collection.class || clazz == List.class || clazz == ArrayList.class ? CollectionDeserializer.instance : (Collection.class.isAssignableFrom(clazz) ? CollectionDeserializer.instance : (Map.class.isAssignableFrom(clazz) ? MapDeserializer.instance : (Throwable.class.isAssignableFrom(clazz) ? new ThrowableDeserializer(this, clazz) : this.createJavaBeanDeserializer(clazz, type))));
        }
        this.putDeserializer(type, derializer);
        return derializer;
    }

    public ObjectDeserializer createJavaBeanDeserializer(Class<?> clazz, Type type) {
        boolean asmEnable = this.asmEnable;
        if (asmEnable && !Modifier.isPublic(clazz.getModifiers())) {
            asmEnable = false;
        }
        if (clazz.getTypeParameters().length != 0) {
            asmEnable = false;
        }
        if (ASMDeserializerFactory.getInstance().isExternalClass(clazz)) {
            asmEnable = false;
        }
        if (asmEnable) {
            Constructor<?> defaultConstructor;
            DeserializeBeanInfo beanInfo;
            if (clazz.isInterface()) {
                asmEnable = false;
            }
            if ((beanInfo = DeserializeBeanInfo.computeSetters(clazz, type)).getFieldList().size() > 200) {
                asmEnable = false;
            }
            if ((defaultConstructor = beanInfo.getDefaultConstructor()) == null && !clazz.isInterface()) {
                asmEnable = false;
            }
            for (FieldInfo fieldInfo : beanInfo.getFieldList()) {
                if (fieldInfo.isGetOnly()) {
                    asmEnable = false;
                    break;
                }
                Class<?> fieldClass = fieldInfo.getFieldClass();
                if (!Modifier.isPublic(fieldClass.getModifiers())) {
                    asmEnable = false;
                    break;
                }
                if (!fieldClass.isMemberClass() || Modifier.isStatic(fieldClass.getModifiers())) continue;
                asmEnable = false;
            }
        }
        if (asmEnable && clazz.isMemberClass() && !Modifier.isStatic(clazz.getModifiers())) {
            asmEnable = false;
        }
        if (!asmEnable) {
            return new JavaBeanDeserializer(this, clazz, type);
        }
        try {
            return ASMDeserializerFactory.getInstance().createJavaBeanDeserializer(this, clazz, type);
        }
        catch (ASMException asmError) {
            return new JavaBeanDeserializer(this, clazz, type);
        }
        catch (Exception e) {
            throw new JSONException("create asm deserializer error, " + clazz.getName(), e);
        }
    }

    public FieldDeserializer createFieldDeserializer(ParserConfig mapping, Class<?> clazz, FieldInfo fieldInfo) {
        boolean asmEnable = this.asmEnable;
        if (!Modifier.isPublic(clazz.getModifiers())) {
            asmEnable = false;
        }
        if (fieldInfo.getFieldClass() == Class.class) {
            asmEnable = false;
        }
        if (ASMDeserializerFactory.getInstance().isExternalClass(clazz)) {
            asmEnable = false;
        }
        if (!asmEnable) {
            return this.createFieldDeserializerWithoutASM(mapping, clazz, fieldInfo);
        }
        try {
            return ASMDeserializerFactory.getInstance().createFieldDeserializer(mapping, clazz, fieldInfo);
        }
        catch (Throwable throwable) {
            return this.createFieldDeserializerWithoutASM(mapping, clazz, fieldInfo);
        }
    }

    public FieldDeserializer createFieldDeserializerWithoutASM(ParserConfig mapping, Class<?> clazz, FieldInfo fieldInfo) {
        Class<?> fieldClass = fieldInfo.getFieldClass();
        if (fieldClass == Boolean.TYPE || fieldClass == Boolean.class) {
            return new BooleanFieldDeserializer(mapping, clazz, fieldInfo);
        }
        if (fieldClass == Integer.TYPE || fieldClass == Integer.class) {
            return new IntegerFieldDeserializer(mapping, clazz, fieldInfo);
        }
        if (fieldClass == Long.TYPE || fieldClass == Long.class) {
            return new LongFieldDeserializer(mapping, clazz, fieldInfo);
        }
        if (fieldClass == String.class) {
            return new StringFieldDeserializer(mapping, clazz, fieldInfo);
        }
        if (fieldClass == List.class || fieldClass == ArrayList.class) {
            return new ArrayListTypeFieldDeserializer(mapping, clazz, fieldInfo);
        }
        return new DefaultFieldDeserializer(mapping, clazz, fieldInfo);
    }

    public void putDeserializer(Type type, ObjectDeserializer deserializer) {
        this.derializers.put(type, deserializer);
    }

    public ObjectDeserializer getDeserializer(FieldInfo fieldInfo) {
        return this.getDeserializer(fieldInfo.getFieldClass(), fieldInfo.getFieldType());
    }

    public boolean isPrimitive(Class<?> clazz) {
        return this.primitiveClasses.contains(clazz);
    }

    public static Field getField(Class<?> clazz, String fieldName) {
        Field field = ParserConfig.getField0(clazz, fieldName);
        if (field == null) {
            field = ParserConfig.getField0(clazz, "_" + fieldName);
        }
        if (field == null) {
            field = ParserConfig.getField0(clazz, "m_" + fieldName);
        }
        return field;
    }

    private static Field getField0(Class<?> clazz, String fieldName) {
        for (Field item : clazz.getDeclaredFields()) {
            if (!fieldName.equals(item.getName())) continue;
            return item;
        }
        if (clazz.getSuperclass() != null && clazz.getSuperclass() != Object.class) {
            return ParserConfig.getField(clazz.getSuperclass(), fieldName);
        }
        return null;
    }

    public Map<String, FieldDeserializer> getFieldDeserializers(Class<?> clazz) {
        ObjectDeserializer deserizer = this.getDeserializer(clazz);
        if (deserizer instanceof JavaBeanDeserializer) {
            return ((JavaBeanDeserializer)deserizer).getFieldDeserializerMap();
        }
        if (deserizer instanceof ASMJavaBeanDeserializer) {
            return ((ASMJavaBeanDeserializer)deserizer).getInnterSerializer().getFieldDeserializerMap();
        }
        return Collections.emptyMap();
    }

    private static String[] splitItemsFormProperty(String property) {
        if (property != null && property.length() > 0) {
            return property.split(",");
        }
        return null;
    }

    public void configFromPropety(Properties properties) {
        String property = properties.getProperty(DENY_PROPERTY);
        String[] items = ParserConfig.splitItemsFormProperty(property);
        this.addItemsToDeny(items);
        property = properties.getProperty(AUTOTYPE_ACCEPT);
        items = ParserConfig.splitItemsFormProperty(property);
        this.addItemsToAccept(items);
        property = properties.getProperty(AUTOTYPE_SUPPORT_PROPERTY);
        if ("true".equals(property)) {
            this.autoTypeSupport = true;
        } else if ("false".equals(property)) {
            this.autoTypeSupport = false;
        }
    }

    private void addItemsToDeny(String[] items) {
        if (items == null) {
            return;
        }
        for (int i = 0; i < items.length; ++i) {
            String item = items[i];
            this.addDeny(item);
        }
    }

    private void addItemsToAccept(String[] items) {
        if (items == null) {
            return;
        }
        for (int i = 0; i < items.length; ++i) {
            String item = items[i];
            this.addAccept(item);
        }
    }

    public boolean isAutoTypeSupport() {
        return this.autoTypeSupport;
    }

    public void setAutoTypeSupport(boolean autoTypeSupport) {
        this.autoTypeSupport = autoTypeSupport;
    }

    public void addDeny(String name) {
        if (name == null || name.length() == 0) {
            return;
        }
        for (String item : this.denyList) {
            if (!name.equals(item)) continue;
            return;
        }
        String[] denyList = new String[this.denyList.length + 1];
        System.arraycopy(this.denyList, 0, denyList, 0, this.denyList.length);
        denyList[denyList.length - 1] = name;
        this.denyList = denyList;
    }

    public void addAccept(String name) {
        if (name == null || name.length() == 0) {
            return;
        }
        for (String item : this.acceptList) {
            if (!name.equals(item)) continue;
            return;
        }
        String[] acceptList = new String[this.acceptList.length + 1];
        System.arraycopy(this.acceptList, 0, acceptList, 0, this.acceptList.length);
        acceptList[acceptList.length - 1] = name;
        this.acceptList = acceptList;
    }

    public Class<?> checkAutoType(String typeName, Class<?> expectClass) {
        Class<?> clazz;
        if (typeName == null) {
            return null;
        }
        String className = typeName.replace('$', '.');
        if (this.autoTypeSupport || expectClass != null) {
            int i;
            for (i = 0; i < this.acceptList.length; ++i) {
                String accept = this.acceptList[i];
                if (!className.startsWith(accept)) continue;
                return TypeUtils.loadClass(typeName);
            }
            for (i = 0; i < this.denyList.length; ++i) {
                String deny = this.denyList[i];
                if (!className.startsWith(deny)) continue;
                throw new JSONException("autoType is not support. " + typeName);
            }
        }
        if ((clazz = TypeUtils.getClassFromMapping(typeName)) == null) {
            clazz = this.derializers.findClass(typeName);
        }
        if (clazz != null) {
            if (expectClass != null && !expectClass.isAssignableFrom(clazz)) {
                throw new JSONException("type not match. " + typeName + " -> " + expectClass.getName());
            }
            return clazz;
        }
        if (!this.autoTypeSupport) {
            int i;
            for (i = 0; i < this.denyList.length; ++i) {
                String deny = this.denyList[i];
                if (!className.startsWith(deny)) continue;
                throw new JSONException("autoType is not support. " + typeName);
            }
            for (i = 0; i < this.acceptList.length; ++i) {
                String accept = this.acceptList[i];
                if (!className.startsWith(accept)) continue;
                clazz = TypeUtils.loadClass(typeName);
                if (expectClass != null && expectClass.isAssignableFrom(clazz)) {
                    throw new JSONException("type not match. " + typeName + " -> " + expectClass.getName());
                }
                return clazz;
            }
        }
        if (this.autoTypeSupport || expectClass != null) {
            clazz = TypeUtils.loadClass(typeName);
        }
        if (clazz != null) {
            if (ClassLoader.class.isAssignableFrom(clazz) || DataSource.class.isAssignableFrom(clazz)) {
                throw new JSONException("autoType is not support. " + typeName);
            }
            if (expectClass != null) {
                if (expectClass.isAssignableFrom(clazz)) {
                    return clazz;
                }
                throw new JSONException("type not match. " + typeName + " -> " + expectClass.getName());
            }
        }
        if (!this.autoTypeSupport) {
            throw new JSONException("autoType is not support. " + typeName);
        }
        return clazz;
    }

    public void initJavaBeanDeserializers(Class<?> ... classes) {
        if (classes == null) {
            return;
        }
        for (Class<?> type : classes) {
            if (type == null) continue;
            ObjectDeserializer deserializer = this.createJavaBeanDeserializer(type, type);
            this.putDeserializer(type, deserializer);
        }
    }

    static {
        String property = IOUtils.getStringProperty(DENY_PROPERTY);
        DENYS = ParserConfig.splitItemsFormProperty(property);
        property = IOUtils.getStringProperty(AUTOTYPE_SUPPORT_PROPERTY);
        AUTO_SUPPORT = "true".equals(property);
        property = IOUtils.getStringProperty(AUTOTYPE_ACCEPT);
        String[] items = ParserConfig.splitItemsFormProperty(property);
        if (items == null) {
            items = new String[]{};
        }
        AUTO_TYPE_ACCEPT_LIST = items;
        global = new ParserConfig();
    }
}

