/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson;

import com.alibaba.fastjson.JSONException;
import com.alibaba.fastjson.JSONStreamContext;
import com.alibaba.fastjson.JSONStreamState;
import com.alibaba.fastjson.parser.DefaultJSONParser;
import com.alibaba.fastjson.parser.Feature;
import com.alibaba.fastjson.parser.JSONLexer;
import com.alibaba.fastjson.parser.JSONReaderScanner;
import com.alibaba.fastjson.util.TypeUtils;
import java.io.Closeable;
import java.io.Reader;
import java.lang.reflect.Type;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JSONReader
implements Closeable {
    private final DefaultJSONParser parser;
    private JSONStreamContext context;

    public JSONReader(Reader reader) {
        this(new DefaultJSONParser(new JSONReaderScanner(reader)));
    }

    public JSONReader(JSONLexer lexer) {
        this(new DefaultJSONParser(lexer));
    }

    public JSONReader(DefaultJSONParser parser) {
        this.parser = parser;
    }

    public void config(Feature feature, boolean state) {
        this.parser.config(feature, state);
    }

    public void startObject() {
        if (this.context == null) {
            this.context = new JSONStreamContext(null, JSONStreamState.BeginObject);
        } else {
            if (this.context.getState() == JSONStreamState.PropertyKey) {
                this.parser.accept(17);
            } else if (this.context.getState() == JSONStreamState.ArrayValue) {
                this.parser.accept(16);
            } else if (this.context.getState() != JSONStreamState.BeginObject && this.context.getState() != JSONStreamState.BeginArray) {
                throw new JSONException("illegal state : " + (Object)((Object)this.context.getState()));
            }
            this.context = new JSONStreamContext(this.context, JSONStreamState.BeginObject);
        }
        this.parser.accept(12, 18);
    }

    public void endObject() {
        this.parser.accept(13);
        this.endStructure();
    }

    public void startArray() {
        if (this.context == null) {
            this.context = new JSONStreamContext(null, JSONStreamState.BeginArray);
        } else {
            if (this.context.getState() == JSONStreamState.PropertyKey) {
                this.parser.accept(17);
            } else if (this.context.getState() == JSONStreamState.ArrayValue) {
                this.parser.accept(16);
            } else if (this.context.getState() != JSONStreamState.BeginArray) {
                throw new JSONException("illegal state : " + (Object)((Object)this.context.getState()));
            }
            this.context = new JSONStreamContext(this.context, JSONStreamState.BeginArray);
        }
        this.parser.accept(14);
    }

    public void endArray() {
        this.parser.accept(15);
        this.endStructure();
    }

    private void endStructure() {
        this.context = this.context.getParent();
        if (this.context != null) {
            if (this.context.getState() == JSONStreamState.PropertyKey) {
                this.context.setState(JSONStreamState.PropertyValue);
            } else if (this.context.getState() == JSONStreamState.BeginArray) {
                this.context.setState(JSONStreamState.ArrayValue);
            } else if (this.context.getState() == JSONStreamState.ArrayValue) {
                // empty if block
            }
        }
    }

    public boolean hasNext() {
        if (this.context == null) {
            throw new JSONException("context is null");
        }
        int token = this.parser.getLexer().token();
        JSONStreamState state = this.context.getState();
        switch (state) {
            case BeginArray: 
            case ArrayValue: {
                return token != 15;
            }
            case BeginObject: 
            case PropertyValue: {
                return token != 13;
            }
        }
        throw new JSONException("illegal state : " + (Object)((Object)state));
    }

    @Override
    public void close() {
        this.parser.close();
    }

    public Integer readInteger() {
        Object object;
        if (this.context == null) {
            object = this.parser.parse();
        } else {
            this.readBefore();
            object = this.parser.parse();
            this.readAfter();
        }
        return TypeUtils.castToInt(object);
    }

    public Long readLong() {
        Object object;
        if (this.context == null) {
            object = this.parser.parse();
        } else {
            this.readBefore();
            object = this.parser.parse();
            this.readAfter();
        }
        return TypeUtils.castToLong(object);
    }

    public String readString() {
        Object object;
        if (this.context == null) {
            object = this.parser.parse();
        } else {
            this.readBefore();
            object = this.parser.parse();
            this.readAfter();
        }
        return TypeUtils.castToString(object);
    }

    public <T> T readObject(Type type) {
        if (this.context == null) {
            return this.parser.parseObject(type);
        }
        this.readBefore();
        Object object = this.parser.parseObject(type);
        this.readAfter();
        return object;
    }

    public <T> T readObject(Class<T> type) {
        if (this.context == null) {
            return this.parser.parseObject(type);
        }
        this.readBefore();
        T object = this.parser.parseObject(type);
        this.readAfter();
        return object;
    }

    public void readObject(Object object) {
        if (this.context == null) {
            this.parser.parseObject(object);
            return;
        }
        this.readBefore();
        this.parser.parseObject(object);
        this.readAfter();
    }

    public Object readObject() {
        Object object;
        if (this.context == null) {
            return this.parser.parse();
        }
        this.readBefore();
        switch (this.context.getState()) {
            case BeginObject: 
            case PropertyValue: {
                object = this.parser.parseKey();
                break;
            }
            default: {
                object = this.parser.parse();
            }
        }
        this.readAfter();
        return object;
    }

    public Object readObject(Map object) {
        if (this.context == null) {
            return this.parser.parseObject(object);
        }
        this.readBefore();
        Object value = this.parser.parseObject(object);
        this.readAfter();
        return value;
    }

    private void readBefore() {
        JSONStreamState state = this.context.getState();
        switch (state) {
            case PropertyKey: {
                this.parser.accept(17);
                break;
            }
            case PropertyValue: {
                this.parser.accept(16, 18);
                break;
            }
            case ArrayValue: {
                this.parser.accept(16);
                break;
            }
            case BeginObject: {
                break;
            }
            case BeginArray: {
                break;
            }
            default: {
                throw new JSONException("illegal state : " + (Object)((Object)state));
            }
        }
    }

    private void readAfter() {
        JSONStreamState state = this.context.getState();
        JSONStreamState newStat = null;
        switch (state) {
            case BeginObject: {
                newStat = JSONStreamState.PropertyKey;
                break;
            }
            case PropertyKey: {
                newStat = JSONStreamState.PropertyValue;
                break;
            }
            case PropertyValue: {
                newStat = JSONStreamState.PropertyKey;
                break;
            }
            case ArrayValue: {
                break;
            }
            case BeginArray: {
                newStat = JSONStreamState.ArrayValue;
                break;
            }
            default: {
                throw new JSONException("illegal state : " + (Object)((Object)state));
            }
        }
        if (newStat != null) {
            this.context.setState(newStat);
        }
    }
}

