/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson.parser.deserializer;

import com.alibaba.fastjson.JSONException;
import com.alibaba.fastjson.parser.DefaultJSONParser;
import com.alibaba.fastjson.parser.JSONScanner;
import com.alibaba.fastjson.parser.deserializer.AbstractDateDeserializer;
import com.alibaba.fastjson.parser.deserializer.ObjectDeserializer;
import java.lang.reflect.Type;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.Date;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SqlDateDeserializer
extends AbstractDateDeserializer
implements ObjectDeserializer {
    public static final SqlDateDeserializer instance = new SqlDateDeserializer();

    @Override
    protected <T> T cast(DefaultJSONParser parser, Type clazz, Object fieldName, Object val) {
        if (val == null) {
            return null;
        }
        if (val instanceof Date) {
            val = new java.sql.Date(((Date)val).getTime());
        } else if (val instanceof Number) {
            val = new java.sql.Date(((Number)val).longValue());
        } else {
            if (val instanceof String) {
                long longVal;
                String strVal = (String)val;
                if (strVal.length() == 0) {
                    return null;
                }
                JSONScanner dateLexer = new JSONScanner(strVal);
                if (dateLexer.scanISO8601DateIfMatch()) {
                    longVal = dateLexer.getCalendar().getTimeInMillis();
                } else {
                    DateFormat dateFormat = parser.getDateFormat();
                    try {
                        Date date = dateFormat.parse(strVal);
                        return (T)new java.sql.Date(date.getTime());
                    }
                    catch (ParseException parseException) {
                        longVal = Long.parseLong(strVal);
                    }
                }
                return (T)new java.sql.Date(longVal);
            }
            throw new JSONException("parse error : " + val);
        }
        return (T)val;
    }

    @Override
    public int getFastMatchToken() {
        return 2;
    }
}

