/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson.parser.deserializer;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONException;
import com.alibaba.fastjson.parser.DefaultJSONParser;
import com.alibaba.fastjson.parser.Feature;
import com.alibaba.fastjson.parser.JSONLexer;
import com.alibaba.fastjson.parser.JSONScanner;
import com.alibaba.fastjson.parser.JSONToken;
import com.alibaba.fastjson.parser.ParseContext;
import com.alibaba.fastjson.parser.deserializer.CollectionDeserializer;
import com.alibaba.fastjson.parser.deserializer.FieldDeserializer;
import com.alibaba.fastjson.parser.deserializer.IntegerDeserializer;
import com.alibaba.fastjson.parser.deserializer.LongDeserializer;
import com.alibaba.fastjson.parser.deserializer.ObjectDeserializer;
import com.alibaba.fastjson.parser.deserializer.StringDeserializer;
import com.alibaba.fastjson.util.ASMClassLoader;
import com.alibaba.fastjson.util.TypeUtils;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultObjectDeserializer
implements ObjectDeserializer {
    public static final DefaultObjectDeserializer instance = new DefaultObjectDeserializer();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object parseMap(DefaultJSONParser parser, Map<Object, Object> map, Type keyType, Type valueType, Object fieldName) {
        JSONScanner lexer = (JSONScanner)parser.getLexer();
        if (lexer.token() != 12 && lexer.token() != 16) {
            throw new JSONException("syntax error, expect {, actual " + lexer.tokenName());
        }
        ObjectDeserializer keyDeserializer = parser.getConfig().getDeserializer(keyType);
        ObjectDeserializer valueDeserializer = parser.getConfig().getDeserializer(valueType);
        lexer.nextToken(keyDeserializer.getFastMatchToken());
        ParseContext context = parser.getContext();
        try {
            while (true) {
                Object object;
                if (lexer.token() == 13) {
                    lexer.nextToken(16);
                    break;
                }
                if (lexer.token() == 4 && lexer.isRef()) {
                    Object ref;
                    object = null;
                    lexer.nextTokenWithColon(4);
                    if (lexer.token() == 4) {
                        ref = lexer.stringVal();
                        if ("@".equals(ref)) {
                            object = context.getObject();
                        } else if ("..".equals(ref)) {
                            ParseContext parentContext = context.getParentContext();
                            if (parentContext.getObject() != null) {
                                object = parentContext.getObject();
                            } else {
                                parser.addResolveTask(new DefaultJSONParser.ResolveTask(parentContext, (String)ref));
                                parser.setResolveStatus(1);
                            }
                        } else if ("$".equals(ref)) {
                            ParseContext rootContext = context;
                            while (rootContext.getParentContext() != null) {
                                rootContext = rootContext.getParentContext();
                            }
                            if (rootContext.getObject() != null) {
                                object = rootContext.getObject();
                            } else {
                                parser.addResolveTask(new DefaultJSONParser.ResolveTask(rootContext, (String)ref));
                                parser.setResolveStatus(1);
                            }
                        } else {
                            parser.addResolveTask(new DefaultJSONParser.ResolveTask(context, (String)ref));
                            parser.setResolveStatus(1);
                        }
                    } else {
                        throw new JSONException("illegal ref, " + JSONToken.name(lexer.token()));
                    }
                    lexer.nextToken(13);
                    if (lexer.token() != 13) {
                        throw new JSONException("illegal ref");
                    }
                    lexer.nextToken(16);
                    ref = object;
                    return ref;
                }
                if (map.size() == 0 && lexer.token() == 4 && JSON.DEFAULT_TYPE_KEY.equals(lexer.stringVal())) {
                    lexer.nextTokenWithColon(4);
                    lexer.nextToken(16);
                    if (lexer.token() == 13) {
                        lexer.nextToken();
                        object = map;
                        return object;
                    }
                    lexer.nextToken(keyDeserializer.getFastMatchToken());
                }
                Object key = keyDeserializer.deserialze(parser, keyType, null);
                if (lexer.token() != 17) {
                    throw new JSONException("syntax error, expect :, actual " + lexer.token());
                }
                lexer.nextToken(valueDeserializer.getFastMatchToken());
                Object value = valueDeserializer.deserialze(parser, valueType, key);
                if (map.size() == 0 && context != null && context.getObject() != map) {
                    parser.setContext(context, map, fieldName);
                }
                map.put(key, value);
                if (lexer.token() != 16) continue;
                lexer.nextToken(keyDeserializer.getFastMatchToken());
            }
        }
        finally {
            parser.setContext(context);
        }
        return map;
    }

    public Map parseMap(DefaultJSONParser parser, Map<String, Object> map, Type valueType, Object fieldName) {
        JSONScanner lexer = (JSONScanner)parser.getLexer();
        if (lexer.token() != 12) {
            throw new JSONException("syntax error, expect {, actual " + lexer.token());
        }
        ParseContext context = parser.getContext();
        try {
            while (true) {
                Object value;
                String key;
                lexer.skipWhitespace();
                char ch = lexer.getCurrent();
                if (parser.isEnabled(Feature.AllowArbitraryCommas)) {
                    while (ch == ',') {
                        lexer.incrementBufferPosition();
                        lexer.skipWhitespace();
                        ch = lexer.getCurrent();
                    }
                }
                if (ch == '\"') {
                    key = lexer.scanSymbol(parser.getSymbolTable(), '\"');
                    lexer.skipWhitespace();
                    ch = lexer.getCurrent();
                    if (ch != ':') {
                        throw new JSONException("expect ':' at " + lexer.pos());
                    }
                } else {
                    if (ch == '}') {
                        lexer.incrementBufferPosition();
                        lexer.resetStringPosition();
                        lexer.nextToken(16);
                        Map<String, Object> map2 = map;
                        return map2;
                    }
                    if (ch == '\'') {
                        if (!parser.isEnabled(Feature.AllowSingleQuotes)) {
                            throw new JSONException("syntax error");
                        }
                        key = lexer.scanSymbol(parser.getSymbolTable(), '\'');
                        lexer.skipWhitespace();
                        ch = lexer.getCurrent();
                        if (ch != ':') {
                            throw new JSONException("expect ':' at " + lexer.pos());
                        }
                    } else {
                        if (!parser.isEnabled(Feature.AllowUnQuotedFieldNames)) {
                            throw new JSONException("syntax error");
                        }
                        key = lexer.scanSymbolUnQuoted(parser.getSymbolTable());
                        lexer.skipWhitespace();
                        ch = lexer.getCurrent();
                        if (ch != ':') {
                            throw new JSONException("expect ':' at " + lexer.pos() + ", actual " + ch);
                        }
                    }
                }
                lexer.incrementBufferPosition();
                lexer.skipWhitespace();
                ch = lexer.getCurrent();
                lexer.resetStringPosition();
                if (key == JSON.DEFAULT_TYPE_KEY) {
                    String typeName = lexer.scanSymbol(parser.getSymbolTable(), '\"');
                    Class<?> clazz = TypeUtils.loadClass(typeName);
                    if (clazz == map.getClass()) {
                        lexer.nextToken(16);
                        if (lexer.token() != 13) continue;
                        lexer.nextToken(16);
                        Map<String, Object> map3 = map;
                        return map3;
                    }
                    ObjectDeserializer deserializer = parser.getConfig().getDeserializer(clazz);
                    lexer.nextToken(16);
                    parser.setResolveStatus(2);
                    if (context != null && !(fieldName instanceof Integer)) {
                        parser.popContext();
                    }
                    Map map4 = (Map)deserializer.deserialze(parser, clazz, fieldName);
                    return map4;
                }
                lexer.nextToken();
                if (lexer.token() == 8) {
                    value = null;
                    lexer.nextToken();
                } else {
                    value = parser.parseObject(valueType);
                }
                map.put(key, value);
                parser.checkMapResolve(map, key);
                parser.setContext(context, value, key);
                if (lexer.token() != 13) continue;
                lexer.nextToken();
                Map<String, Object> map5 = map;
                return map5;
            }
        }
        finally {
            parser.setContext(context);
        }
    }

    public void parseObject(DefaultJSONParser parser, Object object) {
        JSONScanner lexer;
        block17: {
            Class<?> clazz = object.getClass();
            Map<String, FieldDeserializer> setters = parser.getConfig().getFieldDeserializers(clazz);
            lexer = (JSONScanner)parser.getLexer();
            if (lexer.token() == 13) {
                lexer.nextToken(16);
                return;
            }
            if (lexer.token() != 12 && lexer.token() != 16) {
                throw new JSONException("syntax error, expect {, actual " + lexer.tokenName());
            }
            Object[] args = new Object[1];
            while (true) {
                FieldDeserializer fieldDeser;
                String key;
                if ((key = lexer.scanSymbol(parser.getSymbolTable())) == null) {
                    if (lexer.token() != 13) {
                        if (lexer.token() == 16 && parser.isEnabled(Feature.AllowArbitraryCommas)) continue;
                    }
                    break block17;
                }
                if ((fieldDeser = setters.get(key)) == null) {
                    if (!parser.isEnabled(Feature.IgnoreNotMatch)) {
                        throw new JSONException("setter not found, class " + clazz.getName() + ", property " + key);
                    }
                    lexer.nextTokenWithColon();
                    parser.parse();
                    if (lexer.token() != 13) continue;
                    lexer.nextToken();
                    return;
                }
                Method method = fieldDeser.getMethod();
                Class<?> fieldClass = method.getParameterTypes()[0];
                Type fieldType = method.getGenericParameterTypes()[0];
                if (fieldClass == Integer.TYPE) {
                    lexer.nextTokenWithColon(2);
                    args[0] = IntegerDeserializer.deserialze(parser);
                } else if (fieldClass == String.class) {
                    lexer.nextTokenWithColon(4);
                    args[0] = StringDeserializer.deserialze(parser);
                } else if (fieldClass == Long.TYPE) {
                    lexer.nextTokenWithColon(2);
                    args[0] = LongDeserializer.deserialze(parser);
                } else if (fieldClass == List.class) {
                    lexer.nextTokenWithColon(12);
                    args[0] = CollectionDeserializer.instance.deserialze(parser, fieldType, null);
                } else {
                    ObjectDeserializer fieldValueDeserializer = parser.getConfig().getDeserializer(fieldClass, fieldType);
                    lexer.nextTokenWithColon(fieldValueDeserializer.getFastMatchToken());
                    args[0] = fieldValueDeserializer.deserialze(parser, fieldType, null);
                }
                try {
                    method.invoke(object, args);
                }
                catch (Exception e) {
                    throw new JSONException("set proprety error, " + method.getName(), e);
                }
                if (lexer.token() != 16 && lexer.token() == 13) break;
            }
            lexer.nextToken(16);
            return;
        }
        lexer.nextToken(16);
    }

    @Override
    public <T> T deserialze(DefaultJSONParser parser, Type type, Object fieldName) {
        if (type instanceof Class) {
            return this.deserialze(parser, (Class)type);
        }
        if (type instanceof ParameterizedType) {
            return this.deserialze(parser, (ParameterizedType)type, fieldName);
        }
        if (type instanceof TypeVariable) {
            return (T)parser.parse(fieldName);
        }
        if (type instanceof WildcardType) {
            return (T)parser.parse(fieldName);
        }
        if (type instanceof GenericArrayType) {
            Type componentType = ((GenericArrayType)type).getGenericComponentType();
            ArrayList list = new ArrayList();
            parser.parseArray(componentType, list);
            if (componentType instanceof Class) {
                Class componentClass = (Class)componentType;
                Object[] array = (Object[])Array.newInstance(componentClass, list.size());
                list.toArray(array);
                return (T)array;
            }
        }
        throw new JSONException("not support type : " + type);
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public <T> T deserialze(DefaultJSONParser parser, ParameterizedType type, Object fieldName) {
        try {
            void var7_14;
            Class rawClass;
            JSONLexer lexer = parser.getLexer();
            if (lexer.token() == 8) {
                lexer.nextToken();
                return null;
            }
            Type rawType = type.getRawType();
            if (!(rawType instanceof Class) || !Map.class.isAssignableFrom(rawClass = (Class)rawType)) throw new JSONException("not support type : " + type);
            if (Modifier.isAbstract(rawClass.getModifiers())) {
                if (rawClass == Map.class) {
                    HashMap hashMap = new HashMap();
                } else if (rawClass == SortedMap.class) {
                    TreeMap treeMap = new TreeMap();
                } else {
                    if (rawClass != ConcurrentMap.class) throw new JSONException("can not create instance : " + rawClass);
                    ConcurrentHashMap concurrentHashMap = new ConcurrentHashMap();
                }
            } else if (rawClass == HashMap.class) {
                HashMap hashMap = new HashMap();
            } else {
                Map map = (Map)rawClass.newInstance();
            }
            Type keyType = type.getActualTypeArguments()[0];
            Type valueType = type.getActualTypeArguments()[1];
            if (keyType != String.class) return (T)this.parseMap(parser, (Map<Object, Object>)var7_14, keyType, valueType, fieldName);
            return (T)this.parseMap(parser, (Map<String, Object>)var7_14, valueType, fieldName);
        }
        catch (JSONException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new JSONException(e.getMessage(), e);
        }
    }

    public <T> T deserialze(DefaultJSONParser parser, Class<T> clazz) {
        Map value = null;
        if (parser.getLexer().token() == 8) {
            parser.getLexer().nextToken(16);
            return null;
        }
        if (clazz.isAssignableFrom(HashMap.class)) {
            value = new HashMap();
        } else if (clazz.isAssignableFrom(TreeMap.class)) {
            value = new TreeMap();
        } else if (clazz.isAssignableFrom(ConcurrentHashMap.class)) {
            value = new ConcurrentHashMap();
        } else if (clazz.isAssignableFrom(Properties.class)) {
            value = new Properties();
        } else if (clazz.isAssignableFrom(IdentityHashMap.class)) {
            value = new IdentityHashMap();
        }
        if (clazz == Class.class) {
            Object classValue = parser.parse();
            if (classValue == null) {
                return null;
            }
            if (classValue instanceof String) {
                return (T)ASMClassLoader.forName((String)classValue);
            }
        } else if (clazz == Serializable.class) {
            return (T)parser.parse();
        }
        if (value == null) {
            throw new JSONException("not support type : " + clazz);
        }
        try {
            this.parseObject(parser, value);
            return (T)value;
        }
        catch (JSONException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new JSONException(e.getMessage(), e);
        }
    }

    @Override
    public int getFastMatchToken() {
        return 12;
    }
}

