/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson.serializer;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONAware;
import com.alibaba.fastjson.JSONException;
import com.alibaba.fastjson.JSONStreamAware;
import com.alibaba.fastjson.serializer.AppendableSerializer;
import com.alibaba.fastjson.serializer.ArraySerializer;
import com.alibaba.fastjson.serializer.AutowiredObjectSerializer;
import com.alibaba.fastjson.serializer.CalendarSerializer;
import com.alibaba.fastjson.serializer.CharsetSerializer;
import com.alibaba.fastjson.serializer.ClobSeriliazer;
import com.alibaba.fastjson.serializer.CollectionSerializer;
import com.alibaba.fastjson.serializer.DateSerializer;
import com.alibaba.fastjson.serializer.EnumSerializer;
import com.alibaba.fastjson.serializer.EnumerationSeriliazer;
import com.alibaba.fastjson.serializer.ExceptionSerializer;
import com.alibaba.fastjson.serializer.JSONAwareSerializer;
import com.alibaba.fastjson.serializer.JSONSerializerMap;
import com.alibaba.fastjson.serializer.JSONStreamAwareSerializer;
import com.alibaba.fastjson.serializer.ListSerializer;
import com.alibaba.fastjson.serializer.MapSerializer;
import com.alibaba.fastjson.serializer.NameFilter;
import com.alibaba.fastjson.serializer.ObjectSerializer;
import com.alibaba.fastjson.serializer.PropertyFilter;
import com.alibaba.fastjson.serializer.PropertyPreFilter;
import com.alibaba.fastjson.serializer.SerialContext;
import com.alibaba.fastjson.serializer.SerializeConfig;
import com.alibaba.fastjson.serializer.SerializeWriter;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.alibaba.fastjson.serializer.StringSerializer;
import com.alibaba.fastjson.serializer.TimeZoneSerializer;
import com.alibaba.fastjson.serializer.ValueFilter;
import com.alibaba.fastjson.util.ServiceLoader;
import java.io.IOException;
import java.io.Writer;
import java.lang.reflect.Proxy;
import java.lang.reflect.Type;
import java.nio.charset.Charset;
import java.sql.Clob;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.Enumeration;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JSONSerializer {
    private final SerializeConfig config;
    private final SerializeWriter out;
    private List<PropertyFilter> propertyFilters = null;
    private List<ValueFilter> valueFilters = null;
    private List<NameFilter> nameFilters = null;
    private List<PropertyPreFilter> propertyPreFilters = null;
    private int indentCount = 0;
    private String indent = "\t";
    private String dateFormatPatterm = JSON.DEFFAULT_DATE_FORMAT;
    private DateFormat dateFormat;
    private IdentityHashMap<Object, SerialContext> references = null;
    private SerialContext context;

    public JSONSerializer() {
        this(new SerializeWriter(), SerializeConfig.getGlobalInstance());
    }

    public JSONSerializer(SerializeWriter out) {
        this(out, SerializeConfig.getGlobalInstance());
    }

    public JSONSerializer(SerializeConfig config) {
        this(new SerializeWriter(), config);
    }

    @Deprecated
    public JSONSerializer(JSONSerializerMap mapping) {
        this(new SerializeWriter(), mapping);
    }

    public JSONSerializer(SerializeWriter out, SerializeConfig config) {
        this.out = out;
        this.config = config;
    }

    public String getDateFormatPattern() {
        return this.dateFormatPatterm;
    }

    public DateFormat getDateFormat() {
        if (this.dateFormat == null) {
            this.dateFormat = new SimpleDateFormat(this.dateFormatPatterm);
        }
        return this.dateFormat;
    }

    public void setDateFormat(DateFormat dateFormat) {
        this.dateFormat = dateFormat;
    }

    public void setDateFormat(String dateFormat) {
        this.dateFormatPatterm = dateFormat;
        if (this.dateFormat != null) {
            this.dateFormat = null;
        }
    }

    public SerialContext getContext() {
        return this.context;
    }

    public void setContext(SerialContext context) {
        this.context = context;
    }

    public void setContext(SerialContext parent, Object object, Object fieldName) {
        if (this.isEnabled(SerializerFeature.DisableCircularReferenceDetect)) {
            return;
        }
        this.context = new SerialContext(parent, object, fieldName);
        if (this.references == null) {
            this.references = new IdentityHashMap();
        }
        this.references.put(object, this.context);
    }

    public void setContext(Object object, Object fieldName) {
        this.setContext(this.context, object, fieldName);
    }

    public void popContext() {
        if (this.context != null) {
            this.context = this.context.getParent();
        }
    }

    public void setContext(SerialContext parent, Object object) {
        if (this.isEnabled(SerializerFeature.DisableCircularReferenceDetect)) {
            return;
        }
        this.context = new SerialContext(parent, object, null);
        if (this.references == null) {
            this.references = new IdentityHashMap();
        }
        this.references.put(object, this.context);
    }

    public boolean isWriteClassName() {
        return this.isEnabled(SerializerFeature.WriteClassName);
    }

    public final boolean isWriteClassName(Type fieldType, Object obj) {
        boolean result = this.out.isEnabled(SerializerFeature.WriteClassName);
        if (!result) {
            return false;
        }
        if (fieldType == null && this.isEnabled(SerializerFeature.NotWriteRootClassName)) {
            boolean isRoot;
            boolean bl = isRoot = this.context.getParent() == null;
            if (isRoot) {
                return false;
            }
        }
        return true;
    }

    public Collection<SerialContext> getReferences() {
        if (this.references == null) {
            this.references = new IdentityHashMap();
        }
        return this.references.values();
    }

    public SerialContext getSerialContext(Object object) {
        if (this.references == null) {
            return null;
        }
        return this.references.get(object);
    }

    public boolean containsReference(Object value) {
        if (this.isEnabled(SerializerFeature.DisableCircularReferenceDetect)) {
            return false;
        }
        if (this.references == null) {
            return false;
        }
        return this.references.containsKey(value);
    }

    public void writeReference(Object object) {
        if (this.isEnabled(SerializerFeature.DisableCircularReferenceDetect)) {
            return;
        }
        SerialContext context = this.getContext();
        Object current = context.getObject();
        if (object == current) {
            this.out.write("{\"$ref\":\"@\"}");
            return;
        }
        SerialContext parentContext = context.getParent();
        if (parentContext != null && object == parentContext.getObject()) {
            this.out.write("{\"$ref\":\"..\"}");
            return;
        }
        SerialContext rootContext = context;
        while (rootContext.getParent() != null) {
            rootContext = rootContext.getParent();
        }
        if (object == rootContext.getObject()) {
            this.out.write("{\"$ref\":\"$\"}");
            return;
        }
        SerialContext refContext = this.getSerialContext(object);
        String path = refContext.getPath();
        this.out.write("{\"$ref\":\"");
        this.out.write(path);
        this.out.write("\"}");
    }

    public List<ValueFilter> getValueFilters() {
        if (this.valueFilters == null) {
            this.valueFilters = new ArrayList<ValueFilter>();
        }
        return this.valueFilters;
    }

    public List<ValueFilter> getValueFiltersDirect() {
        return this.valueFilters;
    }

    public int getIndentCount() {
        return this.indentCount;
    }

    public void incrementIndent() {
        ++this.indentCount;
    }

    public void decrementIdent() {
        --this.indentCount;
    }

    public void println() {
        this.out.write('\n');
        for (int i = 0; i < this.indentCount; ++i) {
            this.out.write(this.indent);
        }
    }

    public List<NameFilter> getNameFilters() {
        if (this.nameFilters == null) {
            this.nameFilters = new ArrayList<NameFilter>();
        }
        return this.nameFilters;
    }

    public List<NameFilter> getNameFiltersDirect() {
        return this.nameFilters;
    }

    public List<PropertyPreFilter> getPropertyPreFilters() {
        if (this.propertyPreFilters == null) {
            this.propertyPreFilters = new ArrayList<PropertyPreFilter>();
        }
        return this.propertyPreFilters;
    }

    public List<PropertyPreFilter> getPropertyPreFiltersDirect() {
        return this.propertyPreFilters;
    }

    public List<PropertyFilter> getPropertyFilters() {
        if (this.propertyFilters == null) {
            this.propertyFilters = new ArrayList<PropertyFilter>();
        }
        return this.propertyFilters;
    }

    public List<PropertyFilter> getPropertyFiltersDirect() {
        return this.propertyFilters;
    }

    public SerializeWriter getWriter() {
        return this.out;
    }

    public String toString() {
        return this.out.toString();
    }

    public void config(SerializerFeature feature, boolean state) {
        this.out.config(feature, state);
    }

    public boolean isEnabled(SerializerFeature feature) {
        return this.out.isEnabled(feature);
    }

    public void writeNull() {
        this.out.writeNull();
    }

    public SerializeConfig getMapping() {
        return this.config;
    }

    public static final void write(Writer out, Object object) {
        SerializeWriter writer = new SerializeWriter();
        try {
            JSONSerializer serializer = new JSONSerializer(writer);
            serializer.write(object);
            writer.writeTo(out);
        }
        catch (IOException ex) {
            throw new JSONException(ex.getMessage(), ex);
        }
        finally {
            writer.close();
        }
    }

    public static final void write(SerializeWriter out, Object object) {
        JSONSerializer serializer = new JSONSerializer(out);
        serializer.write(object);
    }

    public final void write(Object object) {
        if (object == null) {
            this.out.writeNull();
            return;
        }
        Class<?> clazz = object.getClass();
        ObjectSerializer writer = this.getObjectWriter(clazz);
        try {
            writer.write(this, object, null, null);
        }
        catch (IOException e) {
            throw new JSONException(e.getMessage(), e);
        }
    }

    public final void writeWithFieldName(Object object, Object fieldName) {
        this.writeWithFieldName(object, fieldName, null);
    }

    public final void writeWithFieldName(Object object, Object fieldName, Type fieldType) {
        try {
            if (object == null) {
                this.out.writeNull();
                return;
            }
            Class<?> clazz = object.getClass();
            ObjectSerializer writer = this.getObjectWriter(clazz);
            writer.write(this, object, fieldName, fieldType);
        }
        catch (IOException e) {
            throw new JSONException(e.getMessage(), e);
        }
    }

    public final void writeWithFormat(Object object, String format) {
        if (object instanceof Date) {
            String text = new SimpleDateFormat(format).format((Date)object);
            this.out.writeString(text);
            return;
        }
        this.write(object);
    }

    public final void write(String text) {
        StringSerializer.instance.write(this, text);
    }

    public ObjectSerializer getObjectWriter(Class<?> clazz) {
        AutowiredObjectSerializer autowired;
        ClassLoader classLoader;
        ObjectSerializer writer = (ObjectSerializer)this.config.get(clazz);
        if (writer == null) {
            try {
                classLoader = Thread.currentThread().getContextClassLoader();
                for (AutowiredObjectSerializer o : ServiceLoader.load(AutowiredObjectSerializer.class, classLoader)) {
                    if (!(o instanceof AutowiredObjectSerializer)) continue;
                    autowired = o;
                    for (Type forType : autowired.getAutowiredFor()) {
                        this.config.put(forType, autowired);
                    }
                }
            }
            catch (ClassCastException ex) {
                // empty catch block
            }
            writer = (ObjectSerializer)this.config.get(clazz);
        }
        if (writer == null && (classLoader = JSON.class.getClassLoader()) != Thread.currentThread().getContextClassLoader()) {
            try {
                for (AutowiredObjectSerializer o : ServiceLoader.load(AutowiredObjectSerializer.class, classLoader)) {
                    if (!(o instanceof AutowiredObjectSerializer)) continue;
                    autowired = o;
                    for (Type forType : autowired.getAutowiredFor()) {
                        this.config.put(forType, autowired);
                    }
                }
            }
            catch (ClassCastException ex) {
                // empty catch block
            }
            writer = (ObjectSerializer)this.config.get(clazz);
        }
        if (writer == null) {
            if (Map.class.isAssignableFrom(clazz)) {
                this.config.put(clazz, MapSerializer.instance);
            } else if (List.class.isAssignableFrom(clazz)) {
                this.config.put(clazz, ListSerializer.instance);
            } else if (Collection.class.isAssignableFrom(clazz)) {
                this.config.put(clazz, CollectionSerializer.instance);
            } else if (Date.class.isAssignableFrom(clazz)) {
                this.config.put(clazz, DateSerializer.instance);
            } else if (JSONAware.class.isAssignableFrom(clazz)) {
                this.config.put(clazz, JSONAwareSerializer.instance);
            } else if (JSONStreamAware.class.isAssignableFrom(clazz)) {
                this.config.put(clazz, JSONStreamAwareSerializer.instance);
            } else if (clazz.isEnum() || clazz.getSuperclass() != null && clazz.getSuperclass().isEnum()) {
                this.config.put(clazz, EnumSerializer.instance);
            } else if (clazz.isArray()) {
                Class<?> componentType = clazz.getComponentType();
                ObjectSerializer compObjectSerializer = this.getObjectWriter(componentType);
                this.config.put(clazz, new ArraySerializer(compObjectSerializer));
            } else if (Throwable.class.isAssignableFrom(clazz)) {
                this.config.put(clazz, new ExceptionSerializer(clazz));
            } else if (TimeZone.class.isAssignableFrom(clazz)) {
                this.config.put(clazz, TimeZoneSerializer.instance);
            } else if (Appendable.class.isAssignableFrom(clazz)) {
                this.config.put(clazz, AppendableSerializer.instance);
            } else if (Charset.class.isAssignableFrom(clazz)) {
                this.config.put(clazz, CharsetSerializer.instance);
            } else if (Enumeration.class.isAssignableFrom(clazz)) {
                this.config.put(clazz, EnumerationSeriliazer.instance);
            } else if (Calendar.class.isAssignableFrom(clazz)) {
                this.config.put(clazz, CalendarSerializer.instance);
            } else if (Clob.class.isAssignableFrom(clazz)) {
                this.config.put(clazz, ClobSeriliazer.instance);
            } else {
                boolean isCglibProxy = false;
                boolean isJavassistProxy = false;
                for (Class<?> item : clazz.getInterfaces()) {
                    if (item.getName().equals("net.sf.cglib.proxy.Factory")) {
                        isCglibProxy = true;
                        break;
                    }
                    if (!item.getName().equals("javassist.util.proxy.ProxyObject")) continue;
                    isJavassistProxy = true;
                    break;
                }
                if (isCglibProxy || isJavassistProxy) {
                    Class<?> superClazz = clazz.getSuperclass();
                    ObjectSerializer superWriter = this.getObjectWriter(superClazz);
                    this.config.put(clazz, superWriter);
                    return superWriter;
                }
                if (Proxy.isProxyClass(clazz)) {
                    this.config.put(clazz, this.config.createJavaBeanSerializer(clazz));
                } else {
                    this.config.put(clazz, this.config.createJavaBeanSerializer(clazz));
                }
            }
            writer = (ObjectSerializer)this.config.get(clazz);
        }
        return writer;
    }

    public void close() {
        this.out.close();
    }
}

