/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.excel.read.listener;

import com.alibaba.excel.context.AnalysisContext;
import com.alibaba.excel.read.listener.ReadListener;
import com.alibaba.excel.util.ListUtils;
import java.util.List;
import java.util.function.Consumer;

public class PageReadListener<T>
implements ReadListener<T> {
    public static final int BATCH_COUNT = 3000;
    private List<T> cachedData = ListUtils.newArrayListWithExpectedSize(3000);
    private final Consumer<List<T>> consumer;

    public PageReadListener(Consumer<List<T>> consumer) {
        this.consumer = consumer;
    }

    @Override
    public void invoke(T data, AnalysisContext context) {
        this.cachedData.add(data);
        if (this.cachedData.size() >= 3000) {
            this.consumer.accept(this.cachedData);
            this.cachedData = ListUtils.newArrayListWithExpectedSize(3000);
        }
    }

    @Override
    public void doAfterAllAnalysed(AnalysisContext context) {
        this.consumer.accept(this.cachedData);
    }
}

