/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.dubbo.rpc.cluster.router.script;

import com.alibaba.dubbo.common.URL;
import com.alibaba.dubbo.common.logger.Logger;
import com.alibaba.dubbo.common.logger.LoggerFactory;
import com.alibaba.dubbo.common.utils.StringUtils;
import com.alibaba.dubbo.rpc.Invocation;
import com.alibaba.dubbo.rpc.Invoker;
import com.alibaba.dubbo.rpc.RpcContext;
import com.alibaba.dubbo.rpc.RpcException;
import com.alibaba.dubbo.rpc.cluster.router.AbstractRouter;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.CodeSource;
import java.security.Permissions;
import java.security.PrivilegedAction;
import java.security.ProtectionDomain;
import java.security.cert.Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.script.Bindings;
import javax.script.Compilable;
import javax.script.CompiledScript;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;

public class ScriptRouter
extends AbstractRouter {
    private static final Logger logger = LoggerFactory.getLogger(ScriptRouter.class);
    private static final int DEFAULT_PRIORITY = 1;
    private static final Map<String, ScriptEngine> engines = new ConcurrentHashMap<String, ScriptEngine>();
    private final ScriptEngine engine;
    private final String rule;
    private CompiledScript function;
    private AccessControlContext accessControlContext;

    public ScriptRouter(URL url) {
        Permissions perms = new Permissions();
        perms.add(new RuntimePermission("accessDeclaredMembers"));
        ProtectionDomain domain = new ProtectionDomain(new CodeSource(null, (Certificate[])null), perms);
        this.accessControlContext = new AccessControlContext(new ProtectionDomain[]{domain});
        this.url = url;
        this.priority = url.getParameter("priority", 1);
        this.engine = this.getEngine(url);
        this.rule = this.getRule(url);
        try {
            Compilable compilable = (Compilable)((Object)this.engine);
            this.function = compilable.compile(this.rule);
        }
        catch (ScriptException e) {
            logger.error("route error, rule has been ignored. rule: " + this.rule + ", url: " + RpcContext.getContext().getUrl(), e);
        }
    }

    private String getRule(URL url) {
        String vRule = url.getParameterAndDecoded("rule");
        if (StringUtils.isEmpty(vRule)) {
            throw new IllegalStateException("route rule can not be empty.");
        }
        return vRule;
    }

    private ScriptEngine getEngine(URL url) {
        String type = url.getParameter("type", "javascript");
        ScriptEngine engine = engines.get(type);
        if (engine == null) {
            engine = new ScriptEngineManager().getEngineByName(type);
            if (engine == null) {
                throw new IllegalStateException(new IllegalStateException("Unsupported route rule type: " + type + ", rule: " + this.rule));
            }
            engines.put(type, engine);
        }
        return engine;
    }

    @Override
    public <T> List<Invoker<T>> route(final List<Invoker<T>> invokers, URL url, final Invocation invocation) throws RpcException {
        if (this.engine == null || this.function == null) {
            return invokers;
        }
        final Bindings bindings = this.createBindings(invokers, invocation);
        return this.getRoutedInvokers(AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                try {
                    return ScriptRouter.this.function.eval(bindings);
                }
                catch (ScriptException e) {
                    logger.error("route error, rule has been ignored. rule: " + ScriptRouter.this.rule + ", method:" + invocation.getMethodName() + ", url: " + RpcContext.getContext().getUrl(), e);
                    return invokers;
                }
            }
        }, this.accessControlContext));
    }

    protected <T> List<Invoker<T>> getRoutedInvokers(Object obj) {
        if (obj instanceof Invoker[]) {
            return Arrays.asList((Invoker[])obj);
        }
        if (obj instanceof Object[]) {
            Object[] objects = (Object[])obj;
            ArrayList<Invoker<T>> invokers = new ArrayList<Invoker<T>>();
            for (Object object : objects) {
                invokers.add((Invoker)object);
            }
            return invokers;
        }
        return (List)obj;
    }

    private <T> Bindings createBindings(List<Invoker<T>> invokers, Invocation invocation) {
        Bindings bindings = this.engine.createBindings();
        bindings.put("invokers", (Object)new ArrayList<Invoker<T>>(invokers));
        bindings.put("invocation", (Object)invocation);
        bindings.put("context", (Object)RpcContext.getContext());
        return bindings;
    }
}

