/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.dubbo.config.spring.beans.factory.annotation;

import com.alibaba.dubbo.common.utils.CollectionUtils;
import com.alibaba.dubbo.config.ConsumerConfig;
import com.alibaba.dubbo.config.MethodConfig;
import com.alibaba.dubbo.config.annotation.Method;
import com.alibaba.dubbo.config.annotation.Reference;
import com.alibaba.dubbo.config.spring.ReferenceBean;
import com.alibaba.dubbo.config.spring.beans.factory.annotation.AbstractAnnotationConfigBeanBuilder;
import com.alibaba.dubbo.config.spring.beans.factory.annotation.AnnotationPropertyValuesAdapter;
import com.alibaba.dubbo.config.spring.util.BeanFactoryUtils;
import com.alibaba.dubbo.config.spring.util.ObjectUtils;
import java.beans.PropertyEditor;
import java.beans.PropertyEditorSupport;
import java.lang.annotation.Annotation;
import java.util.List;
import java.util.Map;
import org.springframework.beans.PropertyValues;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.beans.propertyeditors.StringTrimmerEditor;
import org.springframework.context.ApplicationContext;
import org.springframework.core.env.PropertyResolver;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.StringUtils;
import org.springframework.validation.DataBinder;

class ReferenceBeanBuilder
extends AbstractAnnotationConfigBeanBuilder<Reference, ReferenceBean> {
    static final String[] IGNORE_FIELD_NAMES = ObjectUtils.of("application", "module", "consumer", "monitor", "registry");

    private ReferenceBeanBuilder(Reference annotation, ClassLoader classLoader, ApplicationContext applicationContext) {
        super(annotation, classLoader, applicationContext);
    }

    private void configureInterface(Reference reference, ReferenceBean referenceBean) {
        Class interfaceClass = reference.interfaceClass();
        if (Void.TYPE.equals(interfaceClass)) {
            interfaceClass = null;
            String interfaceClassName = reference.interfaceName();
            if (StringUtils.hasText((String)interfaceClassName) && ClassUtils.isPresent((String)interfaceClassName, (ClassLoader)this.classLoader)) {
                interfaceClass = ClassUtils.resolveClassName((String)interfaceClassName, (ClassLoader)this.classLoader);
            }
        }
        if (interfaceClass == null) {
            interfaceClass = this.interfaceClass;
        }
        Assert.isTrue((boolean)interfaceClass.isInterface(), (String)"The class of field or method that was annotated @Reference is not an interface!");
        referenceBean.setInterface(interfaceClass);
    }

    private void configureConsumerConfig(Reference reference, ReferenceBean<?> referenceBean) {
        String consumerBeanName = reference.consumer();
        ConsumerConfig consumerConfig = BeanFactoryUtils.getOptionalBean((ListableBeanFactory)this.applicationContext, consumerBeanName, ConsumerConfig.class);
        referenceBean.setConsumer(consumerConfig);
    }

    void configureMethodConfig(Reference reference, ReferenceBean<?> referenceBean) {
        Method[] methods = reference.methods();
        List<MethodConfig> methodConfigs = MethodConfig.constructMethodConfig(methods);
        if (!methodConfigs.isEmpty()) {
            referenceBean.setMethods(methodConfigs);
        }
    }

    @Override
    protected ReferenceBean doBuild() {
        return new ReferenceBean();
    }

    @Override
    protected void preConfigureBean(Reference reference, ReferenceBean referenceBean) {
        Assert.notNull((Object)this.interfaceClass, (String)"The interface class must set first!");
        DataBinder dataBinder = new DataBinder((Object)referenceBean);
        dataBinder.registerCustomEditor(String.class, "filter", (PropertyEditor)new StringTrimmerEditor(true));
        dataBinder.registerCustomEditor(String.class, "listener", (PropertyEditor)new StringTrimmerEditor(true));
        dataBinder.registerCustomEditor(Map.class, "parameters", (PropertyEditor)new PropertyEditorSupport(){

            @Override
            public void setAsText(String text) throws IllegalArgumentException {
                String content = StringUtils.trimAllWhitespace((String)text);
                if (!StringUtils.hasText((String)content)) {
                    return;
                }
                content = StringUtils.replace((String)content, (String)"=", (String)",");
                content = StringUtils.replace((String)content, (String)":", (String)",");
                Map<String, String> parameters = CollectionUtils.toStringMap(StringUtils.commaDelimitedListToStringArray((String)content));
                this.setValue(parameters);
            }
        });
        dataBinder.bind((PropertyValues)new AnnotationPropertyValuesAdapter((Annotation)reference, (PropertyResolver)this.applicationContext.getEnvironment(), IGNORE_FIELD_NAMES));
    }

    @Override
    protected String resolveModuleConfigBeanName(Reference annotation) {
        return annotation.module();
    }

    @Override
    protected String resolveApplicationConfigBeanName(Reference annotation) {
        return annotation.application();
    }

    @Override
    protected String[] resolveRegistryConfigBeanNames(Reference annotation) {
        return annotation.registry();
    }

    @Override
    protected String resolveMonitorConfigBeanName(Reference annotation) {
        return annotation.monitor();
    }

    @Override
    protected void postConfigureBean(Reference annotation, ReferenceBean bean) throws Exception {
        bean.setApplicationContext(this.applicationContext);
        this.configureInterface(annotation, bean);
        this.configureConsumerConfig(annotation, bean);
        this.configureMethodConfig(annotation, bean);
        bean.afterPropertiesSet();
    }

    public static ReferenceBeanBuilder create(Reference annotation, ClassLoader classLoader, ApplicationContext applicationContext) {
        return new ReferenceBeanBuilder(annotation, classLoader, applicationContext);
    }
}

