/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.druid.pool.ha.node;

import com.alibaba.druid.DruidRuntimeException;
import com.alibaba.druid.pool.ha.node.NodeEvent;
import com.alibaba.druid.support.logging.Log;
import com.alibaba.druid.support.logging.LogFactory;
import java.util.Date;
import java.util.List;
import java.util.Observable;
import java.util.Observer;
import java.util.Properties;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public abstract class NodeListener
extends Observable {
    private static final Log LOG = LogFactory.getLog(NodeListener.class);
    private String prefix = "";
    private Properties properties = new Properties();
    private Date lastUpdateTime = null;
    private Observer observer = null;
    private Lock lock = new ReentrantLock();

    public abstract List<NodeEvent> refresh();

    public abstract void destroy();

    public void init() {
        if (this.observer == null) {
            throw new DruidRuntimeException("No Observer(such as PoolUpdater) specified.");
        }
        this.addObserver(this.observer);
    }

    public void update() {
        this.update(this.refresh());
    }

    public void update(List<NodeEvent> events) {
        if (events != null && !events.isEmpty()) {
            this.lastUpdateTime = new Date();
            NodeEvent[] arr = new NodeEvent[events.size()];
            for (int i = 0; i < events.size(); ++i) {
                arr[i] = events.get(i);
            }
            this.setChanged();
            this.notifyObservers(arr);
        }
    }

    public Observer getObserver() {
        return this.observer;
    }

    public void setObserver(Observer observer) {
        this.observer = observer;
    }

    public Date getLastUpdateTime() {
        return this.lastUpdateTime;
    }

    public void setLastUpdateTime(Date lastUpdateTime) {
        this.lastUpdateTime = lastUpdateTime;
    }

    public Properties getProperties() {
        return this.properties;
    }

    public void setProperties(Properties properties) {
        this.properties = properties;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }
}

