/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.druid.sql.ast.statement;

import com.alibaba.druid.DbType;
import com.alibaba.druid.FastsqlException;
import com.alibaba.druid.sql.SQLUtils;
import com.alibaba.druid.sql.ast.SQLDataType;
import com.alibaba.druid.sql.ast.SQLExpr;
import com.alibaba.druid.sql.ast.SQLObject;
import com.alibaba.druid.sql.ast.SQLObjectImpl;
import com.alibaba.druid.sql.ast.SQLReplaceable;
import com.alibaba.druid.sql.ast.expr.SQLAllColumnExpr;
import com.alibaba.druid.sql.ast.expr.SQLIdentifierExpr;
import com.alibaba.druid.sql.ast.expr.SQLIntegerExpr;
import com.alibaba.druid.sql.ast.expr.SQLPropertyExpr;
import com.alibaba.druid.sql.ast.statement.SQLSubqueryTableSource;
import com.alibaba.druid.sql.ast.statement.SQLTableSource;
import com.alibaba.druid.sql.dialect.oracle.ast.OracleSQLObject;
import com.alibaba.druid.sql.visitor.SQLASTVisitor;
import com.alibaba.druid.util.FnvHash;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class SQLSelectItem
extends SQLObjectImpl
implements SQLReplaceable {
    protected SQLExpr expr;
    protected String alias;
    protected boolean connectByRoot = false;
    protected transient long aliasHashCode64;
    protected List<String> aliasList;

    public SQLSelectItem() {
    }

    public SQLSelectItem(SQLExpr expr) {
        this(expr, null);
    }

    public SQLSelectItem(int value) {
        this(new SQLIntegerExpr(value), null);
    }

    public SQLSelectItem(SQLExpr expr, String alias) {
        this.expr = expr;
        this.alias = alias;
        if (expr != null) {
            expr.setParent(this);
        }
    }

    public SQLSelectItem(SQLExpr expr, String alias, boolean connectByRoot) {
        this.connectByRoot = connectByRoot;
        this.expr = expr;
        this.alias = alias;
        if (expr != null) {
            expr.setParent(this);
        }
    }

    public SQLSelectItem(SQLExpr expr, List<String> aliasList, boolean connectByRoot) {
        this.connectByRoot = connectByRoot;
        this.expr = expr;
        this.aliasList = aliasList;
        if (expr != null) {
            expr.setParent(this);
        }
    }

    public SQLExpr getExpr() {
        return this.expr;
    }

    public void setExpr(SQLExpr expr) {
        if (expr != null) {
            expr.setParent(this);
        }
        this.expr = expr;
    }

    public String computeAlias() {
        String alias = this.getAlias();
        if (alias == null) {
            if (this.expr instanceof SQLIdentifierExpr) {
                alias = ((SQLIdentifierExpr)this.expr).getName();
            } else if (this.expr instanceof SQLPropertyExpr) {
                alias = ((SQLPropertyExpr)this.expr).getName();
            }
        }
        return SQLUtils.normalize(alias);
    }

    @Override
    public SQLDataType computeDataType() {
        if (this.expr == null) {
            return null;
        }
        return this.expr.computeDataType();
    }

    public String getAlias() {
        return this.alias;
    }

    public String getAlias2() {
        if (this.alias == null || this.alias.length() == 0) {
            return this.alias;
        }
        char first = this.alias.charAt(0);
        if (first == '\"' || first == '\'') {
            char[] chars = new char[this.alias.length() - 2];
            int len = 0;
            for (int i = 1; i < this.alias.length() - 1; ++i) {
                char ch = this.alias.charAt(i);
                if (ch == '\\') {
                    ch = this.alias.charAt(++i);
                }
                chars[len++] = ch;
            }
            return new String(chars, 0, len);
        }
        return this.alias;
    }

    public void setAlias(String alias) {
        this.alias = alias;
    }

    @Override
    public void output(Appendable buf) {
        try {
            if (this.connectByRoot) {
                buf.append(" CONNECT_BY_ROOT ");
            }
            this.expr.output(buf);
            if (this.alias != null && this.alias.length() != 0) {
                buf.append(" AS ");
                buf.append(this.alias);
            }
        }
        catch (IOException ex) {
            throw new FastsqlException("output error", ex);
        }
    }

    @Override
    protected void accept0(SQLASTVisitor v) {
        if (v.visit(this) && this.expr != null) {
            this.expr.accept(v);
        }
        v.endVisit(this);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SQLSelectItem that = (SQLSelectItem)o;
        if (this.connectByRoot != that.connectByRoot) {
            return false;
        }
        if (this.alias_hash() != that.alias_hash()) {
            return false;
        }
        if (this.expr != null ? !this.expr.equals(that.expr) : that.expr != null) {
            return false;
        }
        return this.aliasList != null ? this.aliasList.equals(that.aliasList) : that.aliasList == null;
    }

    public int hashCode() {
        int result = this.expr != null ? this.expr.hashCode() : 0;
        result = 31 * result + (this.alias != null ? this.alias.hashCode() : 0);
        result = 31 * result + (this.connectByRoot ? 1 : 0);
        result = 31 * result + (int)(this.alias_hash() ^ this.alias_hash() >>> 32);
        result = 31 * result + (this.aliasList != null ? this.aliasList.hashCode() : 0);
        return result;
    }

    public boolean isConnectByRoot() {
        return this.connectByRoot;
    }

    public void setConnectByRoot(boolean connectByRoot) {
        this.connectByRoot = connectByRoot;
    }

    @Override
    public SQLSelectItem clone() {
        SQLSelectItem x = new SQLSelectItem();
        x.alias = this.alias;
        if (this.expr != null) {
            x.setExpr(this.expr.clone());
        }
        x.connectByRoot = this.connectByRoot;
        if (this.aliasList != null) {
            x.aliasList = new ArrayList<String>(this.aliasList);
        }
        return x;
    }

    @Override
    public boolean replace(SQLExpr expr, SQLExpr target) {
        if (this.expr == expr) {
            this.setExpr(target);
            return true;
        }
        return false;
    }

    public boolean match(String alias) {
        if (alias == null) {
            return false;
        }
        long hash = FnvHash.hashCode64(alias);
        return this.match(hash);
    }

    public long alias_hash() {
        if (this.aliasHashCode64 == 0L) {
            this.aliasHashCode64 = FnvHash.hashCode64(this.alias);
        }
        return this.aliasHashCode64;
    }

    public boolean match(long alias_hash) {
        long hash = this.alias_hash();
        if (hash == alias_hash) {
            return true;
        }
        if (this.expr instanceof SQLAllColumnExpr) {
            SQLTableSource resolvedTableSource = ((SQLAllColumnExpr)this.expr).getResolvedTableSource();
            return resolvedTableSource != null && resolvedTableSource.findColumn(alias_hash) != null;
        }
        if (this.expr instanceof SQLIdentifierExpr) {
            return ((SQLIdentifierExpr)this.expr).nameHashCode64() == alias_hash;
        }
        if (this.expr instanceof SQLPropertyExpr) {
            String ident = ((SQLPropertyExpr)this.expr).getName();
            if ("*".equals(ident)) {
                SQLTableSource resolvedTableSource = ((SQLPropertyExpr)this.expr).getResolvedTableSource();
                if (resolvedTableSource == null) {
                    return false;
                }
                boolean isParentTableSource = false;
                if (resolvedTableSource instanceof SQLSubqueryTableSource) {
                    for (SQLObject parent = this.getParent(); parent != null; parent = parent.getParent()) {
                        if (parent != resolvedTableSource) continue;
                        isParentTableSource = true;
                        break;
                    }
                }
                return !isParentTableSource && resolvedTableSource.findColumn(alias_hash) != null;
            }
            return this.alias == null && ((SQLPropertyExpr)this.expr).nameHashCode64() == alias_hash;
        }
        return false;
    }

    public List<String> getAliasList() {
        return this.aliasList;
    }

    @Override
    public String toString() {
        DbType dbType = null;
        if (this.parent instanceof OracleSQLObject) {
            dbType = DbType.oracle;
        }
        return SQLUtils.toSQLString((SQLObject)this, dbType);
    }

    public boolean isUDTFSelectItem() {
        return this.aliasList != null && this.aliasList.size() > 0;
    }
}

