/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.druid.filter.encoding;

import com.alibaba.druid.filter.FilterAdapter;
import com.alibaba.druid.filter.FilterChain;
import com.alibaba.druid.filter.encoding.CharsetConvert;
import com.alibaba.druid.filter.encoding.CharsetParameter;
import com.alibaba.druid.proxy.jdbc.CallableStatementProxy;
import com.alibaba.druid.proxy.jdbc.ClobProxy;
import com.alibaba.druid.proxy.jdbc.ConnectionProxy;
import com.alibaba.druid.proxy.jdbc.PreparedStatementProxy;
import com.alibaba.druid.proxy.jdbc.ResultSetProxy;
import com.alibaba.druid.proxy.jdbc.StatementProxy;
import com.alibaba.druid.util.Utils;
import java.io.Reader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.Map;
import java.util.Properties;

public class EncodingConvertFilter
extends FilterAdapter {
    public static final String ATTR_CHARSET_PARAMETER = "ali.charset.param";
    public static final String ATTR_CHARSET_CONVERTER = "ali.charset.converter";
    private String clientEncoding;
    private String serverEncoding;

    @Override
    public ConnectionProxy connection_connect(FilterChain chain, Properties info) throws SQLException {
        ConnectionProxy conn = chain.connection_connect(info);
        CharsetParameter param = new CharsetParameter();
        param.setClientEncoding(info.getProperty("clientEncoding"));
        param.setServerEncoding(info.getProperty("serverEncoding"));
        if (param.getClientEncoding() == null || "".equalsIgnoreCase(param.getClientEncoding())) {
            param.setClientEncoding(this.clientEncoding);
        }
        if (param.getServerEncoding() == null || "".equalsIgnoreCase(param.getServerEncoding())) {
            param.setServerEncoding(this.serverEncoding);
        }
        conn.putAttribute(ATTR_CHARSET_PARAMETER, param);
        conn.putAttribute(ATTR_CHARSET_CONVERTER, new CharsetConvert(param.getClientEncoding(), param.getServerEncoding()));
        return conn;
    }

    @Override
    public String resultSet_getString(FilterChain chain, ResultSetProxy result, int columnIndex) throws SQLException {
        String value = super.resultSet_getString(chain, result, columnIndex);
        return this.decode(result.getStatementProxy().getConnectionProxy(), value);
    }

    @Override
    public String resultSet_getString(FilterChain chain, ResultSetProxy result, String columnLabel) throws SQLException {
        String value = super.resultSet_getString(chain, result, columnLabel);
        return this.decode(result.getStatementProxy().getConnectionProxy(), value);
    }

    @Override
    public Object resultSet_getObject(FilterChain chain, ResultSetProxy result, int columnIndex) throws SQLException {
        ResultSet rawResultSet = result.getResultSetRaw();
        ResultSetMetaData metadata = rawResultSet.getMetaData();
        int columnType = metadata.getColumnType(columnIndex);
        Object value = null;
        switch (columnType) {
            case -1: 
            case 1: 
            case 12: 
            case 2005: {
                value = super.resultSet_getString(chain, result, columnIndex);
                break;
            }
            default: {
                value = super.resultSet_getObject(chain, result, columnIndex);
            }
        }
        return this.decodeObject(result.getStatementProxy().getConnectionProxy(), value);
    }

    @Override
    public <T> T resultSet_getObject(FilterChain chain, ResultSetProxy result, int columnIndex, Class<T> type) throws SQLException {
        ResultSet rawResultSet = result.getResultSetRaw();
        ResultSetMetaData metadata = rawResultSet.getMetaData();
        int columnType = metadata.getColumnType(columnIndex);
        String value = null;
        switch (columnType) {
            case -1: 
            case 1: 
            case 12: 
            case 2005: {
                value = super.resultSet_getString(chain, result, columnIndex);
                break;
            }
            default: {
                value = super.resultSet_getObject(chain, result, columnIndex, type);
            }
        }
        return (T)this.decodeObject(result.getStatementProxy().getConnectionProxy(), (Object)value);
    }

    @Override
    public Object resultSet_getObject(FilterChain chain, ResultSetProxy result, int columnIndex, Map<String, Class<?>> map) throws SQLException {
        ResultSet rawResultSet = result.getResultSetRaw();
        ResultSetMetaData metadata = rawResultSet.getMetaData();
        int columnType = metadata.getColumnType(columnIndex);
        Object value = null;
        switch (columnType) {
            case -1: 
            case 1: 
            case 12: 
            case 2005: {
                value = super.resultSet_getString(chain, result, columnIndex);
                break;
            }
            default: {
                value = super.resultSet_getObject(chain, result, columnIndex, map);
            }
        }
        return this.decodeObject(result.getStatementProxy().getConnectionProxy(), value);
    }

    @Override
    public Object resultSet_getObject(FilterChain chain, ResultSetProxy result, String columnLabel) throws SQLException {
        ResultSet rawResultSet = result.getResultSetRaw();
        ResultSetMetaData metadata = rawResultSet.getMetaData();
        int columnIndex = rawResultSet.findColumn(columnLabel);
        int columnType = metadata.getColumnType(columnIndex);
        Object value = null;
        switch (columnType) {
            case -1: 
            case 1: 
            case 12: 
            case 2005: {
                value = super.resultSet_getString(chain, result, columnLabel);
                break;
            }
            default: {
                value = super.resultSet_getObject(chain, result, columnLabel);
            }
        }
        return this.decodeObject(result.getStatementProxy().getConnectionProxy(), value);
    }

    @Override
    public <T> T resultSet_getObject(FilterChain chain, ResultSetProxy result, String columnLabel, Class<T> type) throws SQLException {
        ResultSet rawResultSet = result.getResultSetRaw();
        ResultSetMetaData metadata = rawResultSet.getMetaData();
        int columnIndex = rawResultSet.findColumn(columnLabel);
        int columnType = metadata.getColumnType(columnIndex);
        String value = null;
        switch (columnType) {
            case -1: 
            case 1: 
            case 12: 
            case 2005: {
                value = super.resultSet_getString(chain, result, columnLabel);
                break;
            }
            default: {
                value = super.resultSet_getObject(chain, result, columnLabel, type);
            }
        }
        return (T)this.decodeObject(result.getStatementProxy().getConnectionProxy(), (Object)value);
    }

    @Override
    public Object resultSet_getObject(FilterChain chain, ResultSetProxy result, String columnLabel, Map<String, Class<?>> map) throws SQLException {
        ResultSet rawResultSet = result.getResultSetRaw();
        ResultSetMetaData metadata = rawResultSet.getMetaData();
        int columnIndex = rawResultSet.findColumn(columnLabel);
        int columnType = metadata.getColumnType(columnIndex);
        Object value = null;
        switch (columnType) {
            case 1: {
                value = super.resultSet_getString(chain, result, columnLabel);
                break;
            }
            case 2005: {
                value = super.resultSet_getString(chain, result, columnLabel);
                break;
            }
            case -1: {
                value = super.resultSet_getString(chain, result, columnLabel);
                break;
            }
            case 12: {
                value = super.resultSet_getString(chain, result, columnLabel);
                break;
            }
            default: {
                value = super.resultSet_getObject(chain, result, columnLabel, map);
            }
        }
        return this.decodeObject(result.getStatementProxy().getConnectionProxy(), value);
    }

    public Object decodeObject(ConnectionProxy connection, Object object) throws SQLException {
        if (object instanceof String) {
            return this.decode(connection, (String)object);
        }
        if (object instanceof Reader) {
            Reader reader = (Reader)object;
            String text = Utils.read(reader);
            return new StringReader(this.decode(connection, text));
        }
        return object;
    }

    public Object decodeObject(CallableStatementProxy stmt, Object object) throws SQLException {
        if (object instanceof String) {
            return this.decode(stmt.getConnectionProxy(), (String)object);
        }
        if (object instanceof Reader) {
            Reader reader = (Reader)object;
            String text = Utils.read(reader);
            return new StringReader(this.decode(stmt.getConnectionProxy(), text));
        }
        return object;
    }

    public String encode(ConnectionProxy connection, String s) throws SQLException {
        try {
            CharsetConvert charsetConvert = (CharsetConvert)connection.getAttribute(ATTR_CHARSET_CONVERTER);
            return charsetConvert.encode(s);
        }
        catch (UnsupportedEncodingException e) {
            throw new SQLException(e.getMessage(), e);
        }
    }

    public String decode(ConnectionProxy connection, String s) throws SQLException {
        try {
            CharsetConvert charsetConvert = (CharsetConvert)connection.getAttribute(ATTR_CHARSET_CONVERTER);
            return charsetConvert.decode(s);
        }
        catch (UnsupportedEncodingException e) {
            throw new SQLException(e.getMessage(), e);
        }
    }

    @Override
    public PreparedStatementProxy connection_prepareStatement(FilterChain chain, ConnectionProxy connection, String sql) throws SQLException {
        return super.connection_prepareStatement(chain, connection, this.encode(connection, sql));
    }

    @Override
    public PreparedStatementProxy connection_prepareStatement(FilterChain chain, ConnectionProxy connection, String sql, int autoGeneratedKeys) throws SQLException {
        return super.connection_prepareStatement(chain, connection, this.encode(connection, sql), autoGeneratedKeys);
    }

    @Override
    public PreparedStatementProxy connection_prepareStatement(FilterChain chain, ConnectionProxy connection, String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        return super.connection_prepareStatement(chain, connection, this.encode(connection, sql), resultSetType, resultSetConcurrency);
    }

    @Override
    public PreparedStatementProxy connection_prepareStatement(FilterChain chain, ConnectionProxy connection, String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        return super.connection_prepareStatement(chain, connection, this.encode(connection, sql), resultSetType, resultSetConcurrency, resultSetHoldability);
    }

    @Override
    public PreparedStatementProxy connection_prepareStatement(FilterChain chain, ConnectionProxy connection, String sql, int[] columnIndexes) throws SQLException {
        return super.connection_prepareStatement(chain, connection, this.encode(connection, sql), columnIndexes);
    }

    @Override
    public PreparedStatementProxy connection_prepareStatement(FilterChain chain, ConnectionProxy connection, String sql, String[] columnNames) throws SQLException {
        return super.connection_prepareStatement(chain, connection, this.encode(connection, sql), columnNames);
    }

    @Override
    public CallableStatementProxy connection_prepareCall(FilterChain chain, ConnectionProxy connection, String sql) throws SQLException {
        return super.connection_prepareCall(chain, connection, this.encode(connection, sql));
    }

    @Override
    public CallableStatementProxy connection_prepareCall(FilterChain chain, ConnectionProxy connection, String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        return super.connection_prepareCall(chain, connection, this.encode(connection, sql), resultSetType, resultSetConcurrency);
    }

    @Override
    public CallableStatementProxy connection_prepareCall(FilterChain chain, ConnectionProxy connection, String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        return super.connection_prepareCall(chain, connection, this.encode(connection, sql), resultSetType, resultSetConcurrency, resultSetHoldability);
    }

    @Override
    public String connection_nativeSQL(FilterChain chain, ConnectionProxy connection, String sql) throws SQLException {
        String encodedSql = this.encode(connection, sql);
        return super.connection_nativeSQL(chain, connection, encodedSql);
    }

    @Override
    public void statement_addBatch(FilterChain chain, StatementProxy statement, String sql) throws SQLException {
        super.statement_addBatch(chain, statement, this.encode(statement.getConnectionProxy(), sql));
    }

    @Override
    public boolean statement_execute(FilterChain chain, StatementProxy statement, String sql) throws SQLException {
        return super.statement_execute(chain, statement, this.encode(statement.getConnectionProxy(), sql));
    }

    @Override
    public boolean statement_execute(FilterChain chain, StatementProxy statement, String sql, int autoGeneratedKeys) throws SQLException {
        return super.statement_execute(chain, statement, this.encode(statement.getConnectionProxy(), sql), autoGeneratedKeys);
    }

    @Override
    public boolean statement_execute(FilterChain chain, StatementProxy statement, String sql, int[] columnIndexes) throws SQLException {
        return super.statement_execute(chain, statement, this.encode(statement.getConnectionProxy(), sql), columnIndexes);
    }

    @Override
    public boolean statement_execute(FilterChain chain, StatementProxy statement, String sql, String[] columnNames) throws SQLException {
        return super.statement_execute(chain, statement, this.encode(statement.getConnectionProxy(), sql), columnNames);
    }

    @Override
    public ResultSetProxy statement_executeQuery(FilterChain chain, StatementProxy statement, String sql) throws SQLException {
        return super.statement_executeQuery(chain, statement, this.encode(statement.getConnectionProxy(), sql));
    }

    @Override
    public int statement_executeUpdate(FilterChain chain, StatementProxy statement, String sql) throws SQLException {
        return super.statement_executeUpdate(chain, statement, this.encode(statement.getConnectionProxy(), sql));
    }

    @Override
    public int statement_executeUpdate(FilterChain chain, StatementProxy statement, String sql, int autoGeneratedKeys) throws SQLException {
        return super.statement_executeUpdate(chain, statement, this.encode(statement.getConnectionProxy(), sql), autoGeneratedKeys);
    }

    @Override
    public int statement_executeUpdate(FilterChain chain, StatementProxy statement, String sql, int[] columnIndexes) throws SQLException {
        return super.statement_executeUpdate(chain, statement, this.encode(statement.getConnectionProxy(), sql), columnIndexes);
    }

    @Override
    public int statement_executeUpdate(FilterChain chain, StatementProxy statement, String sql, String[] columnNames) throws SQLException {
        return super.statement_executeUpdate(chain, statement, this.encode(statement.getConnectionProxy(), sql), columnNames);
    }

    @Override
    public void preparedStatement_setString(FilterChain chain, PreparedStatementProxy statement, int parameterIndex, String x) throws SQLException {
        super.preparedStatement_setString(chain, statement, parameterIndex, this.encode(statement.getConnectionProxy(), x));
    }

    @Override
    public void preparedStatement_setCharacterStream(FilterChain chain, PreparedStatementProxy statement, int parameterIndex, Reader reader) throws SQLException {
        String text = Utils.read(reader);
        String encodedText = this.encode(statement.getConnectionProxy(), text);
        super.preparedStatement_setCharacterStream(chain, statement, parameterIndex, new StringReader(encodedText));
    }

    @Override
    public void preparedStatement_setCharacterStream(FilterChain chain, PreparedStatementProxy statement, int parameterIndex, Reader reader, int length) throws SQLException {
        String text = Utils.read(reader, length);
        String encodedText = this.encode(statement.getConnectionProxy(), text);
        super.preparedStatement_setCharacterStream(chain, statement, parameterIndex, (Reader)new StringReader(encodedText), encodedText.length());
    }

    @Override
    public void preparedStatement_setCharacterStream(FilterChain chain, PreparedStatementProxy statement, int parameterIndex, Reader reader, long length) throws SQLException {
        String text = Utils.read(reader, (int)length);
        String encodedText = this.encode(statement.getConnectionProxy(), text);
        super.preparedStatement_setCharacterStream(chain, statement, parameterIndex, (Reader)new StringReader(encodedText), encodedText.length());
    }

    @Override
    public void preparedStatement_setObject(FilterChain chain, PreparedStatementProxy statement, int parameterIndex, Object x) throws SQLException {
        if (x instanceof String) {
            String encodedText = this.encode(statement.getConnectionProxy(), (String)x);
            super.preparedStatement_setObject(chain, statement, parameterIndex, encodedText);
        } else if (x instanceof Reader) {
            String text = Utils.read((Reader)x);
            String encodedText = this.encode(statement.getConnectionProxy(), text);
            super.preparedStatement_setObject(chain, statement, parameterIndex, new StringReader(encodedText));
        } else {
            super.preparedStatement_setObject(chain, statement, parameterIndex, x);
        }
    }

    @Override
    public void preparedStatement_setObject(FilterChain chain, PreparedStatementProxy statement, int parameterIndex, Object x, int targetSqlType) throws SQLException {
        if (x instanceof String) {
            String encodedText = this.encode(statement.getConnectionProxy(), (String)x);
            super.preparedStatement_setObject(chain, statement, parameterIndex, encodedText, targetSqlType);
        } else if (x instanceof Reader) {
            String text = Utils.read((Reader)x);
            String encodedText = this.encode(statement.getConnectionProxy(), text);
            super.preparedStatement_setObject(chain, statement, parameterIndex, new StringReader(encodedText), targetSqlType);
        } else {
            super.preparedStatement_setObject(chain, statement, parameterIndex, x, targetSqlType);
        }
    }

    @Override
    public void preparedStatement_setObject(FilterChain chain, PreparedStatementProxy statement, int parameterIndex, Object x, int targetSqlType, int scaleOrLength) throws SQLException {
        if (x instanceof String) {
            String encodedText = this.encode(statement.getConnectionProxy(), (String)x);
            super.preparedStatement_setObject(chain, statement, parameterIndex, encodedText, targetSqlType, scaleOrLength);
        } else if (x instanceof Reader) {
            String text = Utils.read((Reader)x);
            String encodedText = this.encode(statement.getConnectionProxy(), text);
            super.preparedStatement_setObject(chain, statement, parameterIndex, new StringReader(encodedText), targetSqlType, scaleOrLength);
        } else {
            super.preparedStatement_setObject(chain, statement, parameterIndex, x, targetSqlType, scaleOrLength);
        }
    }

    @Override
    public long clob_position(FilterChain chain, ClobProxy wrapper, String searchstr, long start) throws SQLException {
        return chain.clob_position(wrapper, this.encode(wrapper.getConnectionWrapper(), searchstr), start);
    }

    @Override
    public String clob_getSubString(FilterChain chain, ClobProxy wrapper, long pos, int length) throws SQLException {
        String text = super.clob_getSubString(chain, wrapper, pos, length);
        return this.decode(wrapper.getConnectionWrapper(), text);
    }

    @Override
    public Reader clob_getCharacterStream(FilterChain chain, ClobProxy wrapper) throws SQLException {
        Reader reader = super.clob_getCharacterStream(chain, wrapper);
        String text = Utils.read(reader);
        return new StringReader(this.decode(wrapper.getConnectionWrapper(), text));
    }

    @Override
    public Reader clob_getCharacterStream(FilterChain chain, ClobProxy wrapper, long pos, long length) throws SQLException {
        Reader reader = super.clob_getCharacterStream(chain, wrapper, pos, length);
        String text = Utils.read(reader);
        return new StringReader(this.decode(wrapper.getConnectionWrapper(), text));
    }

    @Override
    public int clob_setString(FilterChain chain, ClobProxy wrapper, long pos, String str) throws SQLException {
        return chain.clob_setString(wrapper, pos, this.encode(wrapper.getConnectionWrapper(), str));
    }

    @Override
    public int clob_setString(FilterChain chain, ClobProxy wrapper, long pos, String str, int offset, int len) throws SQLException {
        return chain.clob_setString(wrapper, pos, this.encode(wrapper.getConnectionWrapper(), str), offset, len);
    }

    @Override
    public void callableStatement_setCharacterStream(FilterChain chain, CallableStatementProxy statement, String parameterName, Reader reader) throws SQLException {
        String text = Utils.read(reader);
        StringReader encodeReader = new StringReader(this.encode(statement.getConnectionProxy(), text));
        super.callableStatement_setCharacterStream(chain, statement, parameterName, encodeReader);
    }

    @Override
    public void callableStatement_setCharacterStream(FilterChain chain, CallableStatementProxy statement, String parameterName, Reader reader, int length) throws SQLException {
        String text = Utils.read(reader, length);
        String encodeText = this.encode(statement.getConnectionProxy(), text);
        StringReader encodeReader = new StringReader(encodeText);
        super.callableStatement_setCharacterStream(chain, statement, parameterName, (Reader)encodeReader, encodeText.length());
    }

    @Override
    public void callableStatement_setCharacterStream(FilterChain chain, CallableStatementProxy statement, String parameterName, Reader reader, long length) throws SQLException {
        String text = Utils.read(reader, (int)length);
        String encodeText = this.encode(statement.getConnectionProxy(), text);
        StringReader encodeReader = new StringReader(encodeText);
        super.callableStatement_setCharacterStream(chain, statement, parameterName, (Reader)encodeReader, (long)encodeText.length());
    }

    @Override
    public void callableStatement_setString(FilterChain chain, CallableStatementProxy statement, String parameterName, String x) throws SQLException {
        super.callableStatement_setString(chain, statement, parameterName, this.encode(statement.getConnectionProxy(), x));
    }

    @Override
    public void callableStatement_setObject(FilterChain chain, CallableStatementProxy statement, String parameterName, Object x) throws SQLException {
        if (x instanceof String) {
            String encodedText = this.encode(statement.getConnectionProxy(), (String)x);
            super.callableStatement_setObject(chain, statement, parameterName, encodedText);
        } else if (x instanceof Reader) {
            String text = Utils.read((Reader)x);
            String encodedText = this.encode(statement.getConnectionProxy(), text);
            super.callableStatement_setObject(chain, statement, parameterName, new StringReader(encodedText));
        } else {
            super.callableStatement_setObject(chain, statement, parameterName, x);
        }
    }

    @Override
    public void callableStatement_setObject(FilterChain chain, CallableStatementProxy statement, String parameterName, Object x, int targetSqlType) throws SQLException {
        if (x instanceof String) {
            String encodedText = this.encode(statement.getConnectionProxy(), (String)x);
            super.callableStatement_setObject(chain, statement, parameterName, encodedText, targetSqlType);
        } else if (x instanceof Reader) {
            String text = Utils.read((Reader)x);
            String encodedText = this.encode(statement.getConnectionProxy(), text);
            super.callableStatement_setObject(chain, statement, parameterName, new StringReader(encodedText), targetSqlType);
        } else {
            super.callableStatement_setObject(chain, statement, parameterName, x, targetSqlType);
        }
    }

    @Override
    public void callableStatement_setObject(FilterChain chain, CallableStatementProxy statement, String parameterName, Object x, int targetSqlType, int scale) throws SQLException {
        if (x instanceof String) {
            String encodedText = this.encode(statement.getConnectionProxy(), (String)x);
            super.callableStatement_setObject(chain, statement, parameterName, encodedText, targetSqlType, scale);
        } else if (x instanceof Reader) {
            String text = Utils.read((Reader)x);
            String encodedText = this.encode(statement.getConnectionProxy(), text);
            super.callableStatement_setObject(chain, statement, parameterName, new StringReader(encodedText), targetSqlType, scale);
        } else {
            super.callableStatement_setObject(chain, statement, parameterName, x, targetSqlType, scale);
        }
    }

    @Override
    public String callableStatement_getString(FilterChain chain, CallableStatementProxy statement, int parameterIndex) throws SQLException {
        String value = super.callableStatement_getString(chain, statement, parameterIndex);
        return this.decode(statement.getConnectionProxy(), value);
    }

    @Override
    public String callableStatement_getString(FilterChain chain, CallableStatementProxy statement, String parameterName) throws SQLException {
        String value = super.callableStatement_getString(chain, statement, parameterName);
        return this.decode(statement.getConnectionProxy(), value);
    }

    @Override
    public Object callableStatement_getObject(FilterChain chain, CallableStatementProxy statement, int parameterIndex) throws SQLException {
        Object value = chain.callableStatement_getObject(statement, parameterIndex);
        return this.decodeObject(statement, value);
    }

    @Override
    public Object callableStatement_getObject(FilterChain chain, CallableStatementProxy statement, int parameterIndex, Map<String, Class<?>> map) throws SQLException {
        Object value = chain.callableStatement_getObject(statement, parameterIndex, map);
        return this.decodeObject(statement, value);
    }

    @Override
    public Object callableStatement_getObject(FilterChain chain, CallableStatementProxy statement, String parameterName) throws SQLException {
        Object value = chain.callableStatement_getObject(statement, parameterName);
        return this.decodeObject(statement, value);
    }

    @Override
    public Object callableStatement_getObject(FilterChain chain, CallableStatementProxy statement, String parameterName, Map<String, Class<?>> map) throws SQLException {
        Object value = chain.callableStatement_getObject(statement, parameterName, map);
        return this.decodeObject(statement, value);
    }
}

