/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.druid.sql.dialect.postgresql.parser;

import com.alibaba.druid.sql.ast.SQLExpr;
import com.alibaba.druid.sql.ast.SQLName;
import com.alibaba.druid.sql.ast.SQLObjectImpl;
import com.alibaba.druid.sql.ast.SQLStatement;
import com.alibaba.druid.sql.ast.expr.SQLCharExpr;
import com.alibaba.druid.sql.ast.expr.SQLCurrentOfCursorExpr;
import com.alibaba.druid.sql.ast.expr.SQLIdentifierExpr;
import com.alibaba.druid.sql.ast.expr.SQLQueryExpr;
import com.alibaba.druid.sql.ast.statement.SQLAlterTableAlterColumn;
import com.alibaba.druid.sql.ast.statement.SQLColumnDefinition;
import com.alibaba.druid.sql.ast.statement.SQLCommitStatement;
import com.alibaba.druid.sql.ast.statement.SQLInsertStatement;
import com.alibaba.druid.sql.ast.statement.SQLSelect;
import com.alibaba.druid.sql.ast.statement.SQLTableSource;
import com.alibaba.druid.sql.ast.statement.SQLUpdateStatement;
import com.alibaba.druid.sql.dialect.postgresql.ast.PGWithClause;
import com.alibaba.druid.sql.dialect.postgresql.ast.PGWithQuery;
import com.alibaba.druid.sql.dialect.postgresql.ast.stmt.PGDeleteStatement;
import com.alibaba.druid.sql.dialect.postgresql.ast.stmt.PGInsertStatement;
import com.alibaba.druid.sql.dialect.postgresql.ast.stmt.PGSelectStatement;
import com.alibaba.druid.sql.dialect.postgresql.ast.stmt.PGSetStatement;
import com.alibaba.druid.sql.dialect.postgresql.ast.stmt.PGShowStatement;
import com.alibaba.druid.sql.dialect.postgresql.ast.stmt.PGStartTransactionStatement;
import com.alibaba.druid.sql.dialect.postgresql.ast.stmt.PGUpdateStatement;
import com.alibaba.druid.sql.dialect.postgresql.parser.PGExprParser;
import com.alibaba.druid.sql.dialect.postgresql.parser.PGSelectParser;
import com.alibaba.druid.sql.parser.Lexer;
import com.alibaba.druid.sql.parser.ParserException;
import com.alibaba.druid.sql.parser.SQLSelectParser;
import com.alibaba.druid.sql.parser.SQLStatementParser;
import com.alibaba.druid.sql.parser.Token;
import java.util.ArrayList;
import java.util.List;

public class PGSQLStatementParser
extends SQLStatementParser {
    public static final String TIME_ZONE = "TIME ZONE";
    public static final String TIME = "TIME";
    public static final String LOCAL = "LOCAL";

    public PGSQLStatementParser(PGExprParser parser) {
        super(parser);
    }

    public PGSQLStatementParser(String sql) {
        super(new PGExprParser(sql));
    }

    public PGSQLStatementParser(Lexer lexer) {
        super(new PGExprParser(lexer));
    }

    @Override
    public PGSelectParser createSQLSelectParser() {
        return new PGSelectParser(this.exprParser);
    }

    @Override
    public SQLUpdateStatement parseUpdateStatement() {
        this.accept(Token.UPDATE);
        PGUpdateStatement udpateStatement = new PGUpdateStatement();
        SQLSelectParser selectParser = this.exprParser.createSelectParser();
        SQLTableSource tableSource = selectParser.parseTableSource();
        udpateStatement.setTableSource(tableSource);
        this.parseUpdateSet(udpateStatement);
        if (this.lexer.token() == Token.FROM) {
            this.lexer.nextToken();
            SQLTableSource from = selectParser.parseTableSource();
            udpateStatement.setFrom(from);
        }
        if (this.lexer.token() == Token.WHERE) {
            this.lexer.nextToken();
            udpateStatement.setWhere(this.exprParser.expr());
        }
        if (this.lexer.token() == Token.RETURNING) {
            this.lexer.nextToken();
            while (true) {
                udpateStatement.getReturning().add(this.exprParser.expr());
                if (this.lexer.token() != Token.COMMA) break;
                this.lexer.nextToken();
            }
        }
        return udpateStatement;
    }

    @Override
    public PGInsertStatement parseInsert() {
        PGInsertStatement stmt = new PGInsertStatement();
        if (this.lexer.token() == Token.INSERT) {
            this.lexer.nextToken();
            this.accept(Token.INTO);
            SQLName tableName = this.exprParser.name();
            stmt.setTableName(tableName);
            if (this.lexer.token() == Token.IDENTIFIER) {
                stmt.setAlias(this.lexer.stringVal());
                this.lexer.nextToken();
            }
        }
        if (this.lexer.token() == Token.DEFAULT) {
            this.lexer.nextToken();
            this.accept(Token.VALUES);
            stmt.setDefaultValues(true);
        }
        if (this.lexer.token() == Token.LPAREN) {
            this.lexer.nextToken();
            this.exprParser.exprList(stmt.getColumns(), stmt);
            this.accept(Token.RPAREN);
        }
        if (this.lexer.token() == Token.VALUES) {
            this.lexer.nextToken();
            while (true) {
                this.accept(Token.LPAREN);
                SQLInsertStatement.ValuesClause valuesCaluse = new SQLInsertStatement.ValuesClause();
                this.exprParser.exprList(valuesCaluse.getValues(), valuesCaluse);
                stmt.addValueCause(valuesCaluse);
                this.accept(Token.RPAREN);
                if (this.lexer.token() == Token.COMMA) {
                    this.lexer.nextToken();
                    continue;
                }
                break;
            }
        } else if (this.lexer.token() == Token.SELECT) {
            SQLQueryExpr queryExpr = (SQLQueryExpr)this.exprParser.expr();
            stmt.setQuery(queryExpr.getSubQuery());
        }
        if (this.lexer.token() == Token.RETURNING) {
            this.lexer.nextToken();
            SQLExpr returning = this.exprParser.expr();
            stmt.setReturning(returning);
        }
        return stmt;
    }

    @Override
    public PGDeleteStatement parseDeleteStatement() {
        this.lexer.nextToken();
        PGDeleteStatement deleteStatement = new PGDeleteStatement();
        if (this.lexer.token() == Token.FROM) {
            this.lexer.nextToken();
        }
        if (this.lexer.token() == Token.ONLY) {
            this.lexer.nextToken();
            deleteStatement.setOnly(true);
        }
        SQLName tableName = this.exprParser.name();
        deleteStatement.setTableName(tableName);
        if (this.lexer.token() == Token.AS) {
            this.accept(Token.AS);
        }
        if (this.lexer.token() == Token.IDENTIFIER) {
            deleteStatement.setAlias(this.lexer.stringVal());
            this.lexer.nextToken();
        }
        if (this.lexer.token() == Token.USING) {
            this.lexer.nextToken();
            while (true) {
                SQLName name = this.exprParser.name();
                deleteStatement.getUsing().add(name);
                if (this.lexer.token() != Token.COMMA) break;
                this.lexer.nextToken();
            }
        }
        if (this.lexer.token() == Token.WHERE) {
            this.lexer.nextToken();
            if (this.lexer.token() == Token.CURRENT) {
                this.lexer.nextToken();
                this.accept(Token.OF);
                SQLName cursorName = this.exprParser.name();
                SQLCurrentOfCursorExpr where = new SQLCurrentOfCursorExpr(cursorName);
                deleteStatement.setWhere(where);
            } else {
                SQLExpr where = this.exprParser.expr();
                deleteStatement.setWhere(where);
            }
        }
        if (this.lexer.token() == Token.RETURNING) {
            this.lexer.nextToken();
            this.accept(Token.STAR);
            deleteStatement.setReturning(true);
        }
        return deleteStatement;
    }

    @Override
    public boolean parseStatementListDialect(List<SQLStatement> statementList) {
        switch (this.lexer.token()) {
            case START: {
                this.lexer.nextToken();
                this.acceptIdentifier("TRANSACTION");
                PGStartTransactionStatement stmt = new PGStartTransactionStatement();
                statementList.add(stmt);
                this.lexer.nextToken();
                return true;
            }
            case WITH: {
                statementList.add(this.parseWith());
                return true;
            }
        }
        return false;
    }

    public PGWithClause parseWithClause() {
        this.lexer.nextToken();
        PGWithClause withClause = new PGWithClause();
        if (this.lexer.token() == Token.RECURSIVE) {
            this.lexer.nextToken();
            withClause.setRecursive(true);
        }
        while (true) {
            PGWithQuery withQuery = this.withQuery();
            withClause.getWithQuery().add(withQuery);
            if (this.lexer.token() != Token.COMMA) break;
            this.lexer.nextToken();
        }
        return withClause;
    }

    private PGWithQuery withQuery() {
        PGWithQuery withQuery = new PGWithQuery();
        if (this.lexer.token() == Token.LITERAL_ALIAS) {
            withQuery.setName(new SQLIdentifierExpr("\"" + this.lexer.stringVal() + "\""));
        } else {
            withQuery.setName(new SQLIdentifierExpr(this.lexer.stringVal()));
        }
        this.lexer.nextToken();
        if (this.lexer.token() == Token.LPAREN) {
            this.lexer.nextToken();
            while (true) {
                SQLExpr expr = this.exprParser.expr();
                withQuery.addColumn(expr);
                if (this.lexer.token() != Token.COMMA) break;
                this.lexer.nextToken();
            }
            this.accept(Token.RPAREN);
        }
        this.accept(Token.AS);
        if (this.lexer.token() == Token.LPAREN) {
            SQLObjectImpl query;
            this.lexer.nextToken();
            if (this.lexer.token() == Token.SELECT) {
                query = this.parseSelect();
            } else if (this.lexer.token() == Token.INSERT) {
                query = this.parseInsert();
            } else if (this.lexer.token() == Token.UPDATE) {
                query = this.parseUpdateStatement();
            } else if (this.lexer.token() == Token.DELETE) {
                query = this.parseDeleteStatement();
            } else if (this.lexer.token() == Token.VALUES) {
                query = this.parseSelect();
            } else {
                throw new ParserException("syntax error, support token '" + (Object)((Object)this.lexer.token()) + "', " + this.lexer.info());
            }
            withQuery.setQuery((SQLStatement)((Object)query));
            this.accept(Token.RPAREN);
        }
        return withQuery;
    }

    @Override
    public PGSelectStatement parseSelect() {
        PGSelectParser selectParser = this.createSQLSelectParser();
        SQLSelect select = selectParser.select();
        return new PGSelectStatement(select);
    }

    public SQLStatement parseWith() {
        PGWithClause with = this.parseWithClause();
        if (this.lexer.token() == Token.INSERT) {
            PGInsertStatement stmt = this.parseInsert();
            stmt.setWith(with);
            return stmt;
        }
        if (this.lexer.token() == Token.SELECT) {
            PGSelectStatement stmt = this.parseSelect();
            stmt.setWith(with);
            return stmt;
        }
        if (this.lexer.token() == Token.DELETE) {
            PGDeleteStatement stmt = this.parseDeleteStatement();
            stmt.setWith(with);
            return stmt;
        }
        if (this.lexer.token() == Token.UPDATE) {
            PGUpdateStatement stmt = (PGUpdateStatement)this.parseUpdateStatement();
            stmt.setWith(with);
            return stmt;
        }
        throw new ParserException("TODO. " + this.lexer.info());
    }

    @Override
    protected SQLAlterTableAlterColumn parseAlterColumn() {
        if (this.lexer.token() == Token.COLUMN) {
            this.lexer.nextToken();
        }
        SQLColumnDefinition column = this.exprParser.parseColumn();
        SQLAlterTableAlterColumn alterColumn = new SQLAlterTableAlterColumn();
        alterColumn.setColumn(column);
        if (column.getDataType() == null && column.getConstraints().size() == 0) {
            if (this.lexer.token() == Token.SET) {
                this.lexer.nextToken();
                if (this.lexer.token() == Token.NOT) {
                    this.lexer.nextToken();
                    this.accept(Token.NULL);
                    alterColumn.setSetNotNull(true);
                } else {
                    this.accept(Token.DEFAULT);
                    SQLExpr defaultValue = this.exprParser.expr();
                    alterColumn.setSetDefault(defaultValue);
                }
            } else if (this.lexer.token() == Token.DROP) {
                this.lexer.nextToken();
                if (this.lexer.token() == Token.NOT) {
                    this.lexer.nextToken();
                    this.accept(Token.NULL);
                    alterColumn.setDropNotNull(true);
                } else {
                    this.accept(Token.DEFAULT);
                    alterColumn.setDropDefault(true);
                }
            }
        }
        return alterColumn;
    }

    @Override
    public SQLStatement parseShow() {
        this.accept(Token.SHOW);
        PGShowStatement stmt = new PGShowStatement();
        switch (this.lexer.token()) {
            case ALL: {
                stmt.setExpr(new SQLIdentifierExpr(Token.ALL.name()));
                this.lexer.nextToken();
                break;
            }
            default: {
                stmt.setExpr(this.exprParser.expr());
            }
        }
        return stmt;
    }

    @Override
    public SQLStatement parseCommit() {
        SQLCommitStatement stmt = new SQLCommitStatement();
        stmt.setDbType(this.dbType);
        this.lexer.nextToken();
        return stmt;
    }

    private SQLStatement handleTimeZoneSet(String range) {
        this.lexer.nextToken();
        this.lexer.nextToken();
        String value = this.lexer.stringVal();
        ArrayList<SQLExpr> exprs = new ArrayList<SQLExpr>();
        if (this.lexer.token() == Token.IDENTIFIER) {
            exprs.add(new SQLIdentifierExpr(value.toUpperCase()));
        } else {
            exprs.add(new SQLCharExpr(value));
        }
        this.lexer.nextToken();
        return new PGSetStatement(range, TIME_ZONE, exprs);
    }

    @Override
    public SQLStatement parseSet() {
        this.accept(Token.SET);
        Token token = this.lexer.token();
        String range = "";
        if (token == Token.SESSION) {
            this.lexer.nextToken();
            range = Token.SESSION.name();
        } else if (token == Token.IDENTIFIER && LOCAL.equalsIgnoreCase(this.lexer.stringVal())) {
            range = LOCAL;
            this.lexer.nextToken();
        }
        String parameter = this.lexer.stringVal();
        if (TIME.equalsIgnoreCase(parameter)) {
            return this.handleTimeZoneSet(range);
        }
        this.lexer.nextToken();
        ArrayList<SQLExpr> values = new ArrayList<SQLExpr>();
        while (!this.lexer.isEOF()) {
            this.lexer.nextToken();
            if (this.lexer.token() == Token.LITERAL_CHARS) {
                values.add(new SQLCharExpr(this.lexer.stringVal()));
            } else if (this.lexer.token() == Token.LITERAL_INT) {
                values.add(new SQLIdentifierExpr(this.lexer.numberString()));
            } else {
                values.add(new SQLIdentifierExpr(this.lexer.stringVal()));
            }
            this.lexer.nextToken();
        }
        return new PGSetStatement(range, parameter, values);
    }
}

