/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.druid.sql.parser;

import com.alibaba.druid.sql.ast.SQLExpr;
import com.alibaba.druid.sql.ast.SQLHint;
import com.alibaba.druid.sql.ast.SQLName;
import com.alibaba.druid.sql.ast.SQLObject;
import com.alibaba.druid.sql.ast.SQLStatement;
import com.alibaba.druid.sql.ast.expr.SQLCharExpr;
import com.alibaba.druid.sql.ast.expr.SQLIdentifierExpr;
import com.alibaba.druid.sql.ast.expr.SQLVariantRefExpr;
import com.alibaba.druid.sql.ast.statement.SQLAlterTableAddColumn;
import com.alibaba.druid.sql.ast.statement.SQLAlterTableAddConstraint;
import com.alibaba.druid.sql.ast.statement.SQLAlterTableAddIndex;
import com.alibaba.druid.sql.ast.statement.SQLAlterTableAddPartition;
import com.alibaba.druid.sql.ast.statement.SQLAlterTableAlterColumn;
import com.alibaba.druid.sql.ast.statement.SQLAlterTableDisableConstraint;
import com.alibaba.druid.sql.ast.statement.SQLAlterTableDisableKeys;
import com.alibaba.druid.sql.ast.statement.SQLAlterTableDisableLifecycle;
import com.alibaba.druid.sql.ast.statement.SQLAlterTableDropColumnItem;
import com.alibaba.druid.sql.ast.statement.SQLAlterTableDropConstraint;
import com.alibaba.druid.sql.ast.statement.SQLAlterTableDropIndex;
import com.alibaba.druid.sql.ast.statement.SQLAlterTableDropPartition;
import com.alibaba.druid.sql.ast.statement.SQLAlterTableEnableConstraint;
import com.alibaba.druid.sql.ast.statement.SQLAlterTableEnableKeys;
import com.alibaba.druid.sql.ast.statement.SQLAlterTableEnableLifecycle;
import com.alibaba.druid.sql.ast.statement.SQLAlterTableItem;
import com.alibaba.druid.sql.ast.statement.SQLAlterTableRename;
import com.alibaba.druid.sql.ast.statement.SQLAlterTableRenameColumn;
import com.alibaba.druid.sql.ast.statement.SQLAlterTableRenamePartition;
import com.alibaba.druid.sql.ast.statement.SQLAlterTableSetComment;
import com.alibaba.druid.sql.ast.statement.SQLAlterTableSetLifecycle;
import com.alibaba.druid.sql.ast.statement.SQLAlterTableStatement;
import com.alibaba.druid.sql.ast.statement.SQLAlterTableTouch;
import com.alibaba.druid.sql.ast.statement.SQLAlterViewRenameStatement;
import com.alibaba.druid.sql.ast.statement.SQLAssignItem;
import com.alibaba.druid.sql.ast.statement.SQLCallStatement;
import com.alibaba.druid.sql.ast.statement.SQLCheck;
import com.alibaba.druid.sql.ast.statement.SQLCloseStatement;
import com.alibaba.druid.sql.ast.statement.SQLColumnDefinition;
import com.alibaba.druid.sql.ast.statement.SQLCommentStatement;
import com.alibaba.druid.sql.ast.statement.SQLConstraint;
import com.alibaba.druid.sql.ast.statement.SQLCreateDatabaseStatement;
import com.alibaba.druid.sql.ast.statement.SQLCreateIndexStatement;
import com.alibaba.druid.sql.ast.statement.SQLCreateTableStatement;
import com.alibaba.druid.sql.ast.statement.SQLCreateTriggerStatement;
import com.alibaba.druid.sql.ast.statement.SQLCreateViewStatement;
import com.alibaba.druid.sql.ast.statement.SQLDeleteStatement;
import com.alibaba.druid.sql.ast.statement.SQLDropDatabaseStatement;
import com.alibaba.druid.sql.ast.statement.SQLDropFunctionStatement;
import com.alibaba.druid.sql.ast.statement.SQLDropIndexStatement;
import com.alibaba.druid.sql.ast.statement.SQLDropProcedureStatement;
import com.alibaba.druid.sql.ast.statement.SQLDropSequenceStatement;
import com.alibaba.druid.sql.ast.statement.SQLDropTableSpaceStatement;
import com.alibaba.druid.sql.ast.statement.SQLDropTableStatement;
import com.alibaba.druid.sql.ast.statement.SQLDropTriggerStatement;
import com.alibaba.druid.sql.ast.statement.SQLDropUserStatement;
import com.alibaba.druid.sql.ast.statement.SQLDropViewStatement;
import com.alibaba.druid.sql.ast.statement.SQLErrorLoggingClause;
import com.alibaba.druid.sql.ast.statement.SQLExplainStatement;
import com.alibaba.druid.sql.ast.statement.SQLExprTableSource;
import com.alibaba.druid.sql.ast.statement.SQLFetchStatement;
import com.alibaba.druid.sql.ast.statement.SQLGrantStatement;
import com.alibaba.druid.sql.ast.statement.SQLInsertInto;
import com.alibaba.druid.sql.ast.statement.SQLInsertStatement;
import com.alibaba.druid.sql.ast.statement.SQLMergeStatement;
import com.alibaba.druid.sql.ast.statement.SQLObjectType;
import com.alibaba.druid.sql.ast.statement.SQLOpenStatement;
import com.alibaba.druid.sql.ast.statement.SQLPrimaryKey;
import com.alibaba.druid.sql.ast.statement.SQLReleaseSavePointStatement;
import com.alibaba.druid.sql.ast.statement.SQLRevokeStatement;
import com.alibaba.druid.sql.ast.statement.SQLRollbackStatement;
import com.alibaba.druid.sql.ast.statement.SQLSavePointStatement;
import com.alibaba.druid.sql.ast.statement.SQLSelect;
import com.alibaba.druid.sql.ast.statement.SQLSelectOrderByItem;
import com.alibaba.druid.sql.ast.statement.SQLSelectStatement;
import com.alibaba.druid.sql.ast.statement.SQLSetStatement;
import com.alibaba.druid.sql.ast.statement.SQLSubqueryTableSource;
import com.alibaba.druid.sql.ast.statement.SQLTableSource;
import com.alibaba.druid.sql.ast.statement.SQLTruncateStatement;
import com.alibaba.druid.sql.ast.statement.SQLUpdateSetItem;
import com.alibaba.druid.sql.ast.statement.SQLUpdateStatement;
import com.alibaba.druid.sql.ast.statement.SQLUseStatement;
import com.alibaba.druid.sql.parser.Lexer;
import com.alibaba.druid.sql.parser.ParserException;
import com.alibaba.druid.sql.parser.SQLCreateTableParser;
import com.alibaba.druid.sql.parser.SQLExprParser;
import com.alibaba.druid.sql.parser.SQLParser;
import com.alibaba.druid.sql.parser.SQLSelectParser;
import com.alibaba.druid.sql.parser.Token;
import java.util.ArrayList;
import java.util.List;

public class SQLStatementParser
extends SQLParser {
    protected SQLExprParser exprParser;
    protected boolean parseCompleteValues = true;
    protected int parseValuesSize = 3;

    public SQLStatementParser(String sql) {
        this(sql, null);
    }

    public SQLStatementParser(String sql, String dbType) {
        this(new SQLExprParser(sql, dbType));
    }

    public SQLStatementParser(SQLExprParser exprParser) {
        super(exprParser.getLexer(), exprParser.getDbType());
        this.exprParser = exprParser;
    }

    protected SQLStatementParser(Lexer lexer, String dbType) {
        super(lexer, dbType);
    }

    public boolean isKeepComments() {
        return this.lexer.isKeepComments();
    }

    public void setKeepComments(boolean keepComments) {
        this.lexer.setKeepComments(keepComments);
    }

    public SQLExprParser getExprParser() {
        return this.exprParser;
    }

    public List<SQLStatement> parseStatementList() {
        ArrayList<SQLStatement> statementList = new ArrayList<SQLStatement>();
        this.parseStatementList(statementList);
        return statementList;
    }

    public void parseStatementList(List<SQLStatement> statementList) {
        this.parseStatementList(statementList, -1);
    }

    public void parseStatementList(List<SQLStatement> statementList, int max) {
        while (max == -1 || statementList.size() < max) {
            SQLStatement stmt;
            if (this.lexer.token() == Token.EOF || this.lexer.token() == Token.END) {
                if (this.lexer.isKeepComments() && this.lexer.hasComment() && statementList.size() > 0) {
                    SQLStatement stmt2 = statementList.get(statementList.size() - 1);
                    stmt2.addAfterComment(this.lexer.readAndResetComments());
                }
                return;
            }
            if (this.lexer.token() == Token.SEMI) {
                int line0 = this.lexer.getLine();
                this.lexer.nextToken();
                int line1 = this.lexer.getLine();
                if (!this.lexer.isKeepComments() || statementList.size() <= 0) continue;
                stmt = statementList.get(statementList.size() - 1);
                if (line1 - line0 <= 1) {
                    stmt.addAfterComment(this.lexer.readAndResetComments());
                }
                stmt.getAttributes().put("format.semi", Boolean.TRUE);
                continue;
            }
            if (this.lexer.token() == Token.SELECT) {
                statementList.add(this.parseSelect());
                continue;
            }
            if (this.lexer.token() == Token.UPDATE) {
                statementList.add(this.parseUpdateStatement());
                continue;
            }
            if (this.lexer.token() == Token.CREATE) {
                statementList.add(this.parseCreate());
                continue;
            }
            if (this.lexer.token() == Token.INSERT) {
                SQLStatement insertStatement = this.parseInsert();
                statementList.add(insertStatement);
                continue;
            }
            if (this.lexer.token() == Token.DELETE) {
                statementList.add(this.parseDeleteStatement());
                continue;
            }
            if (this.lexer.token() == Token.EXPLAIN) {
                statementList.add(this.parseExplain());
                continue;
            }
            if (this.lexer.token() == Token.SET) {
                statementList.add(this.parseSet());
                continue;
            }
            if (this.lexer.token() == Token.ALTER) {
                statementList.add(this.parseAlter());
                continue;
            }
            if (this.lexer.token() == Token.DROP) {
                List<String> beforeComments = null;
                if (this.lexer.isKeepComments() && this.lexer.hasComment()) {
                    beforeComments = this.lexer.readAndResetComments();
                }
                this.lexer.nextToken();
                if (this.lexer.token() == Token.TABLE || this.identifierEquals("TEMPORARY")) {
                    SQLDropTableStatement stmt3 = this.parseDropTable(false);
                    if (beforeComments != null) {
                        stmt3.addBeforeComment(beforeComments);
                    }
                    statementList.add(stmt3);
                    continue;
                }
                if (this.lexer.token() == Token.USER) {
                    SQLDropUserStatement stmt4 = this.parseDropUser();
                    if (beforeComments != null) {
                        stmt4.addBeforeComment(beforeComments);
                    }
                    statementList.add(stmt4);
                    continue;
                }
                if (this.lexer.token() == Token.INDEX) {
                    SQLStatement stmt5 = this.parseDropIndex();
                    if (beforeComments != null) {
                        stmt5.addBeforeComment(beforeComments);
                    }
                    statementList.add(stmt5);
                    continue;
                }
                if (this.lexer.token() == Token.VIEW) {
                    SQLDropViewStatement stmt6 = this.parseDropView(false);
                    if (beforeComments != null) {
                        stmt6.addBeforeComment(beforeComments);
                    }
                    statementList.add(stmt6);
                    continue;
                }
                if (this.lexer.token() == Token.TRIGGER) {
                    SQLDropTriggerStatement stmt7 = this.parseDropTrigger(false);
                    if (beforeComments != null) {
                        stmt7.addBeforeComment(beforeComments);
                    }
                    statementList.add(stmt7);
                    continue;
                }
                if (this.lexer.token() == Token.DATABASE) {
                    SQLDropDatabaseStatement stmt8 = this.parseDropDatabase(false);
                    if (beforeComments != null) {
                        stmt8.addBeforeComment(beforeComments);
                    }
                    statementList.add(stmt8);
                    continue;
                }
                if (this.lexer.token() == Token.FUNCTION) {
                    SQLDropFunctionStatement stmt9 = this.parseDropFunction(false);
                    if (beforeComments != null) {
                        stmt9.addBeforeComment(beforeComments);
                    }
                    statementList.add(stmt9);
                    continue;
                }
                if (this.lexer.token() == Token.TABLESPACE) {
                    SQLDropTableSpaceStatement stmt10 = this.parseDropTablespace(false);
                    if (beforeComments != null) {
                        stmt10.addBeforeComment(beforeComments);
                    }
                    statementList.add(stmt10);
                    continue;
                }
                if (this.lexer.token() == Token.PROCEDURE) {
                    SQLDropProcedureStatement stmt11 = this.parseDropProcedure(false);
                    if (beforeComments != null) {
                        stmt11.addBeforeComment(beforeComments);
                    }
                    statementList.add(stmt11);
                    continue;
                }
                if (this.lexer.token() == Token.SEQUENCE) {
                    SQLDropSequenceStatement stmt12 = this.parseDropSequece(false);
                    if (beforeComments != null) {
                        stmt12.addBeforeComment(beforeComments);
                    }
                    statementList.add(stmt12);
                    continue;
                }
                throw new ParserException("TODO " + (Object)((Object)this.lexer.token()));
            }
            if (this.lexer.token() == Token.TRUNCATE) {
                SQLStatement stmt13 = this.parseTruncate();
                statementList.add(stmt13);
                continue;
            }
            if (this.lexer.token() == Token.USE) {
                SQLUseStatement stmt14 = this.parseUse();
                statementList.add(stmt14);
                continue;
            }
            if (this.lexer.token() == Token.GRANT) {
                SQLGrantStatement stmt15 = this.parseGrant();
                statementList.add(stmt15);
                continue;
            }
            if (this.lexer.token() == Token.REVOKE) {
                SQLRevokeStatement stmt16 = this.parseRevoke();
                statementList.add(stmt16);
                continue;
            }
            if (this.lexer.token() == Token.LBRACE || this.identifierEquals("CALL")) {
                SQLCallStatement stmt17 = this.parseCall();
                statementList.add(stmt17);
                continue;
            }
            if (this.identifierEquals("RENAME")) {
                SQLStatement stmt18 = this.parseRename();
                statementList.add(stmt18);
                continue;
            }
            if (this.identifierEquals("RELEASE")) {
                SQLStatement stmt19 = this.parseReleaseSavePoint();
                statementList.add(stmt19);
                continue;
            }
            if (this.identifierEquals("SAVEPOINT")) {
                SQLStatement stmt20 = this.parseSavePoint();
                statementList.add(stmt20);
                continue;
            }
            if (this.identifierEquals("ROLLBACK")) {
                SQLRollbackStatement stmt21 = this.parseRollback();
                statementList.add(stmt21);
                continue;
            }
            if (this.identifierEquals("COMMIT")) {
                SQLStatement stmt22 = this.parseCommit();
                statementList.add(stmt22);
                continue;
            }
            if (this.lexer.token() == Token.SHOW) {
                SQLStatement stmt23 = this.parseShow();
                statementList.add(stmt23);
                continue;
            }
            if (this.lexer.token() == Token.LPAREN) {
                char markChar = this.lexer.current();
                int markBp = this.lexer.bp();
                this.lexer.nextToken();
                if (this.lexer.token() == Token.SELECT) {
                    this.lexer.reset(markBp, markChar, Token.LPAREN);
                    stmt = this.parseSelect();
                    statementList.add(stmt);
                    continue;
                }
            }
            if (this.lexer.token() == Token.MERGE) {
                statementList.add(this.parseMerge());
                continue;
            }
            if (this.parseStatementListDialect(statementList)) continue;
            if (this.lexer.token() == Token.COMMENT) {
                statementList.add(this.parseComment());
                continue;
            }
            if (this.lexer.token() == Token.UPSERT || this.identifierEquals("UPSERT")) {
                SQLStatement stmt24 = this.parseUpsert();
                statementList.add(stmt24);
                continue;
            }
            this.printError(this.lexer.token());
        }
        return;
    }

    public SQLStatement parseUpsert() {
        SQLInsertStatement insertStatement = new SQLInsertStatement();
        if (this.lexer.token() == Token.UPSERT || this.identifierEquals("UPSERT")) {
            this.lexer.nextToken();
            insertStatement.setUpsert(true);
        }
        this.parseInsert0(insertStatement);
        return insertStatement;
    }

    public SQLRollbackStatement parseRollback() {
        this.lexer.nextToken();
        if (this.identifierEquals("WORK")) {
            this.lexer.nextToken();
        }
        SQLRollbackStatement stmt = new SQLRollbackStatement(this.getDbType());
        if (this.lexer.token() == Token.TO) {
            this.lexer.nextToken();
            if (this.identifierEquals("SAVEPOINT")) {
                this.lexer.nextToken();
            }
            stmt.setTo(this.exprParser.name());
        }
        return stmt;
    }

    public SQLStatement parseCommit() {
        throw new ParserException("TODO " + (Object)((Object)this.lexer.token()) + " " + this.lexer.stringVal());
    }

    public SQLStatement parseShow() {
        throw new ParserException("TODO " + (Object)((Object)this.lexer.token()) + " " + this.lexer.stringVal());
    }

    public SQLUseStatement parseUse() {
        this.accept(Token.USE);
        SQLUseStatement stmt = new SQLUseStatement(this.getDbType());
        stmt.setDatabase(this.exprParser.name());
        return stmt;
    }

    public SQLGrantStatement parseGrant() {
        this.accept(Token.GRANT);
        SQLGrantStatement stmt = new SQLGrantStatement(this.getDbType());
        this.parsePrivileages(stmt.getPrivileges(), stmt);
        if (this.lexer.token() == Token.ON) {
            this.lexer.nextToken();
            if (this.lexer.token() == Token.PROCEDURE) {
                this.lexer.nextToken();
                stmt.setObjectType(SQLObjectType.PROCEDURE);
            } else if (this.lexer.token() == Token.FUNCTION) {
                this.lexer.nextToken();
                stmt.setObjectType(SQLObjectType.FUNCTION);
            } else if (this.lexer.token() == Token.TABLE) {
                this.lexer.nextToken();
                stmt.setObjectType(SQLObjectType.TABLE);
            } else if (this.lexer.token() == Token.USER) {
                this.lexer.nextToken();
                stmt.setObjectType(SQLObjectType.USER);
            } else if (this.lexer.token() == Token.DATABASE) {
                this.lexer.nextToken();
                stmt.setObjectType(SQLObjectType.DATABASE);
            }
            if (stmt.getObjectType() != null && this.lexer.token() == Token.COLONCOLON) {
                this.lexer.nextToken();
            }
            SQLExpr expr = this.exprParser.expr();
            if (stmt.getObjectType() == SQLObjectType.TABLE || stmt.getObjectType() == null) {
                stmt.setOn(new SQLExprTableSource(expr));
            } else {
                stmt.setOn(expr);
            }
        }
        if (this.lexer.token() == Token.TO) {
            this.lexer.nextToken();
            stmt.setTo(this.exprParser.expr());
        }
        if (this.lexer.token() == Token.WITH) {
            this.lexer.nextToken();
            while (true) {
                if (this.identifierEquals("MAX_QUERIES_PER_HOUR")) {
                    this.lexer.nextToken();
                    stmt.setMaxQueriesPerHour(this.exprParser.primary());
                    continue;
                }
                if (this.identifierEquals("MAX_UPDATES_PER_HOUR")) {
                    this.lexer.nextToken();
                    stmt.setMaxUpdatesPerHour(this.exprParser.primary());
                    continue;
                }
                if (this.identifierEquals("MAX_CONNECTIONS_PER_HOUR")) {
                    this.lexer.nextToken();
                    stmt.setMaxConnectionsPerHour(this.exprParser.primary());
                    continue;
                }
                if (!this.identifierEquals("MAX_USER_CONNECTIONS")) break;
                this.lexer.nextToken();
                stmt.setMaxUserConnections(this.exprParser.primary());
            }
        }
        if (this.identifierEquals("ADMIN")) {
            this.lexer.nextToken();
            this.acceptIdentifier("OPTION");
            stmt.setAdminOption(true);
        }
        if (this.lexer.token() == Token.IDENTIFIED) {
            this.lexer.nextToken();
            this.accept(Token.BY);
            stmt.setIdentifiedBy(this.exprParser.expr());
        }
        return stmt;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void parsePrivileages(List<SQLExpr> privileges, SQLObject parent) {
        while (true) {
            String privilege = null;
            if (this.lexer.token() == Token.ALL) {
                this.lexer.nextToken();
                privilege = this.identifierEquals("PRIVILEGES") ? "ALL PRIVILEGES" : "ALL";
            } else if (this.lexer.token() == Token.SELECT) {
                privilege = "SELECT";
                this.lexer.nextToken();
            } else if (this.lexer.token() == Token.UPDATE) {
                privilege = "UPDATE";
                this.lexer.nextToken();
            } else if (this.lexer.token() == Token.DELETE) {
                privilege = "DELETE";
                this.lexer.nextToken();
            } else if (this.lexer.token() == Token.INSERT) {
                privilege = "INSERT";
                this.lexer.nextToken();
            } else if (this.lexer.token() == Token.INDEX) {
                this.lexer.nextToken();
                privilege = "INDEX";
            } else if (this.lexer.token() == Token.TRIGGER) {
                this.lexer.nextToken();
                privilege = "TRIGGER";
            } else if (this.lexer.token() == Token.REFERENCES) {
                privilege = "REFERENCES";
                this.lexer.nextToken();
            } else if (this.lexer.token() == Token.CREATE) {
                this.lexer.nextToken();
                if (this.lexer.token() == Token.TABLE) {
                    privilege = "CREATE TABLE";
                    this.lexer.nextToken();
                } else if (this.lexer.token() == Token.SESSION) {
                    privilege = "CREATE SESSION";
                    this.lexer.nextToken();
                } else if (this.lexer.token() == Token.TABLESPACE) {
                    privilege = "CREATE TABLESPACE";
                    this.lexer.nextToken();
                } else if (this.lexer.token() == Token.USER) {
                    privilege = "CREATE USER";
                    this.lexer.nextToken();
                } else if (this.lexer.token() == Token.VIEW) {
                    privilege = "CREATE VIEW";
                    this.lexer.nextToken();
                } else if (this.lexer.token() == Token.ANY) {
                    this.lexer.nextToken();
                    if (this.lexer.token() == Token.TABLE) {
                        this.lexer.nextToken();
                        privilege = "CREATE ANY TABLE";
                    } else {
                        if (!this.identifierEquals("MATERIALIZED")) throw new ParserException("TODO : " + (Object)((Object)this.lexer.token()) + " " + this.lexer.stringVal());
                        this.lexer.nextToken();
                        this.accept(Token.VIEW);
                        privilege = "CREATE ANY MATERIALIZED VIEW";
                    }
                } else if (this.identifierEquals("SYNONYM")) {
                    privilege = "CREATE SYNONYM";
                    this.lexer.nextToken();
                } else if (this.identifierEquals("ROUTINE")) {
                    privilege = "CREATE ROUTINE";
                    this.lexer.nextToken();
                } else {
                    if (!this.identifierEquals("TEMPORARY")) throw new ParserException("TODO : " + (Object)((Object)this.lexer.token()) + " " + this.lexer.stringVal());
                    this.lexer.nextToken();
                    this.accept(Token.TABLE);
                    privilege = "CREATE TEMPORARY TABLE";
                }
            } else if (this.lexer.token() == Token.ALTER) {
                this.lexer.nextToken();
                if (this.lexer.token() == Token.TABLE) {
                    privilege = "ALTER TABLE";
                    this.lexer.nextToken();
                } else if (this.lexer.token() == Token.SESSION) {
                    privilege = "ALTER SESSION";
                    this.lexer.nextToken();
                } else {
                    if (this.lexer.token() != Token.ANY) throw new ParserException("TODO : " + (Object)((Object)this.lexer.token()) + " " + this.lexer.stringVal());
                    this.lexer.nextToken();
                    if (this.lexer.token() == Token.TABLE) {
                        this.lexer.nextToken();
                        privilege = "ALTER ANY TABLE";
                    } else {
                        if (!this.identifierEquals("MATERIALIZED")) throw new ParserException("TODO : " + (Object)((Object)this.lexer.token()) + " " + this.lexer.stringVal());
                        this.lexer.nextToken();
                        this.accept(Token.VIEW);
                        privilege = "ALTER ANY MATERIALIZED VIEW";
                    }
                }
            } else if (this.lexer.token() == Token.DROP) {
                this.lexer.nextToken();
                if (this.lexer.token() == Token.DROP) {
                    privilege = "DROP TABLE";
                    this.lexer.nextToken();
                } else if (this.lexer.token() == Token.SESSION) {
                    privilege = "DROP SESSION";
                    this.lexer.nextToken();
                } else if (this.lexer.token() == Token.ANY) {
                    this.lexer.nextToken();
                    if (this.lexer.token() == Token.TABLE) {
                        this.lexer.nextToken();
                        privilege = "DROP ANY TABLE";
                    } else {
                        if (!this.identifierEquals("MATERIALIZED")) throw new ParserException("TODO : " + (Object)((Object)this.lexer.token()) + " " + this.lexer.stringVal());
                        this.lexer.nextToken();
                        this.accept(Token.VIEW);
                        privilege = "DROP ANY MATERIALIZED VIEW";
                    }
                } else {
                    privilege = "DROP";
                }
            } else if (this.identifierEquals("USAGE")) {
                privilege = "USAGE";
                this.lexer.nextToken();
            } else if (this.identifierEquals("EXECUTE")) {
                privilege = "EXECUTE";
                this.lexer.nextToken();
            } else if (this.identifierEquals("PROXY")) {
                privilege = "PROXY";
                this.lexer.nextToken();
            } else if (this.identifierEquals("QUERY")) {
                this.lexer.nextToken();
                this.acceptIdentifier("REWRITE");
                privilege = "QUERY REWRITE";
            } else if (this.identifierEquals("GLOBAL")) {
                this.lexer.nextToken();
                this.acceptIdentifier("QUERY");
                this.acceptIdentifier("REWRITE");
                privilege = "GLOBAL QUERY REWRITE";
            } else if (this.identifierEquals("INHERIT")) {
                this.lexer.nextToken();
                this.acceptIdentifier("PRIVILEGES");
                privilege = "INHERIT PRIVILEGES";
            } else if (this.identifierEquals("EVENT")) {
                this.lexer.nextToken();
                privilege = "EVENT";
            } else if (this.identifierEquals("FILE")) {
                this.lexer.nextToken();
                privilege = "FILE";
            } else if (this.lexer.token() == Token.GRANT) {
                this.lexer.nextToken();
                this.acceptIdentifier("OPTION");
                privilege = "GRANT OPTION";
            } else if (this.lexer.token() == Token.LOCK) {
                this.lexer.nextToken();
                this.acceptIdentifier("TABLES");
                privilege = "LOCK TABLES";
            } else if (this.identifierEquals("PROCESS")) {
                this.lexer.nextToken();
                privilege = "PROCESS";
            } else if (this.identifierEquals("RELOAD")) {
                this.lexer.nextToken();
                privilege = "RELOAD";
            } else if (this.identifierEquals("REPLICATION")) {
                this.lexer.nextToken();
                if (this.identifierEquals("SLAVE")) {
                    this.lexer.nextToken();
                    privilege = "REPLICATION SLAVE";
                } else {
                    this.acceptIdentifier("CLIENT");
                    privilege = "REPLICATION CLIENT";
                }
            } else if (this.lexer.token() == Token.SHOW) {
                this.lexer.nextToken();
                if (this.lexer.token() == Token.VIEW) {
                    this.lexer.nextToken();
                    privilege = "SHOW VIEW";
                } else {
                    this.acceptIdentifier("DATABASES");
                    privilege = "SHOW DATABASES";
                }
            } else if (this.identifierEquals("SHUTDOWN")) {
                this.lexer.nextToken();
                privilege = "SHUTDOWN";
            } else if (this.identifierEquals("SUPER")) {
                this.lexer.nextToken();
                privilege = "SUPER";
            } else if (this.identifierEquals("CONTROL")) {
                this.lexer.nextToken();
                privilege = "CONTROL";
            } else if (this.identifierEquals("IMPERSONATE")) {
                this.lexer.nextToken();
                privilege = "IMPERSONATE";
            }
            if (privilege != null) {
                void var4_4;
                SQLIdentifierExpr sQLIdentifierExpr = new SQLIdentifierExpr(privilege);
                if (this.lexer.token() == Token.LPAREN) {
                    SQLExpr sQLExpr = this.exprParser.primaryRest(sQLIdentifierExpr);
                }
                var4_4.setParent(parent);
                privileges.add((SQLExpr)var4_4);
            }
            if (this.lexer.token() != Token.COMMA) return;
            this.lexer.nextToken();
        }
    }

    public SQLRevokeStatement parseRevoke() {
        this.accept(Token.REVOKE);
        SQLRevokeStatement stmt = new SQLRevokeStatement(this.getDbType());
        this.parsePrivileages(stmt.getPrivileges(), stmt);
        if (this.lexer.token() == Token.ON) {
            this.lexer.nextToken();
            if (this.lexer.token() == Token.PROCEDURE) {
                this.lexer.nextToken();
                stmt.setObjectType(SQLObjectType.PROCEDURE);
            } else if (this.lexer.token() == Token.FUNCTION) {
                this.lexer.nextToken();
                stmt.setObjectType(SQLObjectType.FUNCTION);
            } else if (this.lexer.token() == Token.TABLE) {
                this.lexer.nextToken();
                stmt.setObjectType(SQLObjectType.TABLE);
            } else if (this.lexer.token() == Token.USER) {
                this.lexer.nextToken();
                stmt.setObjectType(SQLObjectType.USER);
            }
            SQLExpr expr = this.exprParser.expr();
            if (stmt.getObjectType() == SQLObjectType.TABLE || stmt.getObjectType() == null) {
                stmt.setOn(new SQLExprTableSource(expr));
            } else {
                stmt.setOn(expr);
            }
        }
        if (this.lexer.token() == Token.FROM) {
            this.lexer.nextToken();
            stmt.setFrom(this.exprParser.expr());
        }
        return stmt;
    }

    public SQLStatement parseSavePoint() {
        this.acceptIdentifier("SAVEPOINT");
        SQLSavePointStatement stmt = new SQLSavePointStatement(this.getDbType());
        stmt.setName(this.exprParser.name());
        return stmt;
    }

    public SQLStatement parseReleaseSavePoint() {
        this.acceptIdentifier("RELEASE");
        this.acceptIdentifier("SAVEPOINT");
        SQLReleaseSavePointStatement stmt = new SQLReleaseSavePointStatement(this.getDbType());
        stmt.setName(this.exprParser.name());
        return stmt;
    }

    public SQLStatement parseAlter() {
        this.accept(Token.ALTER);
        if (this.lexer.token() == Token.TABLE) {
            this.lexer.nextToken();
            SQLAlterTableStatement stmt = new SQLAlterTableStatement(this.getDbType());
            stmt.setName(this.exprParser.name());
            while (true) {
                if (this.lexer.token() == Token.DROP) {
                    this.parseAlterDrop(stmt);
                    continue;
                }
                if (this.identifierEquals("ADD")) {
                    SQLConstraint constraint;
                    SQLAlterTableAddColumn item;
                    SQLAlterTableAddConstraint item2;
                    this.lexer.nextToken();
                    boolean ifNotExists = false;
                    if (this.lexer.token() == Token.IF) {
                        this.lexer.nextToken();
                        this.accept(Token.NOT);
                        this.accept(Token.EXISTS);
                        ifNotExists = true;
                    }
                    if (this.lexer.token() == Token.PRIMARY) {
                        SQLPrimaryKey primaryKey = this.exprParser.parsePrimaryKey();
                        item2 = new SQLAlterTableAddConstraint(primaryKey);
                        stmt.addItem(item2);
                        continue;
                    }
                    if (this.lexer.token() == Token.IDENTIFIER) {
                        item = this.parseAlterTableAddColumn();
                        stmt.addItem(item);
                        continue;
                    }
                    if (this.lexer.token() == Token.COLUMN) {
                        this.lexer.nextToken();
                        item = this.parseAlterTableAddColumn();
                        stmt.addItem(item);
                        continue;
                    }
                    if (this.lexer.token() == Token.CHECK) {
                        SQLCheck check = this.exprParser.parseCheck();
                        item2 = new SQLAlterTableAddConstraint(check);
                        stmt.addItem(item2);
                        continue;
                    }
                    if (this.lexer.token() == Token.CONSTRAINT) {
                        constraint = this.exprParser.parseConstaint();
                        item2 = new SQLAlterTableAddConstraint(constraint);
                        stmt.addItem(item2);
                        continue;
                    }
                    if (this.lexer.token() == Token.FOREIGN) {
                        constraint = this.exprParser.parseForeignKey();
                        item2 = new SQLAlterTableAddConstraint(constraint);
                        stmt.addItem(item2);
                        continue;
                    }
                    if (this.lexer.token() == Token.PARTITION) {
                        this.lexer.nextToken();
                        SQLAlterTableAddPartition addPartition = new SQLAlterTableAddPartition();
                        addPartition.setIfNotExists(ifNotExists);
                        this.accept(Token.LPAREN);
                        this.parseAssignItems(addPartition.getPartitions(), addPartition);
                        this.accept(Token.RPAREN);
                        stmt.addItem(addPartition);
                        continue;
                    }
                    throw new ParserException("TODO " + (Object)((Object)this.lexer.token()) + " " + this.lexer.stringVal());
                }
                if (this.lexer.token() == Token.DISABLE) {
                    this.lexer.nextToken();
                    if (this.lexer.token() == Token.CONSTRAINT) {
                        this.lexer.nextToken();
                        SQLAlterTableDisableConstraint item = new SQLAlterTableDisableConstraint();
                        item.setConstraintName(this.exprParser.name());
                        stmt.addItem(item);
                        continue;
                    }
                    if (this.identifierEquals("LIFECYCLE")) {
                        this.lexer.nextToken();
                        SQLAlterTableDisableLifecycle item = new SQLAlterTableDisableLifecycle();
                        stmt.addItem(item);
                        continue;
                    }
                    this.acceptIdentifier("KEYS");
                    SQLAlterTableDisableKeys item = new SQLAlterTableDisableKeys();
                    stmt.addItem(item);
                    continue;
                }
                if (this.lexer.token() == Token.ENABLE) {
                    this.lexer.nextToken();
                    if (this.lexer.token() == Token.CONSTRAINT) {
                        this.lexer.nextToken();
                        SQLAlterTableEnableConstraint item = new SQLAlterTableEnableConstraint();
                        item.setConstraintName(this.exprParser.name());
                        stmt.addItem(item);
                        continue;
                    }
                    if (this.identifierEquals("LIFECYCLE")) {
                        this.lexer.nextToken();
                        SQLAlterTableEnableLifecycle item = new SQLAlterTableEnableLifecycle();
                        stmt.addItem(item);
                        continue;
                    }
                    this.acceptIdentifier("KEYS");
                    SQLAlterTableEnableKeys item = new SQLAlterTableEnableKeys();
                    stmt.addItem(item);
                    continue;
                }
                if (this.lexer.token() == Token.ALTER) {
                    this.lexer.nextToken();
                    if (this.lexer.token() == Token.COLUMN) {
                        SQLAlterTableAlterColumn alterColumn = this.parseAlterColumn();
                        stmt.addItem(alterColumn);
                        continue;
                    }
                    if (this.lexer.token() == Token.LITERAL_ALIAS) {
                        SQLAlterTableAlterColumn alterColumn = this.parseAlterColumn();
                        stmt.addItem(alterColumn);
                        continue;
                    }
                    throw new ParserException("TODO " + (Object)((Object)this.lexer.token()) + " " + this.lexer.stringVal());
                }
                if (this.identifierEquals("CHANGE")) {
                    this.lexer.nextToken();
                    this.accept(Token.COLUMN);
                    SQLName columnName = this.exprParser.name();
                    this.accept(Token.COMMENT);
                    SQLExpr comment = this.exprParser.primary();
                    SQLColumnDefinition columnDefinition = new SQLColumnDefinition();
                    columnDefinition.setName(columnName);
                    columnDefinition.setComment(comment);
                    SQLAlterTableAlterColumn changeColumn = new SQLAlterTableAlterColumn();
                    changeColumn.setColumn(columnDefinition);
                    stmt.addItem(changeColumn);
                    continue;
                }
                if (this.lexer.token() == Token.WITH) {
                    this.lexer.nextToken();
                    this.acceptIdentifier("NOCHECK");
                    this.acceptIdentifier("ADD");
                    SQLConstraint check = this.exprParser.parseConstaint();
                    SQLAlterTableAddConstraint addCheck = new SQLAlterTableAddConstraint();
                    addCheck.setWithNoCheck(true);
                    addCheck.setConstraint(check);
                    stmt.addItem(addCheck);
                    continue;
                }
                if (this.identifierEquals("RENAME")) {
                    stmt.addItem(this.parseAlterTableRename());
                    continue;
                }
                if (this.lexer.token() == Token.SET) {
                    this.lexer.nextToken();
                    if (this.lexer.token() == Token.COMMENT) {
                        this.lexer.nextToken();
                        SQLAlterTableSetComment setComment = new SQLAlterTableSetComment();
                        setComment.setComment(this.exprParser.primary());
                        stmt.addItem(setComment);
                        continue;
                    }
                    if (this.identifierEquals("LIFECYCLE")) {
                        this.lexer.nextToken();
                        SQLAlterTableSetLifecycle setLifecycle = new SQLAlterTableSetLifecycle();
                        setLifecycle.setLifecycle(this.exprParser.primary());
                        stmt.addItem(setLifecycle);
                        continue;
                    }
                    throw new ParserException("TODO " + (Object)((Object)this.lexer.token()) + " " + this.lexer.stringVal());
                }
                if (this.lexer.token() == Token.PARTITION) {
                    this.lexer.nextToken();
                    SQLAlterTableRenamePartition renamePartition = new SQLAlterTableRenamePartition();
                    this.accept(Token.LPAREN);
                    this.parseAssignItems(renamePartition.getPartition(), renamePartition);
                    this.accept(Token.RPAREN);
                    if (this.lexer.token() == Token.ENABLE) {
                        this.lexer.nextToken();
                        if (this.identifierEquals("LIFECYCLE")) {
                            this.lexer.nextToken();
                        }
                        SQLAlterTableEnableLifecycle enableLifeCycle = new SQLAlterTableEnableLifecycle();
                        for (SQLAssignItem condition : renamePartition.getPartition()) {
                            enableLifeCycle.getPartition().add(condition);
                            condition.setParent(enableLifeCycle);
                        }
                        stmt.addItem(enableLifeCycle);
                        continue;
                    }
                    if (this.lexer.token() == Token.DISABLE) {
                        this.lexer.nextToken();
                        if (this.identifierEquals("LIFECYCLE")) {
                            this.lexer.nextToken();
                        }
                        SQLAlterTableDisableLifecycle disableLifeCycle = new SQLAlterTableDisableLifecycle();
                        for (SQLAssignItem condition : renamePartition.getPartition()) {
                            disableLifeCycle.getPartition().add(condition);
                            condition.setParent(disableLifeCycle);
                        }
                        stmt.addItem(disableLifeCycle);
                        continue;
                    }
                    this.acceptIdentifier("RENAME");
                    this.accept(Token.TO);
                    this.accept(Token.PARTITION);
                    this.accept(Token.LPAREN);
                    this.parseAssignItems(renamePartition.getTo(), renamePartition);
                    this.accept(Token.RPAREN);
                    stmt.addItem(renamePartition);
                    continue;
                }
                if (!this.identifierEquals("TOUCH")) break;
                this.lexer.nextToken();
                SQLAlterTableTouch item = new SQLAlterTableTouch();
                if (this.lexer.token() == Token.PARTITION) {
                    this.lexer.nextToken();
                    this.accept(Token.LPAREN);
                    this.parseAssignItems(item.getPartition(), item);
                    this.accept(Token.RPAREN);
                }
                stmt.addItem(item);
            }
            return stmt;
        }
        if (this.lexer.token() == Token.VIEW) {
            this.lexer.nextToken();
            SQLName viewName = this.exprParser.name();
            if (this.identifierEquals("RENAME")) {
                this.lexer.nextToken();
                this.accept(Token.TO);
                SQLAlterViewRenameStatement stmt = new SQLAlterViewRenameStatement();
                stmt.setName(viewName);
                SQLName newName = this.exprParser.name();
                stmt.setTo(newName);
                return stmt;
            }
            throw new ParserException("TODO " + (Object)((Object)this.lexer.token()) + " " + this.lexer.stringVal());
        }
        throw new ParserException("TODO " + (Object)((Object)this.lexer.token()) + " " + this.lexer.stringVal());
    }

    protected SQLAlterTableItem parseAlterTableRename() {
        this.acceptIdentifier("RENAME");
        if (this.lexer.token() == Token.COLUMN) {
            this.lexer.nextToken();
            SQLAlterTableRenameColumn renameColumn = new SQLAlterTableRenameColumn();
            renameColumn.setColumn(this.exprParser.name());
            this.accept(Token.TO);
            renameColumn.setTo(this.exprParser.name());
            return renameColumn;
        }
        if (this.lexer.token() == Token.TO) {
            this.lexer.nextToken();
            SQLAlterTableRename item = new SQLAlterTableRename();
            item.setTo(this.exprParser.name());
            return item;
        }
        throw new ParserException("TODO " + (Object)((Object)this.lexer.token()) + " " + this.lexer.stringVal());
    }

    protected SQLAlterTableAlterColumn parseAlterColumn() {
        this.lexer.nextToken();
        SQLColumnDefinition column = this.exprParser.parseColumn();
        SQLAlterTableAlterColumn alterColumn = new SQLAlterTableAlterColumn();
        alterColumn.setColumn(column);
        return alterColumn;
    }

    public void parseAlterDrop(SQLAlterTableStatement stmt) {
        this.lexer.nextToken();
        boolean ifNotExists = false;
        if (this.lexer.token() == Token.IF) {
            this.lexer.nextToken();
            this.accept(Token.NOT);
            this.accept(Token.EXISTS);
            ifNotExists = true;
        }
        if (this.lexer.token() == Token.CONSTRAINT) {
            this.lexer.nextToken();
            SQLAlterTableDropConstraint item = new SQLAlterTableDropConstraint();
            item.setConstraintName(this.exprParser.name());
            stmt.addItem(item);
        } else if (this.lexer.token() == Token.COLUMN) {
            this.lexer.nextToken();
            SQLAlterTableDropColumnItem item = new SQLAlterTableDropColumnItem();
            this.exprParser.names(item.getColumns());
            if (this.lexer.token == Token.CASCADE) {
                item.setCascade(true);
                this.lexer.nextToken();
            }
            stmt.addItem(item);
        } else if (this.lexer.token() == Token.LITERAL_ALIAS) {
            SQLAlterTableDropColumnItem item = new SQLAlterTableDropColumnItem();
            this.exprParser.names(item.getColumns());
            if (this.lexer.token == Token.CASCADE) {
                item.setCascade(true);
                this.lexer.nextToken();
            }
            stmt.addItem(item);
        } else if (this.lexer.token() == Token.PARTITION) {
            SQLAlterTableDropPartition dropPartition = this.parseAlterTableDropPartition(ifNotExists);
            stmt.addItem(dropPartition);
        } else if (this.lexer.token() == Token.INDEX) {
            this.lexer.nextToken();
            SQLName indexName = this.exprParser.name();
            SQLAlterTableDropIndex item = new SQLAlterTableDropIndex();
            item.setIndexName(indexName);
            stmt.addItem(item);
        } else {
            throw new ParserException("TODO " + (Object)((Object)this.lexer.token()) + " " + this.lexer.stringVal());
        }
    }

    protected SQLAlterTableDropPartition parseAlterTableDropPartition(boolean ifNotExists) {
        this.lexer.nextToken();
        SQLAlterTableDropPartition dropPartition = new SQLAlterTableDropPartition();
        dropPartition.setIfNotExists(ifNotExists);
        if (this.lexer.token() == Token.LPAREN) {
            this.accept(Token.LPAREN);
            this.parseAssignItems(dropPartition.getPartitions(), dropPartition);
            this.accept(Token.RPAREN);
            if (this.identifierEquals("PURGE")) {
                this.lexer.nextToken();
                dropPartition.setPurge(true);
            }
        } else {
            SQLName partition = this.exprParser.name();
            dropPartition.addPartition(partition);
        }
        return dropPartition;
    }

    public SQLStatement parseRename() {
        throw new ParserException("TODO " + (Object)((Object)this.lexer.token()) + " " + this.lexer.stringVal());
    }

    protected SQLDropTableStatement parseDropTable(boolean acceptDrop) {
        if (acceptDrop) {
            this.accept(Token.DROP);
        }
        SQLDropTableStatement stmt = new SQLDropTableStatement(this.getDbType());
        if (this.identifierEquals("TEMPORARY")) {
            this.lexer.nextToken();
            stmt.setTemporary(true);
        }
        this.accept(Token.TABLE);
        if (this.lexer.token() == Token.IF) {
            this.lexer.nextToken();
            this.accept(Token.EXISTS);
            stmt.setIfExists(true);
        }
        while (true) {
            SQLName name = this.exprParser.name();
            stmt.addPartition(new SQLExprTableSource(name));
            if (this.lexer.token() != Token.COMMA) break;
            this.lexer.nextToken();
        }
        while (true) {
            if (this.identifierEquals("RESTRICT")) {
                this.lexer.nextToken();
                stmt.setRestrict(true);
                continue;
            }
            if (this.identifierEquals("CASCADE")) {
                this.lexer.nextToken();
                stmt.setCascade(true);
                if (!this.identifierEquals("CONSTRAINTS")) continue;
                this.lexer.nextToken();
                continue;
            }
            if (this.lexer.token() != Token.PURGE && !this.identifierEquals("PURGE")) break;
            this.lexer.nextToken();
            stmt.setPurge(true);
        }
        return stmt;
    }

    protected SQLDropSequenceStatement parseDropSequece(boolean acceptDrop) {
        if (acceptDrop) {
            this.accept(Token.DROP);
        }
        this.lexer.nextToken();
        SQLName name = this.exprParser.name();
        SQLDropSequenceStatement stmt = new SQLDropSequenceStatement(this.getDbType());
        stmt.setName(name);
        return stmt;
    }

    protected SQLDropTriggerStatement parseDropTrigger(boolean acceptDrop) {
        if (acceptDrop) {
            this.accept(Token.DROP);
        }
        this.lexer.nextToken();
        SQLName name = this.exprParser.name();
        SQLDropTriggerStatement stmt = new SQLDropTriggerStatement(this.getDbType());
        stmt.setName(name);
        return stmt;
    }

    protected SQLDropViewStatement parseDropView(boolean acceptDrop) {
        if (acceptDrop) {
            this.accept(Token.DROP);
        }
        SQLDropViewStatement stmt = new SQLDropViewStatement(this.getDbType());
        this.accept(Token.VIEW);
        if (this.lexer.token() == Token.IF) {
            this.lexer.nextToken();
            this.accept(Token.EXISTS);
            stmt.setIfExists(true);
        }
        while (true) {
            SQLName name = this.exprParser.name();
            stmt.addPartition(new SQLExprTableSource(name));
            if (this.lexer.token() != Token.COMMA) break;
            this.lexer.nextToken();
        }
        if (this.identifierEquals("RESTRICT")) {
            this.lexer.nextToken();
            stmt.setRestrict(true);
        } else if (this.identifierEquals("CASCADE")) {
            this.lexer.nextToken();
            if (this.identifierEquals("CONSTRAINTS")) {
                this.lexer.nextToken();
            }
            stmt.setCascade(true);
        }
        return stmt;
    }

    protected SQLDropDatabaseStatement parseDropDatabase(boolean acceptDrop) {
        if (acceptDrop) {
            this.accept(Token.DROP);
        }
        SQLDropDatabaseStatement stmt = new SQLDropDatabaseStatement(this.getDbType());
        this.accept(Token.DATABASE);
        if (this.lexer.token() == Token.IF) {
            this.lexer.nextToken();
            this.accept(Token.EXISTS);
            stmt.setIfExists(true);
        }
        SQLName name = this.exprParser.name();
        stmt.setDatabase(name);
        return stmt;
    }

    protected SQLDropFunctionStatement parseDropFunction(boolean acceptDrop) {
        if (acceptDrop) {
            this.accept(Token.DROP);
        }
        SQLDropFunctionStatement stmt = new SQLDropFunctionStatement(this.getDbType());
        this.accept(Token.FUNCTION);
        if (this.lexer.token() == Token.IF) {
            this.lexer.nextToken();
            this.accept(Token.EXISTS);
            stmt.setIfExists(true);
        }
        SQLName name = this.exprParser.name();
        stmt.setName(name);
        return stmt;
    }

    protected SQLDropTableSpaceStatement parseDropTablespace(boolean acceptDrop) {
        SQLDropTableSpaceStatement stmt = new SQLDropTableSpaceStatement(this.getDbType());
        if (this.lexer.isKeepComments() && this.lexer.hasComment()) {
            stmt.addBeforeComment(this.lexer.readAndResetComments());
        }
        if (acceptDrop) {
            this.accept(Token.DROP);
        }
        this.accept(Token.TABLESPACE);
        if (this.lexer.token() == Token.IF) {
            this.lexer.nextToken();
            this.accept(Token.EXISTS);
            stmt.setIfExists(true);
        }
        SQLName name = this.exprParser.name();
        stmt.setName(name);
        return stmt;
    }

    protected SQLDropProcedureStatement parseDropProcedure(boolean acceptDrop) {
        if (acceptDrop) {
            this.accept(Token.DROP);
        }
        SQLDropProcedureStatement stmt = new SQLDropProcedureStatement(this.getDbType());
        this.accept(Token.PROCEDURE);
        if (this.lexer.token() == Token.IF) {
            this.lexer.nextToken();
            this.accept(Token.EXISTS);
            stmt.setIfExists(true);
        }
        SQLName name = this.exprParser.name();
        stmt.setName(name);
        return stmt;
    }

    public SQLStatement parseTruncate() {
        this.accept(Token.TRUNCATE);
        if (this.lexer.token() == Token.TABLE) {
            this.lexer.nextToken();
        }
        SQLTruncateStatement stmt = new SQLTruncateStatement(this.getDbType());
        if (this.lexer.token() == Token.ONLY) {
            this.lexer.nextToken();
            stmt.setOnly(true);
        }
        while (true) {
            SQLName name = this.exprParser.name();
            stmt.addTableSource(name);
            if (this.lexer.token() != Token.COMMA) break;
            this.lexer.nextToken();
        }
        while (true) {
            if (this.lexer.token() == Token.PURGE) {
                this.lexer.nextToken();
                if (this.identifierEquals("SNAPSHOT")) {
                    this.lexer.nextToken();
                    this.acceptIdentifier("LOG");
                    stmt.setPurgeSnapshotLog(true);
                    continue;
                }
                throw new ParserException("TODO : " + (Object)((Object)this.lexer.token()) + " " + this.lexer.stringVal());
            }
            if (this.lexer.token() == Token.RESTART) {
                this.lexer.nextToken();
                this.accept(Token.IDENTITY);
                stmt.setRestartIdentity(Boolean.TRUE);
                continue;
            }
            if (this.lexer.token() == Token.SHARE) {
                this.lexer.nextToken();
                this.accept(Token.IDENTITY);
                stmt.setRestartIdentity(Boolean.FALSE);
                continue;
            }
            if (this.lexer.token() == Token.CASCADE) {
                this.lexer.nextToken();
                stmt.setCascade(Boolean.TRUE);
                continue;
            }
            if (this.lexer.token() == Token.RESTRICT) {
                this.lexer.nextToken();
                stmt.setCascade(Boolean.FALSE);
                continue;
            }
            if (this.lexer.token() == Token.DROP) {
                this.lexer.nextToken();
                this.acceptIdentifier("STORAGE");
                stmt.setDropStorage(true);
                continue;
            }
            if (this.identifierEquals("REUSE")) {
                this.lexer.nextToken();
                this.acceptIdentifier("STORAGE");
                stmt.setReuseStorage(true);
                continue;
            }
            if (this.identifierEquals("IGNORE")) {
                this.lexer.nextToken();
                this.accept(Token.DELETE);
                this.acceptIdentifier("TRIGGERS");
                stmt.setIgnoreDeleteTriggers(true);
                continue;
            }
            if (this.identifierEquals("RESTRICT")) {
                this.lexer.nextToken();
                this.accept(Token.WHEN);
                this.accept(Token.DELETE);
                this.acceptIdentifier("TRIGGERS");
                stmt.setRestrictWhenDeleteTriggers(true);
                continue;
            }
            if (this.lexer.token() == Token.CONTINUE) {
                this.lexer.nextToken();
                this.accept(Token.IDENTITY);
                continue;
            }
            if (!this.identifierEquals("IMMEDIATE")) break;
            this.lexer.nextToken();
            stmt.setImmediate(true);
        }
        return stmt;
    }

    public SQLStatement parseInsert() {
        SQLInsertStatement insertStatement = new SQLInsertStatement();
        if (this.lexer.token() == Token.INSERT) {
            this.accept(Token.INSERT);
        }
        this.parseInsert0(insertStatement);
        return insertStatement;
    }

    protected void parseInsert0(SQLInsertInto insertStatement) {
        this.parseInsert0(insertStatement, true);
    }

    protected void parseInsert0_hinits(SQLInsertInto insertStatement) {
    }

    protected void parseInsert0(SQLInsertInto insertStatement, boolean acceptSubQuery) {
        if (this.lexer.token() == Token.INTO) {
            this.lexer.nextToken();
            SQLName tableName = this.exprParser.name();
            insertStatement.setTableName(tableName);
            if (this.lexer.token() == Token.LITERAL_ALIAS) {
                insertStatement.setAlias(this.as());
            }
            this.parseInsert0_hinits(insertStatement);
            if (this.lexer.token() == Token.IDENTIFIER) {
                insertStatement.setAlias(this.lexer.stringVal());
                this.lexer.nextToken();
            }
        }
        if (this.lexer.token() == Token.LPAREN) {
            this.lexer.nextToken();
            this.parseInsertColumns(insertStatement);
            this.accept(Token.RPAREN);
        }
        if (this.lexer.token() == Token.VALUES) {
            this.lexer.nextToken();
            while (true) {
                this.accept(Token.LPAREN);
                SQLInsertStatement.ValuesClause values = new SQLInsertStatement.ValuesClause();
                this.exprParser.exprList(values.getValues(), values);
                insertStatement.getValuesList().add(values);
                this.accept(Token.RPAREN);
                if (this.lexer.token() == Token.COMMA) {
                    this.lexer.nextToken();
                    continue;
                }
                break;
            }
        } else if (acceptSubQuery && (this.lexer.token() == Token.SELECT || this.lexer.token() == Token.LPAREN)) {
            SQLSelect select = this.createSQLSelectParser().select();
            insertStatement.setQuery(select);
        }
    }

    protected void parseInsertColumns(SQLInsertInto insert) {
        this.exprParser.exprList(insert.getColumns(), insert);
    }

    public boolean parseStatementListDialect(List<SQLStatement> statementList) {
        return false;
    }

    public SQLDropUserStatement parseDropUser() {
        this.accept(Token.USER);
        SQLDropUserStatement stmt = new SQLDropUserStatement(this.getDbType());
        while (true) {
            SQLExpr expr = this.exprParser.expr();
            stmt.addUser(expr);
            if (this.lexer.token() != Token.COMMA) break;
            this.lexer.nextToken();
        }
        return stmt;
    }

    public SQLStatement parseDropIndex() {
        this.accept(Token.INDEX);
        SQLDropIndexStatement stmt = new SQLDropIndexStatement(this.getDbType());
        stmt.setIndexName(this.exprParser.name());
        if (this.lexer.token() == Token.ON) {
            this.lexer.nextToken();
            stmt.setTableName(this.exprParser.name());
        }
        return stmt;
    }

    public SQLCallStatement parseCall() {
        boolean brace = false;
        if (this.lexer.token() == Token.LBRACE) {
            this.lexer.nextToken();
            brace = true;
        }
        SQLCallStatement stmt = new SQLCallStatement(this.getDbType());
        if (this.lexer.token() == Token.QUES) {
            this.lexer.nextToken();
            this.accept(Token.EQ);
            stmt.setOutParameter(new SQLVariantRefExpr("?"));
        }
        this.acceptIdentifier("CALL");
        stmt.setProcedureName(this.exprParser.name());
        if (this.lexer.token() == Token.LPAREN) {
            this.lexer.nextToken();
            this.exprParser.exprList(stmt.getParameters(), stmt);
            this.accept(Token.RPAREN);
        }
        if (brace) {
            this.accept(Token.RBRACE);
            stmt.setBrace(true);
        }
        return stmt;
    }

    public SQLStatement parseSet() {
        this.accept(Token.SET);
        SQLSetStatement stmt = new SQLSetStatement(this.getDbType());
        this.parseAssignItems(stmt.getItems(), stmt);
        return stmt;
    }

    public void parseAssignItems(List<? super SQLAssignItem> items, SQLObject parent) {
        while (true) {
            SQLAssignItem item = this.exprParser.parseAssignItem();
            item.setParent(parent);
            items.add(item);
            if (this.lexer.token() != Token.COMMA) break;
            this.lexer.nextToken();
        }
    }

    public SQLStatement parseCreate() {
        char markChar = this.lexer.current();
        int markBp = this.lexer.bp();
        List<String> comments = null;
        if (this.lexer.isKeepComments() && this.lexer.hasComment()) {
            comments = this.lexer.readAndResetComments();
        }
        this.accept(Token.CREATE);
        Token token = this.lexer.token();
        if (token == Token.TABLE || this.identifierEquals("GLOBAL")) {
            SQLCreateTableParser createTableParser = this.getSQLCreateTableParser();
            SQLCreateTableStatement stmt = createTableParser.parseCrateTable(false);
            if (comments != null) {
                stmt.addBeforeComment(comments);
            }
            return stmt;
        }
        if (token == Token.INDEX || token == Token.UNIQUE || this.identifierEquals("NONCLUSTERED")) {
            return this.parseCreateIndex(false);
        }
        if (this.lexer.token() == Token.SEQUENCE) {
            return this.parseCreateSequence(false);
        }
        if (token == Token.OR) {
            this.lexer.nextToken();
            this.accept(Token.REPLACE);
            if (this.lexer.token() == Token.PROCEDURE) {
                this.lexer.reset(markBp, markChar, Token.CREATE);
                return this.parseCreateProcedure();
            }
            if (this.lexer.token() == Token.VIEW) {
                this.lexer.reset(markBp, markChar, Token.CREATE);
                return this.parseCreateView();
            }
            throw new ParserException("TODO " + (Object)((Object)this.lexer.token()) + " " + this.lexer.stringVal());
        }
        if (token == Token.DATABASE) {
            this.lexer.nextToken();
            if (this.identifierEquals("LINK")) {
                this.lexer.reset(markBp, markChar, Token.CREATE);
                return this.parseCreateDbLink();
            }
            this.lexer.reset(markBp, markChar, Token.CREATE);
            return this.parseCreateDatabase();
        }
        if (this.identifierEquals("PUBLIC") || this.identifierEquals("SHARE")) {
            this.lexer.reset(markBp, markChar, Token.CREATE);
            return this.parseCreateDbLink();
        }
        if (token == Token.VIEW) {
            return this.parseCreateView();
        }
        if (token == Token.TRIGGER) {
            return this.parseCreateTrigger();
        }
        throw new ParserException("TODO " + (Object)((Object)this.lexer.token()));
    }

    public SQLStatement parseCreateDbLink() {
        throw new ParserException("TODO " + (Object)((Object)this.lexer.token()));
    }

    public SQLStatement parseCreateTrigger() {
        List<SQLStatement> body;
        this.accept(Token.TRIGGER);
        SQLCreateTriggerStatement stmt = new SQLCreateTriggerStatement(this.getDbType());
        stmt.setName(this.exprParser.name());
        if (this.identifierEquals("BEFORE")) {
            stmt.setTriggerType(SQLCreateTriggerStatement.TriggerType.BEFORE);
            this.lexer.nextToken();
        } else if (this.identifierEquals("AFTER")) {
            stmt.setTriggerType(SQLCreateTriggerStatement.TriggerType.AFTER);
            this.lexer.nextToken();
        } else if (this.identifierEquals("INSTEAD")) {
            this.lexer.nextToken();
            this.accept(Token.OF);
            stmt.setTriggerType(SQLCreateTriggerStatement.TriggerType.INSTEAD_OF);
        }
        while (true) {
            if (this.lexer.token() == Token.INSERT) {
                this.lexer.nextToken();
                stmt.getTriggerEvents().add(SQLCreateTriggerStatement.TriggerEvent.INSERT);
                continue;
            }
            if (this.lexer.token() == Token.UPDATE) {
                this.lexer.nextToken();
                stmt.getTriggerEvents().add(SQLCreateTriggerStatement.TriggerEvent.UPDATE);
                continue;
            }
            if (this.lexer.token() != Token.DELETE) break;
            this.lexer.nextToken();
            stmt.getTriggerEvents().add(SQLCreateTriggerStatement.TriggerEvent.DELETE);
        }
        this.accept(Token.ON);
        stmt.setOn(this.exprParser.name());
        if (this.lexer.token() == Token.FOR) {
            this.lexer.nextToken();
            this.acceptIdentifier("EACH");
            this.accept(Token.ROW);
            stmt.setForEachRow(true);
        }
        if ((body = this.parseStatementList()) == null || body.isEmpty()) {
            throw new ParserException("syntax error");
        }
        stmt.setBody(body.get(0));
        return stmt;
    }

    public SQLStatement parseBlock() {
        throw new ParserException("TODO " + (Object)((Object)this.lexer.token()));
    }

    public SQLStatement parseCreateDatabase() {
        if (this.lexer.token() == Token.CREATE) {
            this.lexer.nextToken();
        }
        this.accept(Token.DATABASE);
        SQLCreateDatabaseStatement stmt = new SQLCreateDatabaseStatement(this.getDbType());
        stmt.setName(this.exprParser.name());
        return stmt;
    }

    public SQLStatement parseCreateProcedure() {
        throw new ParserException("TODO " + (Object)((Object)this.lexer.token()));
    }

    public SQLStatement parseCreateSequence(boolean acceptCreate) {
        throw new ParserException("TODO " + (Object)((Object)this.lexer.token()));
    }

    public SQLStatement parseCreateIndex(boolean acceptCreate) {
        if (acceptCreate) {
            this.accept(Token.CREATE);
        }
        SQLCreateIndexStatement stmt = new SQLCreateIndexStatement(this.getDbType());
        if (this.lexer.token() == Token.UNIQUE) {
            this.lexer.nextToken();
            if (this.identifierEquals("CLUSTERED")) {
                this.lexer.nextToken();
                stmt.setType("UNIQUE CLUSTERED");
            } else {
                stmt.setType("UNIQUE");
            }
        } else if (this.identifierEquals("FULLTEXT")) {
            stmt.setType("FULLTEXT");
            this.lexer.nextToken();
        } else if (this.identifierEquals("NONCLUSTERED")) {
            stmt.setType("NONCLUSTERED");
            this.lexer.nextToken();
        }
        this.accept(Token.INDEX);
        stmt.setName(this.exprParser.name());
        this.accept(Token.ON);
        stmt.setTable(this.exprParser.name());
        this.accept(Token.LPAREN);
        while (true) {
            SQLSelectOrderByItem item = this.exprParser.parseSelectOrderByItem();
            item.setParent(stmt);
            stmt.addItem(item);
            if (this.lexer.token() != Token.COMMA) break;
            this.lexer.nextToken();
        }
        this.accept(Token.RPAREN);
        return stmt;
    }

    public SQLCreateTableParser getSQLCreateTableParser() {
        return new SQLCreateTableParser(this.exprParser);
    }

    public SQLStatement parseSelect() {
        SQLSelectParser selectParser = this.createSQLSelectParser();
        SQLSelect select = selectParser.select();
        return new SQLSelectStatement(select, this.getDbType());
    }

    public SQLSelectParser createSQLSelectParser() {
        return new SQLSelectParser(this.exprParser);
    }

    public SQLUpdateStatement parseUpdateStatement() {
        SQLUpdateStatement udpateStatement = this.createUpdateStatement();
        if (this.lexer.token() == Token.UPDATE) {
            this.lexer.nextToken();
            SQLTableSource tableSource = this.exprParser.createSelectParser().parseTableSource();
            udpateStatement.setTableSource(tableSource);
        }
        this.parseUpdateSet(udpateStatement);
        if (this.lexer.token() == Token.WHERE) {
            this.lexer.nextToken();
            udpateStatement.setWhere(this.exprParser.expr());
        }
        return udpateStatement;
    }

    protected void parseUpdateSet(SQLUpdateStatement update) {
        this.accept(Token.SET);
        while (true) {
            SQLUpdateSetItem item = this.exprParser.parseUpdateSetItem();
            update.addItem(item);
            if (this.lexer.token() != Token.COMMA) break;
            this.lexer.nextToken();
        }
    }

    protected SQLUpdateStatement createUpdateStatement() {
        return new SQLUpdateStatement(this.getDbType());
    }

    public SQLDeleteStatement parseDeleteStatement() {
        SQLDeleteStatement deleteStatement = new SQLDeleteStatement(this.getDbType());
        if (this.lexer.token() == Token.DELETE) {
            this.lexer.nextToken();
            if (this.lexer.token() == Token.FROM) {
                this.lexer.nextToken();
            }
            if (this.lexer.token() == Token.COMMENT) {
                this.lexer.nextToken();
            }
            SQLName tableName = this.exprParser.name();
            deleteStatement.setTableName(tableName);
            if (this.lexer.token() == Token.FROM) {
                this.lexer.nextToken();
                SQLTableSource tableSource = this.createSQLSelectParser().parseTableSource();
                deleteStatement.setFrom(tableSource);
            }
        }
        if (this.lexer.token() == Token.WHERE) {
            this.lexer.nextToken();
            SQLExpr where = this.exprParser.expr();
            deleteStatement.setWhere(where);
        }
        return deleteStatement;
    }

    public SQLCreateTableStatement parseCreateTable() {
        throw new ParserException("TODO");
    }

    public SQLCreateViewStatement parseCreateView() {
        SQLCreateViewStatement createView = new SQLCreateViewStatement(this.getDbType());
        if (this.lexer.token() == Token.CREATE) {
            this.lexer.nextToken();
        }
        if (this.lexer.token() == Token.OR) {
            this.lexer.nextToken();
            this.accept(Token.REPLACE);
            createView.setOrReplace(true);
        }
        this.accept(Token.VIEW);
        if (this.lexer.token() == Token.IF || this.identifierEquals("IF")) {
            this.lexer.nextToken();
            this.accept(Token.NOT);
            this.accept(Token.EXISTS);
            createView.setIfNotExists(true);
        }
        createView.setName(this.exprParser.name());
        if (this.lexer.token() == Token.LPAREN) {
            this.lexer.nextToken();
            while (true) {
                SQLCreateViewStatement.Column column = new SQLCreateViewStatement.Column();
                SQLExpr expr = this.exprParser.expr();
                column.setExpr(expr);
                if (this.lexer.token() == Token.COMMENT) {
                    this.lexer.nextToken();
                    column.setComment((SQLCharExpr)this.exprParser.primary());
                }
                column.setParent(createView);
                createView.addColumn(column);
                if (this.lexer.token() != Token.COMMA) break;
                this.lexer.nextToken();
            }
            this.accept(Token.RPAREN);
        }
        if (this.lexer.token() == Token.COMMENT) {
            this.lexer.nextToken();
            SQLCharExpr comment = (SQLCharExpr)this.exprParser.primary();
            createView.setComment(comment);
        }
        this.accept(Token.AS);
        createView.setSubQuery(new SQLSelectParser(this.exprParser).select());
        return createView;
    }

    public SQLCommentStatement parseComment() {
        this.accept(Token.COMMENT);
        SQLCommentStatement stmt = new SQLCommentStatement();
        this.accept(Token.ON);
        if (this.lexer.token() == Token.TABLE) {
            stmt.setType(SQLCommentStatement.Type.TABLE);
            this.lexer.nextToken();
        } else if (this.lexer.token() == Token.COLUMN) {
            stmt.setType(SQLCommentStatement.Type.COLUMN);
            this.lexer.nextToken();
        }
        stmt.setOn(this.exprParser.name());
        this.accept(Token.IS);
        stmt.setComment(this.exprParser.expr());
        return stmt;
    }

    protected SQLAlterTableAddColumn parseAlterTableAddColumn() {
        boolean odps = "odps".equals(this.dbType);
        if (odps) {
            this.acceptIdentifier("COLUMNS");
            this.accept(Token.LPAREN);
        }
        SQLAlterTableAddColumn item = new SQLAlterTableAddColumn();
        do {
            SQLColumnDefinition columnDef = this.exprParser.parseColumn();
            item.addColumn(columnDef);
            if (this.lexer.token() != Token.COMMA) break;
            this.lexer.nextToken();
        } while (!this.identifierEquals("ADD"));
        if (odps) {
            this.accept(Token.RPAREN);
        }
        return item;
    }

    public SQLStatement parseStatement() {
        ArrayList<SQLStatement> list = new ArrayList<SQLStatement>();
        this.parseStatementList(list, 1);
        return (SQLStatement)list.get(0);
    }

    public SQLExplainStatement parseExplain() {
        this.accept(Token.EXPLAIN);
        if (this.identifierEquals("PLAN")) {
            this.lexer.nextToken();
        }
        if (this.lexer.token() == Token.FOR) {
            this.lexer.nextToken();
        }
        SQLExplainStatement explain = new SQLExplainStatement(this.getDbType());
        if (this.lexer.token == Token.HINT) {
            explain.setHints(this.exprParser.parseHints());
        }
        explain.setStatement(this.parseStatement());
        return explain;
    }

    protected SQLAlterTableAddIndex parseAlterTableAddIndex() {
        SQLAlterTableAddIndex item = new SQLAlterTableAddIndex();
        if (this.lexer.token() == Token.UNIQUE) {
            item.setUnique(true);
            this.lexer.nextToken();
            if (this.lexer.token() == Token.INDEX) {
                this.lexer.nextToken();
            } else if (this.lexer.token() == Token.KEY) {
                item.setKey(true);
                this.lexer.nextToken();
            }
        } else if (this.lexer.token() == Token.INDEX) {
            this.accept(Token.INDEX);
        } else if (this.lexer.token() == Token.KEY) {
            item.setKey(true);
            this.accept(Token.KEY);
        }
        if (this.lexer.token() == Token.LPAREN) {
            this.lexer.nextToken();
        } else {
            item.setName(this.exprParser.name());
            this.accept(Token.LPAREN);
        }
        while (true) {
            SQLSelectOrderByItem column = this.exprParser.parseSelectOrderByItem();
            item.addItem(column);
            if (this.lexer.token() != Token.COMMA) break;
            this.lexer.nextToken();
        }
        this.accept(Token.RPAREN);
        return item;
    }

    public SQLOpenStatement parseOpen() {
        SQLOpenStatement stmt = new SQLOpenStatement();
        this.accept(Token.OPEN);
        stmt.setCursorName(this.exprParser.name().getSimpleName());
        this.accept(Token.SEMI);
        return stmt;
    }

    public SQLFetchStatement parseFetch() {
        this.accept(Token.FETCH);
        SQLFetchStatement stmt = new SQLFetchStatement();
        stmt.setCursorName(this.exprParser.name());
        this.accept(Token.INTO);
        while (true) {
            stmt.getInto().add(this.exprParser.name());
            if (this.lexer.token() != Token.COMMA) break;
            this.lexer.nextToken();
        }
        return stmt;
    }

    public SQLStatement parseClose() {
        SQLCloseStatement stmt = new SQLCloseStatement();
        this.accept(Token.CLOSE);
        stmt.setCursorName(this.exprParser.name().getSimpleName());
        this.accept(Token.SEMI);
        return stmt;
    }

    public boolean isParseCompleteValues() {
        return this.parseCompleteValues;
    }

    public void setParseCompleteValues(boolean parseCompleteValues) {
        this.parseCompleteValues = parseCompleteValues;
    }

    public int getParseValuesSize() {
        return this.parseValuesSize;
    }

    public void setParseValuesSize(int parseValuesSize) {
        this.parseValuesSize = parseValuesSize;
    }

    public SQLMergeStatement parseMerge() {
        this.accept(Token.MERGE);
        SQLMergeStatement stmt = new SQLMergeStatement();
        this.parseHints(stmt.getHints());
        this.accept(Token.INTO);
        if (this.lexer.token() == Token.LPAREN) {
            this.lexer.nextToken();
            SQLSelect select = this.createSQLSelectParser().select();
            SQLSubqueryTableSource tableSource = new SQLSubqueryTableSource(select);
            stmt.setInto(tableSource);
            this.accept(Token.RPAREN);
        } else {
            stmt.setInto(this.exprParser.name());
        }
        stmt.setAlias(this.as());
        this.accept(Token.USING);
        SQLTableSource using = this.createSQLSelectParser().parseTableSource();
        stmt.setUsing(using);
        this.accept(Token.ON);
        stmt.setOn(this.exprParser.expr());
        boolean insertFlag = false;
        if (this.lexer.token() == Token.WHEN) {
            this.lexer.nextToken();
            if (this.lexer.token() == Token.MATCHED) {
                SQLMergeStatement.MergeUpdateClause updateClause = new SQLMergeStatement.MergeUpdateClause();
                this.lexer.nextToken();
                this.accept(Token.THEN);
                this.accept(Token.UPDATE);
                this.accept(Token.SET);
                while (true) {
                    SQLUpdateSetItem item = this.exprParser.parseUpdateSetItem();
                    updateClause.addItem(item);
                    item.setParent(updateClause);
                    if (this.lexer.token() != Token.COMMA) break;
                    this.lexer.nextToken();
                }
                if (this.lexer.token() == Token.WHERE) {
                    this.lexer.nextToken();
                    updateClause.setWhere(this.exprParser.expr());
                }
                if (this.lexer.token() == Token.DELETE) {
                    this.lexer.nextToken();
                    this.accept(Token.WHERE);
                    updateClause.setWhere(this.exprParser.expr());
                }
                stmt.setUpdateClause(updateClause);
            } else if (this.lexer.token() == Token.NOT) {
                this.lexer.nextToken();
                insertFlag = true;
            }
        }
        if (!insertFlag) {
            if (this.lexer.token() == Token.WHEN) {
                this.lexer.nextToken();
            }
            if (this.lexer.token() == Token.NOT) {
                this.lexer.nextToken();
                insertFlag = true;
            }
        }
        if (insertFlag) {
            SQLMergeStatement.MergeInsertClause insertClause = new SQLMergeStatement.MergeInsertClause();
            this.accept(Token.MATCHED);
            this.accept(Token.THEN);
            this.accept(Token.INSERT);
            if (this.lexer.token() == Token.LPAREN) {
                this.accept(Token.LPAREN);
                this.exprParser.exprList(insertClause.getColumns(), insertClause);
                this.accept(Token.RPAREN);
            }
            this.accept(Token.VALUES);
            this.accept(Token.LPAREN);
            this.exprParser.exprList(insertClause.getValues(), insertClause);
            this.accept(Token.RPAREN);
            if (this.lexer.token() == Token.WHERE) {
                this.lexer.nextToken();
                insertClause.setWhere(this.exprParser.expr());
            }
            stmt.setInsertClause(insertClause);
        }
        SQLErrorLoggingClause errorClause = this.parseErrorLoggingClause();
        stmt.setErrorLoggingClause(errorClause);
        return stmt;
    }

    protected SQLErrorLoggingClause parseErrorLoggingClause() {
        if (this.identifierEquals("LOG")) {
            SQLErrorLoggingClause errorClause = new SQLErrorLoggingClause();
            this.lexer.nextToken();
            this.accept(Token.ERRORS);
            if (this.lexer.token() == Token.INTO) {
                this.lexer.nextToken();
                errorClause.setInto(this.exprParser.name());
            }
            if (this.lexer.token() == Token.LPAREN) {
                this.lexer.nextToken();
                errorClause.setSimpleExpression(this.exprParser.expr());
                this.accept(Token.RPAREN);
            }
            if (this.lexer.token() == Token.REJECT) {
                this.lexer.nextToken();
                this.accept(Token.LIMIT);
                errorClause.setLimit(this.exprParser.expr());
            }
            return errorClause;
        }
        return null;
    }

    public void parseHints(List<SQLHint> hints) {
        this.getExprParser().parseHints(hints);
    }
}

