/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.druid.sql.dialect.teradata.parser;

import com.alibaba.druid.sql.ast.SQLExpr;
import com.alibaba.druid.sql.ast.SQLName;
import com.alibaba.druid.sql.ast.SQLStatement;
import com.alibaba.druid.sql.ast.expr.SQLCharExpr;
import com.alibaba.druid.sql.ast.expr.SQLIntegerExpr;
import com.alibaba.druid.sql.ast.expr.SQLNCharExpr;
import com.alibaba.druid.sql.ast.statement.SQLInsertStatement;
import com.alibaba.druid.sql.ast.statement.SQLSelect;
import com.alibaba.druid.sql.ast.statement.SQLSelectStatement;
import com.alibaba.druid.sql.dialect.teradata.ast.stmt.TeradataInsertStatement;
import com.alibaba.druid.sql.dialect.teradata.parser.TeradataExprParser;
import com.alibaba.druid.sql.dialect.teradata.parser.TeradataSelectParser;
import com.alibaba.druid.sql.parser.Lexer;
import com.alibaba.druid.sql.parser.ParserException;
import com.alibaba.druid.sql.parser.SQLStatementParser;
import com.alibaba.druid.sql.parser.Token;
import java.util.ArrayList;
import java.util.List;

public class TeradataStatementParser
extends SQLStatementParser {
    public TeradataStatementParser(String sql) {
        super(new TeradataExprParser(sql));
    }

    public TeradataStatementParser(Lexer lexer) {
        super(new TeradataExprParser(lexer));
    }

    @Override
    public TeradataExprParser getExprParser() {
        return (TeradataExprParser)this.exprParser;
    }

    @Override
    public TeradataSelectParser createSQLSelectParser() {
        return new TeradataSelectParser(this.exprParser);
    }

    @Override
    public SQLSelectStatement parseSelect() {
        TeradataSelectParser selectParser = new TeradataSelectParser(this.exprParser);
        return new SQLSelectStatement(selectParser.select(), "teradata");
    }

    @Override
    public SQLInsertStatement parseInsert() {
        SQLSelect select;
        TeradataInsertStatement insertStatement = new TeradataInsertStatement();
        if (this.lexer.token() == Token.INSERT) {
            this.lexer.nextToken();
            if (this.lexer.token() == Token.INTO) {
                this.lexer.nextToken();
            }
            SQLName tableName = this.exprParser.name();
            insertStatement.setTableName(tableName);
            if (this.lexer.token() == Token.IDENTIFIER && !this.identifierEquals("VALUE")) {
                insertStatement.setAlias(this.lexer.stringVal());
                this.lexer.nextToken();
            }
        }
        int columnSize = 0;
        if (this.lexer.token() == Token.LPAREN) {
            this.lexer.nextToken();
            if (this.lexer.token() == Token.SELECT) {
                select = this.exprParser.createSelectParser().select();
                select.setParent(insertStatement);
                insertStatement.setQuery(select);
            } else {
                this.exprParser.exprList(insertStatement.getColumns(), insertStatement);
                columnSize = insertStatement.getColumns().size();
            }
            this.accept(Token.RPAREN);
        }
        if (this.lexer.token() == Token.VALUES || this.identifierEquals("VALUE")) {
            this.lexer.nextTokenLParen();
            this.parseValueClause(insertStatement.getValuesList(), columnSize);
        } else if (this.lexer.token() == Token.SET) {
            this.lexer.nextToken();
            SQLInsertStatement.ValuesClause values = new SQLInsertStatement.ValuesClause();
            insertStatement.getValuesList().add(values);
            while (true) {
                SQLName name = this.exprParser.name();
                insertStatement.addColumn(name);
                if (this.lexer.token() == Token.EQ) {
                    this.lexer.nextToken();
                } else {
                    this.accept(Token.COLONEQ);
                }
                values.addValue(this.exprParser.expr());
                if (this.lexer.token() == Token.COMMA) {
                    this.lexer.nextToken();
                    continue;
                }
                break;
            }
        } else if (this.lexer.token() == Token.SELECT || this.lexer.token() == Token.SEL) {
            select = this.exprParser.createSelectParser().select();
            select.setParent(insertStatement);
            insertStatement.setQuery(select);
        } else if (this.lexer.token() == Token.LPAREN) {
            this.lexer.nextToken();
            select = this.exprParser.createSelectParser().select();
            select.setParent(insertStatement);
            insertStatement.setQuery(select);
            this.accept(Token.RPAREN);
        }
        return insertStatement;
    }

    private void parseValueClause(List<SQLInsertStatement.ValuesClause> valueClauseList, int columnSize) {
        while (true) {
            if (this.lexer.token() != Token.LPAREN) {
                throw new ParserException("syntax error, expect ')'");
            }
            this.lexer.nextTokenValue();
            if (this.lexer.token() != Token.RPAREN) {
                ArrayList<SQLExpr> valueExprList = columnSize > 0 ? new ArrayList(columnSize) : new ArrayList<SQLExpr>();
                while (true) {
                    SQLExpr expr;
                    if (this.lexer.token() == Token.LITERAL_INT) {
                        expr = new SQLIntegerExpr(this.lexer.integerValue());
                        this.lexer.nextTokenComma();
                    } else if (this.lexer.token() == Token.LITERAL_CHARS) {
                        expr = new SQLCharExpr(this.lexer.stringVal());
                        this.lexer.nextTokenComma();
                    } else if (this.lexer.token() == Token.LITERAL_NCHARS) {
                        expr = new SQLNCharExpr(this.lexer.stringVal());
                        this.lexer.nextTokenComma();
                    } else {
                        expr = this.exprParser.expr();
                    }
                    if (this.lexer.token() == Token.COMMA) {
                        valueExprList.add(expr);
                        this.lexer.nextTokenValue();
                        continue;
                    }
                    if (this.lexer.token() == Token.RPAREN) {
                        valueExprList.add(expr);
                        break;
                    }
                    expr = this.exprParser.primaryRest(expr);
                    if (this.lexer.token() != Token.COMMA && this.lexer.token() != Token.RPAREN) {
                        expr = this.exprParser.exprRest(expr);
                    }
                    valueExprList.add(expr);
                    if (this.lexer.token() != Token.COMMA) break;
                    this.lexer.nextToken();
                }
                SQLInsertStatement.ValuesClause values = new SQLInsertStatement.ValuesClause(valueExprList);
                valueClauseList.add(values);
            } else {
                SQLInsertStatement.ValuesClause values = new SQLInsertStatement.ValuesClause(new ArrayList<SQLExpr>(0));
                valueClauseList.add(values);
            }
            if (this.lexer.token() != Token.RPAREN) {
                throw new ParserException("syntax error");
            }
            if (!this.parseCompleteValues && valueClauseList.size() >= this.parseValuesSize) {
                this.lexer.skipToEOF();
                break;
            }
            this.lexer.nextTokenComma();
            if (this.lexer.token() != Token.COMMA) break;
            this.lexer.nextTokenLParen();
        }
    }

    @Override
    public void parseStatementList(List<SQLStatement> statementList, int max) {
        while (max == -1 || statementList.size() < max) {
            if (this.lexer.token() == Token.EOF) {
                return;
            }
            if (this.lexer.token() == Token.END) {
                return;
            }
            if (this.lexer.token() == Token.ELSE) {
                return;
            }
            if (this.lexer.token() == Token.SEMI) {
                this.lexer.nextToken();
                continue;
            }
            if (this.lexer.token() == Token.SELECT) {
                statementList.add(this.parseSelect());
                continue;
            }
            super.parseStatementList(statementList, max);
        }
        return;
    }

    @Override
    public boolean parseStatementListDialect(List<SQLStatement> statementList) {
        if (this.lexer.token() == Token.SEL) {
            statementList.add(this.parseSelect());
            return true;
        }
        return false;
    }
}

