/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.druid.wall.spi;

import com.alibaba.druid.sql.SQLUtils;
import com.alibaba.druid.sql.ast.SQLName;
import com.alibaba.druid.sql.ast.SQLObject;
import com.alibaba.druid.sql.ast.SQLStatement;
import com.alibaba.druid.sql.ast.expr.SQLBinaryOpExpr;
import com.alibaba.druid.sql.ast.expr.SQLInListExpr;
import com.alibaba.druid.sql.ast.expr.SQLMethodInvokeExpr;
import com.alibaba.druid.sql.ast.expr.SQLNumericLiteralExpr;
import com.alibaba.druid.sql.ast.expr.SQLPropertyExpr;
import com.alibaba.druid.sql.ast.expr.SQLVariantRefExpr;
import com.alibaba.druid.sql.ast.statement.SQLCallStatement;
import com.alibaba.druid.sql.ast.statement.SQLDeleteStatement;
import com.alibaba.druid.sql.ast.statement.SQLExprTableSource;
import com.alibaba.druid.sql.ast.statement.SQLInsertStatement;
import com.alibaba.druid.sql.ast.statement.SQLSelectGroupByClause;
import com.alibaba.druid.sql.ast.statement.SQLSelectQueryBlock;
import com.alibaba.druid.sql.ast.statement.SQLSelectStatement;
import com.alibaba.druid.sql.ast.statement.SQLTruncateStatement;
import com.alibaba.druid.sql.ast.statement.SQLUnionQuery;
import com.alibaba.druid.sql.ast.statement.SQLUpdateStatement;
import com.alibaba.druid.sql.dialect.mysql.ast.expr.MySqlOutFileExpr;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlDeleteStatement;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlInsertStatement;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlSelectGroupBy;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlSelectQueryBlock;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlUpdateStatement;
import com.alibaba.druid.sql.dialect.mysql.visitor.MySqlASTVisitor;
import com.alibaba.druid.sql.dialect.mysql.visitor.MySqlASTVisitorAdapter;
import com.alibaba.druid.wall.Violation;
import com.alibaba.druid.wall.WallConfig;
import com.alibaba.druid.wall.WallProvider;
import com.alibaba.druid.wall.WallVisitor;
import com.alibaba.druid.wall.spi.WallVisitorUtils;
import com.alibaba.druid.wall.violation.IllegalSQLObjectViolation;
import java.util.ArrayList;
import java.util.List;

public class MySqlWallVisitor
extends MySqlASTVisitorAdapter
implements WallVisitor,
MySqlASTVisitor {
    private final WallConfig config;
    private final WallProvider provider;
    private final List<Violation> violations = new ArrayList<Violation>();

    public MySqlWallVisitor(WallProvider provider) {
        this.config = provider.getConfig();
        this.provider = provider;
    }

    @Override
    public WallProvider getProvider() {
        return this.provider;
    }

    @Override
    public WallConfig getConfig() {
        return this.config;
    }

    @Override
    public List<Violation> getViolations() {
        return this.violations;
    }

    @Override
    public boolean visit(SQLPropertyExpr x) {
        WallVisitorUtils.check((WallVisitor)this, x);
        return true;
    }

    @Override
    public boolean visit(SQLInListExpr x) {
        WallVisitorUtils.check((WallVisitor)this, x);
        return true;
    }

    @Override
    public boolean visit(SQLBinaryOpExpr x) {
        WallVisitorUtils.check((WallVisitor)this, x);
        return true;
    }

    @Override
    public boolean visit(SQLSelectQueryBlock x) {
        WallVisitorUtils.checkSelelct(this, x);
        return true;
    }

    @Override
    public boolean visit(MySqlSelectQueryBlock x) {
        WallVisitorUtils.checkSelelct(this, x);
        return true;
    }

    @Override
    public boolean visit(SQLSelectGroupByClause x) {
        WallVisitorUtils.checkHaving(this, x.getHaving());
        return true;
    }

    @Override
    public boolean visit(MySqlSelectGroupBy x) {
        WallVisitorUtils.checkHaving(this, x.getHaving());
        return true;
    }

    @Override
    public boolean visit(MySqlDeleteStatement x) {
        WallVisitorUtils.checkReadOnly(this, x.getFrom());
        return this.visit((SQLDeleteStatement)x);
    }

    @Override
    public boolean visit(SQLDeleteStatement x) {
        WallVisitorUtils.checkDelete(this, x);
        return true;
    }

    @Override
    public boolean visit(MySqlUpdateStatement x) {
        return this.visit((SQLUpdateStatement)x);
    }

    @Override
    public boolean visit(SQLUpdateStatement x) {
        WallVisitorUtils.checkUpdate(this, x);
        return true;
    }

    @Override
    public boolean visit(MySqlInsertStatement x) {
        return this.visit((SQLInsertStatement)x);
    }

    @Override
    public boolean visit(SQLInsertStatement x) {
        WallVisitorUtils.checkInsert(this, x);
        return true;
    }

    @Override
    public boolean visit(SQLSelectStatement x) {
        if (!this.config.isSelelctAllow()) {
            this.getViolations().add(new IllegalSQLObjectViolation(this.toSQL(x)));
            return false;
        }
        return true;
    }

    @Override
    public boolean visit(MySqlSelectQueryBlock.Limit x) {
        int rowCount;
        if (x.getRowCount() instanceof SQLNumericLiteralExpr && (rowCount = ((SQLNumericLiteralExpr)x.getRowCount()).getNumber().intValue()) == 0) {
            this.getViolations().add(new IllegalSQLObjectViolation(this.toSQL(x)));
        }
        return true;
    }

    @Override
    public boolean visit(SQLVariantRefExpr x) {
        String varName = x.getName();
        if (varName == null) {
            return false;
        }
        if (this.config.isVariantCheck() && varName.startsWith("@@")) {
            this.violations.add(new IllegalSQLObjectViolation(this.toSQL(x)));
        }
        return false;
    }

    @Override
    public boolean visit(SQLMethodInvokeExpr x) {
        WallVisitorUtils.checkFunction(this, x);
        return true;
    }

    @Override
    public boolean visit(SQLExprTableSource x) {
        WallVisitorUtils.check((WallVisitor)this, x);
        return !(x.getExpr() instanceof SQLName);
    }

    @Override
    public boolean visit(MySqlOutFileExpr x) {
        if (!this.config.isSelectIntoOutfileAllow()) {
            this.violations.add(new IllegalSQLObjectViolation(this.toSQL(x)));
        }
        return true;
    }

    @Override
    public boolean visit(SQLUnionQuery x) {
        WallVisitorUtils.checkUnion(this, x);
        return true;
    }

    @Override
    public String toSQL(SQLObject obj) {
        return SQLUtils.toMySqlString(obj);
    }

    @Override
    public boolean isPermitTable(String name) {
        if (!this.config.isTableCheck()) {
            return false;
        }
        name = WallVisitorUtils.form(name);
        return this.config.getPermitTables().contains(name);
    }

    @Override
    public void preVisit(SQLObject x) {
        if (!(x instanceof SQLStatement)) {
            return;
        }
        if (this.config.isNoneBaseStatementAllow()) {
            return;
        }
        boolean allow = false;
        if (x instanceof SQLInsertStatement) {
            allow = true;
        } else if (x instanceof SQLSelectStatement) {
            allow = true;
        } else if (x instanceof SQLDeleteStatement) {
            allow = true;
        } else if (x instanceof SQLUpdateStatement) {
            allow = true;
        } else if (x instanceof SQLCallStatement) {
            allow = true;
        } else if (x instanceof SQLTruncateStatement) {
            allow = this.config.isTruncateAllow();
        }
        if (!allow) {
            this.violations.add(new IllegalSQLObjectViolation(this.toSQL(x)));
        }
    }
}

