/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.druid.util;

import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;

public class DaemonThreadFactory
implements ThreadFactory {
    private AtomicInteger threadNo = new AtomicInteger(1);
    private final String nameStart;
    private final String nameEnd = "]";

    public DaemonThreadFactory(String poolName) {
        this.nameStart = "[" + poolName + "-";
    }

    @Override
    public Thread newThread(Runnable r) {
        Thread newThread = new Thread(r, this.nameStart + this.threadNo.getAndIncrement() + "]");
        newThread.setDaemon(true);
        if (newThread.getPriority() != 5) {
            newThread.setPriority(5);
        }
        return newThread;
    }
}

