/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.druid.support.profile;

import com.alibaba.druid.support.profile.ProfileEntryKey;
import com.alibaba.druid.support.profile.ProfileEntryReqStat;
import com.alibaba.druid.support.profile.ProfileEntryStat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class ProfileStat {
    private Map<ProfileEntryKey, ProfileEntryStat> entries = new LinkedHashMap<ProfileEntryKey, ProfileEntryStat>(4);
    private ReadWriteLock lock = new ReentrantReadWriteLock();

    public Map<ProfileEntryKey, ProfileEntryStat> getEntries() {
        return this.entries;
    }

    public void record(Map<ProfileEntryKey, ProfileEntryReqStat> requestStatsMap) {
        if (requestStatsMap == null) {
            return;
        }
        for (Map.Entry<ProfileEntryKey, ProfileEntryReqStat> entry : requestStatsMap.entrySet()) {
            ProfileEntryKey entryKey = entry.getKey();
            ProfileEntryReqStat reqEntryStat = entry.getValue();
            ProfileEntryStat entryStat = this.getProfileEntry(entryKey);
            entryStat.addExecuteCount(reqEntryStat.getExecuteCount());
            entryStat.addExecuteTimeNanos(reqEntryStat.getExecuteTimeNanos());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ProfileEntryStat getProfileEntry(ProfileEntryKey entryKey) {
        ProfileEntryStat entryStat;
        this.lock.readLock().lock();
        try {
            entryStat = this.entries.get(entryKey);
            if (entryStat != null) {
                ProfileEntryStat profileEntryStat = entryStat;
                return profileEntryStat;
            }
        }
        finally {
            this.lock.readLock().unlock();
        }
        this.lock.writeLock().lock();
        try {
            entryStat = this.entries.get(entryKey);
            if (entryStat == null) {
                this.entries.put(entryKey, new ProfileEntryStat());
                entryStat = this.entries.get(entryKey);
            }
            ProfileEntryStat profileEntryStat = entryStat;
            return profileEntryStat;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Map<String, Object>> getStatData() {
        ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
        this.lock.readLock().lock();
        try {
            for (Map.Entry<ProfileEntryKey, ProfileEntryStat> entry : this.entries.entrySet()) {
                LinkedHashMap<String, Object> entryData = new LinkedHashMap<String, Object>();
                entryData.put("Name", entry.getKey().getName());
                entryData.put("Parent", entry.getKey().getParentName());
                entryData.put("Type", entry.getKey().getType());
                entryData.put("ExecuteCount", entry.getValue().getExecuteCount());
                entryData.put("ExecuteTimeMillis", entry.getValue().getExecuteTimeNanos() / 1000L / 1000L);
                list.add(entryData);
            }
        }
        finally {
            this.lock.readLock().unlock();
        }
        Collections.reverse(list);
        return list;
    }
}

