/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.druid.stat;

import com.alibaba.druid.VERSION;
import com.alibaba.druid.pool.DruidDataSource;
import com.alibaba.druid.stat.DruidDataSourceStatManager;
import com.alibaba.druid.stat.JdbcStatManager;
import com.alibaba.druid.support.http.stat.WebAppStatManager;
import com.alibaba.druid.support.spring.stat.SpringStatManager;
import com.alibaba.druid.util.DruidDataSourceUtils;
import com.alibaba.druid.util.JdbcSqlStatUtils;
import com.alibaba.druid.util.StringUtils;
import java.lang.management.ManagementFactory;
import java.sql.Driver;
import java.sql.DriverManager;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;

public final class DruidStatManagerFacade {
    private static final DruidStatManagerFacade instance = new DruidStatManagerFacade();
    private boolean resetEnable = true;
    private final AtomicLong resetCount = new AtomicLong();

    private DruidStatManagerFacade() {
    }

    public static DruidStatManagerFacade getInstance() {
        return instance;
    }

    private Set<Object> getDruidDataSourceInstances() {
        return DruidDataSourceStatManager.getInstances().keySet();
    }

    public Object getDruidDataSourceByName(String name) {
        for (Object o : this.getDruidDataSourceInstances()) {
            String itemName = DruidDataSourceUtils.getName(o);
            if (!StringUtils.equals(name, itemName)) continue;
            return o;
        }
        return null;
    }

    public void resetDataSourceStat() {
        DruidDataSourceStatManager.getInstance().reset();
    }

    public void resetSqlStat() {
        JdbcStatManager.getInstance().reset();
    }

    public void resetAll() {
        if (!this.isResetEnable()) {
            return;
        }
        SpringStatManager.getInstance().resetStat();
        WebAppStatManager.getInstance().resetStat();
        this.resetSqlStat();
        this.resetDataSourceStat();
        this.resetCount.incrementAndGet();
    }

    public boolean isResetEnable() {
        return this.resetEnable;
    }

    public void setResetEnable(boolean resetEnable) {
        this.resetEnable = resetEnable;
    }

    public Object getSqlStatById(Integer id) {
        for (Object ds : this.getDruidDataSourceInstances()) {
            Object sqlStat = DruidDataSourceUtils.getSqlStat(ds, id);
            if (sqlStat == null) continue;
            return sqlStat;
        }
        return null;
    }

    public Map<String, Object> getDataSourceStatData(Integer id) {
        if (id == null) {
            return null;
        }
        Object datasource = this.getDruidDataSourceById(id);
        return datasource == null ? null : this.dataSourceToMapData(datasource, false);
    }

    public Object getDruidDataSourceById(Integer identity) {
        if (identity == null) {
            return null;
        }
        for (Object datasource : this.getDruidDataSourceInstances()) {
            if (System.identityHashCode(datasource) != identity) continue;
            return datasource;
        }
        return null;
    }

    public List<Map<String, Object>> getSqlStatDataList(Integer dataSourceId) {
        Set<Object> dataSources = this.getDruidDataSourceInstances();
        if (dataSourceId == null) {
            ArrayList<Map<String, Object>> sqlList = new ArrayList<Map<String, Object>>();
            for (Object datasource : dataSources) {
                sqlList.addAll(this.getSqlStatDataList(datasource));
            }
            return sqlList;
        }
        for (Object datasource : dataSources) {
            if (dataSourceId != null && dataSourceId != System.identityHashCode(datasource)) continue;
            return this.getSqlStatDataList(datasource);
        }
        return new ArrayList<Map<String, Object>>();
    }

    public List<Map<String, Object>> getSqlStatDataList(Object datasource) {
        ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>();
        Map sqlStatMap = DruidDataSourceUtils.getSqlStatMap(datasource);
        for (Object sqlStat : sqlStatMap.values()) {
            Map<String, Object> data = JdbcSqlStatUtils.getData(sqlStat);
            long executeCount = (Long)data.get("ExecuteCount");
            long runningCount = (Long)data.get("RunningCount");
            if (executeCount == 0L && runningCount == 0L) continue;
            result.add(data);
        }
        return result;
    }

    public Map<String, Object> getSqlStatData(Integer id) {
        if (id == null) {
            return null;
        }
        Object sqlStat = this.getSqlStatById(id);
        if (sqlStat == null) {
            return null;
        }
        return JdbcSqlStatUtils.getData(sqlStat);
    }

    public List<Map<String, Object>> getDataSourceStatDataList() {
        return this.getDataSourceStatDataList(false);
    }

    public List<Map<String, Object>> getDataSourceStatDataList(boolean includeSqlList) {
        ArrayList<Map<String, Object>> datasourceList = new ArrayList<Map<String, Object>>();
        for (Object dataSource : this.getDruidDataSourceInstances()) {
            datasourceList.add(this.dataSourceToMapData(dataSource, includeSqlList));
        }
        return datasourceList;
    }

    public List<List<String>> getActiveConnStackTraceList() {
        ArrayList<List<String>> traceList = new ArrayList<List<String>>();
        for (Object dataSource : this.getDruidDataSourceInstances()) {
            List<String> stacks = ((DruidDataSource)dataSource).getActiveConnectionStackTrace();
            if (stacks.size() <= 0) continue;
            traceList.add(stacks);
        }
        return traceList;
    }

    public Map<String, Object> returnJSONBasicStat() {
        LinkedHashMap<String, Object> dataMap = new LinkedHashMap<String, Object>();
        dataMap.put("Version", VERSION.getVersionNumber());
        dataMap.put("Drivers", this.getDriversData());
        dataMap.put("ResetEnable", this.isResetEnable());
        dataMap.put("ResetCount", this.getResetCount());
        dataMap.put("JavaVMName", System.getProperty("java.vm.name"));
        dataMap.put("JavaVersion", System.getProperty("java.version"));
        dataMap.put("JavaClassPath", System.getProperty("java.class.path"));
        dataMap.put("StartTime", new Date(ManagementFactory.getRuntimeMXBean().getStartTime()));
        return dataMap;
    }

    public long getResetCount() {
        return this.resetCount.get();
    }

    private List<String> getDriversData() {
        ArrayList<String> drivers = new ArrayList<String>();
        Enumeration<Driver> e = DriverManager.getDrivers();
        while (e.hasMoreElements()) {
            Driver driver = e.nextElement();
            drivers.add(driver.getClass().getName());
        }
        return drivers;
    }

    public List<Map<String, Object>> getPoolingConnectionInfoByDataSourceId(Integer id) {
        Object datasource = this.getDruidDataSourceById(id);
        if (datasource == null) {
            return null;
        }
        return DruidDataSourceUtils.getPoolingConnectionInfo(datasource);
    }

    public List<String> getActiveConnectionStackTraceByDataSourceId(Integer id) {
        Object datasource = this.getDruidDataSourceById(id);
        if (datasource == null || !DruidDataSourceUtils.isRemoveAbandoned(datasource)) {
            return null;
        }
        return DruidDataSourceUtils.getActiveConnectionStackTrace(datasource);
    }

    private Map<String, Object> dataSourceToMapData(Object dataSource, boolean includeSql) {
        Map<String, Object> map = DruidDataSourceUtils.getStatData(dataSource);
        if (includeSql) {
            List<Map<String, Object>> sqlList = this.getSqlStatDataList(dataSource);
            map.put("SQL", sqlList);
        }
        return map;
    }
}

