/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.druid.sql.parser;

import com.alibaba.druid.sql.ast.SQLCommentHint;
import com.alibaba.druid.sql.ast.SQLDataType;
import com.alibaba.druid.sql.ast.SQLDataTypeImpl;
import com.alibaba.druid.sql.ast.SQLExpr;
import com.alibaba.druid.sql.ast.SQLName;
import com.alibaba.druid.sql.ast.SQLOrderBy;
import com.alibaba.druid.sql.ast.SQLOrderingSpecification;
import com.alibaba.druid.sql.ast.SQLOver;
import com.alibaba.druid.sql.ast.expr.SQLAggregateExpr;
import com.alibaba.druid.sql.ast.expr.SQLAllColumnExpr;
import com.alibaba.druid.sql.ast.expr.SQLAllExpr;
import com.alibaba.druid.sql.ast.expr.SQLAnyExpr;
import com.alibaba.druid.sql.ast.expr.SQLBetweenExpr;
import com.alibaba.druid.sql.ast.expr.SQLBinaryOpExpr;
import com.alibaba.druid.sql.ast.expr.SQLBinaryOperator;
import com.alibaba.druid.sql.ast.expr.SQLCaseExpr;
import com.alibaba.druid.sql.ast.expr.SQLCastExpr;
import com.alibaba.druid.sql.ast.expr.SQLCharExpr;
import com.alibaba.druid.sql.ast.expr.SQLCurrentOfCursorExpr;
import com.alibaba.druid.sql.ast.expr.SQLDefaultExpr;
import com.alibaba.druid.sql.ast.expr.SQLExistsExpr;
import com.alibaba.druid.sql.ast.expr.SQLHexExpr;
import com.alibaba.druid.sql.ast.expr.SQLIdentifierExpr;
import com.alibaba.druid.sql.ast.expr.SQLInListExpr;
import com.alibaba.druid.sql.ast.expr.SQLInSubQueryExpr;
import com.alibaba.druid.sql.ast.expr.SQLIntegerExpr;
import com.alibaba.druid.sql.ast.expr.SQLListExpr;
import com.alibaba.druid.sql.ast.expr.SQLMethodInvokeExpr;
import com.alibaba.druid.sql.ast.expr.SQLNCharExpr;
import com.alibaba.druid.sql.ast.expr.SQLNotExpr;
import com.alibaba.druid.sql.ast.expr.SQLNullExpr;
import com.alibaba.druid.sql.ast.expr.SQLNumberExpr;
import com.alibaba.druid.sql.ast.expr.SQLPropertyExpr;
import com.alibaba.druid.sql.ast.expr.SQLQueryExpr;
import com.alibaba.druid.sql.ast.expr.SQLSomeExpr;
import com.alibaba.druid.sql.ast.expr.SQLUnaryExpr;
import com.alibaba.druid.sql.ast.expr.SQLUnaryOperator;
import com.alibaba.druid.sql.ast.expr.SQLVariantRefExpr;
import com.alibaba.druid.sql.ast.statement.NotNullConstraint;
import com.alibaba.druid.sql.ast.statement.SQLAssignItem;
import com.alibaba.druid.sql.ast.statement.SQLCharactorDataType;
import com.alibaba.druid.sql.ast.statement.SQLColumnDefinition;
import com.alibaba.druid.sql.ast.statement.SQLPrimaryKey;
import com.alibaba.druid.sql.ast.statement.SQLSelect;
import com.alibaba.druid.sql.ast.statement.SQLSelectOrderByItem;
import com.alibaba.druid.sql.parser.Lexer;
import com.alibaba.druid.sql.parser.ParserException;
import com.alibaba.druid.sql.parser.SQLParseException;
import com.alibaba.druid.sql.parser.SQLParser;
import com.alibaba.druid.sql.parser.SQLSelectParser;
import com.alibaba.druid.sql.parser.Token;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class SQLExprParser
extends SQLParser {
    public SQLExprParser(String sql) {
        super(sql);
    }

    public SQLExprParser(Lexer lexer) {
        super(lexer);
    }

    public SQLExpr expr() {
        if (this.lexer.token() == Token.STAR) {
            this.lexer.nextToken();
            return new SQLAllColumnExpr();
        }
        SQLExpr expr = this.primary();
        if (this.lexer.token() == Token.COMMA) {
            return expr;
        }
        return this.exprRest(expr);
    }

    public SQLExpr exprRest(SQLExpr expr) {
        expr = this.bitXorRest(expr);
        expr = this.multiplicativeRest(expr);
        expr = this.additiveRest(expr);
        expr = this.shiftRest(expr);
        expr = this.bitAndRest(expr);
        expr = this.bitOrRest(expr);
        expr = this.inRest(expr);
        expr = this.relationalRest(expr);
        expr = this.equalityRest(expr);
        expr = this.andRest(expr);
        expr = this.orRest(expr);
        return expr;
    }

    public final SQLExpr bitXor() {
        SQLExpr expr = this.primary();
        return this.bitXorRest(expr);
    }

    public SQLExpr bitXorRest(SQLExpr expr) {
        if (this.lexer.token() == Token.CARET) {
            this.lexer.nextToken();
            SQLExpr rightExp = this.primary();
            expr = new SQLBinaryOpExpr(expr, SQLBinaryOperator.BitwiseXor, rightExp);
            expr = this.bitXorRest(expr);
        }
        return expr;
    }

    public final SQLExpr multiplicative() {
        SQLExpr expr = this.primary();
        return this.multiplicativeRest(expr);
    }

    public SQLExpr multiplicativeRest(SQLExpr expr) {
        if (this.lexer.token() == Token.STAR) {
            this.lexer.nextToken();
            SQLExpr rightExp = this.bitXor();
            expr = new SQLBinaryOpExpr(expr, SQLBinaryOperator.Multiply, rightExp);
            expr = this.multiplicativeRest(expr);
        } else if (this.lexer.token() == Token.SLASH) {
            this.lexer.nextToken();
            SQLExpr rightExp = this.bitXor();
            expr = new SQLBinaryOpExpr(expr, SQLBinaryOperator.Divide, rightExp);
            expr = this.multiplicativeRest(expr);
        } else if (this.lexer.token() == Token.PERCENT) {
            this.lexer.nextToken();
            SQLExpr rightExp = this.bitXor();
            expr = new SQLBinaryOpExpr(expr, SQLBinaryOperator.Modulus, rightExp);
            expr = this.multiplicativeRest(expr);
        }
        return expr;
    }

    public SQLExpr primary() {
        SQLExpr sqlExpr = null;
        Token tok = this.lexer.token();
        block0 : switch (tok) {
            case LPAREN: {
                this.lexer.nextToken();
                sqlExpr = this.expr();
                if (this.lexer.token() == Token.COMMA) {
                    SQLListExpr listExpr = new SQLListExpr();
                    listExpr.getItems().add(sqlExpr);
                    do {
                        this.lexer.nextToken();
                        listExpr.getItems().add(this.expr());
                    } while (this.lexer.token() == Token.COMMA);
                    sqlExpr = listExpr;
                }
                this.accept(Token.RPAREN);
                break;
            }
            case INSERT: {
                this.lexer.nextToken();
                if (this.lexer.token() != Token.LPAREN) {
                    throw new ParserException("syntax error");
                }
                sqlExpr = new SQLIdentifierExpr("INSERT");
                break;
            }
            case IDENTIFIER: {
                sqlExpr = new SQLIdentifierExpr(this.lexer.stringVal());
                this.lexer.nextToken();
                break;
            }
            case NEW: {
                throw new ParserException("TODO");
            }
            case LITERAL_INT: {
                sqlExpr = new SQLIntegerExpr(this.lexer.integerValue());
                this.lexer.nextToken();
                break;
            }
            case LITERAL_FLOAT: {
                sqlExpr = new SQLNumberExpr(this.lexer.decimalValue());
                this.lexer.nextToken();
                break;
            }
            case LITERAL_CHARS: {
                sqlExpr = new SQLCharExpr(this.lexer.stringVal());
                this.lexer.nextToken();
                break;
            }
            case LITERAL_NCHARS: {
                sqlExpr = new SQLNCharExpr(this.lexer.stringVal());
                this.lexer.nextToken();
                break;
            }
            case VARIANT: {
                SQLVariantRefExpr varRefExpr = new SQLVariantRefExpr(this.lexer.stringVal());
                this.lexer.nextToken();
                if (varRefExpr.getName().equals("@") && this.lexer.token() == Token.LITERAL_CHARS) {
                    varRefExpr.setName("@'" + this.lexer.stringVal() + "'");
                    this.lexer.nextToken();
                } else if (varRefExpr.getName().equals("@@") && this.lexer.token() == Token.LITERAL_CHARS) {
                    varRefExpr.setName("@@'" + this.lexer.stringVal() + "'");
                    this.lexer.nextToken();
                }
                sqlExpr = varRefExpr;
                break;
            }
            case DEFAULT: {
                sqlExpr = new SQLDefaultExpr();
                this.lexer.nextToken();
                break;
            }
            case DUAL: 
            case KEY: 
            case DISTINCT: 
            case LIMIT: 
            case SCHEMA: 
            case COLUMN: 
            case IF: {
                sqlExpr = new SQLIdentifierExpr(this.lexer.stringVal());
                this.lexer.nextToken();
                break;
            }
            case CASE: {
                SQLCaseExpr caseExpr = new SQLCaseExpr();
                this.lexer.nextToken();
                if (this.lexer.token() != Token.WHEN) {
                    caseExpr.setValueExpr(this.expr());
                }
                this.accept(Token.WHEN);
                SQLExpr testExpr = this.expr();
                this.accept(Token.THEN);
                SQLExpr valueExpr = this.expr();
                SQLCaseExpr.Item caseItem = new SQLCaseExpr.Item(testExpr, valueExpr);
                caseExpr.getItems().add(caseItem);
                while (this.lexer.token() == Token.WHEN) {
                    this.lexer.nextToken();
                    testExpr = this.expr();
                    this.accept(Token.THEN);
                    valueExpr = this.expr();
                    caseItem = new SQLCaseExpr.Item(testExpr, valueExpr);
                    caseExpr.getItems().add(caseItem);
                }
                if (this.lexer.token() == Token.ELSE) {
                    this.lexer.nextToken();
                    caseExpr.setElseExpr(this.expr());
                }
                this.accept(Token.END);
                sqlExpr = caseExpr;
                break;
            }
            case EXISTS: {
                this.lexer.nextToken();
                this.accept(Token.LPAREN);
                sqlExpr = new SQLExistsExpr(this.createSelectParser().select());
                this.accept(Token.RPAREN);
                break;
            }
            case NOT: {
                this.lexer.nextToken();
                if (this.lexer.token() == Token.EXISTS) {
                    this.lexer.nextToken();
                    this.accept(Token.LPAREN);
                    sqlExpr = new SQLExistsExpr(this.createSelectParser().select(), true);
                    this.accept(Token.RPAREN);
                    break;
                }
                if (this.lexer.token() == Token.LPAREN) {
                    this.lexer.nextToken();
                    SQLExpr notTarget = this.expr();
                    this.accept(Token.RPAREN);
                    notTarget = this.exprRest(notTarget);
                    sqlExpr = new SQLNotExpr(notTarget);
                    return this.primaryRest(sqlExpr);
                }
                SQLExpr restExpr = this.expr();
                sqlExpr = new SQLNotExpr(restExpr);
                break;
            }
            case SELECT: {
                SQLQueryExpr queryExpr = new SQLQueryExpr(this.createSelectParser().select());
                sqlExpr = queryExpr;
                break;
            }
            case CAST: {
                this.lexer.nextToken();
                this.accept(Token.LPAREN);
                SQLCastExpr cast = new SQLCastExpr();
                cast.setExpr(this.expr());
                this.accept(Token.AS);
                cast.setDataType(this.parseDataType());
                this.accept(Token.RPAREN);
                sqlExpr = cast;
                break;
            }
            case SUB: {
                this.lexer.nextToken();
                switch (this.lexer.token()) {
                    case LITERAL_INT: {
                        long longVal;
                        int intVal;
                        Number integerValue = this.lexer.integerValue();
                        integerValue = integerValue instanceof Integer ? (Number)((intVal = ((Integer)integerValue).intValue()) == Integer.MIN_VALUE ? (Number)((long)intVal * -1L) : (Number)(intVal * -1)) : (Number)(integerValue instanceof Long ? ((longVal = ((Long)integerValue).longValue()) == 0x80000000L ? (Number)((int)(longVal * -1L)) : (Number)(longVal * -1L)) : ((BigInteger)integerValue).negate());
                        sqlExpr = new SQLIntegerExpr(integerValue);
                        this.lexer.nextToken();
                        break block0;
                    }
                    case LITERAL_FLOAT: {
                        sqlExpr = new SQLNumberExpr(this.lexer.decimalValue().negate());
                        this.lexer.nextToken();
                        break block0;
                    }
                    case IDENTIFIER: {
                        sqlExpr = new SQLIdentifierExpr('-' + this.lexer.stringVal());
                        this.lexer.nextToken();
                        break block0;
                    }
                }
                throw new ParserException("TODO");
            }
            case PLUS: {
                this.lexer.nextToken();
                switch (this.lexer.token()) {
                    case LITERAL_INT: {
                        sqlExpr = new SQLIntegerExpr(this.lexer.integerValue());
                        this.lexer.nextToken();
                        break block0;
                    }
                    case LITERAL_FLOAT: {
                        sqlExpr = new SQLNumberExpr(this.lexer.decimalValue());
                        this.lexer.nextToken();
                        break block0;
                    }
                }
                throw new ParserException("TODO");
            }
            case TILDE: {
                this.lexer.nextToken();
                SQLExpr unaryValueExpr = this.expr();
                SQLUnaryExpr unary = new SQLUnaryExpr(SQLUnaryOperator.Compl, unaryValueExpr);
                sqlExpr = unary;
                break;
            }
            case QUES: {
                this.lexer.nextToken();
                SQLVariantRefExpr quesVarRefExpr = new SQLVariantRefExpr("?");
                quesVarRefExpr.setIndex(this.lexer.nextVarIndex());
                sqlExpr = quesVarRefExpr;
                break;
            }
            case LEFT: {
                sqlExpr = new SQLIdentifierExpr("LEFT");
                this.lexer.nextToken();
                break;
            }
            case RIGHT: {
                sqlExpr = new SQLIdentifierExpr("RIGHT");
                this.lexer.nextToken();
                break;
            }
            case DATABASE: {
                sqlExpr = new SQLIdentifierExpr("DATABASE");
                this.lexer.nextToken();
                break;
            }
            case LOCK: {
                sqlExpr = new SQLIdentifierExpr("LOCK");
                this.lexer.nextToken();
                break;
            }
            case NULL: {
                sqlExpr = new SQLNullExpr();
                this.lexer.nextToken();
                break;
            }
            case BANG: {
                this.lexer.nextToken();
                SQLExpr bangExpr = this.expr();
                sqlExpr = new SQLUnaryExpr(SQLUnaryOperator.Not, bangExpr);
                break;
            }
            case LITERAL_HEX: {
                String hex = this.lexer.hexString();
                sqlExpr = new SQLHexExpr(hex);
                this.lexer.nextToken();
                break;
            }
            case INTERVAL: {
                sqlExpr = this.parseInterval();
                break;
            }
            case COLON: {
                this.lexer.nextToken();
                if (this.lexer.token != Token.LITERAL_ALIAS) break;
                sqlExpr = new SQLVariantRefExpr(":\"" + this.lexer.stringVal() + "\"");
                this.lexer.nextToken();
                break;
            }
            case ANY: {
                this.lexer.nextToken();
                if (this.lexer.token() == Token.LPAREN) {
                    SQLAnyExpr anyExpr = new SQLAnyExpr();
                    this.accept(Token.LPAREN);
                    SQLSelect anySubQuery = this.createSelectParser().select();
                    anyExpr.setSubQuery(anySubQuery);
                    this.accept(Token.RPAREN);
                    anySubQuery.setParent(anyExpr);
                    sqlExpr = anyExpr;
                    break;
                }
                sqlExpr = new SQLIdentifierExpr("ANY");
                break;
            }
            case SOME: {
                this.lexer.nextToken();
                SQLSomeExpr someExpr = new SQLSomeExpr();
                this.accept(Token.LPAREN);
                SQLSelect someSubQuery = this.createSelectParser().select();
                someExpr.setSubQuery(someSubQuery);
                this.accept(Token.RPAREN);
                someSubQuery.setParent(someExpr);
                sqlExpr = someExpr;
                break;
            }
            case ALL: {
                this.lexer.nextToken();
                SQLAllExpr allExpr = new SQLAllExpr();
                this.accept(Token.LPAREN);
                SQLSelect allSubQuery = this.createSelectParser().select();
                allExpr.setSubQuery(allSubQuery);
                this.accept(Token.RPAREN);
                allSubQuery.setParent(allExpr);
                sqlExpr = allExpr;
                break;
            }
            default: {
                throw new ParserException("ERROR. token : " + (Object)((Object)tok) + " " + this.lexer.stringVal());
            }
        }
        return this.primaryRest(sqlExpr);
    }

    protected SQLExpr parseInterval() {
        throw new ParserException("TODO");
    }

    public SQLSelectParser createSelectParser() {
        return new SQLSelectParser(this);
    }

    public SQLExpr primaryRest(SQLExpr expr) {
        String name;
        if (expr == null) {
            throw new IllegalArgumentException("expr");
        }
        if (this.lexer.token() == Token.OF && expr instanceof SQLIdentifierExpr && "CURRENT".equalsIgnoreCase(name = ((SQLIdentifierExpr)expr).getName())) {
            this.lexer.nextToken();
            SQLName cursorName = this.name();
            return new SQLCurrentOfCursorExpr(cursorName);
        }
        if (this.lexer.token() == Token.DOT) {
            this.lexer.nextToken();
            if (expr instanceof SQLCharExpr) {
                String text = ((SQLCharExpr)expr).getText();
                expr = new SQLIdentifierExpr(text);
            }
            expr = this.dotRest(expr);
            return this.primaryRest(expr);
        }
        if (this.lexer.token() == Token.LPAREN) {
            return this.methodRest(expr, true);
        }
        return expr;
    }

    protected SQLExpr methodRest(SQLExpr expr, boolean acceptLPAREN) {
        if (acceptLPAREN) {
            this.accept(Token.LPAREN);
        }
        if (expr instanceof SQLName || expr instanceof SQLDefaultExpr) {
            SQLMethodInvokeExpr methodInvokeExpr;
            String methodName;
            if (expr instanceof SQLPropertyExpr) {
                methodName = ((SQLPropertyExpr)expr).getName();
                methodInvokeExpr = new SQLMethodInvokeExpr(methodName);
                methodInvokeExpr.setOwner(((SQLPropertyExpr)expr).getOwner());
            } else {
                methodName = expr.toString();
                methodInvokeExpr = new SQLMethodInvokeExpr(methodName);
            }
            if (this.isAggreateFunction(methodName)) {
                SQLAggregateExpr aggregateExpr = this.parseAggregateExpr(methodName);
                return aggregateExpr;
            }
            if (this.lexer.token() != Token.RPAREN) {
                this.exprList(methodInvokeExpr.getParameters());
            }
            this.accept(Token.RPAREN);
            return this.primaryRest(methodInvokeExpr);
        }
        throw new ParserException("not support token:" + (Object)((Object)this.lexer.token()));
    }

    protected SQLExpr dotRest(SQLExpr expr) {
        if (this.lexer.token() == Token.STAR) {
            this.lexer.nextToken();
            expr = new SQLPropertyExpr(expr, "*");
        } else {
            String name;
            if (this.lexer.token() == Token.IDENTIFIER || this.lexer.token() == Token.LITERAL_CHARS || this.lexer.token() == Token.LITERAL_ALIAS) {
                name = this.lexer.stringVal();
                this.lexer.nextToken();
            } else if (this.lexer.getKeywods().containsValue(this.lexer.token())) {
                name = this.lexer.stringVal();
                this.lexer.nextToken();
            } else {
                throw new ParserException("error : " + this.lexer.stringVal());
            }
            if (this.lexer.token() == Token.LPAREN) {
                this.lexer.nextToken();
                SQLMethodInvokeExpr methodInvokeExpr = new SQLMethodInvokeExpr(name);
                methodInvokeExpr.setOwner(expr);
                if (this.lexer.token() == Token.RPAREN) {
                    this.lexer.nextToken();
                } else {
                    if (this.lexer.token() == Token.PLUS) {
                        methodInvokeExpr.getParameters().add(new SQLIdentifierExpr("+"));
                        this.lexer.nextToken();
                    } else {
                        this.exprList(methodInvokeExpr.getParameters());
                    }
                    this.accept(Token.RPAREN);
                }
                expr = methodInvokeExpr;
            } else {
                expr = new SQLPropertyExpr(expr, name);
            }
        }
        expr = this.primaryRest(expr);
        return expr;
    }

    public final SQLExpr groupComparisionRest(SQLExpr expr) {
        return expr;
    }

    public final void names(Collection<SQLName> exprCol) {
        if (this.lexer.token() == Token.RBRACE) {
            return;
        }
        if (this.lexer.token() == Token.EOF) {
            return;
        }
        exprCol.add(this.name());
        while (this.lexer.token() == Token.COMMA) {
            this.lexer.nextToken();
            exprCol.add(this.name());
        }
    }

    public final void exprList(Collection<SQLExpr> exprCol) {
        if (this.lexer.token() == Token.RPAREN || this.lexer.token() == Token.RBRACKET) {
            return;
        }
        if (this.lexer.token() == Token.EOF) {
            return;
        }
        SQLExpr expr = this.expr();
        exprCol.add(expr);
        while (this.lexer.token() == Token.COMMA) {
            this.lexer.nextToken();
            expr = this.expr();
            exprCol.add(expr);
        }
    }

    public SQLName name() {
        String identName;
        if (this.lexer.token() == Token.LITERAL_ALIAS) {
            identName = '\"' + this.lexer.stringVal() + '\"';
            this.lexer.nextToken();
        } else if (this.lexer.token() == Token.IDENTIFIER) {
            identName = this.lexer.stringVal();
            this.lexer.nextToken();
        } else if (this.lexer.token() == Token.LITERAL_CHARS) {
            identName = '\'' + this.lexer.stringVal() + '\'';
            this.lexer.nextToken();
        } else {
            throw new ParserException("error " + (Object)((Object)this.lexer.token()));
        }
        SQLName name = new SQLIdentifierExpr(identName);
        name = this.nameRest(name);
        return name;
    }

    public SQLName nameRest(SQLName name) {
        if (this.lexer.token() == Token.DOT) {
            this.lexer.nextToken();
            if (this.lexer.token() == Token.KEY) {
                name = new SQLPropertyExpr(name, "KEY");
                this.lexer.nextToken();
                return name;
            }
            if (this.lexer.token() != Token.LITERAL_ALIAS && this.lexer.token() != Token.IDENTIFIER && !this.lexer.getKeywods().containsValue(this.lexer.token())) {
                throw new ParserException("error, " + (Object)((Object)this.lexer.token()));
            }
            name = this.lexer.token() == Token.LITERAL_ALIAS ? new SQLPropertyExpr(name, '\"' + this.lexer.stringVal() + '\"') : new SQLPropertyExpr(name, this.lexer.stringVal());
            this.lexer.nextToken();
            name = this.nameRest(name);
        }
        return name;
    }

    public boolean isAggreateFunction(String word) {
        String[] aggregateFunctions = new String[]{"AVG", "COUNT", "MAX", "MIN", "STDDEV", "SUM"};
        for (int i = 0; i < aggregateFunctions.length; ++i) {
            if (aggregateFunctions[i].compareToIgnoreCase(word) != 0) continue;
            return true;
        }
        return false;
    }

    protected SQLAggregateExpr parseAggregateExpr(String methodName) {
        SQLAggregateExpr aggregateExpr;
        methodName = methodName.toUpperCase();
        if (this.lexer.token() == Token.ALL) {
            aggregateExpr = new SQLAggregateExpr(methodName, SQLAggregateExpr.Option.ALL);
            this.lexer.nextToken();
        } else if (this.lexer.token() == Token.DISTINCT) {
            aggregateExpr = new SQLAggregateExpr(methodName, SQLAggregateExpr.Option.DISTINCT);
            this.lexer.nextToken();
        } else {
            aggregateExpr = new SQLAggregateExpr(methodName);
        }
        this.exprList(aggregateExpr.getArguments());
        this.accept(Token.RPAREN);
        if (this.lexer.token() == Token.OVER) {
            this.lexer.nextToken();
            SQLOver over = new SQLOver();
            this.accept(Token.LPAREN);
            if (this.identifierEquals("PARTITION")) {
                this.lexer.nextToken();
                this.accept(Token.BY);
                if (this.lexer.token() == Token.LPAREN) {
                    this.lexer.nextToken();
                    this.exprList(over.getPartitionBy());
                    this.accept(Token.RPAREN);
                } else {
                    this.exprList(over.getPartitionBy());
                }
            }
            over.setOrderBy(this.parseOrderBy());
            this.accept(Token.RPAREN);
            aggregateExpr.setOver(over);
        }
        return aggregateExpr;
    }

    public SQLOrderBy parseOrderBy() {
        if (this.lexer.token() == Token.ORDER) {
            SQLOrderBy orderBy = new SQLOrderBy();
            this.lexer.nextToken();
            this.accept(Token.BY);
            orderBy.getItems().add(this.parseSelectOrderByItem());
            while (this.lexer.token() == Token.COMMA) {
                this.lexer.nextToken();
                orderBy.getItems().add(this.parseSelectOrderByItem());
            }
            return orderBy;
        }
        return null;
    }

    public SQLSelectOrderByItem parseSelectOrderByItem() {
        SQLSelectOrderByItem item = new SQLSelectOrderByItem();
        item.setExpr(this.expr());
        if (this.lexer.token() == Token.ASC) {
            this.lexer.nextToken();
            item.setType(SQLOrderingSpecification.ASC);
        } else if (this.lexer.token() == Token.DESC) {
            this.lexer.nextToken();
            item.setType(SQLOrderingSpecification.DESC);
        }
        return item;
    }

    public final SQLExpr bitAnd() {
        SQLExpr expr = this.shift();
        return this.bitAndRest(expr);
    }

    public final SQLExpr bitAndRest(SQLExpr expr) {
        while (this.lexer.token() == Token.AMP) {
            this.lexer.nextToken();
            SQLExpr rightExp = this.shift();
            expr = new SQLBinaryOpExpr(expr, SQLBinaryOperator.BitwiseAnd, rightExp);
        }
        return expr;
    }

    public final SQLExpr bitOr() {
        SQLExpr expr = this.bitAnd();
        return this.bitOrRest(expr);
    }

    public final SQLExpr bitOrRest(SQLExpr expr) {
        if (this.lexer.token() == Token.BAR) {
            this.lexer.nextToken();
            SQLExpr rightExp = this.bitAnd();
            expr = new SQLBinaryOpExpr(expr, SQLBinaryOperator.BitwiseOr, rightExp);
            expr = this.bitAndRest(expr);
        } else if (this.lexer.token() == Token.TILDE) {
            this.lexer.nextToken();
            SQLExpr rightExp = this.bitAnd();
            expr = new SQLBinaryOpExpr(expr, SQLBinaryOperator.InvertBits, rightExp);
            expr = this.bitAndRest(expr);
        }
        return expr;
    }

    public final SQLExpr equality() {
        SQLExpr expr = this.shift();
        return this.equalityRest(expr);
    }

    public SQLExpr equalityRest(SQLExpr expr) {
        if (this.lexer.token() == Token.EQ) {
            this.lexer.nextToken();
            SQLExpr rightExp = this.shift();
            rightExp = this.equalityRest(rightExp);
            expr = new SQLBinaryOpExpr(expr, SQLBinaryOperator.Equality, rightExp);
        } else if (this.lexer.token() == Token.BANGEQ) {
            this.lexer.nextToken();
            SQLExpr rightExp = this.shift();
            rightExp = this.equalityRest(rightExp);
            expr = new SQLBinaryOpExpr(expr, SQLBinaryOperator.NotEqual, rightExp);
        } else if (this.lexer.token() == Token.COLONEQ) {
            this.lexer.nextToken();
            SQLExpr rightExp = this.expr();
            expr = new SQLBinaryOpExpr(expr, SQLBinaryOperator.Assignment, rightExp);
        }
        return expr;
    }

    public final SQLExpr inRest(SQLExpr expr) {
        if (this.lexer.token() == Token.IN) {
            SQLExpr targetExpr;
            this.lexer.nextToken();
            this.accept(Token.LPAREN);
            SQLInListExpr inListExpr = new SQLInListExpr(expr);
            this.exprList(inListExpr.getTargetList());
            expr = inListExpr;
            this.accept(Token.RPAREN);
            expr = inListExpr;
            if (inListExpr.getTargetList().size() == 1 && (targetExpr = inListExpr.getTargetList().get(0)) instanceof SQLQueryExpr) {
                SQLInSubQueryExpr inSubQueryExpr = new SQLInSubQueryExpr();
                inSubQueryExpr.setExpr(inListExpr.getExpr());
                inSubQueryExpr.setSubQuery(((SQLQueryExpr)targetExpr).getSubQuery());
                expr = inSubQueryExpr;
            }
        }
        return expr;
    }

    public final SQLExpr additive() {
        SQLExpr expr = this.multiplicative();
        return this.additiveRest(expr);
    }

    public SQLExpr additiveRest(SQLExpr expr) {
        if (this.lexer.token() == Token.PLUS) {
            this.lexer.nextToken();
            SQLExpr rightExp = this.multiplicative();
            expr = new SQLBinaryOpExpr(expr, SQLBinaryOperator.Add, rightExp);
            expr = this.additiveRest(expr);
        } else if (this.lexer.token() == Token.BARBAR) {
            this.lexer.nextToken();
            SQLExpr rightExp = this.multiplicative();
            expr = new SQLBinaryOpExpr(expr, SQLBinaryOperator.Concat, rightExp);
            expr = this.additiveRest(expr);
        } else if (this.lexer.token() == Token.SUB) {
            this.lexer.nextToken();
            SQLExpr rightExp = this.multiplicative();
            expr = new SQLBinaryOpExpr(expr, SQLBinaryOperator.Subtract, rightExp);
            expr = this.additiveRest(expr);
        }
        return expr;
    }

    public final SQLExpr shift() {
        SQLExpr expr = this.additive();
        return this.shiftRest(expr);
    }

    public SQLExpr shiftRest(SQLExpr expr) {
        if (this.lexer.token() == Token.LTLT) {
            this.lexer.nextToken();
            SQLExpr rightExp = this.additive();
            expr = new SQLBinaryOpExpr(expr, SQLBinaryOperator.LeftShift, rightExp);
            expr = this.shiftRest(expr);
        } else if (this.lexer.token() == Token.GTGT) {
            this.lexer.nextToken();
            SQLExpr rightExp = this.additive();
            expr = new SQLBinaryOpExpr(expr, SQLBinaryOperator.RightShift, rightExp);
            expr = this.shiftRest(expr);
        }
        return expr;
    }

    public SQLExpr and() {
        SQLExpr expr = this.relational();
        return this.andRest(expr);
    }

    public SQLExpr andRest(SQLExpr expr) {
        while (this.lexer.token() == Token.AND || this.lexer.token() == Token.AMPAMP) {
            this.lexer.nextToken();
            SQLExpr rightExp = this.relational();
            expr = new SQLBinaryOpExpr(expr, SQLBinaryOperator.BooleanAnd, rightExp);
        }
        return expr;
    }

    public SQLExpr or() {
        SQLExpr expr = this.and();
        return this.orRest(expr);
    }

    public SQLExpr orRest(SQLExpr expr) {
        while (true) {
            SQLExpr rightExp;
            if (this.lexer.token() == Token.OR) {
                this.lexer.nextToken();
                rightExp = this.and();
                expr = new SQLBinaryOpExpr(expr, SQLBinaryOperator.BooleanOr, rightExp);
                continue;
            }
            if (this.lexer.token() != Token.XOR) break;
            this.lexer.nextToken();
            rightExp = this.and();
            expr = new SQLBinaryOpExpr(expr, SQLBinaryOperator.BooleanXor, rightExp);
        }
        return expr;
    }

    public SQLExpr relational() {
        SQLExpr expr = this.equality();
        return this.relationalRest(expr);
    }

    public SQLExpr relationalRest(SQLExpr expr) {
        if (this.lexer.token() == Token.LT) {
            SQLBinaryOperator op = SQLBinaryOperator.LessThan;
            this.lexer.nextToken();
            if (this.lexer.token() == Token.EQ) {
                this.lexer.nextToken();
                op = SQLBinaryOperator.LessThanOrEqual;
            }
            SQLExpr rightExp = this.bitOr();
            expr = new SQLBinaryOpExpr(expr, op, rightExp);
        } else if (this.lexer.token() == Token.LTEQ) {
            this.lexer.nextToken();
            SQLExpr rightExp = this.bitOr();
            expr = new SQLBinaryOpExpr(expr, SQLBinaryOperator.LessThanOrEqual, rightExp);
        } else if (this.lexer.token() == Token.LTEQGT) {
            this.lexer.nextToken();
            SQLExpr rightExp = this.bitOr();
            expr = new SQLBinaryOpExpr(expr, SQLBinaryOperator.LessThanOrEqualOrGreaterThan, rightExp);
        } else if (this.lexer.token() == Token.GT) {
            SQLBinaryOperator op = SQLBinaryOperator.GreaterThan;
            this.lexer.nextToken();
            if (this.lexer.token() == Token.EQ) {
                this.lexer.nextToken();
                op = SQLBinaryOperator.GreaterThanOrEqual;
            }
            SQLExpr rightExp = this.bitOr();
            expr = new SQLBinaryOpExpr(expr, op, rightExp);
        } else if (this.lexer.token() == Token.GTEQ) {
            this.lexer.nextToken();
            SQLExpr rightExp = this.bitOr();
            expr = new SQLBinaryOpExpr(expr, SQLBinaryOperator.GreaterThanOrEqual, rightExp);
        } else if (this.lexer.token() == Token.BANGLT) {
            this.lexer.nextToken();
            SQLExpr rightExp = this.bitOr();
            expr = new SQLBinaryOpExpr(expr, SQLBinaryOperator.NotLessThan, rightExp);
        } else if (this.lexer.token() == Token.BANGGT) {
            this.lexer.nextToken();
            SQLExpr rightExp = this.bitOr();
            rightExp = this.relationalRest(rightExp);
            expr = new SQLBinaryOpExpr(expr, SQLBinaryOperator.NotGreaterThan, rightExp);
        } else if (this.lexer.token() == Token.LTGT) {
            this.lexer.nextToken();
            SQLExpr rightExp = this.bitOr();
            expr = new SQLBinaryOpExpr(expr, SQLBinaryOperator.LessThanOrGreater, rightExp);
        } else if (this.lexer.token() == Token.LIKE) {
            this.lexer.nextToken();
            SQLExpr rightExp = this.bitOr();
            expr = new SQLBinaryOpExpr(expr, SQLBinaryOperator.Like, rightExp);
            if (this.lexer.token() == Token.ESCAPE) {
                this.lexer.nextToken();
                rightExp = this.expr();
                expr = new SQLBinaryOpExpr(expr, SQLBinaryOperator.Escape, rightExp);
            }
        } else if (this.lexer.token() == Token.NOT) {
            this.lexer.nextToken();
            expr = this.notRationalRest(expr);
        } else if (this.lexer.token() == Token.BETWEEN) {
            this.lexer.nextToken();
            SQLExpr beginExpr = this.bitOr();
            this.accept(Token.AND);
            SQLExpr endExpr = this.bitOr();
            expr = new SQLBetweenExpr(expr, beginExpr, endExpr);
        } else if (this.lexer.token() == Token.IS) {
            this.lexer.nextToken();
            if (this.lexer.token() == Token.NOT) {
                this.lexer.nextToken();
                SQLExpr rightExpr = this.primary();
                expr = new SQLBinaryOpExpr(expr, SQLBinaryOperator.IsNot, rightExpr);
            } else {
                SQLExpr rightExpr = this.primary();
                expr = new SQLBinaryOpExpr(expr, SQLBinaryOperator.Is, rightExpr);
            }
        } else if (this.lexer.token() == Token.IN) {
            expr = this.inRest(expr);
        }
        return expr;
    }

    public SQLExpr notRationalRest(SQLExpr expr) {
        if (this.lexer.token() == Token.LIKE) {
            this.lexer.nextToken();
            SQLExpr rightExp = this.equality();
            rightExp = this.relationalRest(rightExp);
            expr = new SQLBinaryOpExpr(expr, SQLBinaryOperator.NotLike, rightExp);
            if (this.lexer.token() == Token.ESCAPE) {
                this.lexer.nextToken();
                rightExp = this.expr();
                expr = new SQLBinaryOpExpr(expr, SQLBinaryOperator.Escape, rightExp);
            }
        } else {
            if (this.lexer.token() == Token.IN) {
                SQLExpr targetExpr;
                this.lexer.nextToken();
                this.accept(Token.LPAREN);
                SQLInListExpr inListExpr = new SQLInListExpr(expr, true);
                this.exprList(inListExpr.getTargetList());
                expr = inListExpr;
                this.accept(Token.RPAREN);
                if (inListExpr.getTargetList().size() == 1 && (targetExpr = inListExpr.getTargetList().get(0)) instanceof SQLQueryExpr) {
                    SQLInSubQueryExpr inSubQueryExpr = new SQLInSubQueryExpr();
                    inSubQueryExpr.setNot(true);
                    inSubQueryExpr.setExpr(inListExpr.getExpr());
                    inSubQueryExpr.setSubQuery(((SQLQueryExpr)targetExpr).getSubQuery());
                    expr = inSubQueryExpr;
                }
                expr = this.relationalRest(expr);
                return expr;
            }
            if (this.lexer.token() == Token.BETWEEN) {
                this.lexer.nextToken();
                SQLExpr beginExpr = this.bitOr();
                this.accept(Token.AND);
                SQLExpr endExpr = this.bitOr();
                expr = new SQLBetweenExpr(expr, true, beginExpr, endExpr);
                return expr;
            }
            throw new ParserException("TODO " + (Object)((Object)this.lexer.token()));
        }
        return expr;
    }

    public SQLDataType parseDataType() {
        if (this.lexer.token() == Token.DEFAULT || this.lexer.token() == Token.NOT || this.lexer.token() == Token.NULL) {
            return null;
        }
        SQLName typeExpr = this.name();
        String typeName = typeExpr.toString();
        if ("character".equalsIgnoreCase(typeName) && "varying".equalsIgnoreCase(this.lexer.stringVal())) {
            typeName = typeName + ' ' + this.lexer.stringVal();
            this.lexer.nextToken();
        }
        SQLDataTypeImpl dataType = new SQLDataTypeImpl(typeName);
        return this.parseDataTypeRest(dataType);
    }

    protected SQLDataType parseDataTypeRest(SQLDataType dataType) {
        if (this.lexer.token() == Token.LPAREN) {
            this.lexer.nextToken();
            this.exprList(dataType.getArguments());
            this.accept(Token.RPAREN);
            return this.parseCharTypeRest(dataType);
        }
        return dataType;
    }

    protected boolean isCharType(SQLDataType dataType) {
        String dataTypeName = dataType.getName();
        return "char".equalsIgnoreCase(dataTypeName) || "varchar".equalsIgnoreCase(dataTypeName) || "nchar".equalsIgnoreCase(dataTypeName) || "nvarchar".equalsIgnoreCase(dataTypeName);
    }

    protected SQLDataType parseCharTypeRest(SQLDataType dataType) {
        if (!this.isCharType(dataType)) {
            return dataType;
        }
        SQLCharactorDataType charType = new SQLCharactorDataType(dataType.getName());
        charType.getArguments().addAll(dataType.getArguments());
        if (this.identifierEquals("CHARACTER")) {
            this.lexer.nextToken();
            this.accept(Token.SET);
            if (this.lexer.token() != Token.IDENTIFIER && this.lexer.token() != Token.LITERAL_CHARS) {
                throw new ParserException();
            }
            charType.setCharSetName(this.lexer.stringVal());
            this.lexer.nextToken();
            if (this.lexer.token() == Token.IDENTIFIER && this.lexer.stringVal().equalsIgnoreCase("COLLATE")) {
                this.lexer.nextToken();
                if (this.lexer.token() != Token.IDENTIFIER) {
                    throw new ParserException();
                }
                charType.setCollate(this.lexer.stringVal());
                this.lexer.nextToken();
            }
        }
        return charType;
    }

    @Override
    public void accept(Token token) {
        if (this.lexer.token() != token) {
            throw new SQLParseException("syntax error, expect " + (Object)((Object)token) + ", actual " + (Object)((Object)this.lexer.token()) + " " + this.lexer.stringVal());
        }
        this.lexer.nextToken();
    }

    public SQLColumnDefinition parseColumn() {
        SQLColumnDefinition column = new SQLColumnDefinition();
        column.setName(this.name());
        column.setDataType(this.parseDataType());
        return this.parseColumnRest(column);
    }

    public SQLColumnDefinition parseColumnRest(SQLColumnDefinition column) {
        if (this.lexer.token() == Token.DEFAULT) {
            this.lexer.nextToken();
            column.setDefaultExpr(this.bitOr());
            return this.parseColumnRest(column);
        }
        if (this.lexer.token() == Token.NOT) {
            this.lexer.nextToken();
            this.accept(Token.NULL);
            column.getConstaints().add(new NotNullConstraint());
            return this.parseColumnRest(column);
        }
        if (this.lexer.token() == Token.NULL) {
            this.lexer.nextToken();
            column.setDefaultExpr(new SQLNullExpr());
            return this.parseColumnRest(column);
        }
        return column;
    }

    public SQLPrimaryKey parsePrimaryKey() {
        throw new ParserException("TODO");
    }

    public SQLAssignItem parseAssignItem() {
        SQLAssignItem item = new SQLAssignItem();
        SQLExpr var = this.primary();
        if (var instanceof SQLIdentifierExpr) {
            var = new SQLVariantRefExpr(((SQLIdentifierExpr)var).getName());
        }
        item.setTarget(var);
        if (this.lexer.token() == Token.COLONEQ) {
            this.lexer.nextToken();
        } else {
            this.accept(Token.EQ);
        }
        item.setValue(this.expr());
        return item;
    }

    public List<SQLCommentHint> parseHints() {
        ArrayList<SQLCommentHint> hints = new ArrayList<SQLCommentHint>();
        this.parseHints(hints);
        return hints;
    }

    public void parseHints(List hints) {
        if (this.lexer.token() == Token.HINT) {
            hints.add(new SQLCommentHint(this.lexer.stringVal()));
            this.lexer.nextToken();
        }
    }
}

