/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.csp.sentinel.traffic.rule.router.match;

import com.alibaba.csp.sentinel.traffic.TrafficContext;
import com.alibaba.csp.sentinel.traffic.rule.router.match.ArgumentMatch;
import com.alibaba.csp.sentinel.traffic.rule.router.match.StringMatch;
import com.alibaba.csp.sentinel.util.StringUtil;
import java.util.List;
import java.util.Map;

public class MethodMatch {
    private StringMatch name;
    private StringMatch path;
    private Integer argumentCount;
    private List<ArgumentMatch> arguments;
    private List<StringMatch> argumentParameters;
    private StringMatch group;
    private StringMatch version;
    private Map<String, StringMatch> headers;

    public StringMatch getName() {
        return this.name;
    }

    public void setName(StringMatch name) {
        this.name = name;
    }

    public StringMatch getPath() {
        return this.path;
    }

    public void setPath(StringMatch path) {
        this.path = path;
    }

    public Integer getArgumentCount() {
        return this.argumentCount;
    }

    public void setArgumentCount(Integer argumentCount) {
        this.argumentCount = argumentCount;
    }

    public List<ArgumentMatch> getArguments() {
        return this.arguments;
    }

    public void setArguments(List<ArgumentMatch> arguments) {
        this.arguments = arguments;
    }

    public List<StringMatch> getArgumentParameters() {
        return this.argumentParameters;
    }

    public void setArgumentParameters(List<StringMatch> argumentParameters) {
        this.argumentParameters = argumentParameters;
    }

    public StringMatch getGroup() {
        return this.group;
    }

    public void setGroup(StringMatch group) {
        this.group = group;
    }

    public StringMatch getVersion() {
        return this.version;
    }

    public void setVersion(StringMatch version) {
        this.version = version;
    }

    public Map<String, StringMatch> getHeaders() {
        return this.headers;
    }

    public void setHeaders(Map<String, StringMatch> headers) {
        this.headers = headers;
    }

    public String toString() {
        return "MethodMatch{name=" + this.name + ", path=" + this.path + ", argumentCount=" + this.argumentCount + ", arguments=" + this.arguments + ", argumentParameters=" + this.argumentParameters + ", group=" + this.group + ", version=" + this.version + ", headers=" + this.headers + '}';
    }

    public boolean isMatch(TrafficContext context) {
        List<ArgumentMatch> args;
        if (this.getName() != null && !this.getName().isMatch(context.getMethodName())) {
            return false;
        }
        if (this.getPath() != null && !this.getPath().isMatch(context.getPath())) {
            return false;
        }
        if (this.getGroup() != null && !this.getGroup().isMatch(context.getGroup())) {
            return false;
        }
        if (this.getVersion() != null && !this.getVersion().isMatch(context.getVersion())) {
            return false;
        }
        Integer argc = this.getArgumentCount();
        List<Object> arguments = context.getArgs();
        if (argc != null && (argc != 0 && (arguments == null || arguments.size() == 0) || argc.intValue() != arguments.size())) {
            return false;
        }
        List<StringMatch> argp = this.getArgumentParameters();
        List<String> parameterTypes = context.getParamTypes();
        if (argp != null && argp.size() > 0) {
            if (parameterTypes == null || parameterTypes.size() == 0) {
                return false;
            }
            if (argp.size() != parameterTypes.size()) {
                return false;
            }
            for (int index = 0; index < argp.size(); ++index) {
                boolean match = argp.get(index).isMatch(parameterTypes.get(index));
                if (match) continue;
                return false;
            }
        }
        if ((args = this.getArguments()) != null && args.size() > 0) {
            if (arguments == null || arguments.size() == 0) {
                return false;
            }
            for (ArgumentMatch argumentMatch : args) {
                int index = argumentMatch.getIndex();
                if (index >= arguments.size()) {
                    throw new IndexOutOfBoundsException("Sentinel Method Arg index >= parameters.length");
                }
                if (argumentMatch.isMatch(arguments.get(index))) continue;
                return false;
            }
        }
        if (this.getHeaders() != null) {
            for (String key : this.getHeaders().keySet()) {
                String value = context.getHeaders().get(key);
                if (!StringUtil.isNotEmpty(value)) continue;
                return this.getHeaders().get(key).isMatch(value);
            }
        }
        return false;
    }
}

