/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.csp.sentinel.traffic.rule.router;

import com.alibaba.csp.sentinel.spi.SpiLoader;
import com.alibaba.csp.sentinel.traffic.RemoteAppObserver;
import com.alibaba.csp.sentinel.traffic.rule.TrafficRoutingRuleGroup;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;

public class TrafficRouterRuleManager {
    private static final ConcurrentHashMap<String, Object> trafficRouterRuleListenerMap = new ConcurrentHashMap();
    private static List<RemoteAppObserver> subscribers = SpiLoader.of(RemoteAppObserver.class).loadInstanceList();
    private static volatile TrafficRoutingRuleGroup trafficRoutingRuleGroup = new TrafficRoutingRuleGroup();
    private static final Object object = new Object();

    public static synchronized void updateTrafficRouter(TrafficRoutingRuleGroup rules) {
        trafficRoutingRuleGroup = rules;
    }

    public static TrafficRoutingRuleGroup getTrafficRoutingRules() {
        return trafficRoutingRuleGroup;
    }

    public static synchronized void register(String app) {
        Object value = trafficRouterRuleListenerMap.put(app, object);
        if (value == null) {
            for (RemoteAppObserver subscriber : subscribers) {
                subscriber.onRemoteAppAppears(app);
            }
        }
    }

    public static synchronized void unregister(String app) {
        for (RemoteAppObserver subscriber : subscribers) {
            subscriber.onRemoteAppDisappears(app);
        }
        trafficRouterRuleListenerMap.remove(app);
    }
}

