/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.csp.sentinel.traffic;

import com.alibaba.csp.sentinel.traffic.ClusterManager;
import com.alibaba.csp.sentinel.traffic.Instance;
import com.alibaba.csp.sentinel.traffic.RouterFilter;
import com.alibaba.csp.sentinel.traffic.TrafficContext;
import com.alibaba.csp.sentinel.traffic.TrafficException;
import com.alibaba.csp.sentinel.traffic.rule.TrafficRoutingRuleGroup;
import com.alibaba.csp.sentinel.traffic.rule.router.Route;
import com.alibaba.csp.sentinel.traffic.rule.router.RouteDetail;
import com.alibaba.csp.sentinel.traffic.rule.router.TrafficRouter;
import com.alibaba.csp.sentinel.traffic.rule.router.TrafficRouterRuleManager;
import com.alibaba.csp.sentinel.traffic.rule.router.destination.Destination;
import com.alibaba.csp.sentinel.traffic.rule.router.destination.RouteDestination;
import com.alibaba.csp.sentinel.traffic.rule.router.match.RequestMatch;
import com.alibaba.csp.sentinel.traffic.rule.router.match.StringMatch;
import com.alibaba.csp.sentinel.traffic.rule.workload.Subset;
import com.alibaba.csp.sentinel.traffic.rule.workload.VirtualWorkload;
import com.alibaba.csp.sentinel.util.StringUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ThreadLocalRandom;

public class TrafficRouterFilter
implements RouterFilter {
    private final ClusterManager clusterManager;

    public TrafficRouterFilter(ClusterManager clusterManager) {
        this.clusterManager = clusterManager;
    }

    @Override
    public List<Instance> filter(List<Instance> instanceList, TrafficContext context) throws TrafficException {
        String appName;
        String subset;
        if (null == instanceList || instanceList.size() == 0) {
            return instanceList;
        }
        TrafficRoutingRuleGroup routingRules = TrafficRouterRuleManager.getTrafficRoutingRules();
        if (!routingRules.isValid()) {
            return instanceList;
        }
        List<RouteDestination> routeDestination = this.getRouteDestination(routingRules, context);
        ArrayList<Instance> targetInstances = new ArrayList<Instance>();
        if (routeDestination != null && (subset = this.randomSelectDestination(appName = instanceList.get(0).getAppName(), routeDestination, instanceList)) != null) {
            List<Instance> destination = this.getSubsetInstances(appName, subset, instanceList);
            targetInstances.addAll(destination);
        }
        return targetInstances;
    }

    protected String randomSelectDestination(String appName, List<RouteDestination> routeDestination, List<Instance> instanceList) throws TrafficException {
        String result;
        int totalWeight = 0;
        for (RouteDestination dubboRouteDestination : routeDestination) {
            totalWeight += Math.max(dubboRouteDestination.getWeight(), 1);
        }
        int target = ThreadLocalRandom.current().nextInt(totalWeight);
        for (RouteDestination destination : routeDestination) {
            if ((target -= Math.max(destination.getWeight(), 1)) > 0 || (result = this.computeDestination(appName, destination.getDestination(), instanceList)) == null) continue;
            return result;
        }
        for (RouteDestination destination : routeDestination) {
            result = this.computeDestination(appName, destination.getDestination(), instanceList);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    protected String computeDestination(String appName, Destination destination, List<Instance> instanceList) throws TrafficException {
        String subset = destination.getSubset();
        while (true) {
            List<Instance> result = this.getSubsetInstances(appName, subset, instanceList);
            ArrayList<Instance> newResult = new ArrayList<Instance>(instanceList);
            newResult.addAll(result);
            if (!result.isEmpty() && !newResult.isEmpty()) {
                return subset;
            }
            RouteDestination routeDestination = destination.getFallback();
            if (routeDestination == null || (destination = routeDestination.getDestination()) == null) break;
            subset = destination.getSubset();
        }
        return null;
    }

    private List<Instance> getSubsetInstances(String appName, String subset, List<Instance> instanceList) {
        TrafficRoutingRuleGroup rules = TrafficRouterRuleManager.getTrafficRoutingRules();
        ArrayList<Instance> results = new ArrayList<Instance>();
        for (VirtualWorkload virtualWorkload : rules.getVirtualWorkloadRuleList()) {
            if (!virtualWorkload.getHost().equals(appName)) continue;
            for (Subset subsetRule : virtualWorkload.getSubsets()) {
                if (!subsetRule.getName().equals(subset)) continue;
                Map<String, String> labels = subsetRule.getLabels();
                for (String labelKey : labels.keySet()) {
                    for (Instance instance : instanceList) {
                        String labelValue = instance.getMetadata().get(labelKey);
                        if (!StringUtil.isNotEmpty(labelValue) || !labelValue.equals(labels.get(labelKey))) continue;
                        results.add(instance);
                    }
                }
            }
        }
        return results;
    }

    protected List<RouteDestination> getRouteDestination(TrafficRoutingRuleGroup trafficRoutingRuleGroup, TrafficContext context) {
        List<TrafficRouter> trafficRouterRuleList;
        if (trafficRoutingRuleGroup != null && (trafficRouterRuleList = trafficRoutingRuleGroup.getTrafficRouterRuleList()) != null && trafficRouterRuleList.size() > 0) {
            for (TrafficRouter trafficRouter : trafficRouterRuleList) {
                List<Route> rpcRoutes = this.getRoutes(trafficRouter, context);
                if (rpcRoutes == null) continue;
                return this.getRouteDestination(rpcRoutes, context);
            }
        }
        return null;
    }

    protected List<RouteDestination> getRouteDestination(List<Route> routes, TrafficContext context) {
        for (Route route : routes) {
            List<RouteDetail> routeDetailList = route.getRouteDetail();
            if (routeDetailList == null || routeDetailList.size() <= 0) continue;
            for (RouteDetail routeDetail : routeDetailList) {
                List<RequestMatch> requestMatchList = routeDetail.getMatch();
                if (requestMatchList == null || requestMatchList.isEmpty()) {
                    return routeDetail.getRoute();
                }
                if (!requestMatchList.stream().allMatch(request -> request.isMatch(context))) continue;
                return routeDetail.getRoute();
            }
        }
        return null;
    }

    protected List<Route> getRoutes(TrafficRouter trafficRouter, TrafficContext context) {
        List<Route> rpcRouteList = trafficRouter.getHttp();
        ArrayList<Route> result = new ArrayList<Route>();
        if (rpcRouteList != null && rpcRouteList.size() > 0) {
            for (Route rpcRoute : rpcRouteList) {
                List<StringMatch> stringMatchList = rpcRoute.getServices();
                if (stringMatchList == null || stringMatchList.size() == 0) {
                    result.add(rpcRoute);
                    continue;
                }
                for (StringMatch stringMatch : stringMatchList) {
                    if (!stringMatch.isMatch(context.getServiceName())) continue;
                    result.add(rpcRoute);
                }
            }
        }
        return result;
    }
}

